/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings;

import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsControllerImpl;
import com.intellij.ide.startup.importSettings.transfer.backend.TransferSettingsDataProvider;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.ui.representation.ideVersion.sections.IdeRepresentationSection;
import com.intellij.ide.startup.importSettings.ui.representation.ideVersion.sections.KeymapSection;
import com.intellij.ide.startup.importSettings.ui.representation.ideVersion.sections.PluginsSection;
import com.intellij.ide.startup.importSettings.ui.representation.ideVersion.sections.RecentProjectsSection;
import com.intellij.ide.startup.importSettings.ui.representation.ideVersion.sections.TransferSettingsSection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/startup/importSettings/DefaultTransferSettingsConfiguration;", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "dataProvider", "Lcom/intellij/ide/startup/importSettings/transfer/backend/TransferSettingsDataProvider;", "shouldDisplayFailedVersions", "", "<init>", "(Lcom/intellij/ide/startup/importSettings/transfer/backend/TransferSettingsDataProvider;Z)V", "getDataProvider", "()Lcom/intellij/ide/startup/importSettings/transfer/backend/TransferSettingsDataProvider;", "getShouldDisplayFailedVersions", "()Z", "controller", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsControllerImpl;", "getController", "()Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsControllerImpl;", "getSectionsFactory", "Lkotlin/Function1;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "", "Lcom/intellij/ide/startup/importSettings/ui/representation/ideVersion/sections/TransferSettingsSection;", "intellij.ide.startup.importSettings"})
public class DefaultTransferSettingsConfiguration
implements TransferSettingsConfiguration {
    @NotNull
    private final TransferSettingsDataProvider dataProvider;
    private final boolean shouldDisplayFailedVersions;
    @NotNull
    private final TransferSettingsControllerImpl controller;

    public DefaultTransferSettingsConfiguration(@NotNull TransferSettingsDataProvider dataProvider, boolean shouldDisplayFailedVersions) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        this.dataProvider = dataProvider;
        this.shouldDisplayFailedVersions = shouldDisplayFailedVersions;
        this.controller = new TransferSettingsControllerImpl();
    }

    @Override
    @NotNull
    public TransferSettingsDataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public boolean getShouldDisplayFailedVersions() {
        return this.shouldDisplayFailedVersions;
    }

    @Override
    @NotNull
    public TransferSettingsControllerImpl getController() {
        return this.controller;
    }

    @Override
    @NotNull
    public Function1<IdeVersion, List<TransferSettingsSection>> getSectionsFactory() {
        return DefaultTransferSettingsConfiguration::getSectionsFactory$lambda$0;
    }

    private static final List getSectionsFactory$lambda$0(IdeVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new IdeRepresentationSection[]{new KeymapSection(it), new PluginsSection(it), new RecentProjectsSection(it)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

