/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNodeGen;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;

@ImportStatic(value={TruffleString.CodeRange.class})
public abstract class TRegexExecutorEntryNode
extends Node {
    private final TRegexExecutorBaseNode executor;
    @Node.Child
    TRegexExecutorEntryInnerNode innerNode;

    public TRegexExecutorEntryNode(RegexLanguage language, TRegexExecutorBaseNode executor) {
        this.executor = executor;
        this.innerNode = this.insert(TRegexExecutorEntryInnerNode.create(language, executor));
    }

    public static TRegexExecutorEntryNode create(RegexLanguage language, TRegexExecutorBaseNode executor) {
        if (executor == null) {
            return null;
        }
        return TRegexExecutorEntryNodeGen.create(language, executor);
    }

    public TRegexExecutorBaseNode getExecutor() {
        return this.executor;
    }

    public abstract Object execute(VirtualFrame var1, TruffleString var2, int var3, int var4, int var5);

    @Specialization
    Object doTString(VirtualFrame frame, TruffleString input, int fromIndex, int index, int maxIndex, @Cached TruffleString.MaterializeNode materializeNode, @Cached TruffleString.GetCodeRangeImpreciseNode codeRangeImpreciseNode, @Cached TruffleString.GetCodeRangeNode codeRangePreciseNode, @Cached InlinedConditionProfile isLatin1Profile) {
        TruffleString.Encoding encoding = this.executor.getEncoding().getTStringEncoding();
        CompilerAsserts.partialEvaluationConstant((Object)encoding);
        materializeNode.execute(input, encoding);
        TruffleString.CodeRange codeRangeImprecise = codeRangeImpreciseNode.execute(input, encoding);
        TruffleString.CodeRange codeRange = isLatin1Profile.profile(this, codeRangeImprecise.isSubsetOf(TruffleString.CodeRange.LATIN_1)) ? codeRangeImprecise : codeRangePreciseNode.execute(input, encoding);
        return this.innerNode.execute(frame, input, fromIndex, index, maxIndex, codeRange);
    }

    @ImportStatic(value={TruffleString.CodeRange.class})
    public static abstract class TRegexExecutorEntryInnerNode
    extends Node {
        private final RegexLanguage language;
        @Node.Child
        TRegexExecutorBaseNode executor;

        public TRegexExecutorEntryInnerNode(RegexLanguage language, TRegexExecutorBaseNode executor) {
            this.language = language;
            this.executor = executor;
        }

        public static TRegexExecutorEntryInnerNode create(RegexLanguage language, TRegexExecutorBaseNode executor) {
            if (executor == null) {
                return null;
            }
            return TRegexExecutorEntryNodeGen.TRegexExecutorEntryInnerNodeGen.create(language, executor);
        }

        public TRegexExecutorBaseNode getExecutor() {
            return this.executor;
        }

        public abstract Object execute(VirtualFrame var1, TruffleString var2, int var3, int var4, int var5, TruffleString.CodeRange var6);

        @Specialization(guards={"codeRange == cachedCodeRange"}, limit="5")
        Object doTString(VirtualFrame frame, TruffleString input, int fromIndex, int index, int maxIndex, TruffleString.CodeRange codeRange, @Cached(value="codeRange") TruffleString.CodeRange cachedCodeRange, @Cached(value="createCallTarget(cachedCodeRange)") DirectCallNode callNode) {
            return this.runExecutor(frame, input, fromIndex, index, maxIndex, callNode, cachedCodeRange);
        }

        DirectCallNode createCallTarget(TruffleString.CodeRange codeRange) {
            if (this.getExecutor().isTrivial()) {
                return null;
            }
            return DirectCallNode.create(new TRegexExecutorRootNode(this.language, this.executor.shallowCopy(), codeRange).getCallTarget());
        }

        private Object runExecutor(VirtualFrame frame, TruffleString input, int fromIndex, int index, int maxIndex, DirectCallNode callNode, TruffleString.CodeRange cachedCodeRange) {
            CompilerAsserts.partialEvaluationConstant((Object)cachedCodeRange);
            CompilerAsserts.partialEvaluationConstant(callNode);
            if (callNode == null) {
                return this.executor.execute(frame, this.executor.createLocals(input, fromIndex, index, maxIndex), cachedCodeRange);
            }
            return callNode.call(input, fromIndex, index, maxIndex);
        }
    }

    private static final class TRegexExecutorRootNode
    extends RootNode {
        @Node.Child
        TRegexExecutorBaseNode executor;
        private final TruffleString.CodeRange codeRange;

        private TRegexExecutorRootNode(RegexLanguage language, TRegexExecutorNode executor, TruffleString.CodeRange codeRange) {
            super(language, RegexRootNode.SHARED_EMPTY_FRAMEDESCRIPTOR);
            this.executor = this.insert(executor);
            this.codeRange = codeRange;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            TruffleString input = (TruffleString)arguments[0];
            int fromIndex = (Integer)arguments[1];
            int index = (Integer)arguments[2];
            int maxIndex = (Integer)arguments[3];
            return this.executor.execute(frame, this.executor.createLocals(input, fromIndex, index, maxIndex), this.codeRange);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString() {
            String src = this.executor.getSource().toStringEscaped();
            return "tregex " + this.executor.getSource().getSource().getName() + " " + this.executor.getName() + " " + String.valueOf((Object)this.codeRange) + ": " + (String)(src.length() > 30 ? src.substring(0, 30) + "..." : src);
        }
    }
}

