/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.profiler.api.monitor.JCmdProcessMonitor;
import com.intellij.profiler.api.monitor.JMXProcessMonitor;
import java.io.IOException;
import java.lang.module.FindException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000b2\u00060\u0001j\u0002`\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H&J\b\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "dumpThreads", "", "dumpHeap", "", "filePath", "close", "Companion", "intellij.profiler.common"})
public abstract class JavaProcessMonitor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String dumpThreads();

    public abstract void dumpHeap(@NotNull String var1);

    @Override
    public void close() {
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor connect(@NotNull ProcessInfo processInfo) {
        return Companion.connect(processInfo);
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor connect(@NotNull String appName, int pid) {
        return Companion.connect(appName, pid);
    }

    @JvmStatic
    public static final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
        Companion.dumpHeap(pid, filePath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor$Companion;", "", "<init>", "()V", "connect", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "appName", "", "pid", "", "dumpHeap", "", "filePath", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor connect(@NotNull ProcessInfo processInfo) {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            String string = processInfo.getExecutableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableName(...)");
            return this.connect(string, processInfo.getPid());
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor connect(@NotNull String appName, int pid) {
            JavaProcessMonitor javaProcessMonitor;
            Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
            JMXProcessMonitor jMXProcessMonitor = JMXProcessMonitor.Companion.connectOrNull$intellij_profiler_common(pid);
            if (jMXProcessMonitor != null) {
                javaProcessMonitor = jMXProcessMonitor;
            } else {
                JCmdProcessMonitor jCmdProcessMonitor = JCmdProcessMonitor.Companion.connectOrNull$intellij_profiler_common(pid);
                if (jCmdProcessMonitor != null) {
                    javaProcessMonitor = jCmdProcessMonitor;
                } else {
                    throw new IOException("Unable to connect to process " + appName + " with PID " + pid);
                }
            }
            return javaProcessMonitor;
        }

        @JvmStatic
        public final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            JMXProcessMonitor.Companion.dumpHeap(pid, filePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

