/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.LabeledXYLineDataset;
import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineConverter;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelineSlider;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.charts.ChartUtils;
import com.intellij.ui.charts.ChartWrapper;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.intellij.ui.charts.ValueIterable;
import com.intellij.ui.charts.XYChartComponent;
import com.intellij.ui.charts.XYLineChart;
import com.intellij.ui.charts.XYLineDataset;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 Q*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0006LMNOPQB)\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020(J\u000e\u0010D\u001a\u00020(2\u0006\u0010C\u001a\u00020?J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\u000e\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020?J\b\u0010K\u001a\u00020FH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u00120\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010'\u001a\u00020(X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R+\u0010-\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020(8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010&\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u0014\u00101\u001a\u00020(X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010*R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u00108\u001a\u0002072\u0006\u0010\u001e\u001a\u0002078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010&\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006R"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "T", "F", "Ljavax/swing/JComponent;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "values", "", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;Ljava/lang/Iterable;)V", "getModel", "()Lcom/intellij/profiler/ui/timeline/TimelineModel;", "getValues", "()Ljava/lang/Iterable;", "header", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "getHeader", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "cellRenderer", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "getCellRenderer", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "setCellRenderer", "(Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "timeFormatter", "Lcom/intellij/profiler/ui/timeline/TimelineConverter;", "getTimeFormatter", "()Lcom/intellij/profiler/ui/timeline/TimelineConverter;", "setTimeFormatter", "(Lcom/intellij/profiler/ui/timeline/TimelineConverter;)V", "<set-?>", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "range", "getRange", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "setRange", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;)V", "range$delegate", "Lkotlin/properties/ReadWriteProperty;", "rowHeight", "", "getRowHeight", "()I", "setRowHeight", "(I)V", "headerHeight", "getHeaderHeight", "setHeaderHeight", "headerHeight$delegate", "pinSliderRadiusPx", "getPinSliderRadiusPx", "myMovingSlider", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Moving;", "myFixedSlider", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Fixed;", "", "slidersEnabled", "getSlidersEnabled", "()Z", "setSlidersEnabled", "(Z)V", "slidersEnabled$delegate", "fixedSliderTime", "", "getFixedSliderTime", "()J", "toWorldCoordinate", "x", "toScreenCoordinate", "paintComponent", "", "g", "Ljava/awt/Graphics;", "setFixedSliderTime", "time", "addNotify", "RowDrawer", "Range", "Header", "SliderOverlay", "MyViewportListener", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nTimelineComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n33#2,3:395\n33#2,3:398\n33#2,3:401\n1869#3,2:404\n1878#3,2:406\n1869#3,2:408\n1880#3:410\n*S KotlinDebug\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent\n*L\n40#1:395,3\n46#1:398,3\n56#1:401,3\n103#1:404,2\n115#1:406,2\n128#1:408,2\n115#1:410\n*E\n"})
public class TimelineComponent<T, F>
extends JComponent {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TimelineModel<T, F> model;
    @NotNull
    private final Iterable<T> values;
    @NotNull
    private final Header header;
    @NotNull
    private TimelineCellRenderer<T, F> cellRenderer;
    @NotNull
    private TimelineConverter timeFormatter;
    @NotNull
    private final ReadWriteProperty range$delegate;
    private int rowHeight;
    @NotNull
    private final ReadWriteProperty headerHeight$delegate;
    private final int pinSliderRadiusPx;
    @Nullable
    private TimelineSlider.Moving myMovingSlider;
    @Nullable
    private TimelineSlider.Fixed myFixedSlider;
    @NotNull
    private final ReadWriteProperty slidersEnabled$delegate;
    @NotNull
    private static final Range DEFAULT_RANGE;

    public TimelineComponent(@NotNull TimelineModel<T, F> model2, @NotNull Iterable<? extends T> values) {
        Constable initialValue$iv;
        Range $this$header_u24lambda_u240;
        Header header;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.model = model2;
        this.values = values;
        Header header2 = header = new Header();
        TimelineComponent timelineComponent = this;
        boolean bl = false;
        ((Header)((Object)$this$header_u24lambda_u240)).setBorder(JBUI.Borders.customLine((Color)NamedColorUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        $this$header_u24lambda_u240.setPreferredSize(new Dimension($this$header_u24lambda_u240.getWidth(), JBUI.getInt((String)"TableHeader.height", (int)25)));
        List list = ((Header)((Object)$this$header_u24lambda_u240)).getChart().getOverlays();
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ui.charts.ChartComponent>");
        TypeIntrinsics.asMutableList((Object)list).add(new SliderOverlay(((Header)((Object)$this$header_u24lambda_u240)).getChart().getDatasets()));
        timelineComponent.header = header;
        this.cellRenderer = new DefaultTimelineCellRenderer();
        this.timeFormatter = (arg_0, arg_1) -> TimelineComponent.timeFormatter$lambda$0(this, arg_0, arg_1);
        header = Delegates.INSTANCE;
        $this$header_u24lambda_u240 = DEFAULT_RANGE;
        boolean $i$f$observable = false;
        this.range$delegate = (ReadWriteProperty)new ObservableProperty<Range>((Object)initialValue$iv, this){
            final /* synthetic */ TimelineComponent this$0;
            {
                this.this$0 = timelineComponent;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Range range = (Range)newValue;
                Range cfr_ignored_0 = (Range)oldValue;
                boolean bl = false;
                this.this$0.getHeader().getChart().getRanges().setXMin((Number)newValue2.getStart());
                this.this$0.getHeader().getChart().getRanges().setXMax((Number)newValue2.getStop());
            }
        };
        this.rowHeight = 20;
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = this.header.getPreferredSize().height;
        $i$f$observable = false;
        this.headerHeight$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ TimelineComponent this$0;
            {
                this.this$0 = timelineComponent;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                ((Number)oldValue).intValue();
                boolean bl = false;
                this.this$0.getHeader().setPreferredSize(new Dimension(this.this$0.getWidth(), (int)newValue2));
                this.this$0.getHeader().setSize(this.this$0.getPreferredSize());
                this.this$0.getHeader().revalidate();
                this.this$0.getHeader().repaint();
            }
        };
        this.pinSliderRadiusPx = 20;
        this_$iv = Delegates.INSTANCE;
        initialValue$iv = Boolean.valueOf(false);
        $i$f$observable = false;
        this.slidersEnabled$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ TimelineComponent this$0;
            {
                this.this$0 = timelineComponent;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void new_;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean old = (Boolean)oldValue;
                boolean bl2 = false;
                if (new_ != old) {
                    TimelineComponent.access$setMyMovingSlider$p(this.this$0, new_ != false ? new TimelineSlider.Moving() : null);
                    TimelineComponent.access$setMyFixedSlider$p(this.this$0, new_ != false ? new TimelineSlider.Fixed(this.this$0) : null);
                }
            }
        };
        HoverListener listener2 = new HoverListener(this){
            final /* synthetic */ TimelineComponent<T, F> this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(Component component, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                this.mouseMoved(component, x, y);
            }

            public void mouseMoved(Component component, int x, int y) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    if (TimelineComponent.access$getMyMovingSlider$p(this.this$0) == null) {
                        return;
                    }
                    TimelineSlider.Moving moving = TimelineComponent.access$getMyMovingSlider$p(this.this$0);
                    if (moving != null) {
                        moving.setPositionX$intellij_profiler_common(SwingUtilities.convertPoint((Component)component, (Point)new Point((int)x, (int)y), (Component)((Component)this.this$0)).x - this.this$0.getVisibleRect().x);
                    }
                    JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)this.this$0);
                    if (jScrollPane == null) break block2;
                    jScrollPane.repaint();
                }
            }

            public void mouseExited(Component component) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    if (TimelineComponent.access$getMyMovingSlider$p(this.this$0) == null) {
                        return;
                    }
                    TimelineSlider.Moving moving = TimelineComponent.access$getMyMovingSlider$p(this.this$0);
                    if (moving != null) {
                        moving.setPositionX$intellij_profiler_common(-1);
                    }
                    JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)this.this$0);
                    if (jScrollPane == null) break block2;
                    jScrollPane.repaint();
                }
            }
        };
        listener2.addTo((JComponent)this);
        listener2.addTo(this.header.getChart().getComponent());
    }

    @NotNull
    public final TimelineModel<T, F> getModel() {
        return this.model;
    }

    @NotNull
    public final Iterable<T> getValues() {
        return this.values;
    }

    @NotNull
    public final Header getHeader() {
        return this.header;
    }

    @NotNull
    public final TimelineCellRenderer<T, F> getCellRenderer() {
        return this.cellRenderer;
    }

    public final void setCellRenderer(@NotNull TimelineCellRenderer<T, F> timelineCellRenderer2) {
        Intrinsics.checkNotNullParameter(timelineCellRenderer2, (String)"<set-?>");
        this.cellRenderer = timelineCellRenderer2;
    }

    @NotNull
    public final TimelineConverter getTimeFormatter() {
        return this.timeFormatter;
    }

    public final void setTimeFormatter(@NotNull TimelineConverter timelineConverter) {
        Intrinsics.checkNotNullParameter((Object)timelineConverter, (String)"<set-?>");
        this.timeFormatter = timelineConverter;
    }

    @NotNull
    public final Range getRange() {
        return (Range)this.range$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"<set-?>");
        this.range$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)range);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public final int getHeaderHeight() {
        return ((Number)this.headerHeight$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    public final void setHeaderHeight(int n) {
        this.headerHeight$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)n);
    }

    public final int getPinSliderRadiusPx() {
        return this.pinSliderRadiusPx;
    }

    public final boolean getSlidersEnabled() {
        return (Boolean)this.slidersEnabled$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setSlidersEnabled(boolean bl) {
        this.slidersEnabled$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    public final long getFixedSliderTime() {
        TimelineSlider.Fixed fixed = this.myFixedSlider;
        return fixed != null ? fixed.getTime$intellij_profiler_common() : -1L;
    }

    public final long toWorldCoordinate(int x) {
        Range range = this.getRange();
        boolean bl = false;
        long start = range.component1();
        long end = range.component2();
        return this.getWidth() == 0 ? 0L : MathKt.roundToLong((double)((double)x / (double)this.getWidth() * (double)(end - start))) + start;
    }

    public final int toScreenCoordinate(long x) {
        Range range = this.getRange();
        boolean bl = false;
        long start = range.component1();
        long end = range.component2();
        return end == start ? 0 : MathKt.roundToInt((double)((double)(x - start) / (double)(end - start) * (double)this.getWidth()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.getRowHeight() < 1) {
            return;
        }
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        Rectangle visibleRect = this.getVisibleRect();
        g2d.setClip(visibleRect);
        g2d.setColor(this.header.getChart().getGridColor());
        Iterable $this$forEach$iv = (Iterable)this.header.getChart().getGrid().getXLines();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            int x = this.toScreenCoordinate(it);
            g2d.drawLine(x, visibleRect.y, x, visibleRect.y + visibleRect.height);
        }
        long startX = this.toWorldCoordinate(visibleRect.x);
        long endX = this.toWorldCoordinate(visibleRect.x + visibleRect.width);
        int startY = visibleRect.y - visibleRect.y % this.getRowHeight() + this.getInsets().top;
        int skippedRows = (startY - this.getInsets().top) / this.getRowHeight();
        int minDistance = 0;
        minDistance = Integer.MAX_VALUE;
        int nearestX = 0;
        nearestX = -1;
        TimelineSlider.Moving moving = this.myMovingSlider;
        int movingX = moving != null ? moving.getPositionX$intellij_profiler_common() : -1;
        Iterable<T> $this$forEachIndexed$iv = this.values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void any;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            T t = item$iv;
            int i = n;
            boolean bl = false;
            if (any == null) continue;
            boolean hovered = this.cellRenderer.isHovered(skippedRows + i);
            if (this.cellRenderer.isSelected(skippedRows + i)) {
                g2d.setColor(this.cellRenderer.getSelectionBackground());
                g2d.fillRect(0, startY + i * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            } else if (hovered) {
                g2d.setColor(this.cellRenderer.getHoverBackground());
                g2d.fillRect(0, startY + i * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
            Intrinsics.checkNotNull((Object)visibleRect);
            RowDrawer drawer = new RowDrawer(visibleRect);
            Iterable<TimelineModel.TimelineInterval<F>> $this$forEach$iv2 = this.model.getIntervalsFast(any);
            boolean $i$f$forEach2 = false;
            Iterator<TimelineModel.TimelineInterval<F>> iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                boolean isOutOfVisibleArea;
                TimelineModel.TimelineInterval<F> element$iv;
                TimelineModel.TimelineInterval<F> it = element$iv = iterator2.next();
                boolean bl2 = false;
                boolean bl3 = isOutOfVisibleArea = it.getStart() > endX || it.getEnd() < startX;
                if (!isOutOfVisibleArea) {
                    int x1 = this.toScreenCoordinate(it.getStart());
                    int x2 = this.toScreenCoordinate(it.getEnd());
                    if (hovered) {
                        int ax1 = x1 - visibleRect.x;
                        int ax2 = x2 - visibleRect.x;
                        if (ax1 == ax2) {
                            if (Math.abs(movingX - ax1) < minDistance) {
                                minDistance = Math.abs(movingX - ax1);
                                nearestX = ax1;
                            }
                        } else {
                            boolean bl4 = ax1 <= movingX ? movingX <= ax2 : false;
                            if (bl4) {
                                minDistance = 0;
                                nearestX = movingX;
                            } else if (movingX < ax1 && ax1 - movingX < minDistance) {
                                minDistance = ax1 - movingX;
                                nearestX = ax1;
                            } else if (ax2 < movingX && movingX - ax2 < minDistance) {
                                minDistance = movingX - ax2;
                                nearestX = ax2;
                            }
                        }
                    }
                    if (drawer.canDraw(x1, x2)) {
                        Graphics graphics2 = g2d.create(x1, startY + i * this.getRowHeight(), Math.max(x2 - x1, 1), this.getRowHeight());
                        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                        Graphics2D cg = (Graphics2D)graphics2;
                        try {
                            this.cellRenderer.paint(this, cg, it);
                        }
                        finally {
                            cg.dispose();
                        }
                    }
                }
                drawer.clear();
            }
        }
        if (minDistance < this.pinSliderRadiusPx) {
            TimelineSlider.Moving moving2 = this.myMovingSlider;
            if (moving2 != null) {
                moving2.setPositionX$intellij_profiler_common(nearestX);
            }
        }
        TimelineSlider.Fixed fixed = this.myFixedSlider;
        if (fixed != null) {
            Intrinsics.checkNotNull((Object)visibleRect);
            fixed.drawPanelPart(g2d, visibleRect);
        }
        TimelineSlider.Moving moving3 = this.myMovingSlider;
        if (moving3 != null) {
            Intrinsics.checkNotNull((Object)visibleRect);
            moving3.drawPanelPart(g2d, visibleRect);
        }
        g2d.dispose();
    }

    public final void setFixedSliderTime(long time) {
        block0: {
            TimelineSlider.Fixed fixed = this.myFixedSlider;
            if (fixed == null) break block0;
            fixed.setTime$intellij_profiler_common(time);
        }
    }

    @Override
    public void addNotify() {
        block0: {
            JScrollPane jScrollPane;
            super.addNotify();
            JScrollPane jScrollPane2 = ComponentUtil.getScrollPane((Component)this);
            if (jScrollPane2 == null) break block0;
            JScrollPane $this$addNotify_u24lambda_u240 = jScrollPane = jScrollPane2;
            boolean bl = false;
            $this$addNotify_u24lambda_u240.setColumnHeaderView((Component)((Object)this.header));
            $this$addNotify_u24lambda_u240.getViewport().addChangeListener(new MyViewportListener());
        }
    }

    private static final String timeFormatter$lambda$0(TimelineComponent this$0, int n, long time) {
        String string = NlsMessages.formatDuration((long)(time - this$0.getRange().getStart()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        return string;
    }

    @NotNull
    public static final Range getDEFAULT_RANGE() {
        return Companion.getDEFAULT_RANGE();
    }

    public static final /* synthetic */ void access$setMyMovingSlider$p(TimelineComponent $this, TimelineSlider.Moving moving) {
        $this.myMovingSlider = moving;
    }

    public static final /* synthetic */ void access$setMyFixedSlider$p(TimelineComponent $this, TimelineSlider.Fixed fixed) {
        $this.myFixedSlider = fixed;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelineComponent.class, "range", "getRange()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelineComponent.class, "headerHeight", "getHeaderHeight()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelineComponent.class, "slidersEnabled", "getSlidersEnabled()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        DEFAULT_RANGE = new Range(0L, 3600000L);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Companion;", "", "<init>", "()V", "DEFAULT_RANGE", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "getDEFAULT_RANGE$annotations", "getDEFAULT_RANGE", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Range getDEFAULT_RANGE() {
            return DEFAULT_RANGE;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_RANGE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent;)V", "chart", "Lcom/intellij/ui/charts/XYLineChart;", "", "", "getChart", "()Lcom/intellij/ui/charts/XYLineChart;", "setBorder", "", "ignored", "Ljavax/swing/border/Border;", "value", "", "isDatasetVisible", "()Z", "setDatasetVisible", "(Z)V", "spaceWidth", "", "getSpaceWidth", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nTimelineComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent$Header\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n1761#2,3:395\n*S KotlinDebug\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent$Header\n*L\n261#1:395,3\n*E\n"})
    public final class Header
    extends BorderLayoutPanel {
        @NotNull
        private final XYLineChart<Long, Double> chart = ChartUtils.lineChart(arg_0 -> Header.chart$lambda$0(TimelineComponent.this, this, arg_0));
        private int spaceWidth = -1;

        public Header() {
            this.addToCenter(this.chart.getComponent());
        }

        @NotNull
        public final XYLineChart<Long, Double> getChart() {
            return this.chart;
        }

        public void setBorder(@Nullable Border ignored) {
            super.setBorder(JBUI.Borders.customLine((Color)NamedColorUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        }

        public final boolean isDatasetVisible() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.chart.getDatasets();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        XYLineDataset it = (XYLineDataset)element$iv;
                        boolean bl2 = false;
                        if (!(CollectionsKt.count((Iterable)it.getData()) > 1)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void setDatasetVisible(boolean value) {
            List list = this.chart.getDatasets();
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ui.charts.XYLineDataset<kotlin.Long, kotlin.Double>>");
            List list2 = TypeIntrinsics.asMutableList((Object)list);
            TimelineComponent timelineComponent = TimelineComponent.this;
            List $this$_set_isDatasetVisible__u24lambda_u240 = list2;
            boolean bl = false;
            if (this.isDatasetVisible() == value) {
                return;
            }
            if (value) {
                $this$_set_isDatasetVisible__u24lambda_u240.addAll((Collection)timelineComponent.getModel().getCharts());
            } else {
                $this$_set_isDatasetVisible__u24lambda_u240.clear();
            }
        }

        private final int getSpaceWidth() {
            if (this.spaceWidth < 0) {
                int n;
                Header header;
                Header header2 = this;
                try {
                    header = header2;
                    String stub = TimelineComponent.this.getTimeFormatter().convert(0, TimelineComponent.this.getRange().getStart() + 23456789L);
                    FontRenderContext frc = new FontRenderContext(null, true, true);
                    n = MathKt.roundToInt((double)this.getFont().getStringBounds(stub, frc).getWidth());
                }
                catch (Throwable ignored) {
                    header = header2;
                    n = 150;
                }
                header.spaceWidth = n;
            }
            return this.spaceWidth;
        }

        private static final Unit chart$lambda$0(TimelineComponent this$0, Header this$1, XYLineChart $this$lineChart) {
            Intrinsics.checkNotNullParameter((Object)$this$lineChart, (String)"$this$lineChart");
            ChartUtils.ranges((XYChartComponent)((XYChartComponent)$this$lineChart), Header::chart$lambda$0$0);
            $this$lineChart.setDatasets(CollectionsKt.toMutableList((Collection)this$0.getModel().getCharts()));
            ChartUtils.grid((GridChartWrapper)((GridChartWrapper)$this$lineChart), arg_0 -> Header.chart$lambda$0$1($this$lineChart, this$1, this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit chart$lambda$0$0(MinMax $this$ranges) {
            Intrinsics.checkNotNullParameter((Object)$this$ranges, (String)"$this$ranges");
            $this$ranges.setYMin((Number)0.0);
            $this$ranges.setYMax((Number)1.0);
            $this$ranges.setXMin((Number)Companion.getDEFAULT_RANGE().getStart());
            $this$ranges.setXMax((Number)Companion.getDEFAULT_RANGE().getStop());
            return Unit.INSTANCE;
        }

        private static final Unit chart$lambda$0$1(XYLineChart $this_lineChart, Header this$0, TimelineComponent this$1, Grid $this$grid) {
            Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
            $this$grid.setXLines((ValueIterable)new ValueIterable<Long>((XYLineChart<Long, Double>)$this_lineChart, (Grid<Long, Double>)$this$grid, this$0, this$1){
                final /* synthetic */ XYLineChart<Long, Double> $this_lineChart;
                final /* synthetic */ Grid<Long, Double> $this_grid;
                final /* synthetic */ Header this$0;
                final /* synthetic */ TimelineComponent<T, F> this$1;
                {
                    this.$this_lineChart = $this_lineChart;
                    this.$this_grid = $this_grid;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public Iterator<Long> iterator() {
                    int scale = ChartUtils.findScale((ChartWrapper)((ChartWrapper)this.$this_lineChart), (long)this.$this_grid.getXMin().longValue(), (long)this.$this_grid.getXMax().longValue(), (int)Header.access$getSpaceWidth(this.this$0));
                    long xMin = (this.$this_grid.getXMin().longValue() - this.this$1.getRange().getStart()) / (long)scale * (long)scale + this.this$1.getRange().getStart();
                    long xMax = this.$this_grid.getXMax().longValue();
                    return (Iterator)RangesKt.step((LongProgression)((LongProgression)new LongRange(xMin, xMax)), (long)scale).iterator();
                }
            });
            ChartUtils.xPainter((Grid)$this$grid, arg_0 -> Header.chart$lambda$0$1$0($this_lineChart, this$0, this$1, arg_0));
            $this$grid.setYOrigin((Number)1.0);
            return Unit.INSTANCE;
        }

        private static final Unit chart$lambda$0$1$0(XYLineChart $this_lineChart, Header this$0, TimelineComponent this$1, GridLine $this$xPainter) {
            Intrinsics.checkNotNullParameter((Object)$this$xPainter, (String)"$this$xPainter");
            int scale = ChartUtils.findScale((ChartWrapper)((ChartWrapper)$this_lineChart), (long)$this$xPainter.getXY().getXMin().longValue(), (long)$this$xPainter.getXY().getXMax().longValue(), (int)this$0.getSpaceWidth());
            $this$xPainter.setPaintLine(($this$xPainter.getValue().longValue() - this$1.getRange().getStart()) % (long)scale == 0L);
            $this$xPainter.setVerticalAlignment(3);
            $this$xPainter.setHorizontalAlignment(4);
            if ($this$xPainter.getPaintLine()) {
                $this$xPainter.setLabel(this$1.getTimeFormatter().convert(scale, $this$xPainter.getValue().longValue()));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ int access$getSpaceWidth(Header $this) {
            return $this.getSpaceWidth();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$MyViewportListener;", "Ljavax/swing/event/ChangeListener;", "<init>", "()V", "stateChanged", "", "e", "Ljavax/swing/event/ChangeEvent;", "intellij.profiler.common"})
    private static final class MyViewportListener
    implements ChangeListener {
        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JViewport");
            JViewport port = (JViewport)object;
            Component component = port.getView();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.timeline.TimelineComponent<*, *>");
            TimelineComponent line = (TimelineComponent)component;
            int x = port.getViewPosition().x;
            int width = port.getWidth();
            Grid $this$stateChanged_u24lambda_u240 = line.getHeader().getChart().getRanges();
            boolean bl = false;
            $this$stateChanged_u24lambda_u240.setXMin((Number)line.toWorldCoordinate(x));
            $this$stateChanged_u24lambda_u240.setXMax((Number)(line.toWorldCoordinate(x + width) + 1L));
            Insets $this$stateChanged_u24lambda_u241 = line.getHeader().getChart().getMargins();
            boolean bl2 = false;
            int start = line.toScreenCoordinate(line.getHeader().getChart().getRanges().getXMin().longValue());
            int end = line.toScreenCoordinate(line.getHeader().getChart().getRanges().getXMax().longValue());
            Rectangle rect = port.getViewRect();
            $this$stateChanged_u24lambda_u241.left = start - rect.x;
            $this$stateChanged_u24lambda_u241.right = rect.x + port.getParent().getWidth() - end;
            line.getHeader().setPreferredSize(new Dimension(width, line.getHeaderHeight()));
            line.getHeader().repaint();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "", "start", "", "stop", "<init>", "(JJ)V", "duration", "(J)V", "getStart", "()J", "getStop", "getDuration", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
    public static final class Range {
        private final long start;
        private final long stop;

        public Range(long start, long stop) {
            this.start = start;
            this.stop = stop;
        }

        public final long getStart() {
            return this.start;
        }

        public final long getStop() {
            return this.stop;
        }

        public Range(long duration) {
            this(0L, duration);
        }

        public final long getDuration() {
            return this.stop - this.start;
        }

        public final long component1() {
            return this.start;
        }

        public final long component2() {
            return this.stop;
        }

        @NotNull
        public final Range copy(long start, long stop) {
            return new Range(start, stop);
        }

        public static /* synthetic */ Range copy$default(Range range, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = range.start;
            }
            if ((n & 2) != 0) {
                l2 = range.stop;
            }
            return range.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "Range(start=" + this.start + ", stop=" + this.stop + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.start);
            result2 = result2 * 31 + Long.hashCode(this.stop);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (this.start != range.start) {
                return false;
            }
            return this.stop == range.stop;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$RowDrawer;", "", "visibleRect", "Ljava/awt/Rectangle;", "<init>", "(Ljava/awt/Rectangle;)V", "getVisibleRect", "()Ljava/awt/Rectangle;", "painted", "", "canDraw", "", "x1", "", "x2", "clear", "", "intellij.profiler.common"})
    private static final class RowDrawer {
        @NotNull
        private final Rectangle visibleRect;
        @NotNull
        private final boolean[] painted;

        public RowDrawer(@NotNull Rectangle visibleRect) {
            Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
            this.visibleRect = visibleRect;
            this.painted = new boolean[this.visibleRect.width + 1];
        }

        @NotNull
        public final Rectangle getVisibleRect() {
            return this.visibleRect;
        }

        public final boolean canDraw(int x1, int x2) {
            if (x1 < x2) {
                return true;
            }
            if (x1 == x2) {
                int index = x1 - this.visibleRect.x;
                boolean bl = 0 <= index ? index < this.painted.length : false;
                if (bl) {
                    boolean isPainted = this.painted[index];
                    this.painted[index] = true;
                    return !isPainted;
                }
            }
            return false;
        }

        public final void clear() {
            int n = this.painted.length;
            for (int index = 0; index < n; ++index) {
                this.painted[index] = false;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B!\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J@\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J&\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$SliderOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "datasets", "", "Lcom/intellij/ui/charts/XYLineDataset;", "", "", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent;Ljava/util/List;)V", "labeledDatasets", "Lcom/intellij/profiler/ui/timeline/LabeledXYLineDataset;", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "drawSlider", "slider", "Lcom/intellij/profiler/ui/timeline/TimelineSlider;", "chart", "Lcom/intellij/ui/charts/XYLineChart;", "xy", "Lcom/intellij/ui/charts/MinMax;", "getIntersectionWithSlider", "Lcom/intellij/ui/charts/Coordinates;", "sliderX", "", "data", "makeTimeLabel", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nTimelineComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent$SliderOverlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n808#2,11:395\n1869#2,2:407\n1#3:406\n*S KotlinDebug\n*F\n+ 1 TimelineComponent.kt\ncom/intellij/profiler/ui/timeline/TimelineComponent$SliderOverlay\n*L\n296#1:395,11\n314#1:407,2\n*E\n"})
    private final class SliderOverlay
    extends Overlay<LineChart<?, ?, ?>> {
        @NotNull
        private final List<LabeledXYLineDataset> labeledDatasets;

        /*
         * WARNING - void declaration
         */
        public SliderOverlay(List<? extends XYLineDataset<Long, Double>> datasets) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter(datasets, (String)"datasets");
            Iterable iterable = datasets;
            SliderOverlay sliderOverlay = this;
            boolean $i$f$filterIsInstance = false;
            void var5_6 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LabeledXYLineDataset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sliderOverlay.labeledDatasets = (List)destination$iv$iv;
        }

        public void paintComponent(@NotNull Graphics2D g) {
            block2: {
                TimelineSlider it;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                XYLineChart<Long, Double> chart2 = TimelineComponent.this.getHeader().getChart();
                MinMax xy = chart2.findMinMax();
                if (!xy.isInitialized()) {
                    return;
                }
                TimelineSlider.Fixed fixed = TimelineComponent.this.myFixedSlider;
                if (fixed != null) {
                    it = fixed;
                    boolean bl = false;
                    this.drawSlider(g, it, chart2, (MinMax<Long, Double>)xy);
                }
                TimelineSlider.Moving moving = TimelineComponent.this.myMovingSlider;
                if (moving == null) break block2;
                it = moving;
                boolean bl = false;
                this.drawSlider(g, it, chart2, (MinMax<Long, Double>)xy);
            }
        }

        private final void drawSlider(Graphics2D g, TimelineSlider slider, XYLineChart<Long, Double> chart2, MinMax<Long, Double> xy) {
            int pointCenterY = 0;
            pointCenterY = -1;
            List labels = new ArrayList();
            if (TimelineComponent.this.getHeader().isDatasetVisible()) {
                Iterable $this$forEach$iv = this.labeledDatasets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Coordinates<Long, Double> res;
                    LabeledXYLineDataset data = (LabeledXYLineDataset)((Object)element$iv);
                    boolean bl = false;
                    if (this.getIntersectionWithSlider(slider.getDrawPosition$intellij_profiler_common(), data) == null) continue;
                    boolean bl2 = false;
                    Point2D.Double p = chart2.findLocation(xy, res);
                    if (data.getLabeler().createLabel(res) != null) {
                        String p0;
                        boolean bl3 = false;
                        labels.add(p0);
                    }
                    if (!data.getLabeler().getShowPinpointToNearestCoordinate()) continue;
                    pointCenterY = MathKt.roundToInt((double)p.y);
                }
            }
            labels.add(this.makeTimeLabel(slider));
            Rectangle rectangle = chart2.getComponent().getVisibleRect();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleRect(...)");
            slider.drawChartPart(g, rectangle, pointCenterY, labels);
        }

        private final Coordinates<Long, Double> getIntersectionWithSlider(int sliderX, LabeledXYLineDataset data) {
            Coordinates<Long, Double> coordinates;
            Coordinates prev2;
            long value;
            block6: {
                Coordinates<Long, Double> it;
                Coordinates<Long, Double> coordinates2;
                MinMax xy;
                XYLineChart<Long, Double> chart2;
                block8: {
                    block7: {
                        chart2 = TimelineComponent.this.getHeader().getChart();
                        xy = chart2.findMinMax();
                        if (!xy.isInitialized()) break block7;
                        int n = chart2.getMargins().left;
                        if (sliderX <= chart2.getWidth() - chart2.getMargins().right ? n <= sliderX : false) break block8;
                    }
                    return null;
                }
                int x = sliderX - chart2.getMargins().left;
                double rat = (double)x * 1.0 / (double)(chart2.getWidth() - (chart2.getMargins().left + chart2.getMargins().right));
                value = MathKt.roundToLong((double)((double)(xy.getXMax().longValue() - xy.getXMin().longValue()) * rat)) + xy.getXMin().longValue();
                Iterable<Coordinates<Long, Double>> iterable = data.getData();
                Iterable<Coordinates<Long, Double>> iterable2 = null;
                Iterator<Coordinates<Long, Double>> iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    it = coordinates2 = iterator2.next();
                    boolean bl = false;
                    if (!(it.getX().longValue() <= value)) continue;
                    iterable2 = coordinates2;
                }
                prev2 = (Coordinates)iterable2;
                iterable2 = data.getData();
                iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    it = coordinates2 = iterator2.next();
                    boolean bl = false;
                    if (!(it.getX().longValue() >= value)) continue;
                    coordinates = coordinates2;
                    break block6;
                }
                coordinates = null;
            }
            Coordinates next2 = (Coordinates)coordinates;
            if (prev2 == null || next2 == null) {
                return null;
            }
            return prev2.getX().longValue() == next2.getX().longValue() ? next2 : new Coordinates((Number)value, (Number)(prev2.getY().doubleValue() + (next2.getY().doubleValue() - prev2.getY().doubleValue()) * (double)Math.abs(value - prev2.getX().longValue()) / (double)(next2.getX().longValue() - prev2.getX().longValue())));
        }

        private final String makeTimeLabel(TimelineSlider slider) {
            int sliderX = slider.getDrawPosition$intellij_profiler_common();
            long durationMs = TimelineComponent.this.toWorldCoordinate(sliderX + TimelineComponent.this.getVisibleRect().x) - TimelineComponent.this.getRange().getStart();
            long seconds = TimeUnit.MILLISECONDS.toSeconds(durationMs) % (long)60;
            long minutes = TimeUnit.MILLISECONDS.toMinutes(durationMs) % (long)60;
            long hours = TimeUnit.MILLISECONDS.toHours(durationMs);
            String string = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
    }
}

