/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.FamilyBatch;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelModifiedCache;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.owner.MutableElementOwnerSynchronizer;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\f\u0010\u000e\u001a\u00020\r*\u0004\u0018\u00010\u000fJ>\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00132\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0013H\u0016J>\u0010\u0016\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00132\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0013H\u0002J@\u0010\u0017\u001a\u00020\u0011\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b2\u001e\u0010\u001b\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001cH\u0002J@\u0010\u001f\u001a\u00020\u0011\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b2\u001e\u0010\u001b\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001cH\u0002J^\u0010 \u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u001e\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u001b\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001c2\u001a\u0010!\u001a\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\"\u0018\u00010\u001dH\u0002J2\u0010#\u001a\u0014\u0012\u0002\b\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180$\u0018\u00010\u001d\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/schemaEditor/DbObjectEditorModelSynchronizer;", "Lcom/intellij/database/schemaEditor/owner/MutableElementOwnerSynchronizer;", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "modelController", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "<init>", "(Lcom/intellij/database/schemaEditor/ElementOwner;Lcom/intellij/database/schemaEditor/model/DbEditorModelController;)V", "possibleReincarnation", "Lcom/intellij/database/util/ObjectPath;", "id", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "shouldBlockRemoval", "", "containsUserInput", "Lcom/intellij/database/schemaEditor/model/DbModelModifiedCache$State;", "onChanged", "", "createdIds", "", "modifiedIds", "removedIds", "processChanges", "handleCreation", "T", "Lcom/intellij/database/model/basic/BasicElement;", "identity", "cache", "", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "Lcom/intellij/database/schemaEditor/FamilyBatch;", "handleRemoval", "getFamilyBatch", "obj", "Lcom/intellij/database/schemaEditor/model/state/DbStructureObjectModelState;", "getFamily", "Lcom/intellij/database/schemaEditor/model/state/DbStructureFamilyModelState;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbObjectEditorModelSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectEditorModelSynchronizer.kt\ncom/intellij/database/schemaEditor/DbObjectEditorModelSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,127:1\n1869#2,2:128\n774#2:130\n865#2,2:131\n1869#2,2:133\n1869#2,2:135\n1625#2:137\n1869#2:138\n1870#2:140\n1626#2:141\n774#2:142\n865#2,2:143\n1869#2,2:145\n1#3:139\n1#3:154\n382#4,7:147\n*S KotlinDebug\n*F\n+ 1 DbObjectEditorModelSynchronizer.kt\ncom/intellij/database/schemaEditor/DbObjectEditorModelSynchronizer\n*L\n43#1:128,2\n46#1:130\n46#1:131,2\n49#1:133,2\n52#1:135,2\n53#1:137\n53#1:138\n53#1:140\n53#1:141\n61#1:142\n61#1:143,2\n64#1:145,2\n53#1:139\n87#1:147,7\n*E\n"})
public final class DbObjectEditorModelSynchronizer
extends MutableElementOwnerSynchronizer {
    @NotNull
    private final ElementOwner targetOwner;
    @NotNull
    private final DbEditorModelController modelController;

    public DbObjectEditorModelSynchronizer(@NotNull ElementOwner targetOwner, @NotNull DbEditorModelController modelController) {
        Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
        Intrinsics.checkNotNullParameter((Object)modelController, (String)"modelController");
        ElementOwner elementOwner = targetOwner.getOriginal();
        Intrinsics.checkNotNull((Object)elementOwner);
        super(elementOwner);
        this.targetOwner = targetOwner;
        this.modelController = modelController;
    }

    @Override
    @Nullable
    public ObjectPath possibleReincarnation(@NotNull ElementIdentity<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return ObjectPaths.of((DasObject)((DasObject)this.targetOwner.findElement(id)));
    }

    @Override
    public boolean shouldBlockRemoval(@NotNull ElementIdentity<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        DbEditorModel<?, DbObjectModelState<?>> dbEditorModel = this.modelController.getObjectModel(id);
        if (dbEditorModel == null) {
            return false;
        }
        DbEditorModel<?, DbObjectModelState<?>> model = dbEditorModel;
        return this.containsUserInput(this.modelController.getModifiedCache().getState(model));
    }

    public final boolean containsUserInput(@Nullable DbModelModifiedCache.State $this$containsUserInput) {
        return $this$containsUserInput == DbModelModifiedCache.State.MODIFIED || $this$containsUserInput == DbModelModifiedCache.State.NEW;
    }

    @Override
    public void onChanged(@NotNull Set<? extends ElementIdentity<?>> createdIds, @NotNull Set<? extends ElementIdentity<?>> modifiedIds, @NotNull Set<? extends ElementIdentity<?>> removedIds) {
        Intrinsics.checkNotNullParameter(createdIds, (String)"createdIds");
        Intrinsics.checkNotNullParameter(modifiedIds, (String)"modifiedIds");
        Intrinsics.checkNotNullParameter(removedIds, (String)"removedIds");
        CoroutineScope coroutineScope = this.modelController.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        ModalityState modalityState = this.modelController.getModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getModalityState(...)");
        BuildersKt.launch((CoroutineScope)coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, createdIds, modifiedIds, removedIds, null){
            int label;
            final /* synthetic */ DbObjectEditorModelSynchronizer this$0;
            final /* synthetic */ Set<ElementIdentity<?>> $createdIds;
            final /* synthetic */ Set<ElementIdentity<?>> $modifiedIds;
            final /* synthetic */ Set<ElementIdentity<?>> $removedIds;
            {
                this.this$0 = $receiver;
                this.$createdIds = $createdIds;
                this.$modifiedIds = $modifiedIds;
                this.$removedIds = $removedIds;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DbModelTransactionManager dbModelTransactionManager = DbObjectEditorModelSynchronizer.access$getModelController$p(this.this$0).getTransactionManager();
                        String string = DatabaseBundle.message((String)"schema.editor.apply.model.changes", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = dbModelTransactionManager.inTransaction(string, new Object(), (Function2)new Function2<DbModelTransactionManager.DbModelTransaction, Continuation<? super Unit>, Object>(this.this$0, this.$createdIds, this.$modifiedIds, this.$removedIds, null){
                            int label;
                            final /* synthetic */ DbObjectEditorModelSynchronizer this$0;
                            final /* synthetic */ Set<ElementIdentity<?>> $createdIds;
                            final /* synthetic */ Set<ElementIdentity<?>> $modifiedIds;
                            final /* synthetic */ Set<ElementIdentity<?>> $removedIds;
                            {
                                this.this$0 = $receiver;
                                this.$createdIds = $createdIds;
                                this.$modifiedIds = $modifiedIds;
                                this.$removedIds = $removedIds;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        DbObjectEditorModelSynchronizer.access$processChanges(this.this$0, this.$createdIds, this.$modifiedIds, this.$removedIds);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(DbModelTransactionManager.DbModelTransaction p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void processChanges(Set<? extends ElementIdentity<?>> createdIds, Set<? extends ElementIdentity<?>> modifiedIds, Set<? extends ElementIdentity<?>> removedIds) {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv;
        Iterator $this$filterTo$iv$iv2;
        Object element$iv2;
        Map<DbEditorModel<?, ?>, DbModelModifiedCache.State> modified = this.modelController.getModifiedCache().snapshot();
        LinkedHashMap cache = new LinkedHashMap();
        Iterable $this$forEach$iv = createdIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ElementIdentity it = (ElementIdentity)element$iv2;
            boolean bl = false;
            this.handleCreation(it, cache);
        }
        Collection<DbEditorModel<?, ?>> collection = this.modelController.getAllModels();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllModels(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            DbEditorModel it = (DbEditorModel)element$iv$iv;
            boolean bl = false;
            if (!(modifiedIds.contains(it.getIdentity()) || createdIds.contains(it.getIdentity()) || removedIds.contains(it.getIdentity()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List affectedModels = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = removedIds;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            ElementIdentity it = (ElementIdentity)element$iv3;
            boolean bl = false;
            this.handleRemoval(it, cache);
        }
        Collection collection2 = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        $this$forEach$iv2 = collection2;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            FamilyBatch it = (FamilyBatch)element$iv3;
            boolean bl = false;
            it.apply();
        }
        Iterable $i$f$forEach22 = modifiedIds;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            DbEditorModel dbEditorModel;
            Object element$iv4 = element$iv$iv;
            boolean bl = false;
            ElementIdentity it = (ElementIdentity)element$iv4;
            boolean bl2 = false;
            if (this.getOwner().findElement(it) != null) {
                dbEditorModel = null;
            } else {
                DbModelRef dbModelRef = this.getFamily(it);
                dbEditorModel = dbModelRef != null ? dbModelRef.resolve(this.modelController) : null;
            }
            if (dbEditorModel == null) continue;
            DbEditorModel it$iv = dbEditorModel;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet familiesToKeep = (HashSet)destination$iv;
        Iterable $this$filter$iv2 = affectedModels;
        boolean $i$f$filter2 = false;
        $this$forEach$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DbEditorModel it = (DbEditorModel)element$iv$iv;
            boolean bl = false;
            if (!(!this.containsUserInput(modified.get(it)) && !removedIds.contains(it.getIdentity()) && this.getOwner().findElement(it.getIdentity()) != null && !CollectionsKt.contains((Iterable)familiesToKeep, (Object)it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List toReset = (List)destination$iv$iv2;
        Iterable $this$forEach$iv3 = affectedModels;
        boolean $i$f$forEach4 = false;
        for (Object element$iv5 : $this$forEach$iv3) {
            DbEditorModel it = (DbEditorModel)element$iv5;
            boolean bl = false;
            Object s = it.getState();
            Intrinsics.checkNotNull(s, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.model.DbEditorModelBase.StateBase");
            ((DbEditorModelBase.StateBase)s).forceModified();
        }
        Collection collection3 = toReset;
        ElementOwner elementOwner = this.targetOwner.getOriginal();
        Intrinsics.checkNotNull((Object)elementOwner);
        DbModelResetHelper.reset(this.modelController, collection3, elementOwner);
    }

    private final <T extends BasicElement> void handleCreation(ElementIdentity<T> identity, Map<DbModelRef<?, ?>, FamilyBatch<?>> cache) {
        block0: {
            DbModelRef<T, DbStructureObjectModelState<T>> newObj = new DbModelRef<T, DbStructureObjectModelState<T>>(this.modelController.createStructureNodeModel(identity));
            FamilyBatch<T> familyBatch = this.getFamilyBatch(this.modelController, cache, newObj);
            if (familyBatch == null) break block0;
            familyBatch.handleCreation(newObj);
        }
    }

    private final <T extends BasicElement> void handleRemoval(ElementIdentity<T> identity, Map<DbModelRef<?, ?>, FamilyBatch<?>> cache) {
        block0: {
            DbModelRef<T, DbStructureObjectModelState<T>> remObj = DbModelRef.create(this.modelController.getStructureNodeModel(identity));
            FamilyBatch<T> familyBatch = this.getFamilyBatch(this.modelController, cache, remObj);
            if (familyBatch == null) break block0;
            familyBatch.handleRemoval(remObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends BasicElement> FamilyBatch<T> getFamilyBatch(DbEditorModelController modelController, Map<DbModelRef<?, ?>, FamilyBatch<?>> cache, DbModelRef<T, DbStructureObjectModelState<T>> obj) {
        Object object;
        void $this$getOrPut$iv;
        if (obj == null) {
            return null;
        }
        DbModelRef<?, DbStructureFamilyModelState<T>> dbModelRef = DbStructureFamilyModelState.getParentFamilyNode(modelController, obj);
        if (dbModelRef == null) {
            return null;
        }
        DbModelRef<?, DbStructureFamilyModelState<T>> family = dbModelRef;
        Map<DbModelRef<?, ?>, FamilyBatch<?>> map2 = cache;
        DbModelRef<?, DbStructureFamilyModelState<T>> key$iv = family;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DbEditorModel<?, DbStructureFamilyModelState<T>> dbEditorModel = family.resolve(modelController);
            Intrinsics.checkNotNullExpressionValue(dbEditorModel, (String)"resolve(...)");
            FamilyBatch<T> answer$iv = new FamilyBatch<T>(dbEditorModel);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FamilyBatch)object;
    }

    private final <T extends BasicElement> DbModelRef<?, DbStructureFamilyModelState<T>> getFamily(ElementIdentity<T> id) {
        DbModelRef<?, DbStructureFamilyModelState<T>> dbModelRef;
        DbEditorModel<T, DbStructureObjectModelState<T>> dbEditorModel = this.modelController.getStructureNodeModel(id);
        if (dbEditorModel != null) {
            DbEditorModel<T, DbStructureObjectModelState<T>> n = dbEditorModel;
            boolean bl = false;
            dbModelRef = DbStructureFamilyModelState.getParentFamilyNode(this.modelController, DbModelRef.create(n));
        } else {
            dbModelRef = null;
        }
        return dbModelRef;
    }

    public static final /* synthetic */ DbEditorModelController access$getModelController$p(DbObjectEditorModelSynchronizer $this) {
        return $this.modelController;
    }

    public static final /* synthetic */ void access$processChanges(DbObjectEditorModelSynchronizer $this, Set createdIds, Set modifiedIds, Set removedIds) {
        $this.processChanges(createdIds, modifiedIds, removedIds);
    }
}

