/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBraceMatcher
implements XmlAwareBraceMatcher {
    private static final int XML_TAG_TOKEN_GROUP = 1;
    private static final int XML_VALUE_DELIMITER_GROUP = 2;
    private static final BidirectionalMap<IElementType, IElementType> PAIRING_TOKENS = new BidirectionalMap();

    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(0);
        }
        Language l = tokenType.getLanguage();
        PairedBraceMatcher matcher = this.getPairedBraceMatcher(tokenType);
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() != tokenType && pair.getRightBraceType() != tokenType) continue;
                return l.hashCode();
            }
        }
        if (tokenType instanceof IXmlLeafElementType) {
            return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? 2 : 1;
        }
        return -1;
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        IElementType tokenType;
        PairedBraceMatcher matcher;
        if (iterator == null) {
            XmlBraceMatcher.$$$reportNull$$$0(1);
        }
        if (fileText == null) {
            XmlBraceMatcher.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(3);
        }
        if ((matcher = this.getPairedBraceMatcher(tokenType = iterator.getTokenType())) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() != tokenType) continue;
                return true;
            }
        }
        return tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || tokenType == XmlTokenType.XML_CDATA_START;
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        IElementType tokenType;
        PairedBraceMatcher matcher;
        if (iterator == null) {
            XmlBraceMatcher.$$$reportNull$$$0(4);
        }
        if (fileText == null) {
            XmlBraceMatcher.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(6);
        }
        if ((matcher = this.getPairedBraceMatcher(tokenType = iterator.getTokenType())) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getRightBraceType() != tokenType) continue;
                return true;
            }
        }
        if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER || tokenType == XmlTokenType.XML_CDATA_END) {
            return true;
        }
        if (tokenType == XmlTokenType.XML_TAG_END) {
            String tagName;
            boolean result = XmlBraceMatcher.findEndTagStart(iterator);
            if (this.isFileTypeWithSingleHtmlTags(fileType) && (tagName = this.getTagName(fileText, iterator)) != null && HtmlUtil.isSingleHtmlTag((String)tagName, (boolean)false)) {
                return !result;
            }
            return result;
        }
        return false;
    }

    protected boolean isFileTypeWithSingleHtmlTags(FileType fileType) {
        return fileType == HtmlFileType.INSTANCE;
    }

    @Nullable
    protected PairedBraceMatcher getPairedBraceMatcher(IElementType tokenType) {
        return (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
    }

    public boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2) {
        PairedBraceMatcher matcher;
        if (tokenType1 == null) {
            XmlBraceMatcher.$$$reportNull$$$0(7);
        }
        if (tokenType2 == null) {
            XmlBraceMatcher.$$$reportNull$$$0(8);
        }
        if ((matcher = this.getPairedBraceMatcher(tokenType1)) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() == tokenType1) {
                    return pair.getRightBraceType() == tokenType2;
                }
                if (pair.getRightBraceType() != tokenType1) continue;
                return pair.getLeftBraceType() == tokenType2;
            }
        }
        if (tokenType2.equals(PAIRING_TOKENS.get((Object)tokenType1))) {
            return true;
        }
        List keys = PAIRING_TOKENS.getKeysByValue((Object)tokenType1);
        return keys != null && keys.contains(tokenType2);
    }

    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator, @NotNull CharSequence text, @NotNull FileType fileType) {
        IElementType tokenType;
        PairedBraceMatcher matcher;
        if (iterator == null) {
            XmlBraceMatcher.$$$reportNull$$$0(9);
        }
        if (text == null) {
            XmlBraceMatcher.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(11);
        }
        if ((matcher = this.getPairedBraceMatcher(tokenType = iterator.getTokenType())) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() != tokenType && pair.getRightBraceType() != tokenType || !pair.isStructural()) continue;
                return true;
            }
        }
        return this.isXmlStructuralBrace(tokenType);
    }

    protected boolean isXmlStructuralBrace(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(12);
        }
        return true;
    }

    public boolean isStrictTagMatching(@NotNull FileType fileType, int braceGroupId) {
        if (fileType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(13);
        }
        if (braceGroupId == 1) {
            return this.isStrictTagMatchingForFileType(fileType);
        }
        return false;
    }

    protected boolean isStrictTagMatchingForFileType(FileType fileType) {
        return fileType == XmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public boolean areTagsCaseSensitive(@NotNull FileType fileType, int braceGroupId) {
        if (fileType == null) {
            XmlBraceMatcher.$$$reportNull$$$0(14);
        }
        return braceGroupId == 1 && fileType == XmlFileType.INSTANCE;
    }

    private static boolean findEndTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int balance = 0;
        int count = 0;
        while (balance >= 0) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
            if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                ++balance;
                continue;
            }
            if (tokenType != XmlTokenType.XML_END_TAG_START && tokenType != XmlTokenType.XML_START_TAG_START) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == XmlTokenType.XML_END_TAG_START;
    }

    public String getTagName(@NotNull CharSequence fileText, @NotNull HighlighterIterator iterator) {
        if (fileText == null) {
            XmlBraceMatcher.$$$reportNull$$$0(15);
        }
        if (iterator == null) {
            XmlBraceMatcher.$$$reportNull$$$0(16);
        }
        IElementType tokenType = iterator.getTokenType();
        String name = null;
        if (tokenType == XmlTokenType.XML_START_TAG_START) {
            iterator.advance();
            IElementType tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            boolean wasWhiteSpace = false;
            if (this.isWhitespace(tokenType1)) {
                wasWhiteSpace = true;
                iterator.advance();
                IElementType iElementType = tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            }
            if (tokenType1 == XmlTokenType.XML_TAG_NAME || tokenType1 == XmlTokenType.XML_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            if (wasWhiteSpace) {
                iterator.retreat();
            }
            iterator.retreat();
        } else if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            int balance = 0;
            int count = 0;
            IElementType tokenType1 = iterator.getTokenType();
            while (balance >= 0) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
                if (tokenType1 == XmlTokenType.XML_TAG_END || tokenType1 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    ++balance;
                    continue;
                }
                if (tokenType1 != XmlTokenType.XML_TAG_NAME) continue;
                --balance;
            }
            if (tokenType1 == XmlTokenType.XML_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        }
        return name;
    }

    protected boolean isWhitespace(IElementType tokenType1) {
        return tokenType1 == TokenType.WHITE_SPACE;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        PairedBraceMatcher matcher;
        if (type == null) {
            XmlBraceMatcher.$$$reportNull$$$0(17);
        }
        if ((matcher = this.getPairedBraceMatcher(type)) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() == type) {
                    return pair.getRightBraceType();
                }
                if (pair.getRightBraceType() != type) continue;
                return pair.getLeftBraceType();
            }
        }
        return null;
    }

    public int getCodeConstructStart(@NotNull PsiFile psiFile, int openingBraceOffset) {
        if (psiFile == null) {
            XmlBraceMatcher.$$$reportNull$$$0(18);
        }
        return openingBraceOffset;
    }

    static {
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_TAG_END, (Object)XmlTokenType.XML_START_TAG_START);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_CDATA_START, (Object)XmlTokenType.XML_CDATA_END);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_EMPTY_ELEMENT_END, (Object)XmlTokenType.XML_START_TAG_START);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/impl/XmlBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBraceTokenGroupId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairBraces";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isStructuralBrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isStrictTagMatching";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "areTagsCaseSensitive";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeConstructStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

