/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.jinja.template.formatter.BlockIndex;
import com.intellij.jinja.template.formatter.BlockModification;
import com.intellij.jinja.template.formatter.DjangoTagPairsRetrieveVisitor;
import com.intellij.jinja.template.formatter.DjangoTemplateFormatterUtil;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateBlockTreeFormatter {
    @NotNull
    public Block reformat(@Nullable XmlFormattingPolicy policy, @NotNull Block blockTree, @NotNull PsiElement myDjangoPsiRoot) {
        if (blockTree == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(0);
        }
        if (myDjangoPsiRoot == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(1);
        }
        BlockIndex blockIndex = this.createBlockIndex();
        blockIndex.doBuild(blockTree);
        DjangoTagPairsRetrieveVisitor visitor2 = new DjangoTagPairsRetrieveVisitor();
        myDjangoPsiRoot.accept((PsiElementVisitor)visitor2);
        List<PsiElement[]> tagPairs = visitor2.getTagPairs();
        Collections.reverse(tagPairs);
        for (PsiElement[] tagPair : tagPairs) {
            blockTree = this.balanceBlocks(policy, blockTree, tagPair, blockIndex);
        }
        Block block = blockTree;
        if (block == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(2);
        }
        return block;
    }

    protected BlockIndex createBlockIndex() {
        return new BlockIndex();
    }

    private Block balanceBlocks(@Nullable XmlFormattingPolicy policy, @NotNull Block blockTree, PsiElement @NotNull [] oneLevelElements, @NotNull BlockIndex index) {
        Block[] blocks;
        if (blockTree == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(3);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(4);
        }
        if (oneLevelElements == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(5);
        }
        if ((blocks = DjangoTemplateBlockTreeFormatter.getBlocksFor(oneLevelElements, index)).length < 2) {
            throw new IllegalArgumentException("blocks length should be >=2");
        }
        Block open = DjangoTemplateBlockTreeFormatter.getValidBlock(blocks[0], index);
        Block close = DjangoTemplateBlockTreeFormatter.getValidBlock(blocks[blocks.length - 1], index);
        HashSet<Block> middle = new HashSet<Block>();
        if (blocks.length > 2) {
            for (int i = 1; i < blocks.length - 1; ++i) {
                middle.add(DjangoTemplateBlockTreeFormatter.getValidBlock(blocks[i], index));
            }
        }
        if (open != close && open != null && close != null) {
            blockTree = this.balancePair(policy, open, close, middle, index);
        }
        return blockTree;
    }

    @Nullable
    private static Block getValidBlock(@Nullable Block block, @NotNull BlockIndex index) {
        ASTBlock astBlock;
        HtmlTag tag;
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(6);
        }
        if (block == null) {
            return null;
        }
        if (block instanceof ASTBlock && (tag = (HtmlTag)PsiTreeUtil.getParentOfType((PsiElement)(astBlock = (ASTBlock)block).getNode().getPsi(), HtmlTag.class)) != null && astBlock.getNode().getElementType() != DjangoTemplateTokenTypes.DJANGO_INJECTION_IN_HTML) {
            TextRange textRange = null;
            TextRange tagStart = XmlTagUtil.getStartTagRange((XmlTag)tag);
            if (tagStart != null && tagStart.contains(astBlock.getTextRange())) {
                textRange = tagStart;
            } else {
                TextRange tagEnd = XmlTagUtil.getEndTagRange((XmlTag)tag);
                if (tagEnd != null && tagEnd.contains(astBlock.getTextRange())) {
                    textRange = tagEnd;
                }
            }
            if (textRange != null) {
                return index.getBlock(textRange);
            }
        }
        return index.get(block);
    }

    private Block balancePair(@Nullable XmlFormattingPolicy policy, @NotNull Block open, @NotNull Block close, @NotNull Set<Block> middle, @NotNull BlockIndex index) {
        if (open == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(7);
        }
        if (close == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(8);
        }
        if (middle == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(9);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(10);
        }
        Block commonParent = DjangoTemplateBlockTreeFormatter.findCommonParent(index, open, close);
        ArrayList<Block> openParents = DjangoTemplateFormatterUtil.getParents(open, commonParent, index);
        ArrayList<Block> closeParents = DjangoTemplateFormatterUtil.getParents(close, commonParent, index);
        if (!(commonParent == null || DjangoTemplateBlockTreeFormatter.atOneLevel(open, close, commonParent, index) || openParents.isEmpty() || closeParents.isEmpty())) {
            Block openInParent = openParents.get(openParents.size() - 1);
            Block closeInParent = closeParents.get(closeParents.size() - 1);
            DjangoTemplateBlockTreeFormatter.moveToOneLevel(open, close, commonParent, openInParent, closeInParent, index);
        }
        return this.indentPair(policy, index.get(open), index.get(close), index.get(middle), index, index.getParent(open));
    }

    protected Block indentPair(@Nullable XmlFormattingPolicy policy, Block open, Block close, Set<Block> middle, BlockIndex index, Block parent) {
        return BlockModification.indentInnerBlocksBetween(policy, open, close, middle, parent).apply(index);
    }

    private static void moveToOneLevel(@NotNull Block open, @NotNull Block close, @NotNull Block commonParent, @NotNull Block openInParent, @NotNull Block closeInParent, @NotNull BlockIndex index) {
        if (open == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(11);
        }
        if (close == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(12);
        }
        if (commonParent == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(13);
        }
        if (openInParent == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(14);
        }
        if (closeInParent == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(15);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(16);
        }
        Block after = null;
        if (index.get(commonParent) == index.getParent(open)) {
            after = DjangoTemplateFormatterUtil.getPrevFor(index.get(closeInParent), index);
        }
        List<Block> l1 = DjangoTemplateBlockTreeFormatter.moveAllAfterToLevel(open, commonParent, index.getParent(open), index);
        List<Block> l2 = DjangoTemplateBlockTreeFormatter.moveAllAfterToLevel(close, commonParent, index.getParent(open), index);
        Block stop = after != null ? after : openInParent;
        List<Block> l3 = DjangoTemplateBlockTreeFormatter.moveAllBeforeToLevel(close, commonParent, stop, index.getParent(open), index);
        l1.addAll(l3);
        l1.addAll(l2);
        if (!l1.isEmpty()) {
            BlockModification.addBlocksAfter(l1, index.getParent(open), index.get(after)).apply(index);
        }
    }

    private static List<Block> moveAllBeforeToLevel(@NotNull Block beforeWhat, @NotNull Block top, @NotNull Block afterInTop, @NotNull Block whereToMove, @NotNull BlockIndex index) {
        if (beforeWhat == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(17);
        }
        if (top == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(18);
        }
        if (afterInTop == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(19);
        }
        if (whereToMove == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(20);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(21);
        }
        ArrayList<Block> addList = new ArrayList<Block>();
        DjangoTemplateBlockTreeFormatter.moveAllBeforeToLevel(index.getParent(beforeWhat), index.get(beforeWhat), index.get(top), index.get(afterInTop), index.getParent(whereToMove), index, addList);
        BlockModification.deleteBlocksFrom(Collections.singletonList(index.get(beforeWhat)), index.getParent(beforeWhat)).apply(index);
        Collections.reverse(addList);
        addList.add(beforeWhat);
        return addList;
    }

    private static List<Block> moveAllAfterToLevel(@NotNull Block afterWhat, @NotNull Block top, @NotNull Block whereToMove, @NotNull BlockIndex index) {
        if (afterWhat == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(22);
        }
        if (top == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(23);
        }
        if (whereToMove == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(24);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(25);
        }
        ArrayList<Block> result = new ArrayList<Block>();
        DjangoTemplateBlockTreeFormatter.moveAllAfterToLevel(index.getParent(afterWhat), index.get(afterWhat), index.get(top), whereToMove, index, result);
        return result;
    }

    private static void moveAllAfterToLevel(@NotNull Block fromWhere, @NotNull Block afterWhat, @NotNull Block top, @NotNull Block whereToMove, @NotNull BlockIndex index, @NotNull List<Block> addList) {
        if (fromWhere == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(26);
        }
        if (afterWhat == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(27);
        }
        if (top == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(28);
        }
        if (whereToMove == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(29);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(30);
        }
        if (addList == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(31);
        }
        if (fromWhere != top) {
            List subBlocks = fromWhere.getSubBlocks();
            if (fromWhere != whereToMove) {
                ArrayList<Block> list = new ArrayList<Block>();
                boolean add = false;
                for (Block b : subBlocks) {
                    if (add) {
                        list.add(b);
                    }
                    if (b != afterWhat) continue;
                    add = true;
                }
                if (!list.isEmpty()) {
                    BlockModification.deleteBlocksFrom(list, fromWhere).apply(index);
                }
                addList.addAll(list);
            }
            if (index.getParent(fromWhere) != null) {
                DjangoTemplateBlockTreeFormatter.moveAllAfterToLevel(index.getParent(fromWhere), index.getParent(afterWhat), index.get(top), index.get(whereToMove), index, addList);
            }
        }
    }

    private static void moveAllBeforeToLevel(Block fromWhere, Block beforeWhat, Block top, Block afterInTop, Block whereToMove, BlockIndex index, List<Block> addList) {
        if (fromWhere != null) {
            List subBlocks = fromWhere.getSubBlocks();
            ArrayList<Block> list = new ArrayList<Block>();
            boolean skip = fromWhere == top;
            for (Block b : subBlocks) {
                if (b == beforeWhat) {
                    skip = true;
                }
                if (!skip) {
                    list.add(b);
                }
                if (b != afterInTop) continue;
                skip = false;
            }
            if (!list.isEmpty()) {
                BlockModification.deleteBlocksFrom(list, fromWhere).apply(index);
                Collections.reverse(list);
                addList.addAll(list);
            }
            if (fromWhere != top) {
                DjangoTemplateBlockTreeFormatter.moveAllBeforeToLevel(index.getParent(fromWhere), index.getParent(beforeWhat), index.get(top), index.get(afterInTop), index.get(whereToMove), index, addList);
            }
        }
    }

    private static boolean atOneLevel(@NotNull Block open, @NotNull Block close, @NotNull Block commonParent, @NotNull BlockIndex index) {
        if (open == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(32);
        }
        if (close == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(33);
        }
        if (commonParent == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(34);
        }
        if (index == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(35);
        }
        return index.getParent(open) == commonParent && index.getParent(close) == commonParent;
    }

    @Nullable
    private static Block findCommonParent(BlockIndex blockIndex, Block ... blocks) {
        return DjangoTemplateFormatterUtil.findCommonParent(blockIndex, blocks);
    }

    private static Block[] getBlocksFor(PsiElement @NotNull [] oneLevelElements, @NotNull BlockIndex blockIndex) {
        if (blockIndex == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(36);
        }
        if (oneLevelElements == null) {
            DjangoTemplateBlockTreeFormatter.$$$reportNull$$$0(37);
        }
        Block[] blocks = new Block[oneLevelElements.length];
        for (int i = 0; i < oneLevelElements.length; ++i) {
            blocks[i] = blockIndex.getBlockForPsi(oneLevelElements[i]);
        }
        return blocks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDjangoPsiRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/formatter/DjangoTemplateBlockTreeFormatter";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 16: 
            case 21: 
            case 25: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneLevelElements";
                break;
            }
            case 7: 
            case 11: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "open";
                break;
            }
            case 8: 
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middle";
                break;
            }
            case 13: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonParent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openInParent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeInParent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeWhat";
                break;
            }
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "top";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterInTop";
                break;
            }
            case 20: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whereToMove";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterWhat";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromWhere";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addList";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/formatter/DjangoTemplateBlockTreeFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "balanceBlocks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValidBlock";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "balancePair";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveToOneLevel";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveAllBeforeToLevel";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "moveAllAfterToLevel";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "atOneLevel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBlocksFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

