/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.jinja.template.formatter.BlockIndex;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateFormatterUtil {
    private DjangoTemplateFormatterUtil() {
    }

    public static boolean isComplexElement(ASTNode node) {
        return node.getPsi() instanceof DjangoTagElementImpl;
    }

    @Nullable
    public static Block findCommonParent(@NotNull BlockIndex blockIndex, Block ... elements) {
        if (blockIndex == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(1);
        }
        if (elements.length == 0) {
            return null;
        }
        Block toReturn = null;
        for (Block element : elements) {
            if (element == null) continue;
            Block block = toReturn = toReturn == null ? element : DjangoTemplateFormatterUtil.findCommonParent(toReturn, element, blockIndex);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static Block findCommonParent(@NotNull Block element1, @NotNull Block element2, BlockIndex blockIndex) {
        Block parent2;
        Block parent1;
        if (element1 == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(3);
        }
        if (element1 == element2) {
            return element1;
        }
        ArrayList<Block> parents1 = DjangoTemplateFormatterUtil.getParents(element1, blockIndex);
        ArrayList<Block> parents2 = DjangoTemplateFormatterUtil.getParents(element2, blockIndex);
        int size = Math.min(parents1.size(), parents2.size());
        Block parent = null;
        for (int i = 1; i <= size && (parent1 = parents1.get(parents1.size() - i)).equals((Object)(parent2 = parents2.get(parents2.size() - i))); ++i) {
            parent = parent1;
        }
        return parent;
    }

    public static ArrayList<Block> getParents(Block block, BlockIndex blockIndex) {
        return DjangoTemplateFormatterUtil.getParents(block, null, blockIndex);
    }

    @NotNull
    public static ArrayList<Block> getParents(@NotNull Block block, @Nullable Block topLevel, @NotNull BlockIndex blockIndex) {
        if (block == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(4);
        }
        if (blockIndex == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(5);
        }
        ArrayList<Block> result = new ArrayList<Block>();
        Block cur = blockIndex.get(block);
        while (cur != null && cur != topLevel) {
            result.add(cur);
            cur = blockIndex.getParent(cur);
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static Block getPrevFor(Block block, BlockIndex index) {
        @NotNull Block parent = index.getParent(block);
        List children = parent.getSubBlocks();
        int i = children.indexOf(block);
        if (i == -1) {
            throw new IllegalStateException("element should be within children of his father");
        }
        if (i - 1 >= 0) {
            return (Block)parent.getSubBlocks().get(i - 1);
        }
        return null;
    }

    @NotNull
    public static Indent getChildIndent(int newChildIndex, @NotNull List<? extends Block> subBlocks) {
        if (subBlocks == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(7);
        }
        Indent indent = null;
        if (newChildIndex > subBlocks.size()) {
            newChildIndex = subBlocks.size();
        }
        if (newChildIndex > 0) {
            Block prev = subBlocks.get(newChildIndex - 1);
            indent = prev.getIndent();
            if (newChildIndex < subBlocks.size()) {
                Block next2 = subBlocks.get(newChildIndex);
                indent = next2.getIndent();
            }
        }
        if (indent == null) {
            indent = Indent.getNoneIndent();
        }
        Indent indent2 = indent;
        if (indent2 == null) {
            DjangoTemplateFormatterUtil.$$$reportNull$$$0(8);
        }
        return indent2;
    }

    @Nullable
    public static Alignment getFirstChildAlignment(Block block) {
        List subBlocks = block.getSubBlocks();
        for (Block subBlock : subBlocks) {
            Alignment alignment = subBlock.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/formatter/DjangoTemplateFormatterUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/formatter/DjangoTemplateFormatterUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

