/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.execution.Executor;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.ProfilerCommunication;
import com.intellij.python.profiler.ProfilerSessionVirtualFileImpl;
import com.intellij.python.profiler.SnapshotAction;
import com.intellij.util.PathMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013*\u00020\u001aH\u0000\u001a8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0016\"$\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018*\"\u0010\u0012\"\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u00a8\u0006!"}, d2={"buildProfileRunContentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "profilerCommunication", "Lcom/intellij/python/profiler/ProfilerCommunication;", "name", "", "createConsolePanel", "Ljavax/swing/JComponent;", "view", "actions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createToolbar", "LocalPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "identityFunction", "Lcom/intellij/python/profiler/LocalPathFunction;", "getIdentityFunction", "()Lkotlin/jvm/functions/Function1;", "asLocalPathFunction", "Lcom/intellij/util/PathMapper;", "openProfileResultsInEditor", "", "profileData", "Lcom/intellij/python/profiler/ProfileStats;", "file", "localPathFunction", "intellij.python.profiler"})
public final class ProfileSessionKt {
    @NotNull
    private static final Function1<Path, Path> identityFunction = ProfileSessionKt::identityFunction$lambda$0;

    private static final RunContentDescriptor buildProfileRunContentDescriptor(Project project, ConsoleView consoleView, ProcessHandler processHandler, ProfilerCommunication profilerCommunication, @NlsSafe String name) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        JComponent consolePanel = ProfileSessionKt.createConsolePanel(consoleView, (ActionGroup)actions);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, processHandler, consolePanel, name, AllIcons.Actions.Profile);
        actions.add((AnAction)new SnapshotAction(project, profilerCommunication, processHandler));
        actions.add((AnAction)new StopProcessAction("Stop process", "Stops current process", processHandler));
        actions.add((AnAction)new CloseAction(executor, descriptor, project));
        return descriptor;
    }

    private static final JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        panel2.add((Component)ProfileSessionKt.createToolbar(actions), "West");
        return panel2;
    }

    private static final JComponent createToolbar(ActionGroup actions) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PyProfileSession", actions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent(null);
        JComponent jComponent = actionToolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public static final Function1<Path, Path> getIdentityFunction() {
        return identityFunction;
    }

    @NotNull
    public static final Function1<Path, String> asLocalPathFunction(@NotNull PathMapper $this$asLocalPathFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$asLocalPathFunction, (String)"<this>");
        return arg_0 -> ProfileSessionKt.asLocalPathFunction$lambda$0($this$asLocalPathFunction, arg_0);
    }

    public static final void openProfileResultsInEditor(@NotNull Project project, @NotNull ProfileStats profileData, @Nullable String file, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profileData, (String)"profileData");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        ApplicationManager.getApplication().invokeLater(() -> ProfileSessionKt.openProfileResultsInEditor$lambda$0(project, profileData, localPathFunction, file), project.getDisposed());
    }

    private static final Path identityFunction$lambda$0(Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2;
    }

    private static final String asLocalPathFunction$lambda$0(PathMapper $this_asLocalPathFunction, Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return $this_asLocalPathFunction.convertToLocal(((Object)path2).toString());
    }

    private static final void openProfileResultsInEditor$lambda$0(Project $project, ProfileStats $profileData, Function1 $localPathFunction, String $file) {
        FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)new ProfilerSessionVirtualFileImpl($profileData, (Function1<? super Path, ? extends Path>)$localPathFunction, $file), true);
    }

    public static final /* synthetic */ RunContentDescriptor access$buildProfileRunContentDescriptor(Project project, ConsoleView consoleView, ProcessHandler processHandler, ProfilerCommunication profilerCommunication, String name) {
        return ProfileSessionKt.buildProfileRunContentDescriptor(project, consoleView, processHandler, profilerCommunication, name);
    }
}

