/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add.wizard.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.python.remoteInterpreter.add.wizard.ui.ValidationAwareForm;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.ui.ApplicationOnlySdkScopeController;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ui.SshConfigProjectLevelSetupForm;
import com.jetbrains.python.PyPsiBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshServerConfigurationForm
extends ValidationAwareForm {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Disposable myParent;
    private JPanel myMainPanel;
    private JBRadioButton myNewServerConfigurationRadioButton;
    private JPanel myNewServerConfigurationPanel;
    private JBTextField myHostTextField;
    private JBTextField myPortTextField;
    private JBTextField myUsernameTextField;
    private JBRadioButton myExistingServerConfigurationRadioButton;
    private JBLabel mySshConfigLabel;
    private SshConfigComboBox mySshConfigComboBox;
    private JBLabel myHostURLLabel;
    private JBLabel myHostURLValueLabel;
    private JPanel mySshConfigProjectLevelSetupPanel;
    @NotNull
    private final SshConfigProjectLevelSetupForm mySshConfigProjectLevelSetupForm;
    private static final BundleAccessor BUNDLE_ACCESSOR = new BundleAccessor(){

        @NotNull
        public String message(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = PyPsiBundle.message((String)key, (Object[])params);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String messageOrNull(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(2);
            }
            return PyPsiBundle.INSTANCE.messageOrNull(key, params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/add/wizard/ui/SshServerConfigurationForm$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/add/wizard/ui/SshServerConfigurationForm$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "messageOrNull";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    private void createUIComponents() {
        this.mySshConfigComboBox = new SshConfigComboBox(this.myProject, this.myParent, SshConfigVisibility.App);
        this.mySshConfigComboBox.reload();
    }

    public SshServerConfigurationForm(@Nullable Project project, @NotNull Disposable parent) {
        if (parent == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myParent = parent;
        this.$$$setupUI$$$();
        this.myNewServerConfigurationRadioButton.addActionListener(e -> this.onNewConfigurationSelected());
        this.myExistingServerConfigurationRadioButton.addActionListener(e -> this.onExistingConfigurationSelected());
        DocumentListener listener = this.createUpdateIsValidDocumentListener();
        this.myHostTextField.getDocument().addDocumentListener(listener);
        this.myPortTextField.getDocument().addDocumentListener(listener);
        this.myUsernameTextField.getDocument().addDocumentListener(listener);
        this.mySshConfigComboBox.setDataListener(this::onSshConfigurationChanged);
        this.mySshConfigProjectLevelSetupForm = new SshConfigProjectLevelSetupForm(project, BUNDLE_ACCESSOR, new SshConfigProjectLevelSetupForm.Listener(){

            public void onConfigMoved(@NotNull SshConfig movedConfig) {
                if (movedConfig == null) {
                    2.$$$reportNull$$$0(0);
                }
                SshServerConfigurationForm.this.setupSshCombo(movedConfig);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "movedConfig", "com/intellij/python/remoteInterpreter/add/wizard/ui/SshServerConfigurationForm$2", "onConfigMoved"));
            }
        }, (SdkScopeController)ApplicationOnlySdkScopeController.INSTANCE);
        this.mySshConfigProjectLevelSetupPanel.setVisible(false);
        this.mySshConfigProjectLevelSetupPanel.setLayout(new BorderLayout());
        this.mySshConfigProjectLevelSetupPanel.add((Component)this.mySshConfigProjectLevelSetupForm.getMainPanel(), "Center");
        this.myNewServerConfigurationRadioButton.setSelected(true);
        this.onNewConfigurationSelected();
        this.hideSshConfigurationURL();
    }

    private void setupSshCombo(@Nullable SshConfig configToSelect) {
        if (configToSelect == null) {
            this.mySshConfigComboBox.reload();
        } else {
            this.mySshConfigComboBox.reload(configToSelect.createPresentableId(), configToSelect.getVisibility());
            this.mySshConfigProjectLevelSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateSshConfig(configToSelect)));
        }
        this.onSshConfigurationChanged();
    }

    @Nls
    @Nullable
    public String validateSshConfig(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(1);
        }
        if (sshConfig.isProjectLevel()) {
            return PythonRemoteInterpreterBundle.message("ssh.connection.wizard.configuration.project.level.not.supported", new Object[0]);
        }
        return null;
    }

    private void onNewConfigurationSelected() {
        this.updateConfigurationOptionsEnabled(true);
        this.updateSshConfigProjectLevelSetupPanel();
        this.updateIsValid();
    }

    private void onExistingConfigurationSelected() {
        this.updateConfigurationOptionsEnabled(false);
        this.updateSshConfigProjectLevelSetupPanel();
        this.updateIsValid();
    }

    private void onSshConfigurationChanged() {
        Pair dataAndName = this.mySshConfigComboBox.getSelectedUiDataAndName();
        if (dataAndName == null || dataAndName.first == null) {
            this.hideSshConfigurationURL();
        } else {
            String url = RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)((RemoteCredentials)dataAndName.first));
            this.showSshConfigurationURL(url);
        }
        this.updateSshConfigProjectLevelSetupPanel();
        this.updateIsValid();
    }

    private void hideSshConfigurationURL() {
        this.myHostURLLabel.setVisible(false);
        this.myHostURLValueLabel.setVisible(false);
    }

    private void showSshConfigurationURL(@NlsSafe @NotNull String url) {
        if (url == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(2);
        }
        this.myHostURLLabel.setVisible(true);
        this.myHostURLValueLabel.setVisible(true);
        this.myHostURLValueLabel.setText(url);
    }

    @Override
    protected boolean computeIsValid() {
        if (this.myNewServerConfigurationRadioButton.isSelected()) {
            return this.getHost() != null && this.getPort() != null && this.getUsername() != null;
        }
        if (this.myExistingServerConfigurationRadioButton.isSelected()) {
            SshConfig sshConfig = this.mySshConfigComboBox.getSelectedSshConfig();
            return sshConfig != null && !sshConfig.isProjectLevel();
        }
        return false;
    }

    private void updateSshConfigProjectLevelSetupPanel() {
        SshConfig sshConfig = this.mySshConfigComboBox.getSelectedSshConfig();
        if (this.myNewServerConfigurationRadioButton.isSelected() || sshConfig == null || !sshConfig.isProjectLevel()) {
            this.mySshConfigProjectLevelSetupForm.setSshConfigName(null);
            this.mySshConfigProjectLevelSetupPanel.setVisible(false);
        } else {
            this.mySshConfigProjectLevelSetupForm.setSshConfigName(sshConfig.getName());
            this.mySshConfigProjectLevelSetupPanel.setVisible(true);
        }
    }

    private void updateConfigurationOptionsEnabled(boolean newServerOptionEnabled) {
        UIUtil.setEnabled((Component)this.myNewServerConfigurationPanel, (boolean)newServerOptionEnabled, (boolean)true);
        this.mySshConfigLabel.setEnabled(!newServerOptionEnabled);
        this.mySshConfigComboBox.setEnabled(!newServerOptionEnabled);
        this.myHostURLLabel.setEnabled(!newServerOptionEnabled);
        this.myHostURLValueLabel.setEnabled(!newServerOptionEnabled);
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public String getUsername() {
        return StringUtil.nullize((String)this.myUsernameTextField.getText().trim());
    }

    @Nullable
    public String getHost() {
        return StringUtil.nullize((String)this.myHostTextField.getText().trim());
    }

    @Nullable
    public Integer getPort() {
        try {
            return Integer.parseInt(this.myPortTextField.getText().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public <T> T accept(@NotNull OptionVisitor<T> visitor2) {
        if (visitor2 == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(4);
        }
        if (this.myNewServerConfigurationRadioButton.isSelected()) {
            T t = visitor2.onNewServerConfiguration(this.getHost(), this.getPort(), this.getUsername());
            if (t == null) {
                SshServerConfigurationForm.$$$reportNull$$$0(5);
            }
            return t;
        }
        SshConfig sshConfig = this.mySshConfigComboBox.getSelectedSshConfig();
        T t = visitor2.onExistingServerConfiguration(sshConfig);
        if (t == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(6);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/add/wizard/ui/SshServerConfigurationForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/add/wizard/ui/SshServerConfigurationForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateSshConfig";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showSshConfigurationURL";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNewServerConfigurationRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.new.server.configuration.option.label.text"));
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExistingServerConfigurationRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.existing.server.configuration.label.text"));
        jPanel3.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNewServerConfigurationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.host.label.text"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.port.label.text"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortTextField = jBTextField3 = new JBTextField();
        jBTextField3.setText("22");
        jPanel2.add((Component)jBTextField3, new GridConstraints(0, 3, 1, 1, 8, 1, 0, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.username.label.text"));
        jPanel2.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameTextField = jBTextField2 = new JBTextField();
        jBTextField2.setText("");
        jPanel2.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(200, -1), null));
        this.myHostTextField = jBTextField = new JBTextField();
        jBTextField.setText("");
        jPanel2.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, new Dimension(120, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myHostURLLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("ssh.connection.wizard.host.url.label.text"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostURLValueLabel = jBLabel2 = new JBLabel();
        jPanel4.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySshConfigProjectLevelSetupPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySshConfigLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PythonRemoteInterpreterBundle", SshServerConfigurationForm.class).getString("sdk.connection.wizard.ssh.config.label.text"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SshConfigComboBox sshConfigComboBox = this.mySshConfigComboBox;
        jPanel4.add((Component)sshConfigComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface OptionVisitor<T> {
        @NotNull
        public T onNewServerConfiguration(@NotNull String var1, int var2, @NotNull String var3);

        @NotNull
        public T onExistingServerConfiguration(@NotNull SshConfig var1);
    }
}

