/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.refactoring.extractComponent;

import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.angular2.codeInsight.template.Angular2TemplateScopesResolver;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.parser.Angular2EmbeddedExprTokenType;
import org.angular2.lang.expr.psi.Angular2Action;
import org.angular2.lang.expr.psi.Angular2Binding;
import org.angular2.lang.expr.psi.Angular2EmbeddedExpression;
import org.angular2.lang.expr.psi.Angular2Interpolation;
import org.angular2.lang.expr.psi.Angular2PipeReferenceExpression;
import org.angular2.lang.expr.psi.Angular2RecursiveVisitor;
import org.angular2.lang.html.lexer.Angular2HtmlTokenTypes;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlBananaBoxBinding;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.Angular2HtmlExpansionForm;
import org.angular2.lang.html.psi.Angular2HtmlPropertyBinding;
import org.angular2.lang.html.psi.Angular2HtmlRecursiveElementVisitor;
import org.angular2.lang.html.psi.Angular2HtmlTemplateBindings;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.angular2.refactoring.extractComponent.Angular2ExtractComponentUnsupportedException;
import org.angular2.refactoring.extractComponent.Angular2ExtractedComponent;
import org.angular2.refactoring.extractComponent.Angular2ExtractedComponentBuilder;
import org.angular2.refactoring.extractComponent.Attr;
import org.angular2.refactoring.extractComponent.Replacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/angular2/refactoring/extractComponent/Angular2ExtractedComponentBuilder;", "", "sourceFile", "Lcom/intellij/psi/PsiFile;", "selectionStart", "", "selectionEnd", "<init>", "(Lcom/intellij/psi/PsiFile;II)V", "extractedRange", "Lcom/intellij/openapi/util/TextRange;", "enclosingTag", "Lcom/intellij/psi/xml/XmlTag;", "nameClashes", "", "", "deduplicate", "name", "isInsideInterpolation", "", "element", "Lcom/intellij/psi/PsiElement;", "build", "Lorg/angular2/refactoring/extractComponent/Angular2ExtractedComponent;", "doBuild", "isReferenceReferencingOuterScope", "reference", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "findUnqualifiedReference", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngular2ExtractedComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Angular2ExtractedComponentBuilder.kt\norg/angular2/refactoring/extractComponent/Angular2ExtractedComponentBuilder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n67#2:284\n1#3:285\n*S KotlinDebug\n*F\n+ 1 Angular2ExtractedComponentBuilder.kt\norg/angular2/refactoring/extractComponent/Angular2ExtractedComponentBuilder\n*L\n71#1:284\n*E\n"})
public final class Angular2ExtractedComponentBuilder {
    @NotNull
    private final PsiFile sourceFile;
    private final int selectionStart;
    private final int selectionEnd;
    @NotNull
    private TextRange extractedRange;
    @Nullable
    private XmlTag enclosingTag;
    @NotNull
    private final Map<String, Integer> nameClashes;

    public Angular2ExtractedComponentBuilder(@NotNull PsiFile sourceFile, int selectionStart, int selectionEnd) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.sourceFile = sourceFile;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        this.extractedRange = textRange;
        this.nameClashes = new LinkedHashMap();
    }

    private final String deduplicate(String name) {
        Integer counter = this.nameClashes.get(name);
        if (counter != null) {
            int n = counter;
            counter = n + 1;
            this.nameClashes.put(name, counter);
            return name + "_" + counter;
        }
        this.nameClashes.put(name, 0);
        return name;
    }

    private final boolean isInsideInterpolation(PsiElement element) {
        IElementType iElementType = element.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (Intrinsics.areEqual((Object)elementType, (Object)Angular2HtmlTokenTypes.INTERPOLATION_START) || Intrinsics.areEqual((Object)elementType, (Object)Angular2HtmlTokenTypes.INTERPOLATION_END)) {
            return true;
        }
        for (PsiElement parent : PsiTreeUtilKt.parents((PsiElement)element, (boolean)false)) {
            if (!(parent.getNode().getElementType() instanceof Angular2EmbeddedExprTokenType.Angular2InterpolationExprTokenType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Angular2ExtractedComponent build() {
        try {
            TextRange textRange;
            XmlTag tag;
            PsiElement psiElement = this.sourceFile.findElementAt(this.selectionStart);
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement startElement = psiElement;
            PsiElement psiElement2 = this.sourceFile.findElementAt(this.selectionEnd);
            if (psiElement2 == null) {
                PsiElement psiElement3 = this.sourceFile.findElementAt(this.selectionEnd - 1);
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
            PsiElement endElement = psiElement2;
            if (this.isInsideInterpolation(startElement) || this.isInsideInterpolation(endElement)) {
                throw new IllegalStateException();
            }
            PsiElement psiElement4 = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (psiElement4 != null) {
                void $this$parentOfType$iv;
                PsiElement psiElement5 = psiElement4;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                v4 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)false);
            } else {
                v4 = tag = null;
            }
            if (this.selectionStart != this.selectionEnd) {
                textRange = new TextRange(this.selectionStart, this.selectionEnd);
            } else {
                XmlTag xmlTag = tag;
                if (xmlTag != null) {
                    TextRange textRange2 = xmlTag.getTextRange();
                    textRange = textRange2;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
                } else {
                    throw new IllegalStateException();
                }
            }
            this.extractedRange = textRange;
            this.enclosingTag = tag == null || tag.getValue().getTextRange().containsRange(this.selectionStart, this.selectionEnd) ? tag : tag.getParentTag();
        }
        catch (IllegalStateException e) {
            throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.unsupported-selection", new Object[0]));
        }
        return this.doBuild();
    }

    private final Angular2ExtractedComponent doBuild() throws Angular2ExtractComponentUnsupportedException {
        int templateStartOffset = this.extractedRange.getStartOffset();
        Map propertyBindings = new LinkedHashMap();
        List attributes = new ArrayList();
        List infos = new ArrayList();
        List replacements = new ArrayList();
        XmlTag xmlTag = this.enclosingTag;
        (xmlTag != null ? (PsiNamedElement)xmlTag : (PsiNamedElement)this.sourceFile).acceptChildren((PsiElementVisitor)new Angular2HtmlRecursiveElementVisitor(this, attributes, replacements, templateStartOffset, propertyBindings, infos){
            final /* synthetic */ Angular2ExtractedComponentBuilder this$0;
            final /* synthetic */ List<Attr> $attributes;
            final /* synthetic */ List<Replacement> $replacements;
            final /* synthetic */ int $templateStartOffset;
            final /* synthetic */ Map<String, Attr> $propertyBindings;
            final /* synthetic */ List<ES6ReferenceExpressionsInfo> $infos;
            {
                this.this$0 = $receiver;
                this.$attributes = $attributes;
                this.$replacements = $replacements;
                this.$templateStartOffset = $templateStartOffset;
                this.$propertyBindings = $propertyBindings;
                this.$infos = $infos;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.getNode().getElementType() instanceof Angular2EmbeddedExprTokenType.Angular2InterpolationExprTokenType) {
                    for (PsiElement grandChild = element.getFirstChild(); grandChild != null; grandChild = grandChild.getNextSibling()) {
                        if (!(grandChild instanceof Angular2Interpolation)) continue;
                        this.pseudoVisitTextInterpolation((Angular2Interpolation)grandChild);
                        return;
                    }
                }
                super.visitElement(element);
            }

            public void visitXmlTag(XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).intersects(tag.getTextRange())) {
                    return;
                }
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(tag.getTextRange())) {
                    throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.unsupported-selection", new Object[0]));
                }
                if (Intrinsics.areEqual((Object)tag.getName(), (Object)"ng-content")) {
                    throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.unsupported-ng-content", new Object[0]));
                }
                super.visitXmlTag(tag);
            }

            public void visitExpansionForm(Angular2HtmlExpansionForm expansion) {
                Intrinsics.checkNotNullParameter((Object)expansion, (String)"expansion");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(expansion.getTextRange())) {
                    return;
                }
                throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.unsupported-i18n", new Object[0]));
            }

            public void visitTemplateBindings(Angular2HtmlTemplateBindings bindings) {
                Intrinsics.checkNotNullParameter((Object)bindings, (String)"bindings");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(bindings.getTextRange())) {
                    return;
                }
                this.handleEmbeddedExpression(bindings.getBindings());
            }

            public void visitPropertyBinding(Angular2HtmlPropertyBinding propertyBinding) {
                Intrinsics.checkNotNullParameter((Object)propertyBinding, (String)"propertyBinding");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(propertyBinding.getTextRange())) {
                    return;
                }
                if (propertyBinding.getBindingType() == PropertyBindingType.ANIMATION) {
                    throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.animations", new Object[0]));
                }
                Angular2Binding binding = propertyBinding.getBinding();
                if (binding != null) {
                    this.handleEmbeddedExpression(binding);
                } else {
                    for (Angular2Interpolation interpolation : propertyBinding.getInterpolations()) {
                        this.handleEmbeddedExpression(interpolation);
                    }
                }
            }

            public void visitEvent(Angular2HtmlEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(event.getTextRange())) {
                    return;
                }
                if (event.getEventType() == Angular2HtmlEvent.EventType.ANIMATION) {
                    throw new Angular2ExtractComponentUnsupportedException(Angular2Bundle.Companion.message("angular.refactor.extractComponent.animations", new Object[0]));
                }
                Angular2Action embeddedExpression = event.getAction();
                if (embeddedExpression == null) {
                    return;
                }
                this.handleEmbeddedExpression(embeddedExpression);
            }

            public void visitBananaBoxBinding(Angular2HtmlBananaBoxBinding bananaBoxBinding) {
                JSExpression expression;
                Intrinsics.checkNotNullParameter((Object)bananaBoxBinding, (String)"bananaBoxBinding");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(bananaBoxBinding.getTextRange())) {
                    return;
                }
                Angular2Binding angular2Binding = bananaBoxBinding.getBinding();
                Object object = expression = angular2Binding != null ? angular2Binding.getExpression() : null;
                if (!(expression instanceof JSReferenceExpression)) {
                    return;
                }
                if (!Angular2ExtractedComponentBuilder.access$isReferenceReferencingOuterScope(this.this$0, Angular2ExtractedComponentBuilder.access$findUnqualifiedReference(this.this$0, (JSReferenceExpression)expression))) {
                    return;
                }
                String name = Angular2ExtractedComponentBuilder.access$deduplicate(this.this$0, bananaBoxBinding.getPropertyName());
                doBuild.1 var5_4 = this;
                int n = this.$templateStartOffset;
                doBuild.1 it = var5_4;
                boolean bl = false;
                String inputName = bananaBoxBinding.getPropertyName();
                String outputName = bananaBoxBinding.getPropertyName() + "Change";
                String replacedText = StringsKt.trimIndent((String)("\n            " + Angular2AttributeType.PROPERTY_BINDING.buildName(inputName) + "=\"" + name + "\" \n            " + Angular2AttributeType.EVENT.buildName(outputName) + "=\"" + name + "Change.emit($event)\"\n          "));
                TextRange textRange = bananaBoxBinding.getTextRange().shiftLeft(n);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
                Replacement replacement = new Replacement(textRange, replacedText);
                Angular2Binding angular2Binding2 = bananaBoxBinding.getBinding();
                JSType jsType = this.processElementJSType((PsiElement)(angular2Binding2 != null ? angular2Binding2.getExpression() : null));
                String string = bananaBoxBinding.getValue();
                Intrinsics.checkNotNull((Object)string);
                this.$attributes.add(new Attr(name, jsType, string, Angular2AttributeType.BANANA_BOX_BINDING));
                this.$replacements.add(replacement);
            }

            public final void pseudoVisitTextInterpolation(Angular2Interpolation interpolation) {
                Intrinsics.checkNotNullParameter((Object)interpolation, (String)"interpolation");
                if (!Angular2ExtractedComponentBuilder.access$getExtractedRange$p(this.this$0).contains(interpolation.getTextRange())) {
                    return;
                }
                this.handleEmbeddedExpression(interpolation);
            }

            public final void handleEmbeddedExpression(Angular2EmbeddedExpression embeddedExpression) {
                Intrinsics.checkNotNullParameter((Object)embeddedExpression, (String)"embeddedExpression");
                embeddedExpression.acceptChildren((PsiElementVisitor)new Angular2RecursiveVisitor(this.this$0, this.$propertyBindings, this, this.$attributes, this.$templateStartOffset, this.$replacements){
                    final /* synthetic */ Angular2ExtractedComponentBuilder this$0;
                    final /* synthetic */ Map<String, Attr> $propertyBindings;
                    final /* synthetic */ doBuild.1 this$1;
                    final /* synthetic */ List<Attr> $attributes;
                    final /* synthetic */ int $templateStartOffset;
                    final /* synthetic */ List<Replacement> $replacements;
                    {
                        this.this$0 = $receiver;
                        this.$propertyBindings = $propertyBindings;
                        this.this$1 = $receiver2;
                        this.$attributes = $attributes;
                        this.$templateStartOffset = $templateStartOffset;
                        this.$replacements = $replacements;
                    }

                    public void visitJSReferenceExpression(JSReferenceExpression reference) {
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        JSReferenceExpression unqualifiedReference = Angular2ExtractedComponentBuilder.access$findUnqualifiedReference(this.this$0, reference);
                        if (reference instanceof Angular2PipeReferenceExpression) {
                            return;
                        }
                        if (!Angular2ExtractedComponentBuilder.access$isReferenceReferencingOuterScope(this.this$0, unqualifiedReference)) {
                            return;
                        }
                        String value = unqualifiedReference.getText();
                        Intrinsics.checkNotNull((Object)value);
                        String name = Angular2ExtractedComponentBuilder.access$deduplicate(this.this$0, value);
                        Attr attr = this.$propertyBindings.get(value);
                        if (attr == null) {
                            JSType jsType = this.this$1.processElementJSType((PsiElement)unqualifiedReference);
                            attr = new Attr(name, jsType, value, Angular2AttributeType.PROPERTY_BINDING);
                            this.$attributes.add(attr);
                            this.$propertyBindings.put(value, attr);
                        }
                        TextRange textRange = unqualifiedReference.getTextRange().shiftLeft(this.$templateStartOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
                        Replacement replacement = new Replacement(textRange, attr.getName());
                        this.$replacements.add(replacement);
                    }
                });
            }

            public final JSType processElementJSType(PsiElement element) {
                JSReferenceExpression source;
                Object object;
                JSType jsType = JSResolveUtil.getElementJSType((PsiElement)element, (boolean)true);
                PsiElement $this$asSafely$iv = element;
                boolean $i$f$asSafely = false;
                PsiElement psiElement = $this$asSafely$iv;
                if (!(psiElement instanceof JSReferenceExpression)) {
                    psiElement = null;
                }
                if ((object = (JSReferenceExpression)psiElement) == null || (object = object.resolve()) == null) {
                    JSType jSType = jsType;
                    object = jSType != null ? jSType.getSourceElement() : null;
                }
                if ((source = object) != null) {
                    ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo((PsiElement)source);
                    Intrinsics.checkNotNullExpressionValue((Object)eS6ReferenceExpressionsInfo, (String)"getInfo(...)");
                    this.$infos.add(eS6ReferenceExpressionsInfo);
                }
                if (jsType != null && !jsType.isTypeScript()) {
                    JSType jSType = jsType.substitute(element).withNewSource(JSTypeSource.EMPTY_TS);
                    Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"withNewSource(...)");
                    return jSType;
                }
                JSType jSType = jsType;
                if (jSType == null || (jSType = jSType.substitute(element)) == null) {
                    JSAnyType jSAnyType = JSAnyType.get((JSTypeSource)JSTypeSource.EMPTY_TS);
                    Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"get(...)");
                    jSType = (JSType)jSAnyType;
                }
                return jSType;
            }
        });
        String string = this.extractedRange.substring(this.sourceFile.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new Angular2ExtractedComponent(string, templateStartOffset, attributes, replacements, infos);
    }

    private final boolean isReferenceReferencingOuterScope(JSReferenceExpression reference) {
        block9: {
            block8: {
                boolean bl;
                if (Angular2TemplateScopesResolver.isImplicitReferenceExpression(reference)) {
                    return false;
                }
                PsiElement source = reference.resolve();
                if (source == null) {
                    return true;
                }
                if (source.getContainingFile() instanceof JSFile) {
                    return true;
                }
                if (this.enclosingTag != null && !PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)this.enclosingTag), (PsiElement)source, (boolean)true)) break block8;
                TextRange textRange = source.getTextRange();
                if (textRange != null) {
                    TextRange it = textRange;
                    boolean bl2 = false;
                    bl = !this.extractedRange.contains(it);
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return false;
    }

    private final JSReferenceExpression findUnqualifiedReference(JSReferenceExpression reference) {
        JSReferenceExpression unqualifiedReference = reference;
        while (unqualifiedReference.getQualifier() instanceof JSReferenceExpression) {
            JSExpression jSExpression = unqualifiedReference.getQualifier();
            Intrinsics.checkNotNull((Object)jSExpression, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSReferenceExpression");
            unqualifiedReference = (JSReferenceExpression)jSExpression;
        }
        return unqualifiedReference;
    }

    public static final /* synthetic */ TextRange access$getExtractedRange$p(Angular2ExtractedComponentBuilder $this) {
        return $this.extractedRange;
    }

    public static final /* synthetic */ boolean access$isReferenceReferencingOuterScope(Angular2ExtractedComponentBuilder $this, JSReferenceExpression reference) {
        return $this.isReferenceReferencingOuterScope(reference);
    }

    public static final /* synthetic */ JSReferenceExpression access$findUnqualifiedReference(Angular2ExtractedComponentBuilder $this, JSReferenceExpression reference) {
        return $this.findUnqualifiedReference(reference);
    }

    public static final /* synthetic */ String access$deduplicate(Angular2ExtractedComponentBuilder $this, String name) {
        return $this.deduplicate(name);
    }
}

