import ast
import io
import re
from _typeshed import Incomplete, Unused
from collections.abc import Callable, Iterable
from datetime import datetime
from threading import local as _localbase
from types import CodeType, FunctionType, TracebackType
from typing import Any, NoReturn, overload

localbase = _localbase

class PonyDeprecationWarning(DeprecationWarning): ...

def deprecated(stacklevel: int, message: str) -> None: ...
def decorator(caller, func=None): ...
def decorator_with_params(dec): ...
def cut_traceback(func): ...

cut_traceback_depth: int

@overload
def reraise(exc_type: Unused, exc: None, tb: TracebackType | None) -> None: ...
@overload
def reraise(exc_type: Unused, exc: BaseException, tb: TracebackType | None) -> NoReturn: ...
def throw(exc_type: Exception | Callable[..., Exception], *args, **kwargs) -> NoReturn: ...
def truncate_repr(s: object, max_len: int = 100) -> str: ...

codeobjects: dict[int, CodeType]

def get_codeobject_id(codeobject: CodeType) -> int: ...

lambda_args_cache: dict[int | ast.Lambda, list[str]]

def get_lambda_args(func: FunctionType | ast.Lambda) -> list[str]: ...
def error_method(*args: Unused, **kwargs: Unused) -> NoReturn: ...
def is_ident(string: str) -> bool: ...
def split_name(name: str) -> list[str]: ...
def uppercase_name(name: str) -> str: ...
def lowercase_name(name: str) -> str: ...
def camelcase_name(name: str) -> str: ...
def mixedcase_name(name: str) -> str: ...
def import_module(name: str): ...
def is_absolute_path(filename: str) -> bool: ...
def absolutize_path(filename: str, frame_depth: int) -> str: ...
def current_timestamp() -> str: ...
def datetime2timestamp(d: datetime) -> str: ...
def timestamp2datetime(t: str) -> datetime: ...

expr1_re: re.Pattern[str]
expr2_re: re.Pattern[str]
expr3_re: re.Pattern[str]

def parse_expr(s: str, pos: int = 0) -> tuple[str, bool]: ...
def tostring(x): ...
def strjoin(
    sep: str, strings: Iterable[str], source_encoding: str = "ascii", dest_encoding: str | None = None
) -> str | bytes: ...
def count(*args, **kwargs): ...
def avg(iter: Iterable[float | None]) -> float | None: ...
@overload
def group_concat(items: None, sep: str = ",") -> None: ...
@overload
def group_concat(items: Iterable[object], sep: str = ",") -> str: ...
def coalesce(*args: Any) -> Any: ...
def distinct(iter): ...
def concat(*args) -> str: ...
def between(x: float, a: float, b: float) -> bool: ...
def is_utf8(encoding: str) -> bool: ...
def pickle_ast(val): ...
def unpickle_ast(pickled: io.BytesIO): ...
def copy_ast(tree): ...

class HashableDict(dict[Incomplete, Incomplete]):
    def __hash__(self) -> int: ...  # type: ignore[override]
    def __deepcopy__(self, memo): ...
    __setitem__: Incomplete
    __delitem__: Incomplete
    clear: Incomplete
    pop: Incomplete
    popitem: Incomplete
    setdefault: Incomplete
    update: Incomplete

def deref_proxy(value): ...
def deduplicate(value, deduplication_cache): ...
