/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.migration;

import com.intellij.database.console.ConsolesMigrationManager;
import com.intellij.database.console.DataSourcePerFileMappings;
import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.console.migration.ConsolesMigrationManagerImpl;
import com.intellij.database.console.migration.ConsolesMigrationStorage;
import com.intellij.database.console.migration.ConsolesMigrationStorageGlobal;
import com.intellij.database.console.migration.dialog.AdvancedConsolesMigrationDialog;
import com.intellij.database.console.migration.dialog.SimpleConsolesMigrationDialog;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.sql.SqlFileType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0002$%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J9\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ'\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ(\u0010\u001f\u001a\u00020\u00122\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0082@\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl;", "Lcom/intellij/database/console/ConsolesMigrationManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "migrationStorage", "Lcom/intellij/database/console/migration/ConsolesMigrationStorage;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "migrateIfNeeded", "", "migrateSqlFileTypeIfNeeded", "forceMigrate", "consoles", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceAdvanced", "", "forceMigrate$intellij_database_impl", "migrationInfo", "Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "attachConsolesToDataSources", "allDataSourcesToConsoles", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConsoles", "isMigrated", "MigrationInfo", "ConsolesMigrationProjectActivity", "intellij.database.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConsolesMigrationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolesMigrationManagerImpl.kt\ncom/intellij/database/console/migration/ConsolesMigrationManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,171:1\n1563#2:172\n1634#2,3:173\n774#2:180\n865#2,2:181\n774#2:183\n865#2,2:184\n126#3:176\n153#3,3:177\n*S KotlinDebug\n*F\n+ 1 ConsolesMigrationManagerImpl.kt\ncom/intellij/database/console/migration/ConsolesMigrationManagerImpl\n*L\n76#1:172\n76#1:173,3\n138#1:180\n138#1:181,2\n139#1:183\n139#1:184,2\n101#1:176\n101#1:177,3\n*E\n"})
public final class ConsolesMigrationManagerImpl
implements ConsolesMigrationManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConsolesMigrationStorage migrationStorage;
    @NotNull
    private final Logger LOG;

    public ConsolesMigrationManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.migrationStorage = ConsolesMigrationStorage.Companion.getInstance(this.project);
        Logger logger = Logger.getInstance(ConsolesMigrationManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public void migrateIfNeeded() {
        if (PlatformProjectOpenProcessor.Companion.isNewlyCreatedProject(this.project) || PlatformProjectOpenProcessor.Companion.isNewProject(this.project)) {
            this.migrationStorage.setMigrated();
            return;
        }
        if (this.isMigrated()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ConsolesMigrationManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ ConsolesMigrationManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        consoles = ConsolesMigrationManagerImpl.access$getConsoles(this.this$0);
                                        if (consoles.isEmpty()) {
                                            ConsolesMigrationManagerImpl.access$getMigrationStorage$p(this.this$0).setMigrated();
                                            return Unit.INSTANCE;
                                        }
                                        if (!ConsolesMigrationManagerImpl.access$getMigrationStorage$p(this.this$0).getAreConsolesAttachedToDataSources()) {
                                            this.L$0 = consoles;
                                            this.label = 1;
                                            v0 = ConsolesMigrationManagerImpl.access$attachConsolesToDataSources(this.this$0, consoles, (Continuation)this);
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                        }
                                        ** GOTO lbl20
                                    }
                                    case 1: {
                                        consoles = (Map)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl20:
                                        // 2 sources

                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)consoles);
                                        this.label = 2;
                                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (Map<LocalDataSource, ? extends List<? extends VirtualFile>>)consoles, null){
                                            int label;
                                            final /* synthetic */ ConsolesMigrationManagerImpl this$0;
                                            final /* synthetic */ Map<LocalDataSource, List<VirtualFile>> $consoles;
                                            {
                                                this.this$0 = $receiver;
                                                this.$consoles = $consoles;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        ConsolesMigrationManagerImpl.forceMigrate$intellij_database_impl$default(this.this$0, this.this$0.getProject(), this.$consoles, false, 4, null);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v1 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl30
                                    }
                                    case 2: {
                                        consoles = (Map)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl30:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void migrateSqlFileTypeIfNeeded() {
        void $this$mapTo$iv$iv;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ConsolesMigrationStorageGlobal globalMigrationStorage = ConsolesMigrationStorageGlobal.Companion.getInstance();
        if (globalMigrationStorage.isSqlFileTypeMigrated()) {
            return;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            return;
        }
        FileTypeManager fileTypeManager2 = fileTypeManager;
        Object[] objectArray = new String[]{"ddl", "fnc", "pck", "pkb", "pks", "pls", "prc", "sql", "tpb", "tps", "trg", "vw"};
        Set required = SetsKt.setOf((Object[])objectArray);
        List list = fileTypeManager2.getAssociations((FileType)SqlFileType.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociations(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileNameMatcher fileNameMatcher = (FileNameMatcher)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPresentableString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableString(...)");
            collection.add(StringsKt.substringAfter$default((String)string, (String)"*.", null, (int)2, null));
        }
        Set associated = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set toAssociate = SetsKt.minus((Set)required, (Iterable)associated);
        if (toAssociate.isEmpty()) {
            globalMigrationStorage.setSqlFileTypeMigrated();
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Set<String>)toAssociate, fileTypeManager2, this, null){
            int label;
            final /* synthetic */ Set<String> $toAssociate;
            final /* synthetic */ FileTypeManager $fileTypeManager;
            final /* synthetic */ ConsolesMigrationManagerImpl this$0;
            {
                this.$toAssociate = $toAssociate;
                this.$fileTypeManager = $fileTypeManager;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeAction(() -> migrateSqlFileTypeIfNeeded.1.invokeSuspend$lambda$0(this.$toAssociate, this.$fileTypeManager, this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Set $toAssociate, FileTypeManager $fileTypeManager, ConsolesMigrationManagerImpl this$0) {
                for (String ext : $toAssociate) {
                    $fileTypeManager.associate((FileType)SqlFileType.INSTANCE, (FileNameMatcher)new ExtensionFileNameMatcher(ext));
                }
                ConsolesMigrationManagerImpl.access$getLOG$p(this$0).info("Added SqlFileType associations: " + CollectionsKt.joinToString$default((Iterable)$toAssociate, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        globalMigrationStorage.setSqlFileTypeMigrated();
    }

    public void forceMigrate() {
        this.forceMigrate$intellij_database_impl(this.project, this.getConsoles(), false);
    }

    /*
     * WARNING - void declaration
     */
    public final void forceMigrate$intellij_database_impl(@NotNull Project project, @NotNull Map<LocalDataSource, ? extends List<? extends VirtualFile>> consoles, boolean forceAdvanced) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(consoles, (String)"consoles");
        Map<LocalDataSource, ? extends List<? extends VirtualFile>> $this$map$iv = consoles;
        boolean $i$f$map = false;
        Map<LocalDataSource, ? extends List<? extends VirtualFile>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)CollectionsKt.toMutableList((Collection)((Collection)it.getValue()))));
        }
        Map mutableConsoles = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        this.forceMigrate$intellij_database_impl(project, new MigrationInfo(project, mutableConsoles, null, null, null, 28, null), forceAdvanced);
    }

    public static /* synthetic */ void forceMigrate$intellij_database_impl$default(ConsolesMigrationManagerImpl consolesMigrationManagerImpl, Project project, Map map2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        consolesMigrationManagerImpl.forceMigrate$intellij_database_impl(project, map2, bl);
    }

    public final void forceMigrate$intellij_database_impl(@NotNull Project project, @NotNull MigrationInfo migrationInfo, boolean forceAdvanced) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        Function0 onMigrated = () -> ConsolesMigrationManagerImpl.forceMigrate$lambda$1(this);
        if (!forceAdvanced) {
            new SimpleConsolesMigrationDialog(project, this.coroutineScope, migrationInfo, (Function0<Unit>)onMigrated).show();
        } else {
            new AdvancedConsolesMigrationDialog(project, this.coroutineScope, migrationInfo, (Function0<Unit>)onMigrated).show();
        }
    }

    public static /* synthetic */ void forceMigrate$intellij_database_impl$default(ConsolesMigrationManagerImpl consolesMigrationManagerImpl, Project project, MigrationInfo migrationInfo, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        consolesMigrationManagerImpl.forceMigrate$intellij_database_impl(project, migrationInfo, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final Object attachConsolesToDataSources(Map<LocalDataSource, ? extends List<? extends VirtualFile>> allDataSourcesToConsoles, Continuation<? super Unit> $completion) {
        if (!($completion instanceof attachConsolesToDataSources.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ConsolesMigrationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConsolesMigrationManagerImpl.access$attachConsolesToDataSources(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)allDataSourcesToConsoles);
                $continuation.label = 1;
                v0 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, attachConsolesToDataSources$lambda$0(com.intellij.database.console.migration.ConsolesMigrationManagerImpl java.util.Map ), ()Lkotlin/Unit;)((ConsolesMigrationManagerImpl)this, (Map)allDataSourcesToConsoles), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                allDataSourcesToConsoles = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.migrationStorage.setConsolesAttachedToDataSources();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<LocalDataSource, List<VirtualFile>> getConsoles() {
        List list = LocalDataSourceManager.getInstance(this.project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        List dataSources = list;
        Map dataSourcesToConsolesMap = new LinkedHashMap();
        for (LocalDataSource dataSource : dataSources) {
            VirtualFile it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            VirtualFile consoleDir = DatabaseEditorHelper.getDataSourceRootDir((DasDataSource)dataSource);
            if (consoleDir == null) continue;
            consoleDir.refresh(false, true);
            List list2 = VfsUtil.collectChildrenRecursively((VirtualFile)consoleDir);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"collectChildrenRecursively(...)");
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"sql") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"js"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(it.getLength() != 0L)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List consoles = (List)destination$iv$iv;
            if (!(!((Collection)consoles).isEmpty())) continue;
            dataSourcesToConsolesMap.put(dataSource, consoles);
        }
        return dataSourcesToConsolesMap;
    }

    private final boolean isMigrated() {
        return QueryFilesUtilsKt.isQueryFilesFlagEnabled() && (this.migrationStorage.isMigrated() || ApplicationManager.getApplication().isUnitTestMode());
    }

    private static final Unit forceMigrate$lambda$1(ConsolesMigrationManagerImpl this$0) {
        this$0.migrationStorage.setMigrated();
        return Unit.INSTANCE;
    }

    private static final Unit attachConsolesToDataSources$lambda$0(ConsolesMigrationManagerImpl this$0, Map $allDataSourcesToConsoles) {
        DataSourcePerFileMappings mapping = DataSourcePerFileMappingsImpl.Companion.getInstance(this$0.project);
        for (Map.Entry dsToConsoles : $allDataSourcesToConsoles.entrySet()) {
            for (VirtualFile console : (List)dsToConsoles.getValue()) {
                mapping.setMapping(console, dsToConsoles.getKey());
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getConsoles(ConsolesMigrationManagerImpl $this) {
        return $this.getConsoles();
    }

    public static final /* synthetic */ ConsolesMigrationStorage access$getMigrationStorage$p(ConsolesMigrationManagerImpl $this) {
        return $this.migrationStorage;
    }

    public static final /* synthetic */ Object access$attachConsolesToDataSources(ConsolesMigrationManagerImpl $this, Map allDataSourcesToConsoles, Continuation $completion) {
        return $this.attachConsolesToDataSources(allDataSourcesToConsoles, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$p(ConsolesMigrationManagerImpl $this) {
        return $this.LOG;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$ConsolesMigrationProjectActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.impl"})
    public static final class ConsolesMigrationProjectActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
                return Unit.INSTANCE;
            }
            ConsolesMigrationManager consolesMigrationManager = (ConsolesMigrationManager)project.getService(ConsolesMigrationManager.class);
            if (consolesMigrationManager == null) {
                return Unit.INSTANCE;
            }
            ConsolesMigrationManager migrationService = consolesMigrationManager;
            migrationService.migrateSqlFileTypeIfNeeded();
            migrationService.migrateIfNeeded();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0012\b\u0002\u0010\u000e\u001a\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005H\u00c6\u0003J\u001b\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003J\u0013\u0010\"\u001a\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u00c6\u0003Ji\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\u0012\b\u0002\u0010\u000e\u001a\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u000e\u001a\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "", "project", "Lcom/intellij/openapi/project/Project;", "allConsoles", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "consolesToMigrate", "", "", "fileNameTemplate", "", "queriesDirectory", "Lorg/jetbrains/annotations/SystemDependent;", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAllConsoles", "()Ljava/util/Map;", "getConsolesToMigrate", "getFileNameTemplate", "()Ljava/lang/String;", "setFileNameTemplate", "(Ljava/lang/String;)V", "getQueriesDirectory", "setQueriesDirectory", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nConsolesMigrationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolesMigrationManagerImpl.kt\ncom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,171:1\n126#2:172\n153#2,3:173\n*S KotlinDebug\n*F\n+ 1 ConsolesMigrationManagerImpl.kt\ncom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo\n*L\n155#1:172\n155#1:173,3\n*E\n"})
    public static final class MigrationInfo {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<LocalDataSource, List<VirtualFile>> allConsoles;
        @NotNull
        private final Map<LocalDataSource, List<VirtualFile>> consolesToMigrate;
        @NotNull
        private String fileNameTemplate;
        @NotNull
        private String queriesDirectory;

        public MigrationInfo(@NotNull Project project, @NotNull Map<LocalDataSource, ? extends List<? extends VirtualFile>> allConsoles, @NotNull Map<LocalDataSource, List<VirtualFile>> consolesToMigrate, @NotNull String fileNameTemplate, @NotNull String queriesDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(allConsoles, (String)"allConsoles");
            Intrinsics.checkNotNullParameter(consolesToMigrate, (String)"consolesToMigrate");
            Intrinsics.checkNotNullParameter((Object)fileNameTemplate, (String)"fileNameTemplate");
            Intrinsics.checkNotNullParameter((Object)queriesDirectory, (String)"queriesDirectory");
            this.project = project;
            this.allConsoles = allConsoles;
            this.consolesToMigrate = consolesToMigrate;
            this.fileNameTemplate = fileNameTemplate;
            this.queriesDirectory = queriesDirectory;
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ MigrationInfo(Project project, Map map2, Map map3, String string, String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                void $this$mapTo$iv$iv;
                Map $this$map$iv = map2;
                boolean $i$f$map = false;
                Map map4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to(it.getKey(), (Object)CollectionsKt.toMutableList((Collection)((Collection)it.getValue()))));
                }
                map3 = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
            }
            if ((n & 8) != 0) {
                string = QueryFileSettings.Companion.getDefaultQueriesNameTemplate();
            }
            if ((n & 0x10) != 0) {
                Object object2 = QueryFileSettings.Companion.getDefaultQueriesPath(project);
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                object = object2;
            }
            this(project, map2, map3, string, (String)object);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Map<LocalDataSource, List<VirtualFile>> getAllConsoles() {
            return this.allConsoles;
        }

        @NotNull
        public final Map<LocalDataSource, List<VirtualFile>> getConsolesToMigrate() {
            return this.consolesToMigrate;
        }

        @NotNull
        public final String getFileNameTemplate() {
            return this.fileNameTemplate;
        }

        public final void setFileNameTemplate(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.fileNameTemplate = string;
        }

        @NotNull
        public final String getQueriesDirectory() {
            return this.queriesDirectory;
        }

        public final void setQueriesDirectory(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.queriesDirectory = string;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Map<LocalDataSource, List<VirtualFile>> component2() {
            return this.allConsoles;
        }

        @NotNull
        public final Map<LocalDataSource, List<VirtualFile>> component3() {
            return this.consolesToMigrate;
        }

        @NotNull
        public final String component4() {
            return this.fileNameTemplate;
        }

        @NotNull
        public final String component5() {
            return this.queriesDirectory;
        }

        @NotNull
        public final MigrationInfo copy(@NotNull Project project, @NotNull Map<LocalDataSource, ? extends List<? extends VirtualFile>> allConsoles, @NotNull Map<LocalDataSource, List<VirtualFile>> consolesToMigrate, @NotNull String fileNameTemplate, @NotNull String queriesDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(allConsoles, (String)"allConsoles");
            Intrinsics.checkNotNullParameter(consolesToMigrate, (String)"consolesToMigrate");
            Intrinsics.checkNotNullParameter((Object)fileNameTemplate, (String)"fileNameTemplate");
            Intrinsics.checkNotNullParameter((Object)queriesDirectory, (String)"queriesDirectory");
            return new MigrationInfo(project, allConsoles, consolesToMigrate, fileNameTemplate, queriesDirectory);
        }

        public static /* synthetic */ MigrationInfo copy$default(MigrationInfo migrationInfo, Project project, Map map2, Map map3, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                project = migrationInfo.project;
            }
            if ((n & 2) != 0) {
                map2 = migrationInfo.allConsoles;
            }
            if ((n & 4) != 0) {
                map3 = migrationInfo.consolesToMigrate;
            }
            if ((n & 8) != 0) {
                string = migrationInfo.fileNameTemplate;
            }
            if ((n & 0x10) != 0) {
                string2 = migrationInfo.queriesDirectory;
            }
            return migrationInfo.copy(project, map2, map3, string, string2);
        }

        @NotNull
        public String toString() {
            return "MigrationInfo(project=" + this.project + ", allConsoles=" + this.allConsoles + ", consolesToMigrate=" + this.consolesToMigrate + ", fileNameTemplate=" + this.fileNameTemplate + ", queriesDirectory=" + this.queriesDirectory + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + ((Object)this.allConsoles).hashCode();
            result2 = result2 * 31 + ((Object)this.consolesToMigrate).hashCode();
            result2 = result2 * 31 + this.fileNameTemplate.hashCode();
            result2 = result2 * 31 + this.queriesDirectory.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MigrationInfo)) {
                return false;
            }
            MigrationInfo migrationInfo = (MigrationInfo)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)migrationInfo.project)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allConsoles, migrationInfo.allConsoles)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.consolesToMigrate, migrationInfo.consolesToMigrate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileNameTemplate, (Object)migrationInfo.fileNameTemplate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.queriesDirectory, (Object)migrationInfo.queriesDirectory);
        }
    }
}

