/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProviderSupport;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptComparingUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCoreLibraryElementsCollector<T> {
    private final Map<JSQualifiedNamedElement, Pair<String, T>> myElements = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<JSQualifiedNamedElement>(){

        public int hashCode(@Nullable JSQualifiedNamedElement object) {
            if (object instanceof TypeScriptFunction) {
                int parameters = ((TypeScriptFunction)object).getParameters().length;
                TypeScriptTypeParameterList typeParameters = ((TypeScriptFunction)object).getTypeParameterList();
                int typeParametersLength = typeParameters == null ? 0 : typeParameters.getTypeParameters().length;
                return Objects.hash(object.getQualifiedName(), parameters, typeParametersLength);
            }
            return object == null ? 0 : Objects.hash(object.getQualifiedName());
        }

        public boolean equals(@Nullable JSQualifiedNamedElement o1, @Nullable JSQualifiedNamedElement o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (o1.equals(o2)) {
                return true;
            }
            if (!Objects.equals(o1.getQualifiedName(), o2.getQualifiedName())) {
                return false;
            }
            if (o1 instanceof TypeScriptFunction && o2 instanceof TypeScriptFunction) {
                return TypeScriptComparingUtil.areFunctionsSimilar((TypeScriptFunction)o1, (TypeScriptFunction)o2, JSCoreLibraryElementsCollector.this.myContext);
            }
            if (o1 instanceof JSFieldVariable && o2 instanceof JSFieldVariable) {
                return TypeScriptComparingUtil.areVariablesSimilar((JSFieldVariable)o1, (JSFieldVariable)o2, JSCoreLibraryElementsCollector.this.myContext) || "browser.d.ts".equals(o1.getContainingFile().getName()) || "browser.d.ts".equals(o2.getContainingFile().getName());
            }
            return false;
        }
    });
    @NotNull
    private final Condition<PsiElement> myLibraryCondition;
    @Nullable
    private final PsiElement myContext;

    public static boolean canBeMerged(@Nullable PsiElement element) {
        return element instanceof TypeScriptField || element instanceof TypeScriptFunction || element instanceof TypeScriptVariable;
    }

    @NotNull
    private static Condition<PsiElement> getIsLibraryFileCondition(@Nullable PsiElement context) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder == null || holder.isECMA4) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                JSCoreLibraryElementsCollector.$$$reportNull$$$0(0);
            }
            return condition;
        }
        if (!holder.isTypeScript) {
            Condition condition = JSCorePredefinedLibrariesProviderSupport.getInstance()::isLibraryElement;
            if (condition == null) {
                JSCoreLibraryElementsCollector.$$$reportNull$$$0(1);
            }
            return condition;
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(context.getProject());
        Condition condition = file -> service.isLibraryFile(PsiUtilCore.getVirtualFile((PsiElement)file));
        if (condition == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(2);
        }
        return condition;
    }

    public JSCoreLibraryElementsCollector(@Nullable PsiElement context) {
        this.myContext = context;
        this.myLibraryCondition = JSCoreLibraryElementsCollector.getIsLibraryFileCondition(context);
    }

    public boolean isLibraryElement(@Nullable PsiElement element) {
        return JSCoreLibraryElementsCollector.canBeMerged(element) && this.myLibraryCondition.value((Object)element);
    }

    @Nullable
    public T getValue(@NotNull PsiElement key) {
        if (key == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(3);
        }
        if (!(key instanceof JSQualifiedNamedElement)) {
            return null;
        }
        Pair<String, T> pair = this.myElements.get(key);
        return (T)Pair.getSecond(pair);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> getElements() {
        Set<JSQualifiedNamedElement> set = this.myElements.keySet();
        if (set == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<T> getValues() {
        Collection collection = this.myElements.values().stream().map(el -> el.getSecond()).collect(Collectors.toSet());
        if (collection == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean addElement(@Nullable PsiElement element, @Nullable T valueToStore) {
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedNamedElement newElement = (JSQualifiedNamedElement)element;
        Pair<String, T> value = this.myElements.get(element);
        String newFileName = newElement.getContainingFile().getName();
        if (value == null) {
            this.myElements.put(newElement, Pair.create((Object)newFileName, valueToStore));
            return true;
        }
        if (JSCoreLibraryElementsCollector.useNewElements(newFileName, (String)value.first)) {
            this.myElements.remove(newElement);
            this.myElements.put(newElement, Pair.create((Object)newFileName, valueToStore));
            return true;
        }
        return false;
    }

    private static boolean useNewElements(@NotNull String newFileName, @NotNull String storedFileName) {
        if (newFileName == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(6);
        }
        if (storedFileName == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(7);
        }
        if ("browser.d.ts".equals(newFileName)) {
            return true;
        }
        if ("browser.d.ts".equals(storedFileName)) {
            return false;
        }
        if ("flow.utilities.d.ts".equals(newFileName)) {
            return true;
        }
        if ("flow.utilities.d.ts".equals(storedFileName)) {
            return false;
        }
        if ("es2019decorators.d.ts".equals(newFileName)) {
            return true;
        }
        if ("es2019decorators.d.ts".equals(storedFileName)) {
            return false;
        }
        return newFileName.compareTo(storedFileName) <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSCoreLibraryElementsCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsLibraryFileCondition";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCoreLibraryElementsCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "useNewElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

