/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redis;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.redis.RedisDialect;
import com.intellij.sql.dialects.redis._RedisLexer;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class RedisLexer
extends SqlLexer {
    public RedisLexer() {
        super((SqlLanguageDialectBase)RedisDialect.INSTANCE, (FlexLexer)new _RedisLexer());
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(0);
        }
        this.consumeSingleLineComments(baseLexer);
        super.lookAhead(baseLexer);
    }

    private static boolean isBegin(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(1);
        }
        return baseLexer.getTokenStart() == 0;
    }

    private static boolean isEnd(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(2);
        }
        return baseLexer.getTokenType() == null;
    }

    private static boolean isEndOfLine(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(3);
        }
        return baseLexer.getTokenType() == SqlTokens.SQL_EOL;
    }

    private static boolean isWhiteSpace(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(4);
        }
        return SqlTokens.WS_TOKENS.contains(baseLexer.getTokenType());
    }

    private void consumeSingleLineComments(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            RedisLexer.$$$reportNull$$$0(5);
        }
        if (!RedisLexer.isBegin(baseLexer) && !RedisLexer.isEndOfLine(baseLexer)) {
            return;
        }
        do {
            if (RedisLexer.isEndOfLine(baseLexer)) {
                this.addToken((IElementType)SqlTokens.SQL_EOL);
                baseLexer.advance();
            }
            while (RedisLexer.isWhiteSpace(baseLexer)) {
                this.addToken(SqlTokens.WHITE_SPACE);
                baseLexer.advance();
            }
            if (!baseLexer.getTokenText().startsWith("--")) continue;
            int commentEnd = baseLexer.getTokenEnd();
            while (!RedisLexer.isEnd(baseLexer) && !RedisLexer.isEndOfLine(baseLexer)) {
                commentEnd = baseLexer.getTokenEnd();
                baseLexer.advance();
            }
            this.addToken(commentEnd, (IElementType)SqlTokens.SQL_LINE_COMMENT);
        } while (RedisLexer.isEndOfLine(baseLexer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "baseLexer";
        objectArray2[1] = "com/intellij/sql/dialects/redis/RedisLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isBegin";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnd";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEndOfLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhiteSpace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeSingleLineComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

