/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasCompositeType;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u00032\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraRefCursorType;", "Lcom/intellij/database/types/DasCompositeType;", "returnType", "Lcom/intellij/database/types/DasType;", "<init>", "(Lcom/intellij/database/types/DasType;)V", "getReturnType", "()Lcom/intellij/database/types/DasType;", "getTypeClass", "Lcom/intellij/database/types/DasSimpleTypeClass;", "toDataType", "Lcom/intellij/database/model/DataType;", "getDescription", "", "transform", "transformer", "Ljava/util/function/Function;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.database.dialects.oracle"})
public final class OraRefCursorType
implements DasCompositeType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DasType returnType;
    @NotNull
    private static final DasSimpleTypeClass TYPE_CLASS = new DasSimpleTypeClass("<ref cursor>");

    public OraRefCursorType(@NotNull DasType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        this.returnType = returnType;
    }

    @NotNull
    public final DasType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public DasSimpleTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @NotNull
    public DataType toDataType() {
        if (Intrinsics.areEqual((Object)this.returnType, (Object)DasTypeSystemBase.UNKNOWN)) {
            DataType dataType = DataTypeFactory.of((String)"SYS_REFCURSOR");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            return dataType;
        }
        DataType dataType = DataTypeFactory.withSuffix((DataType)this.returnType.toDataType(), (String)"REF CURSOR");
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"withSuffix(...)");
        return dataType;
    }

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append("REF CURSOR");
        if (!Intrinsics.areEqual((Object)this.returnType, (Object)DasTypeSystemBase.UNKNOWN)) {
            $this$getDescription_u24lambda_u240.append(" RETURN " + this.returnType.getDescription());
        }
        return stringBuilder.toString();
    }

    @NotNull
    public DasType transform(@NotNull Function<DasType, DasType> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        DasType dasType = transformer.apply(this.returnType);
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"apply(...)");
        return (DasType)new OraRefCursorType(dasType);
    }

    @NotNull
    public final DasType component1() {
        return this.returnType;
    }

    @NotNull
    public final OraRefCursorType copy(@NotNull DasType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        return new OraRefCursorType(returnType);
    }

    public static /* synthetic */ OraRefCursorType copy$default(OraRefCursorType oraRefCursorType, DasType dasType, int n, Object object) {
        if ((n & 1) != 0) {
            dasType = oraRefCursorType.returnType;
        }
        return oraRefCursorType.copy(dasType);
    }

    @NotNull
    public String toString() {
        return "OraRefCursorType(returnType=" + this.returnType + ")";
    }

    public int hashCode() {
        return this.returnType.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OraRefCursorType)) {
            return false;
        }
        OraRefCursorType oraRefCursorType = (OraRefCursorType)other;
        return Intrinsics.areEqual((Object)this.returnType, (Object)oraRefCursorType.returnType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraRefCursorType$Companion;", "", "<init>", "()V", "TYPE_CLASS", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getTYPE_CLASS", "()Lcom/intellij/database/types/DasSimpleTypeClass;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasSimpleTypeClass getTYPE_CLASS() {
            return TYPE_CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

