/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi;

import com.intellij.docker.splitApi.DockerDtoConvertersKt;
import com.intellij.docker.splitApi.DockerServerRuntimeEventDto;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\r\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\u000e\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector;", "", "<init>", "()V", "serverEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/docker/splitApi/DockerServerRuntimeEventDto;", "getServerEvents", "Lkotlinx/coroutines/flow/Flow;", "fireServerRuntimeAdded", "", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "fireServerRuntimeRemoved", "fireServerRuntimeChanged", "Companion", "intellij.clouds.docker"})
public final class DockerRuntimeEventsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<DockerServerRuntimeEventDto> serverEvents = SharedFlowKt.MutableSharedFlow((int)1000, (int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST);

    @NotNull
    public final Flow<DockerServerRuntimeEventDto> getServerEvents() {
        return (Flow)FlowKt.asSharedFlow(this.serverEvents);
    }

    public final void fireServerRuntimeAdded(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerAddedEvent(server2));
    }

    public final void fireServerRuntimeRemoved(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerRemovedEvent(server2));
    }

    public final void fireServerRuntimeChanged(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerChangedEvent(server2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerRuntimeEventsCollector getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DockerRuntimeEventsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DockerRuntimeEventsCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

