/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRuleProducer
extends UtilRuleProducer {
    private final boolean myTestMode;

    public CustomRuleProducer(@NotNull String recorderId) {
        if (recorderId == null) {
            CustomRuleProducer.$$$reportNull$$$0(0);
        }
        this.myTestMode = StatisticsRecorderUtil.isTestModeEnabled(recorderId);
    }

    @Nullable
    public UtilValidationRule createValidationRule(@NotNull String value, @NotNull EventGroupContextData contextData) {
        if (value == null) {
            CustomRuleProducer.$$$reportNull$$$0(1);
        }
        if (contextData == null) {
            CustomRuleProducer.$$$reportNull$$$0(2);
        }
        for (CustomValidationRule extension : CustomValidationRule.EP_NAME.getExtensionList()) {
            if (!this.isAcceptedRule(extension) || !extension.acceptRuleId(value)) continue;
            return extension;
        }
        for (CustomValidationRuleFactory extension : (CustomValidationRuleFactory[])CustomValidationRuleFactory.EP_NAME.getExtensions()) {
            if (!CustomRuleProducer.isDevelopedByJetBrains(extension.getClass()) || !value.equals(extension.getRuleId())) continue;
            return extension.createValidator(contextData);
        }
        return null;
    }

    private boolean isAcceptedRule(FUSRule extension) {
        if (extension instanceof TestModeValidationRule && !this.myTestMode) {
            return false;
        }
        return CustomRuleProducer.isDevelopedByJetBrains(extension.getClass());
    }

    private static boolean isDevelopedByJetBrains(Class<?> clazz) {
        return ApplicationManager.getApplication().isUnitTestMode() || PluginInfoDetectorKt.getPluginInfo(clazz).isDevelopedByJetBrains();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/utils/CustomRuleProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidationRule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

