/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.DocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.RuffConfigOptionInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffConfigOptionDocumentationTarget;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlTableHeader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigOptionDocumentationProvider;", "Lcom/intellij/platform/backend/documentation/DocumentationTargetProvider;", "<init>", "()V", "documentationTargets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "getFullPath", "", "keyValue", "Lorg/toml/lang/psi/TomlKeyValue;", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffConfigOptionDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffConfigOptionDocumentationProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigOptionDocumentationProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,176:1\n30#2,2:177\n*S KotlinDebug\n*F\n+ 1 RuffConfigOptionDocumentationProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigOptionDocumentationProvider\n*L\n46#1:177,2\n*E\n"})
public final class RuffConfigOptionDocumentationProvider
implements DocumentationTargetProvider {
    @NotNull
    public List<DocumentationTarget> documentationTargets(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof TomlFile)) {
            return CollectionsKt.emptyList();
        }
        if (!RuffDocumentationUtilKt.isRuffConfigFile((TomlFile)file)) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = ((TomlFile)file).findElementAt(offset);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        PsiElement psiElement2 = element.getParent();
        TomlKeySegment tomlKeySegment = psiElement2 instanceof TomlKeySegment ? (TomlKeySegment)psiElement2 : null;
        if (tomlKeySegment == null) {
            return CollectionsKt.emptyList();
        }
        TomlKeySegment keySegment = tomlKeySegment;
        String string = RuffDocumentationUtilKt.ruffConfigPath(keySegment);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String configPath = string;
        Project project = ((TomlFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RuffService> serviceClass$iv = RuffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RuffConfigOptionInfo ruffConfigOptionInfo = ((RuffService)object).getConfigOptions().get(configPath);
        if (ruffConfigOptionInfo == null) {
            return CollectionsKt.emptyList();
        }
        RuffConfigOptionInfo configInfo = ruffConfigOptionInfo;
        Project project2 = ((TomlFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return CollectionsKt.listOf((Object)new RuffConfigOptionDocumentationTarget(configPath, configInfo, project2));
    }

    private final String getFullPath(TomlKeyValue keyValue) {
        TomlTableHeader tableHeader;
        TomlKey tableKey;
        PsiElement parent = keyValue.getParent();
        if (parent instanceof TomlTable && (tableKey = (tableHeader = ((TomlTable)parent).getHeader()).getKey()) != null) {
            return tableKey.getText() + "." + keyValue.getKey().getText();
        }
        String string = keyValue.getKey().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

