/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.python.ruff.RuffConfigOptionInfo;
import com.intellij.python.ruff.RuffUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0003J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigOptionDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "configPath", "", "configInfo", "Lcom/intellij/python/ruff/RuffConfigOptionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/python/ruff/RuffConfigOptionInfo;Lcom/intellij/openapi/project/Project;)V", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentationHint", "Lorg/jetbrains/annotations/Nls;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "formatConfigOptionDocumentationHint", "formatConfigOptionDocumentation", "intellij.python.ruff"})
public final class RuffConfigOptionDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final String configPath;
    @NotNull
    private final RuffConfigOptionInfo configInfo;
    @NotNull
    private final Project project;

    public RuffConfigOptionDocumentationTarget(@Nls @NotNull String configPath, @NotNull RuffConfigOptionInfo configInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)configInfo, (String)"configInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configPath = configPath;
        this.configInfo = configInfo;
        this.project = project;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.configPath).icon(RuffUtil.INSTANCE.getDefaultRuffIcon()).presentableText(this.configPath).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public String computeDocumentationHint() {
        return this.formatConfigOptionDocumentationHint(this.configInfo);
    }

    @NotNull
    public DocumentationResult computeDocumentation() {
        String html = this.formatConfigOptionDocumentation(this.configInfo, this.project);
        return (DocumentationResult)DocumentationResult.Companion.documentation(html);
    }

    @Nls
    private final String formatConfigOptionDocumentationHint(RuffConfigOptionInfo configInfo) {
        String[] stringArray = new String[]{"\n"};
        String string = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)configInfo.getDoc(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (string == null) {
            string = "";
        }
        String firstLine = string;
        return "<b>" + this.configPath + "</b><br>" + firstLine;
    }

    @Nls
    private final String formatConfigOptionDocumentation(RuffConfigOptionInfo configInfo, Project project) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatConfigOptionDocumentation_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"."};
        $this$formatConfigOptionDocumentation_u24lambda_u240.append("# " + CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.configPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + "\n\n");
        if (configInfo.getDeprecated() != null) {
            $this$formatConfigOptionDocumentation_u24lambda_u240.append("**This option is deprecated**: " + configInfo.getDeprecated() + "\n\n");
        }
        $this$formatConfigOptionDocumentation_u24lambda_u240.append(configInfo.getDoc());
        $this$formatConfigOptionDocumentation_u24lambda_u240.append("\n\n");
        $this$formatConfigOptionDocumentation_u24lambda_u240.append("**Type:** `" + configInfo.getValueType() + "`\n\n");
        if (((CharSequence)configInfo.getDefault()).length() > 0) {
            $this$formatConfigOptionDocumentation_u24lambda_u240.append("**Default:** `" + configInfo.getDefault() + "`\n\n");
        }
        if (configInfo.getScope() != null) {
            $this$formatConfigOptionDocumentation_u24lambda_u240.append("**Scope:** " + configInfo.getScope() + "\n\n");
        }
        if (((CharSequence)configInfo.getExample()).length() > 0) {
            $this$formatConfigOptionDocumentation_u24lambda_u240.append("**Example:**\n\n```toml\n" + configInfo.getExample() + "\n```\n\n");
        }
        String markdown = stringBuilder.toString();
        return DocMarkdownToHtmlConverter.convert$default((Project)project, (String)markdown, null, (int)4, null);
    }
}

