/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PyContainingFileRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyContainingFileRenamerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PyClass)) {
            return false;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (scopeOwner instanceof PyFile) {
            String className = ((PyClass)element).getName();
            String fileName = FileUtilRt.getNameWithoutExtension((String)scopeOwner.getName());
            return fileName.equalsIgnoreCase(className);
        }
        return false;
    }

    public String getOptionName() {
        return PyBundle.message("refactoring.rename.containing.file", new Object[0]);
    }

    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE;
    }

    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new PyContainingFileRenamer((PyClass)element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/PyContainingFileRenamerFactory", "isApplicable"));
    }

    public static class PyContainingFileRenamer
    extends AutomaticRenamer {
        private final PyClass myClass;

        public PyContainingFileRenamer(PyClass element, String newName) {
            this.myClass = element;
            this.myElements.add(element.getContainingFile());
            this.suggestAllNames(element.getName(), newName);
        }

        public String getDialogTitle() {
            return PyBundle.message("refactoring.rename.containing.file.title", new Object[0]);
        }

        public String getDialogDescription() {
            return PyBundle.message("refactoring.rename.containing.file.with.the.following.name.to", new Object[0]);
        }

        public String entityName() {
            return PyBundle.message("refactoring.rename.containing.file.entity.name", new Object[0]);
        }

        protected String nameToCanonicalName(@NonNls String name2, PsiNamedElement element) {
            return FileUtilRt.getNameWithoutExtension((String)name2);
        }

        protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
            return canonicalName + "." + FileUtilRt.getExtension((String)this.myClass.getContainingFile().getName());
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            if (element instanceof PyFile && element.getName().equals(StringUtil.toLowerCase((String)oldClassName) + ".py")) {
                return StringUtil.toLowerCase((String)newClassName) + ".py";
            }
            return super.suggestNameForElement(element, suggester, newClassName, oldClassName);
        }
    }
}

