/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 84489595482295L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1001112660 + (char)-6421, 1001112660 + (char)-11701, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1001112660 + (char)-6422, -1001112660 + -((char)-8497), (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 84148209489682L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.Y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1210169310 + -((char)-1142), -1210300380 - -((char)-14570), (int)l) + string + WindowsNamedPipeAgentIpc.b(-1210169310 + -((char)-1143), 1210300380 - (char)-17884, (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(-1210169310 + -((char)-1148), 1210169310 + (char)-13168, (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l;
                    block15: {
                        block16: {
                            l = 49713576609568L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.Y();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(669898770 - (char)-1179, -669898770 - -((char)-4261), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(669898770 - (char)-1180, 669767700 + (char)-2088, (int)l) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(669898770 - (char)-1181, -669767700 + -((char)-5155), (int)l));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(669898770 - (char)-1166, -669767700 + -((char)-3525), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(669898770 - (char)-1167, 669898770 - (char)-10131, (int)l) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(669898770 - (char)-1168, 669767700 + (char)-711, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(669898770 - (char)-1166, -669767700 + -((char)-3525), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(669898770 - (char)-1169, 669767700 + (char)-6171, (int)l));
                            if (ActionTimestamp.v() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.v(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l = 13483226162907L;
                    bl = SshAgentIpcService.Y();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l;
        block27: {
            block28: {
                l = 39355952755583L;
                boolean bl2 = SshAgentIpcService.v();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1167440490 - -25445, -1167440490 - -19352, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25444, -1167440490 - -((char)-20765), (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25443, 1167440490 - 28050, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1167440490 - -25445, -1167440490 - -19352, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25442, 1167440490 - (char)-18283, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1167440490 - -25445, -1167440490 - -19352, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25425, 1167440490 - 17039, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25424, 1167440490 - 20868, (int)l) + ErrorToolsKt.prettyHRESULT((int)n)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25443, 1167440490 - 28050, (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1167440490 - -25445, -1167440490 - -19352, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1167440490 - -25449, 1167440490 - 30844, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1167440490 - -25423, 1167440490 - (char)-26221, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 33366748424314L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-852479280 + -25860, 852479280 + 24657, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 12683050155433L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(11665230 + (char)-10032, 11665230 + (char)-13637, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ee\u00b5\u00f94\u0086\u00e9$\u00b6-\u00a8\u00ec\u00c4\u00bf\u001e\u0013\f\u0091F\u00be\u0014U1\u008e\u00a2s\u00f9\u00e71\u00d7^v\u00ce.\u00a6\u00e0\u0090\u0002\u0013\u00cb\u00df";
                        var4_3 = "\u00ee\u00b5\u00f94\u0086\u00e9$\u00b6-\u00a8\u00ec\u00c4\u00bf\u001e\u0013\f\u0091F\u00be\u0014U1\u008e\u00a2s\u00f9\u00e71\u00d7^v\u00ce.\u00a6\u00e0\u0090\u0002\u0013\u00cb\u00df".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 6;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 64;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 70;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 62;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 12;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 79;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 56;
                                        break;
                                    }
                                    default: {
                                        v11 = 13;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n, int n2, int n3) {
                    int n4 = (n ^ n3 ^ 0x25B6) & 0xFFFF;
                    if (b[n4] == null) {
                        int n5;
                        char[] cArray = a[n4].toCharArray();
                        int n6 = switch (cArray[0] & 0xFF) {
                            case 0 -> 179;
                            case 1 -> 125;
                            case 2 -> 55;
                            case 3 -> 242;
                            case 4 -> 111;
                            case 5 -> 238;
                            case 6 -> 188;
                            case 7 -> 182;
                            case 8 -> 71;
                            case 9 -> 206;
                            case 10 -> 142;
                            case 11 -> 45;
                            case 12 -> 218;
                            case 13 -> 129;
                            case 14 -> 165;
                            case 15 -> 19;
                            case 16 -> 157;
                            case 17 -> 99;
                            case 18 -> 195;
                            case 19 -> 35;
                            case 20 -> 79;
                            case 21 -> 153;
                            case 22 -> 113;
                            case 23 -> 26;
                            case 24 -> 83;
                            case 25 -> 201;
                            case 26 -> 82;
                            case 27 -> 0;
                            case 28 -> 158;
                            case 29 -> 75;
                            case 30 -> 247;
                            case 31 -> 8;
                            case 32 -> 116;
                            case 33 -> 178;
                            case 34 -> 236;
                            case 35 -> 152;
                            case 36 -> 131;
                            case 37 -> 172;
                            case 38 -> 128;
                            case 39 -> 181;
                            case 40 -> 114;
                            case 41 -> 168;
                            case 42 -> 239;
                            case 43 -> 124;
                            case 44 -> 140;
                            case 45 -> 97;
                            case 46 -> 68;
                            case 47 -> 135;
                            case 48 -> 148;
                            case 49 -> 88;
                            case 50 -> 253;
                            case 51 -> 65;
                            case 52 -> 202;
                            case 53 -> 233;
                            case 54 -> 151;
                            case 55 -> 95;
                            case 56 -> 241;
                            case 57 -> 255;
                            case 58 -> 154;
                            case 59 -> 13;
                            case 60 -> 44;
                            case 61 -> 249;
                            case 62 -> 250;
                            case 63 -> 186;
                            case 64 -> 252;
                            case 65 -> 118;
                            case 66 -> 132;
                            case 67 -> 29;
                            case 68 -> 105;
                            case 69 -> 2;
                            case 70 -> 217;
                            case 71 -> 137;
                            case 72 -> 191;
                            case 73 -> 80;
                            case 74 -> 216;
                            case 75 -> 9;
                            case 76 -> 102;
                            case 77 -> 198;
                            case 78 -> 86;
                            case 79 -> 96;
                            case 80 -> 126;
                            case 81 -> 62;
                            case 82 -> 185;
                            case 83 -> 146;
                            case 84 -> 17;
                            case 85 -> 92;
                            case 86 -> 12;
                            case 87 -> 21;
                            case 88 -> 212;
                            case 89 -> 76;
                            case 90 -> 145;
                            case 91 -> 211;
                            case 92 -> 193;
                            case 93 -> 205;
                            case 94 -> 18;
                            case 95 -> 166;
                            case 96 -> 130;
                            case 97 -> 190;
                            case 98 -> 94;
                            case 99 -> 25;
                            case 100 -> 225;
                            case 101 -> 207;
                            case 102 -> 32;
                            case 103 -> 204;
                            case 104 -> 36;
                            case 105 -> 167;
                            case 106 -> 24;
                            case 107 -> 213;
                            case 108 -> 69;
                            case 109 -> 40;
                            case 110 -> 189;
                            case 111 -> 77;
                            case 112 -> 101;
                            case 113 -> 120;
                            case 114 -> 251;
                            case 115 -> 4;
                            case 116 -> 200;
                            case 117 -> 119;
                            case 118 -> 84;
                            case 119 -> 134;
                            case 120 -> 133;
                            case 121 -> 230;
                            case 122 -> 66;
                            case 123 -> 123;
                            case 124 -> 136;
                            case 125 -> 46;
                            case 126 -> 74;
                            case 127 -> 121;
                            case 128 -> 89;
                            case 129 -> 232;
                            case 130 -> 109;
                            case 131 -> 50;
                            case 132 -> 11;
                            case 133 -> 81;
                            case 134 -> 141;
                            case 135 -> 117;
                            case 136 -> 52;
                            case 137 -> 162;
                            case 138 -> 72;
                            case 139 -> 246;
                            case 140 -> 107;
                            case 141 -> 23;
                            case 142 -> 67;
                            case 143 -> 85;
                            case 144 -> 3;
                            case 145 -> 147;
                            case 146 -> 248;
                            case 147 -> 203;
                            case 148 -> 254;
                            case 149 -> 103;
                            case 150 -> 194;
                            case 151 -> 176;
                            case 152 -> 138;
                            case 153 -> 221;
                            case 154 -> 199;
                            case 155 -> 122;
                            case 156 -> 174;
                            case 157 -> 184;
                            case 158 -> 224;
                            case 159 -> 20;
                            case 160 -> 173;
                            case 161 -> 28;
                            case 162 -> 38;
                            case 163 -> 108;
                            case 164 -> 231;
                            case 165 -> 5;
                            case 166 -> 27;
                            case 167 -> 234;
                            case 168 -> 53;
                            case 169 -> 73;
                            case 170 -> 227;
                            case 171 -> 98;
                            case 172 -> 70;
                            case 173 -> 245;
                            case 174 -> 49;
                            case 175 -> 214;
                            case 176 -> 61;
                            case 177 -> 155;
                            case 178 -> 244;
                            case 179 -> 171;
                            case 180 -> 160;
                            case 181 -> 183;
                            case 182 -> 63;
                            case 183 -> 164;
                            case 184 -> 243;
                            case 185 -> 235;
                            case 186 -> 31;
                            case 187 -> 209;
                            case 188 -> 78;
                            case 189 -> 237;
                            case 190 -> 10;
                            case 191 -> 104;
                            case 192 -> 39;
                            case 193 -> 37;
                            case 194 -> 34;
                            case 195 -> 208;
                            case 196 -> 150;
                            case 197 -> 144;
                            case 198 -> 64;
                            case 199 -> 110;
                            case 200 -> 106;
                            case 201 -> 42;
                            case 202 -> 143;
                            case 203 -> 161;
                            case 204 -> 43;
                            case 205 -> 229;
                            case 206 -> 149;
                            case 207 -> 219;
                            case 208 -> 51;
                            case 209 -> 112;
                            case 210 -> 240;
                            case 211 -> 1;
                            case 212 -> 48;
                            case 213 -> 60;
                            case 214 -> 210;
                            case 215 -> 15;
                            case 216 -> 93;
                            case 217 -> 30;
                            case 218 -> 180;
                            case 219 -> 7;
                            case 220 -> 41;
                            case 221 -> 222;
                            case 222 -> 159;
                            case 223 -> 156;
                            case 224 -> 177;
                            case 225 -> 192;
                            case 226 -> 91;
                            case 227 -> 223;
                            case 228 -> 115;
                            case 229 -> 127;
                            case 230 -> 54;
                            case 231 -> 228;
                            case 232 -> 226;
                            case 233 -> 22;
                            case 234 -> 163;
                            case 235 -> 220;
                            case 236 -> 56;
                            case 237 -> 6;
                            case 238 -> 57;
                            case 239 -> 59;
                            case 240 -> 169;
                            case 241 -> 58;
                            case 242 -> 170;
                            case 243 -> 14;
                            case 244 -> 215;
                            case 245 -> 16;
                            case 246 -> 197;
                            case 247 -> 139;
                            case 248 -> 187;
                            case 249 -> 175;
                            case 250 -> 90;
                            case 251 -> 33;
                            case 252 -> 87;
                            case 253 -> 196;
                            case 254 -> 100;
                            default -> 47;
                        };
                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                            n5 += 256;
                        }
                        int n8 = 0;
                        while (n8 < cArray.length) {
                            int n9 = n8 % 2;
                            int n10 = n8;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n10];
                            if (n9 == 0) {
                                cArray2[n10] = (char)(c2 ^ n7);
                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                            } else {
                                cArray2[n10] = (char)(c2 ^ n5);
                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                            }
                            ++n8;
                        }
                        accept.3.b[n4] = new String(cArray).intern();
                    }
                    return b[n4];
                }
            };
            if (!bl) {
                ActionTimestamp.v(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l2;
            block2: {
                block3: {
                    l2 = 65983562589434L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.v();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(20053710 - (char)-176, 19922640 + (char)-14373, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(20053710 - (char)-172, -19922640 + -((char)-5435), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(20053710 - (char)-147, -19922640 + -((char)-23578), (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(20053710 - (char)-176, 19922640 + (char)-14373, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(20053710 - (char)-172, -19922640 + -((char)-5435), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(20053710 - (char)-152, 19922640 + (char)-11300, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l = 36154054036244L;
                        boolean bl3 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(980665740 - 13571, -980665740 + -10338, (int)l));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(980665740 - 13570, 980665740 - 15106, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l;
        block25: {
            block26: {
                l = 56282984719586L;
                boolean bl2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1733269680 - -6166, -1733269680 + -8349, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1733269680 - -6162, 1733269680 - 573, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1733269680 - -6189, -1733269680 + -16297, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1733269680 - -6162, 1733269680 - 573, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1733269680 - -6164, 1733269680 + 661, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1733269680 - -6166, -1733269680 + -8349, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1733269680 - -6162, 1733269680 - 573, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1733269680 - -6178, -1733269680 + -4970, (int)l));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1733269680 - -6166, -1733269680 + -8349, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1733269680 - -6162, 1733269680 - 573, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1733269680 - -6179, -1733269680 - -1603, (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1733269680 - -6166, -1733269680 + -8349, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1733269680 - -6162, 1733269680 - 573, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1733269680 - -6176, -1733269680 - -1234, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                boolean bl2;
                block16: {
                    l = 15932238678808L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.v();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3376, 2090042220 - (char)-9693, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3372, -2090042220 - -((char)-779), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3359, 2090042220 - (char)-5212, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3360, -2090042220 - -((char)-19008), (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3376, 2090042220 - (char)-9693, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3372, -2090042220 - -((char)-779), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3361, -2090042220 - -((char)-30826), (int)l));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3376, 2090042220 - (char)-9693, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3372, -2090042220 - -((char)-779), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3362, 2090042220 - (char)-11717, (int)l) + ErrorToolsKt.prettyHRESULT((int)n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3376, 2090042220 - (char)-9693, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3372, -2090042220 - -((char)-779), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3363, -2090042220 - -((char)-20805), (int)l));
                    if (!bl2) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3376, 2090042220 - (char)-9693, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3372, -2090042220 - -((char)-779), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3396, 2090042220 - (char)-4316, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2090042220 - (char)-3397, -2090042220 - -((char)-25968), (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\r\u00c9sr\u00d6\u00e4{\u00a2\u0014+\u00f1\u008f\u0092\u00b7p\u00f8*rl+6\u00ac\u00c0\u0014J\u00ab\u00f3\u00df\u00fc\u0006\r\u00bbs<\u00bcl\u0018<4\r\u001ae\u00a4\u00a0p\u00b1Z\\\u0080$\u00e9W\u00edjn\u00c9\u00d2\u000b+\u0016M\t\u00c2&L\u00e9&E\u00d0\u0004\u0083\u0005\u0002\u00eb\u00926\u009a\b\u00f7\u00fe,\u00e5o0J\u00da\u0014:\u0000\u00d57\u0091\u00cc\t*\"\u00b1\u008a9\u00d2\u0082`\u00ef7\u0094\u00b5R\u0005\u00f1X\u00ec@U\u001eF\u00f4\u000f\u00b1\u00b4\u00158<\u0007\u00c7\u00c1\u00b4\u00dbO\n] \u00e9R\u00d6\u00d4\u0084\u00e1u\u000e\u00b0\\\u00ca\u00de\u000f\u0010<^\u00a4!\u00965\u008a\u00c1,\u00ca)\u00e8\u00c0\u0091\u00c6\u0019\t\u00b1\u00d5\u00f4\u0086b\u008f~\u00c2\u00b8\u0010\u001e\u00ec\u00e0w\u001e\u00ff\u009b\u0098\u000e\u00e1m\u008dH=\u00d7\u008c?\u00ean\u0092\u00e2\nvj<<\u0016\u00e3u \u0081H\u00bd\u00ad\u0090\u009e<\u00c3\u008bx\u00f2-\u00a85}\u00c4\u00af\u00c3\u00c9LdN\u00f7\u00b2\u00c9O\u008cd\u00b5]\u001a\u0016\n\u0098\u0094>\u0012i\u00b0-\u00ff\u001a \u0082u\u00dc\u00b8\u0083=8\b-\u00b0w,\u0004\t'\u00fd\fi\u00a4\u00ef\u00b5\nX\b\u00d0U\u00a0T\u00a1FL\u00e9K\u001c\u009em\u009av\u0007x\u0014~H\u00e8Z\u00b6\u0013\u0096IS+4f7\u00d8;x\u0004\u00d2\u00a9;5oM\u00e8\u00f3\u00bc\u0004%\u00f1\u00ba\u000f\r\u00b6\u00c2\u001aV\u00eb\u0000\u0005\u00c8\u00f8\u00f6`w\u00c8\u00b0\u001c\f)\u00aafA=\u00e9\u00df\u00ce\u00ec\u00f13\u001f\u0083\u0018\u00b7,\u00a3\u00a6\u00daJ[\tJm\u00aai/(\u00ff\u00af\u00d4\u00d4\u00cfDU\u00c6\u00f9\u0016\u00b5\u00d2\u00fe\u00fd\u00bc\u000b\u00e6\\\u001e\u00aa4\u00bb\u00cf\u00ac\u00ad#A\u0015\u00dd\u0013y@\u00df\u008e^w\u00a1\u00b8\b\u0090\\z\u00ec\u001c|\u00bdy\u00efL)\u0080\u00e5\u00d7\u0093\u00afQ[\u00b4k\u00d6L\u0096n\u001c)\u0083`R\u00fc\u00cc:?-\u00b1\u0099\u00b1n^\u00aa\u0098\u00b4-`\u00ebo\u00aaR2s\u009e\u00d3\u0007{\u008b\u00a2D%\u00f6\u0091\u0007kK\u00c40\u000e\u0097\u00e2(!\u00b5\u00af\u00b8\u0010^Zr;\u00d9lAIg\u008fo\u00b3b(\u0089\u00c1\u00a9=\u00a8\u000b.\u008a\u00d6\u0001\u00e9\u001a\u001aNf4\u00b6\u0083\u00cc\u00da\u00b2\u000f\u0094\u0082Ww\u00e7\u00cb\u0001\u0003%z\u000ed\u00a5\u0097\u008c\"\u0016\u00bb\u0005X\u00f5(\u0010\u009b\u00023a*\u00c8\u0087\u0099>\u009d\u00cc\u00c9]v\r\u0004\u00a7/'uR\u00ed+\u00fe\\\u00076\u000e{v\u00aa\u00e9X\u0018\u00f6y\u00db5\u00d1\u008dR\u00a0\u001bD]J\u0089\u00bf\u00a1\u009f\u0012\u00a1\u00df\u0013\u00d1Z\u001d\u00ed{\u00bb\u00ce\u00b0\u0081b\u00a2\u00f5\u00f4Z \u008e\n\u00f4\u00d2\u0098\u007f\u00f1\u009b\u0085\u007fI\u0010\u0018\u009dgq\u00c3\u00d9Tr\u00f2\u0002\n\u00a5\u00f45\u00ea\u00fc\u00a4\u00ee4\u00cd\u00a7\u00b5-TV)I\u009f\u00ee\u00dc\u0088\u00b8\u00bf\u0089\u00f7q\u00dfb\u0018\u008bx\n4\u0016\u00a9\u0081\u00aa\u0086v\u008a\u0087D0\f2\u008e\u001c~P_\u00bc\u00a8\u00f6V\u00e7\u0012A\tky\u00af\r\u00031\u0004NJ";
                var4_3 = "\r\u00c9sr\u00d6\u00e4{\u00a2\u0014+\u00f1\u008f\u0092\u00b7p\u00f8*rl+6\u00ac\u00c0\u0014J\u00ab\u00f3\u00df\u00fc\u0006\r\u00bbs<\u00bcl\u0018<4\r\u001ae\u00a4\u00a0p\u00b1Z\\\u0080$\u00e9W\u00edjn\u00c9\u00d2\u000b+\u0016M\t\u00c2&L\u00e9&E\u00d0\u0004\u0083\u0005\u0002\u00eb\u00926\u009a\b\u00f7\u00fe,\u00e5o0J\u00da\u0014:\u0000\u00d57\u0091\u00cc\t*\"\u00b1\u008a9\u00d2\u0082`\u00ef7\u0094\u00b5R\u0005\u00f1X\u00ec@U\u001eF\u00f4\u000f\u00b1\u00b4\u00158<\u0007\u00c7\u00c1\u00b4\u00dbO\n] \u00e9R\u00d6\u00d4\u0084\u00e1u\u000e\u00b0\\\u00ca\u00de\u000f\u0010<^\u00a4!\u00965\u008a\u00c1,\u00ca)\u00e8\u00c0\u0091\u00c6\u0019\t\u00b1\u00d5\u00f4\u0086b\u008f~\u00c2\u00b8\u0010\u001e\u00ec\u00e0w\u001e\u00ff\u009b\u0098\u000e\u00e1m\u008dH=\u00d7\u008c?\u00ean\u0092\u00e2\nvj<<\u0016\u00e3u \u0081H\u00bd\u00ad\u0090\u009e<\u00c3\u008bx\u00f2-\u00a85}\u00c4\u00af\u00c3\u00c9LdN\u00f7\u00b2\u00c9O\u008cd\u00b5]\u001a\u0016\n\u0098\u0094>\u0012i\u00b0-\u00ff\u001a \u0082u\u00dc\u00b8\u0083=8\b-\u00b0w,\u0004\t'\u00fd\fi\u00a4\u00ef\u00b5\nX\b\u00d0U\u00a0T\u00a1FL\u00e9K\u001c\u009em\u009av\u0007x\u0014~H\u00e8Z\u00b6\u0013\u0096IS+4f7\u00d8;x\u0004\u00d2\u00a9;5oM\u00e8\u00f3\u00bc\u0004%\u00f1\u00ba\u000f\r\u00b6\u00c2\u001aV\u00eb\u0000\u0005\u00c8\u00f8\u00f6`w\u00c8\u00b0\u001c\f)\u00aafA=\u00e9\u00df\u00ce\u00ec\u00f13\u001f\u0083\u0018\u00b7,\u00a3\u00a6\u00daJ[\tJm\u00aai/(\u00ff\u00af\u00d4\u00d4\u00cfDU\u00c6\u00f9\u0016\u00b5\u00d2\u00fe\u00fd\u00bc\u000b\u00e6\\\u001e\u00aa4\u00bb\u00cf\u00ac\u00ad#A\u0015\u00dd\u0013y@\u00df\u008e^w\u00a1\u00b8\b\u0090\\z\u00ec\u001c|\u00bdy\u00efL)\u0080\u00e5\u00d7\u0093\u00afQ[\u00b4k\u00d6L\u0096n\u001c)\u0083`R\u00fc\u00cc:?-\u00b1\u0099\u00b1n^\u00aa\u0098\u00b4-`\u00ebo\u00aaR2s\u009e\u00d3\u0007{\u008b\u00a2D%\u00f6\u0091\u0007kK\u00c40\u000e\u0097\u00e2(!\u00b5\u00af\u00b8\u0010^Zr;\u00d9lAIg\u008fo\u00b3b(\u0089\u00c1\u00a9=\u00a8\u000b.\u008a\u00d6\u0001\u00e9\u001a\u001aNf4\u00b6\u0083\u00cc\u00da\u00b2\u000f\u0094\u0082Ww\u00e7\u00cb\u0001\u0003%z\u000ed\u00a5\u0097\u008c\"\u0016\u00bb\u0005X\u00f5(\u0010\u009b\u00023a*\u00c8\u0087\u0099>\u009d\u00cc\u00c9]v\r\u0004\u00a7/'uR\u00ed+\u00fe\\\u00076\u000e{v\u00aa\u00e9X\u0018\u00f6y\u00db5\u00d1\u008dR\u00a0\u001bD]J\u0089\u00bf\u00a1\u009f\u0012\u00a1\u00df\u0013\u00d1Z\u001d\u00ed{\u00bb\u00ce\u00b0\u0081b\u00a2\u00f5\u00f4Z \u008e\n\u00f4\u00d2\u0098\u007f\u00f1\u009b\u0085\u007fI\u0010\u0018\u009dgq\u00c3\u00d9Tr\u00f2\u0002\n\u00a5\u00f45\u00ea\u00fc\u00a4\u00ee4\u00cd\u00a7\u00b5-TV)I\u009f\u00ee\u00dc\u0088\u00b8\u00bf\u0089\u00f7q\u00dfb\u0018\u008bx\n4\u0016\u00a9\u0081\u00aa\u0086v\u008a\u0087D0\f2\u008e\u001c~P_\u00bc\u00a8\u00f6V\u00e7\u0012A\tky\u00af\r\u00031\u0004NJ".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 36;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "]\u00c9}\u0007\u00eb\u00d2\u00c2\u00d5I\u00eb\u0019 \u00d1\u00d2P0 Lj_\u0096s\u0013\u00fb\u0091gr<\u00fb\u0014\u00cf\u00f7\u0002C\u0017[\u00fd^\u00c3\u00f3\f\u00d4Y\u008d\u00bb\u00f2O\u00f5R-";
                    var4_3 = "]\u00c9}\u0007\u00eb\u00d2\u00c2\u00d5I\u00eb\u0019 \u00d1\u00d2P0 Lj_\u0096s\u0013\u00fb\u0091gr<\u00fb\u0014\u00cf\u00f7\u0002C\u0017[\u00fd^\u00c3\u00f3\f\u00d4Y\u008d\u00bb\u00f2O\u00f5R-".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 126;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 114;
                            break;
                        }
                        case 1: {
                            v15 = 109;
                            break;
                        }
                        case 2: {
                            v15 = 50;
                            break;
                        }
                        case 3: {
                            v15 = 103;
                            break;
                        }
                        case 4: {
                            v15 = 112;
                            break;
                        }
                        case 5: {
                            v15 = 78;
                            break;
                        }
                        default: {
                            v15 = 33;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0xFFFFDB88) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 29;
                case 1 -> 125;
                case 2 -> 231;
                case 3 -> 7;
                case 4 -> 226;
                case 5 -> 245;
                case 6 -> 175;
                case 7 -> 146;
                case 8 -> 230;
                case 9 -> 209;
                case 10 -> 56;
                case 11 -> 201;
                case 12 -> 39;
                case 13 -> 217;
                case 14 -> 98;
                case 15 -> 18;
                case 16 -> 91;
                case 17 -> 250;
                case 18 -> 168;
                case 19 -> 22;
                case 20 -> 76;
                case 21 -> 124;
                case 22 -> 50;
                case 23 -> 103;
                case 24 -> 221;
                case 25 -> 63;
                case 26 -> 132;
                case 27 -> 240;
                case 28 -> 60;
                case 29 -> 222;
                case 30 -> 85;
                case 31 -> 4;
                case 32 -> 198;
                case 33 -> 11;
                case 34 -> 20;
                case 35 -> 83;
                case 36 -> 139;
                case 37 -> 134;
                case 38 -> 181;
                case 39 -> 246;
                case 40 -> 57;
                case 41 -> 26;
                case 42 -> 89;
                case 43 -> 110;
                case 44 -> 70;
                case 45 -> 169;
                case 46 -> 90;
                case 47 -> 112;
                case 48 -> 158;
                case 49 -> 64;
                case 50 -> 195;
                case 51 -> 235;
                case 52 -> 176;
                case 53 -> 156;
                case 54 -> 9;
                case 55 -> 35;
                case 56 -> 47;
                case 57 -> 42;
                case 58 -> 97;
                case 59 -> 160;
                case 60 -> 216;
                case 61 -> 80;
                case 62 -> 55;
                case 63 -> 165;
                case 64 -> 247;
                case 65 -> 166;
                case 66 -> 155;
                case 67 -> 100;
                case 68 -> 211;
                case 69 -> 140;
                case 70 -> 8;
                case 71 -> 215;
                case 72 -> 34;
                case 73 -> 218;
                case 74 -> 73;
                case 75 -> 184;
                case 76 -> 232;
                case 77 -> 93;
                case 78 -> 77;
                case 79 -> 46;
                case 80 -> 205;
                case 81 -> 229;
                case 82 -> 99;
                case 83 -> 40;
                case 84 -> 69;
                case 85 -> 123;
                case 86 -> 41;
                case 87 -> 23;
                case 88 -> 200;
                case 89 -> 149;
                case 90 -> 10;
                case 91 -> 253;
                case 92 -> 75;
                case 93 -> 81;
                case 94 -> 137;
                case 95 -> 118;
                case 96 -> 2;
                case 97 -> 113;
                case 98 -> 185;
                case 99 -> 142;
                case 100 -> 43;
                case 101 -> 150;
                case 102 -> 213;
                case 103 -> 95;
                case 104 -> 101;
                case 105 -> 133;
                case 106 -> 96;
                case 107 -> 241;
                case 108 -> 0;
                case 109 -> 145;
                case 110 -> 105;
                case 111 -> 86;
                case 112 -> 79;
                case 113 -> 15;
                case 114 -> 114;
                case 115 -> 203;
                case 116 -> 21;
                case 117 -> 109;
                case 118 -> 233;
                case 119 -> 238;
                case 120 -> 239;
                case 121 -> 242;
                case 122 -> 14;
                case 123 -> 102;
                case 124 -> 58;
                case 125 -> 54;
                case 126 -> 92;
                case 127 -> 227;
                case 128 -> 48;
                case 129 -> 234;
                case 130 -> 237;
                case 131 -> 33;
                case 132 -> 28;
                case 133 -> 210;
                case 134 -> 107;
                case 135 -> 180;
                case 136 -> 71;
                case 137 -> 187;
                case 138 -> 192;
                case 139 -> 255;
                case 140 -> 94;
                case 141 -> 121;
                case 142 -> 131;
                case 143 -> 68;
                case 144 -> 88;
                case 145 -> 5;
                case 146 -> 17;
                case 147 -> 67;
                case 148 -> 196;
                case 149 -> 24;
                case 150 -> 115;
                case 151 -> 248;
                case 152 -> 163;
                case 153 -> 87;
                case 154 -> 129;
                case 155 -> 16;
                case 156 -> 37;
                case 157 -> 212;
                case 158 -> 38;
                case 159 -> 206;
                case 160 -> 173;
                case 161 -> 49;
                case 162 -> 190;
                case 163 -> 236;
                case 164 -> 108;
                case 165 -> 148;
                case 166 -> 152;
                case 167 -> 186;
                case 168 -> 220;
                case 169 -> 224;
                case 170 -> 25;
                case 171 -> 130;
                case 172 -> 154;
                case 173 -> 6;
                case 174 -> 243;
                case 175 -> 1;
                case 176 -> 30;
                case 177 -> 66;
                case 178 -> 122;
                case 179 -> 32;
                case 180 -> 251;
                case 181 -> 3;
                case 182 -> 52;
                case 183 -> 143;
                case 184 -> 104;
                case 185 -> 254;
                case 186 -> 219;
                case 187 -> 182;
                case 188 -> 128;
                case 189 -> 228;
                case 190 -> 74;
                case 191 -> 141;
                case 192 -> 27;
                case 193 -> 82;
                case 194 -> 12;
                case 195 -> 178;
                case 196 -> 116;
                case 197 -> 19;
                case 198 -> 111;
                case 199 -> 120;
                case 200 -> 84;
                case 201 -> 188;
                case 202 -> 214;
                case 203 -> 65;
                case 204 -> 249;
                case 205 -> 78;
                case 206 -> 117;
                case 207 -> 44;
                case 208 -> 45;
                case 209 -> 31;
                case 210 -> 189;
                case 211 -> 161;
                case 212 -> 135;
                case 213 -> 170;
                case 214 -> 106;
                case 215 -> 153;
                case 216 -> 136;
                case 217 -> 127;
                case 218 -> 223;
                case 219 -> 225;
                case 220 -> 61;
                case 221 -> 36;
                case 222 -> 59;
                case 223 -> 208;
                case 224 -> 159;
                case 225 -> 51;
                case 226 -> 119;
                case 227 -> 164;
                case 228 -> 53;
                case 229 -> 162;
                case 230 -> 157;
                case 231 -> 252;
                case 232 -> 62;
                case 233 -> 204;
                case 234 -> 193;
                case 235 -> 138;
                case 236 -> 147;
                case 237 -> 144;
                case 238 -> 199;
                case 239 -> 191;
                case 240 -> 72;
                case 241 -> 13;
                case 242 -> 151;
                case 243 -> 167;
                case 244 -> 179;
                case 245 -> 177;
                case 246 -> 244;
                case 247 -> 194;
                case 248 -> 172;
                case 249 -> 197;
                case 250 -> 207;
                case 251 -> 183;
                case 252 -> 126;
                case 253 -> 202;
                case 254 -> 171;
                default -> 174;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 42752046989757L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(57408660 + (char)-11881, -57408660 + -((char)-17651), (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l = 60274114672937L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1456318770 + (char)-12916, 1456318770 + (char)-11236, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1456318770 + (char)-12917, 1456318770 + (char)-16070, (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1456318770 + (char)-12918, -1456318770 + -29719, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0097\u001b\u00df\u0003\u00fen\u0094\u00be\u0010]\u00caw\u0098Q\u00a6\u0098\u00fe\u000e\u00d2FV\u0089\u00ac\u00a2\u00de";
                    var4_3 = "\u0097\u001b\u00df\u0003\u00fen\u0094\u00be\u0010]\u00caw\u0098Q\u00a6\u0098\u00fe\u000e\u00d2FV\u0089\u00ac\u00a2\u00de".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 111;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0019\u0088C<P5\u00cd*\u00ce\u00043A\u0081\u00e4\u0017g\u00bam\u00aclN\u0001\u00c1\u00a8tC%\u00e1%Y\u0081\u0082V\u00b58\u00ab?h\u00df\u0005\u009f\u009a`\u00fc7\u00b12\u009a\u0000:Z\u0083\u0013\u00de\\\u00ad\u001b\u00d0@";
                        var4_3 = "\u0019\u0088C<P5\u00cd*\u00ce\u00043A\u0081\u00e4\u0017g\u00bam\u00aclN\u0001\u00c1\u00a8tC%\u00e1%Y\u0081\u0082V\u00b58\u00ab?h\u00df\u0005\u009f\u009a`\u00fc7\u00b12\u009a\u0000:Z\u0083\u0013\u00de\\\u00ad\u001b\u00d0@".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 14;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 70;
                                break;
                            }
                            case 2: {
                                v15 = 46;
                                break;
                            }
                            case 3: {
                                v15 = 11;
                                break;
                            }
                            case 4: {
                                v15 = 108;
                                break;
                            }
                            case 5: {
                                v15 = 69;
                                break;
                            }
                            default: {
                                v15 = 106;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFCF96) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 134;
                    case 1 -> 91;
                    case 2 -> 231;
                    case 3 -> 58;
                    case 4 -> 30;
                    case 5 -> 80;
                    case 6 -> 215;
                    case 7 -> 29;
                    case 8 -> 178;
                    case 9 -> 118;
                    case 10 -> 8;
                    case 11 -> 146;
                    case 12 -> 190;
                    case 13 -> 56;
                    case 14 -> 184;
                    case 15 -> 102;
                    case 16 -> 81;
                    case 17 -> 115;
                    case 18 -> 187;
                    case 19 -> 224;
                    case 20 -> 4;
                    case 21 -> 188;
                    case 22 -> 22;
                    case 23 -> 220;
                    case 24 -> 76;
                    case 25 -> 105;
                    case 26 -> 163;
                    case 27 -> 52;
                    case 28 -> 182;
                    case 29 -> 38;
                    case 30 -> 43;
                    case 31 -> 57;
                    case 32 -> 218;
                    case 33 -> 225;
                    case 34 -> 9;
                    case 35 -> 185;
                    case 36 -> 123;
                    case 37 -> 103;
                    case 38 -> 152;
                    case 39 -> 32;
                    case 40 -> 210;
                    case 41 -> 55;
                    case 42 -> 197;
                    case 43 -> 54;
                    case 44 -> 64;
                    case 45 -> 109;
                    case 46 -> 154;
                    case 47 -> 161;
                    case 48 -> 37;
                    case 49 -> 84;
                    case 50 -> 216;
                    case 51 -> 18;
                    case 52 -> 78;
                    case 53 -> 47;
                    case 54 -> 59;
                    case 55 -> 128;
                    case 56 -> 135;
                    case 57 -> 88;
                    case 58 -> 7;
                    case 59 -> 86;
                    case 60 -> 205;
                    case 61 -> 65;
                    case 62 -> 104;
                    case 63 -> 119;
                    case 64 -> 2;
                    case 65 -> 137;
                    case 66 -> 82;
                    case 67 -> 251;
                    case 68 -> 63;
                    case 69 -> 214;
                    case 70 -> 127;
                    case 71 -> 209;
                    case 72 -> 246;
                    case 73 -> 204;
                    case 74 -> 193;
                    case 75 -> 85;
                    case 76 -> 100;
                    case 77 -> 200;
                    case 78 -> 62;
                    case 79 -> 254;
                    case 80 -> 60;
                    case 81 -> 50;
                    case 82 -> 136;
                    case 83 -> 110;
                    case 84 -> 117;
                    case 85 -> 116;
                    case 86 -> 92;
                    case 87 -> 126;
                    case 88 -> 255;
                    case 89 -> 164;
                    case 90 -> 48;
                    case 91 -> 228;
                    case 92 -> 211;
                    case 93 -> 12;
                    case 94 -> 227;
                    case 95 -> 247;
                    case 96 -> 203;
                    case 97 -> 124;
                    case 98 -> 108;
                    case 99 -> 177;
                    case 100 -> 249;
                    case 101 -> 131;
                    case 102 -> 72;
                    case 103 -> 226;
                    case 104 -> 234;
                    case 105 -> 244;
                    case 106 -> 83;
                    case 107 -> 42;
                    case 108 -> 112;
                    case 109 -> 71;
                    case 110 -> 201;
                    case 111 -> 139;
                    case 112 -> 232;
                    case 113 -> 223;
                    case 114 -> 158;
                    case 115 -> 79;
                    case 116 -> 147;
                    case 117 -> 1;
                    case 118 -> 169;
                    case 119 -> 165;
                    case 120 -> 212;
                    case 121 -> 96;
                    case 122 -> 195;
                    case 123 -> 46;
                    case 124 -> 111;
                    case 125 -> 241;
                    case 126 -> 44;
                    case 127 -> 237;
                    case 128 -> 196;
                    case 129 -> 39;
                    case 130 -> 198;
                    case 131 -> 206;
                    case 132 -> 238;
                    case 133 -> 239;
                    case 134 -> 186;
                    case 135 -> 15;
                    case 136 -> 93;
                    case 137 -> 192;
                    case 138 -> 68;
                    case 139 -> 31;
                    case 140 -> 3;
                    case 141 -> 144;
                    case 142 -> 75;
                    case 143 -> 171;
                    case 144 -> 129;
                    case 145 -> 95;
                    case 146 -> 160;
                    case 147 -> 10;
                    case 148 -> 150;
                    case 149 -> 173;
                    case 150 -> 34;
                    case 151 -> 113;
                    case 152 -> 90;
                    case 153 -> 114;
                    case 154 -> 166;
                    case 155 -> 51;
                    case 156 -> 208;
                    case 157 -> 140;
                    case 158 -> 66;
                    case 159 -> 120;
                    case 160 -> 23;
                    case 161 -> 252;
                    case 162 -> 0;
                    case 163 -> 242;
                    case 164 -> 6;
                    case 165 -> 217;
                    case 166 -> 28;
                    case 167 -> 213;
                    case 168 -> 61;
                    case 169 -> 170;
                    case 170 -> 21;
                    case 171 -> 69;
                    case 172 -> 189;
                    case 173 -> 122;
                    case 174 -> 155;
                    case 175 -> 148;
                    case 176 -> 73;
                    case 177 -> 19;
                    case 178 -> 167;
                    case 179 -> 194;
                    case 180 -> 26;
                    case 181 -> 133;
                    case 182 -> 202;
                    case 183 -> 141;
                    case 184 -> 176;
                    case 185 -> 248;
                    case 186 -> 229;
                    case 187 -> 142;
                    case 188 -> 235;
                    case 189 -> 159;
                    case 190 -> 45;
                    case 191 -> 25;
                    case 192 -> 36;
                    case 193 -> 168;
                    case 194 -> 97;
                    case 195 -> 107;
                    case 196 -> 27;
                    case 197 -> 145;
                    case 198 -> 14;
                    case 199 -> 191;
                    case 200 -> 87;
                    case 201 -> 101;
                    case 202 -> 41;
                    case 203 -> 17;
                    case 204 -> 138;
                    case 205 -> 121;
                    case 206 -> 98;
                    case 207 -> 183;
                    case 208 -> 149;
                    case 209 -> 179;
                    case 210 -> 236;
                    case 211 -> 172;
                    case 212 -> 24;
                    case 213 -> 40;
                    case 214 -> 13;
                    case 215 -> 181;
                    case 216 -> 230;
                    case 217 -> 20;
                    case 218 -> 94;
                    case 219 -> 222;
                    case 220 -> 207;
                    case 221 -> 153;
                    case 222 -> 125;
                    case 223 -> 157;
                    case 224 -> 243;
                    case 225 -> 132;
                    case 226 -> 16;
                    case 227 -> 89;
                    case 228 -> 250;
                    case 229 -> 35;
                    case 230 -> 233;
                    case 231 -> 199;
                    case 232 -> 162;
                    case 233 -> 240;
                    case 234 -> 174;
                    case 235 -> 53;
                    case 236 -> 151;
                    case 237 -> 253;
                    case 238 -> 33;
                    case 239 -> 245;
                    case 240 -> 67;
                    case 241 -> 106;
                    case 242 -> 156;
                    case 243 -> 219;
                    case 244 -> 221;
                    case 245 -> 11;
                    case 246 -> 175;
                    case 247 -> 77;
                    case 248 -> 74;
                    case 249 -> 143;
                    case 250 -> 180;
                    case 251 -> 99;
                    case 252 -> 130;
                    case 253 -> 49;
                    case 254 -> 70;
                    default -> 5;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 18075766018791L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "0O\f\u0006, \u007fi\t7E\u001f\fabbu\u0003";
                    var5_4 = "0O\f\u0006, \u007fi\t7E\u001f\fabbu\u0003".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 18;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 73;
                                    break;
                                }
                                case 1: {
                                    v11 = 56;
                                    break;
                                }
                                case 2: {
                                    v11 = 108;
                                    break;
                                }
                                case 3: {
                                    v11 = 122;
                                    break;
                                }
                                case 4: {
                                    v11 = 91;
                                    break;
                                }
                                case 5: {
                                    v11 = 94;
                                    break;
                                }
                                default: {
                                    v11 = 94;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 13177913192608L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "C\u0007(UPk\u0012\u0004E\u0019$O\nI\u0006/O\\i\nc\u0007&\tI\u0006/O\\i\no\r\rN\u00002BVd\u0010o\n5HWm";
                    var5_4 = "C\u0007(UPk\u0012\u0004E\u0019$O\nI\u0006/O\\i\nc\u0007&\tI\u0006/O\\i\no\r\rN\u00002BVd\u0010o\n5HWm".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 23;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "W\u001b0LNz\u0007\u0006W\u001b0LBp";
                        var5_4 = "W\u001b0LNz\u0007\u0006W\u001b0LBp".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 9;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 29;
                                break;
                            }
                            case 1: {
                                v15 = 126;
                                break;
                            }
                            case 2: {
                                v15 = 86;
                                break;
                            }
                            case 3: {
                                v15 = 54;
                                break;
                            }
                            case 4: {
                                v15 = 46;
                                break;
                            }
                            case 5: {
                                v15 = 29;
                                break;
                            }
                            default: {
                                v15 = 105;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 82073827144029L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1297068720 - -8276, -1297068720 + -16039, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 87424625966877L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0095\u0015?y\u00f6\u0003\u00b8@.\u0005\u00cc\u00e92\"\u00b4\r)\u0014\u00b8\u00d7\u0010\u000b\u00e2\u0082S_q-X\u0010cN6w\u00fe\u008a\u0014\u008fDzp\u00c4\u009e\u0087\u00b4`\u0005\u00e3\u00a7\u00d7\u00eb\b3\u0096Bh \u00e0$\u00e7NG\u00bf\u009bU%\u00e4\u00ef\u0013\u000e\u00c30\u00b2>`\u00b6*\n\u00b9R\u00b0\u00bf);WT\u00d8:\u00f3\u00b8X\u00ae\u00e5\u0000~\u00ee\u0002=\u00c4[\u0080\u00e8\u00ef\u00eb";
                    var4_3 = "\u0095\u0015?y\u00f6\u0003\u00b8@.\u0005\u00cc\u00e92\"\u00b4\r)\u0014\u00b8\u00d7\u0010\u000b\u00e2\u0082S_q-X\u0010cN6w\u00fe\u008a\u0014\u008fDzp\u00c4\u009e\u0087\u00b4`\u0005\u00e3\u00a7\u00d7\u00eb\b3\u0096Bh \u00e0$\u00e7NG\u00bf\u009bU%\u00e4\u00ef\u0013\u000e\u00c30\u00b2>`\u00b6*\n\u00b9R\u00b0\u00bf);WT\u00d8:\u00f3\u00b8X\u00ae\u00e5\u0000~\u00ee\u0002=\u00c4[\u0080\u00e8\u00ef\u00eb".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "4(z\u001d\u00d1aWT\u008a\u00a7\u000f\u00d9\u00d7\u0082;fLl<\u0086Ud\u00a0\u008f\u0002\u0018\u00fe\u00f1K\u0006^\u0092\u0084\u0002F\u00e8R\u00eb\u00be\u0080\u00f5I\u000f\u00b9\u0006\u009e\u0010V\u00b9OM\u008e\u00fb\u00ba!r\n\u000b\u00d8\u00e6\r\u008f]`-\u00db\u00c8\u00c3\u0085\u00a5\u001c'\u009b>\u00cb[\u00a4\u00db\u0015\u00ae9|\u0080t\u00fa\u00dc\u0093\u009f\u00edLT,\u0087";
                        var4_3 = "4(z\u001d\u00d1aWT\u008a\u00a7\u000f\u00d9\u00d7\u0082;fLl<\u0086Ud\u00a0\u008f\u0002\u0018\u00fe\u00f1K\u0006^\u0092\u0084\u0002F\u00e8R\u00eb\u00be\u0080\u00f5I\u000f\u00b9\u0006\u009e\u0010V\u00b9OM\u008e\u00fb\u00ba!r\n\u000b\u00d8\u00e6\r\u008f]`-\u00db\u00c8\u00c3\u0085\u00a5\u001c'\u009b>\u00cb[\u00a4\u00db\u0015\u00ae9|\u0080t\u00fa\u00dc\u0093\u009f\u00edLT,\u0087".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 125;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 62;
                                break;
                            }
                            case 1: {
                                v15 = 67;
                                break;
                            }
                            case 2: {
                                v15 = 22;
                                break;
                            }
                            case 3: {
                                v15 = 34;
                                break;
                            }
                            case 4: {
                                v15 = 26;
                                break;
                            }
                            case 5: {
                                v15 = 71;
                                break;
                            }
                            default: {
                                v15 = 43;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFF9CF9) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 113;
                    case 1 -> 221;
                    case 2 -> 58;
                    case 3 -> 86;
                    case 4 -> 48;
                    case 5 -> 80;
                    case 6 -> 232;
                    case 7 -> 72;
                    case 8 -> 239;
                    case 9 -> 155;
                    case 10 -> 53;
                    case 11 -> 67;
                    case 12 -> 192;
                    case 13 -> 246;
                    case 14 -> 65;
                    case 15 -> 223;
                    case 16 -> 130;
                    case 17 -> 167;
                    case 18 -> 77;
                    case 19 -> 45;
                    case 20 -> 202;
                    case 21 -> 117;
                    case 22 -> 233;
                    case 23 -> 9;
                    case 24 -> 241;
                    case 25 -> 166;
                    case 26 -> 132;
                    case 27 -> 181;
                    case 28 -> 21;
                    case 29 -> 188;
                    case 30 -> 131;
                    case 31 -> 200;
                    case 32 -> 160;
                    case 33 -> 196;
                    case 34 -> 190;
                    case 35 -> 15;
                    case 36 -> 170;
                    case 37 -> 250;
                    case 38 -> 176;
                    case 39 -> 152;
                    case 40 -> 193;
                    case 41 -> 114;
                    case 42 -> 146;
                    case 43 -> 255;
                    case 44 -> 38;
                    case 45 -> 182;
                    case 46 -> 243;
                    case 47 -> 47;
                    case 48 -> 194;
                    case 49 -> 123;
                    case 50 -> 127;
                    case 51 -> 7;
                    case 52 -> 10;
                    case 53 -> 76;
                    case 54 -> 225;
                    case 55 -> 128;
                    case 56 -> 171;
                    case 57 -> 129;
                    case 58 -> 94;
                    case 59 -> 95;
                    case 60 -> 4;
                    case 61 -> 213;
                    case 62 -> 24;
                    case 63 -> 121;
                    case 64 -> 172;
                    case 65 -> 164;
                    case 66 -> 231;
                    case 67 -> 230;
                    case 68 -> 52;
                    case 69 -> 158;
                    case 70 -> 70;
                    case 71 -> 0;
                    case 72 -> 157;
                    case 73 -> 162;
                    case 74 -> 18;
                    case 75 -> 101;
                    case 76 -> 205;
                    case 77 -> 55;
                    case 78 -> 108;
                    case 79 -> 215;
                    case 80 -> 148;
                    case 81 -> 64;
                    case 82 -> 124;
                    case 83 -> 179;
                    case 84 -> 89;
                    case 85 -> 37;
                    case 86 -> 144;
                    case 87 -> 204;
                    case 88 -> 79;
                    case 89 -> 115;
                    case 90 -> 247;
                    case 91 -> 49;
                    case 92 -> 84;
                    case 93 -> 165;
                    case 94 -> 22;
                    case 95 -> 253;
                    case 96 -> 137;
                    case 97 -> 245;
                    case 98 -> 68;
                    case 99 -> 145;
                    case 100 -> 66;
                    case 101 -> 50;
                    case 102 -> 222;
                    case 103 -> 26;
                    case 104 -> 35;
                    case 105 -> 136;
                    case 106 -> 180;
                    case 107 -> 33;
                    case 108 -> 126;
                    case 109 -> 110;
                    case 110 -> 69;
                    case 111 -> 23;
                    case 112 -> 12;
                    case 113 -> 234;
                    case 114 -> 251;
                    case 115 -> 237;
                    case 116 -> 248;
                    case 117 -> 19;
                    case 118 -> 102;
                    case 119 -> 173;
                    case 120 -> 42;
                    case 121 -> 97;
                    case 122 -> 125;
                    case 123 -> 199;
                    case 124 -> 195;
                    case 125 -> 71;
                    case 126 -> 178;
                    case 127 -> 159;
                    case 128 -> 186;
                    case 129 -> 118;
                    case 130 -> 216;
                    case 131 -> 44;
                    case 132 -> 85;
                    case 133 -> 147;
                    case 134 -> 141;
                    case 135 -> 197;
                    case 136 -> 83;
                    case 137 -> 90;
                    case 138 -> 106;
                    case 139 -> 133;
                    case 140 -> 99;
                    case 141 -> 209;
                    case 142 -> 235;
                    case 143 -> 208;
                    case 144 -> 254;
                    case 145 -> 63;
                    case 146 -> 51;
                    case 147 -> 218;
                    case 148 -> 210;
                    case 149 -> 226;
                    case 150 -> 39;
                    case 151 -> 8;
                    case 152 -> 20;
                    case 153 -> 252;
                    case 154 -> 91;
                    case 155 -> 177;
                    case 156 -> 105;
                    case 157 -> 203;
                    case 158 -> 142;
                    case 159 -> 2;
                    case 160 -> 41;
                    case 161 -> 3;
                    case 162 -> 1;
                    case 163 -> 32;
                    case 164 -> 240;
                    case 165 -> 57;
                    case 166 -> 16;
                    case 167 -> 25;
                    case 168 -> 174;
                    case 169 -> 78;
                    case 170 -> 140;
                    case 171 -> 217;
                    case 172 -> 81;
                    case 173 -> 104;
                    case 174 -> 93;
                    case 175 -> 34;
                    case 176 -> 138;
                    case 177 -> 109;
                    case 178 -> 154;
                    case 179 -> 60;
                    case 180 -> 156;
                    case 181 -> 111;
                    case 182 -> 100;
                    case 183 -> 227;
                    case 184 -> 185;
                    case 185 -> 61;
                    case 186 -> 5;
                    case 187 -> 120;
                    case 188 -> 96;
                    case 189 -> 119;
                    case 190 -> 13;
                    case 191 -> 135;
                    case 192 -> 40;
                    case 193 -> 27;
                    case 194 -> 211;
                    case 195 -> 59;
                    case 196 -> 75;
                    case 197 -> 149;
                    case 198 -> 175;
                    case 199 -> 29;
                    case 200 -> 249;
                    case 201 -> 122;
                    case 202 -> 219;
                    case 203 -> 214;
                    case 204 -> 107;
                    case 205 -> 161;
                    case 206 -> 103;
                    case 207 -> 28;
                    case 208 -> 74;
                    case 209 -> 17;
                    case 210 -> 163;
                    case 211 -> 54;
                    case 212 -> 134;
                    case 213 -> 30;
                    case 214 -> 183;
                    case 215 -> 184;
                    case 216 -> 236;
                    case 217 -> 191;
                    case 218 -> 224;
                    case 219 -> 143;
                    case 220 -> 73;
                    case 221 -> 150;
                    case 222 -> 92;
                    case 223 -> 139;
                    case 224 -> 14;
                    case 225 -> 212;
                    case 226 -> 189;
                    case 227 -> 116;
                    case 228 -> 112;
                    case 229 -> 6;
                    case 230 -> 151;
                    case 231 -> 168;
                    case 232 -> 31;
                    case 233 -> 229;
                    case 234 -> 198;
                    case 235 -> 56;
                    case 236 -> 207;
                    case 237 -> 228;
                    case 238 -> 220;
                    case 239 -> 98;
                    case 240 -> 62;
                    case 241 -> 43;
                    case 242 -> 11;
                    case 243 -> 169;
                    case 244 -> 46;
                    case 245 -> 87;
                    case 246 -> 201;
                    case 247 -> 88;
                    case 248 -> 238;
                    case 249 -> 153;
                    case 250 -> 244;
                    case 251 -> 206;
                    case 252 -> 242;
                    case 253 -> 36;
                    case 254 -> 187;
                    default -> 82;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 41354387841240L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1852281240 - 8953, -1852281240 - -27232, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 55780260919791L;
                    boolean bl = SshAgentIpcService.v();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1520674140 - -23813, 1520674140 - 26268, (int)l));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 122932807019071L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00fb&\u00ae\u0081\u00d9\u0003\u00e0\u00fa\u009b";
                var4_3 = "\u00fb&\u00ae\u0081\u00d9\u0003\u00e0\u00fa\u009b".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 107;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 7;
                                break;
                            }
                            case 1: {
                                v11 = 52;
                                break;
                            }
                            case 2: {
                                v11 = 31;
                                break;
                            }
                            case 3: {
                                v11 = 32;
                                break;
                            }
                            case 4: {
                                v11 = 84;
                                break;
                            }
                            case 5: {
                                v11 = 97;
                                break;
                            }
                            default: {
                                v11 = 65;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFF8E47) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 107;
                    case 1 -> 96;
                    case 2 -> 209;
                    case 3 -> 70;
                    case 4 -> 66;
                    case 5 -> 200;
                    case 6 -> 247;
                    case 7 -> 133;
                    case 8 -> 147;
                    case 9 -> 181;
                    case 10 -> 103;
                    case 11 -> 126;
                    case 12 -> 153;
                    case 13 -> 194;
                    case 14 -> 186;
                    case 15 -> 17;
                    case 16 -> 160;
                    case 17 -> 202;
                    case 18 -> 18;
                    case 19 -> 54;
                    case 20 -> 41;
                    case 21 -> 176;
                    case 22 -> 208;
                    case 23 -> 90;
                    case 24 -> 255;
                    case 25 -> 250;
                    case 26 -> 19;
                    case 27 -> 224;
                    case 28 -> 44;
                    case 29 -> 50;
                    case 30 -> 210;
                    case 31 -> 20;
                    case 32 -> 2;
                    case 33 -> 246;
                    case 34 -> 241;
                    case 35 -> 203;
                    case 36 -> 53;
                    case 37 -> 72;
                    case 38 -> 104;
                    case 39 -> 199;
                    case 40 -> 43;
                    case 41 -> 148;
                    case 42 -> 74;
                    case 43 -> 136;
                    case 44 -> 206;
                    case 45 -> 94;
                    case 46 -> 1;
                    case 47 -> 156;
                    case 48 -> 140;
                    case 49 -> 220;
                    case 50 -> 214;
                    case 51 -> 238;
                    case 52 -> 174;
                    case 53 -> 35;
                    case 54 -> 92;
                    case 55 -> 121;
                    case 56 -> 204;
                    case 57 -> 73;
                    case 58 -> 222;
                    case 59 -> 68;
                    case 60 -> 150;
                    case 61 -> 137;
                    case 62 -> 173;
                    case 63 -> 102;
                    case 64 -> 145;
                    case 65 -> 24;
                    case 66 -> 75;
                    case 67 -> 216;
                    case 68 -> 51;
                    case 69 -> 10;
                    case 70 -> 82;
                    case 71 -> 63;
                    case 72 -> 157;
                    case 73 -> 171;
                    case 74 -> 127;
                    case 75 -> 11;
                    case 76 -> 236;
                    case 77 -> 98;
                    case 78 -> 86;
                    case 79 -> 235;
                    case 80 -> 77;
                    case 81 -> 244;
                    case 82 -> 69;
                    case 83 -> 39;
                    case 84 -> 226;
                    case 85 -> 114;
                    case 86 -> 58;
                    case 87 -> 166;
                    case 88 -> 109;
                    case 89 -> 36;
                    case 90 -> 84;
                    case 91 -> 111;
                    case 92 -> 233;
                    case 93 -> 76;
                    case 94 -> 27;
                    case 95 -> 170;
                    case 96 -> 30;
                    case 97 -> 175;
                    case 98 -> 118;
                    case 99 -> 116;
                    case 100 -> 71;
                    case 101 -> 196;
                    case 102 -> 112;
                    case 103 -> 113;
                    case 104 -> 87;
                    case 105 -> 16;
                    case 106 -> 184;
                    case 107 -> 177;
                    case 108 -> 105;
                    case 109 -> 23;
                    case 110 -> 179;
                    case 111 -> 167;
                    case 112 -> 91;
                    case 113 -> 89;
                    case 114 -> 138;
                    case 115 -> 15;
                    case 116 -> 120;
                    case 117 -> 253;
                    case 118 -> 0;
                    case 119 -> 122;
                    case 120 -> 152;
                    case 121 -> 12;
                    case 122 -> 198;
                    case 123 -> 169;
                    case 124 -> 218;
                    case 125 -> 237;
                    case 126 -> 142;
                    case 127 -> 230;
                    case 128 -> 106;
                    case 129 -> 227;
                    case 130 -> 7;
                    case 131 -> 185;
                    case 132 -> 188;
                    case 133 -> 242;
                    case 134 -> 3;
                    case 135 -> 119;
                    case 136 -> 88;
                    case 137 -> 164;
                    case 138 -> 129;
                    case 139 -> 110;
                    case 140 -> 48;
                    case 141 -> 162;
                    case 142 -> 219;
                    case 143 -> 183;
                    case 144 -> 213;
                    case 145 -> 38;
                    case 146 -> 251;
                    case 147 -> 172;
                    case 148 -> 59;
                    case 149 -> 83;
                    case 150 -> 193;
                    case 151 -> 26;
                    case 152 -> 146;
                    case 153 -> 99;
                    case 154 -> 240;
                    case 155 -> 95;
                    case 156 -> 33;
                    case 157 -> 168;
                    case 158 -> 182;
                    case 159 -> 31;
                    case 160 -> 52;
                    case 161 -> 32;
                    case 162 -> 45;
                    case 163 -> 187;
                    case 164 -> 62;
                    case 165 -> 205;
                    case 166 -> 225;
                    case 167 -> 80;
                    case 168 -> 78;
                    case 169 -> 108;
                    case 170 -> 155;
                    case 171 -> 9;
                    case 172 -> 249;
                    case 173 -> 49;
                    case 174 -> 215;
                    case 175 -> 130;
                    case 176 -> 25;
                    case 177 -> 192;
                    case 178 -> 67;
                    case 179 -> 22;
                    case 180 -> 223;
                    case 181 -> 212;
                    case 182 -> 100;
                    case 183 -> 248;
                    case 184 -> 232;
                    case 185 -> 81;
                    case 186 -> 234;
                    case 187 -> 101;
                    case 188 -> 178;
                    case 189 -> 8;
                    case 190 -> 161;
                    case 191 -> 229;
                    case 192 -> 40;
                    case 193 -> 123;
                    case 194 -> 56;
                    case 195 -> 47;
                    case 196 -> 5;
                    case 197 -> 93;
                    case 198 -> 125;
                    case 199 -> 228;
                    case 200 -> 159;
                    case 201 -> 211;
                    case 202 -> 191;
                    case 203 -> 37;
                    case 204 -> 149;
                    case 205 -> 165;
                    case 206 -> 64;
                    case 207 -> 124;
                    case 208 -> 195;
                    case 209 -> 239;
                    case 210 -> 65;
                    case 211 -> 42;
                    case 212 -> 131;
                    case 213 -> 151;
                    case 214 -> 163;
                    case 215 -> 60;
                    case 216 -> 46;
                    case 217 -> 128;
                    case 218 -> 243;
                    case 219 -> 154;
                    case 220 -> 143;
                    case 221 -> 29;
                    case 222 -> 197;
                    case 223 -> 217;
                    case 224 -> 207;
                    case 225 -> 180;
                    case 226 -> 254;
                    case 227 -> 55;
                    case 228 -> 252;
                    case 229 -> 201;
                    case 230 -> 132;
                    case 231 -> 61;
                    case 232 -> 21;
                    case 233 -> 189;
                    case 234 -> 85;
                    case 235 -> 190;
                    case 236 -> 4;
                    case 237 -> 221;
                    case 238 -> 79;
                    case 239 -> 134;
                    case 240 -> 245;
                    case 241 -> 135;
                    case 242 -> 117;
                    case 243 -> 34;
                    case 244 -> 141;
                    case 245 -> 144;
                    case 246 -> 13;
                    case 247 -> 115;
                    case 248 -> 231;
                    case 249 -> 139;
                    case 250 -> 97;
                    case 251 -> 14;
                    case 252 -> 158;
                    case 253 -> 57;
                    case 254 -> 6;
                    default -> 28;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

