/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.google.common.net.HostAndPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.run.DockerHelpersImageCreator;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.docker.PyBaseDockerProcessConnectionData;
import com.intellij.python.docker.PyDockerAgentDeploymentConfigImpl;
import com.intellij.python.docker.PyDockerCommandLinePatcher;
import com.intellij.python.docker.PyDockerProcessConnectionData;
import com.intellij.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDockerProcessUtil {
    private static final Logger LOG = Logger.getInstance(PyDockerProcessUtil.class);
    private static final String PYCHARM_HELPERS_IMAGE_REPOSITORY = "pycharm_helpers";
    public static final String PYCHARM_HELPERS_VERSION_LABEL = "com.jetbrains.pycharm_helpers.version";
    public static final String PYCHARM_HELPERS_VOLUME_PATH = "/opt/.pycharm_helpers";
    private static final String PYCHARM_HELPERS_DIRECTORY_ENV = "PYCHARM_HELPERS_DIRECTORY";
    private static final String PYCHARM_HELPERS_SERVICE_NAME = "pycharm_helpers";
    private static final DockerHelpersImageCreator myHelpersImageCreator = new DockerHelpersImageCreator("pycharm_helpers", "com.jetbrains.pycharm_helpers.version", "/opt/.pycharm_helpers", "PYCHARM_HELPERS_DIRECTORY", "pycharm_helpers"){

        @NotNull
        protected List<File> getHelpersRoots() {
            List list = ContainerUtil.map((Collection)PythonHelpersLocator.getHelpersRoots(), Path::toFile);
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        protected void fillEnv(@NotNull Map<String, String> env) {
            if (env == null) {
                1.$$$reportNull$$$0(1);
            }
            PythonEnvUtil.setPythonUnbuffered(env);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/docker/PyDockerProcessUtil$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelpersRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/docker/PyDockerProcessUtil$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fillEnv";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };

    @NotNull
    public static DockerExecProcess createDockerProcess(@Nullable Project project, @NotNull PyRemotePathMapper pathMapper, @NotNull PyDockerProcessConnectionData data, @NotNull GeneralCommandLine commandLine) throws RemoteSdkException {
        DockerExecProcess dockerExecProcess;
        if (pathMapper == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(2);
        }
        DockerContainerSettings containerSettings = (DockerContainerSettings)commandLine.getUserData(DockerContainerSettings.KEY);
        PathMappingSettings additionalMappings = (PathMappingSettings)commandLine.getUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS);
        if (additionalMappings != null) {
            pathMapper.addAll((Collection)additionalMappings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.REPLICATED_FOLDER);
        }
        PythonEnvUtil.setPythonUnbuffered((Map)commandLine.getEnvironment());
        try {
            boolean openForIncomingConnections = PyDockerProcessUtil.getBoolean((Boolean)commandLine.getUserData(PyRemoteProcessStarter.OPEN_FOR_INCOMING_CONNECTION));
            DockerCloudConfiguration account = data.getAccount();
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)account, (Project)project);
            commandLine.getEnvironment().put("JETBRAINS_REMOTE_RUN", "1");
            PortsBuilder portsBuilder = DockerProcessUtil.getWebServerBindPorts((HostAndPort)((HostAndPort)commandLine.getUserData(PyRemoteProcessStarter.WEB_SERVER_HOST_AND_PORT)));
            String cliOptions = containerSettings != null ? containerSettings.getRunCliOptions() : null;
            PyDockerAgentDeploymentConfigImpl config = new PyDockerAgentDeploymentConfigImpl(data.getImage(), DockerProcessUtil.setupVolumesBinds((PathMappingSettings)additionalMappings, (DockerContainerSettings)containerSettings).build(), cliOptions);
            config.setupRemoteCommandLine(pathMapper, commandLine, data.getInterpreterPath());
            config.setupHelpers(dockerRuntime);
            dockerExecProcess = DockerProcessUtil.prepareAndStartProcess((DockerAgentDeploymentConfigImpl)config, (GeneralCommandLine)commandLine, (RemoteDockerRuntime)dockerRuntime, (DockerContainerSettings)containerSettings, (PortsBuilder)portsBuilder, (boolean)openForIncomingConnections);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)data.getImage());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (dockerExecProcess == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(3);
        }
        return dockerExecProcess;
    }

    private static boolean getBoolean(@Nullable Boolean value2) {
        return value2 != null && value2 != false;
    }

    @NotNull
    public static SharedVolume getPyCharmHelpersSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(4);
        }
        SharedVolume sharedVolume = myHelpersImageCreator.getHelpersContainerSharedVolume(dockerRuntime);
        if (sharedVolume == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(5);
        }
        return sharedVolume;
    }

    public static DockerVolumesFrom @NotNull [] getHelpersContainerVolumesFrom(RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        DockerVolumesFrom[] dockerVolumesFromArray = myHelpersImageCreator.getHelpersContainerVolumesFrom(dockerRuntime);
        if (dockerVolumesFromArray == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(6);
        }
        return dockerVolumesFromArray;
    }

    public static PyRemoteProcessHandler startDockerProcess(@Nullable Project project, @NotNull PyDockerProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        ParamsGroup exeGroup;
        DockerContainerSettings settings;
        PathMappingSettings additionalMappings;
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(7);
        }
        if (commandLine == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(9);
        }
        if ((additionalMappings = (PathMappingSettings)commandLine.getUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS)) != null) {
            pathMapper.addAll((Collection)additionalMappings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.REPLICATED_FOLDER);
        }
        if ((settings = (DockerContainerSettings)commandLine.getUserData(DockerContainerSettings.KEY)) != null) {
            for (DockerVolumeBindingImpl binding : settings.getVolumeBindings()) {
                pathMapper.addMapping(PyDockerProcessUtil.toLocalPath(data, binding.getHostPath()), binding.getContainerPath(), PyRemotePathMapper.PyPathMappingType.REPLICATED_FOLDER);
            }
        }
        if ((exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options")) != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        PyRemoteSocketToLocalHostProvider dockerSocketProvider = data.getPyRemoteSocketToLocalHostProvider();
        PyDockerCommandLinePatcher.patchCommandLineForDocker(commandLine, (RemoteSdkPropertiesPaths)data, dockerSocketProvider, pathMapper);
        PyCommandLineStateUtil.remap((String)data.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)pathMapper);
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
        DockerExecProcess process = PyDockerProcessUtil.createDockerProcess(project, pathMapper, data, commandLine);
        return PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process, (String)PyDockerProcessUtil.getFullInterpreterPath((PyBaseDockerProcessConnectionData)data, process), (GeneralCommandLine)commandLine, (PyRemotePathMapper)pathMapper, (PyRemoteSocketToLocalHostProvider)dockerSocketProvider);
    }

    @Nullable
    private static String toLocalPath(@NotNull PyDockerProcessConnectionData data, @Nullable String hostPath) throws RemoteSdkException {
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(10);
        }
        return DockerUtils.convertDockerMachinePathToLocalPath((DockerCloudConfiguration)((DockerCloudConfiguration)data.getRemoteServer().getConfiguration()), (String)hostPath);
    }

    @NotNull
    public static String getFullInterpreterPath(@NotNull PyBaseDockerProcessConnectionData data, DockerExecProcess process) {
        String id;
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(11);
        }
        id = (id = process.getApplicationRuntime().getContainerId()).length() > 12 ? id.substring(0, 12) : id;
        String string = id + ":" + data.getInterpreterPath();
        if (string == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getFullInterpreterPath(@NotNull PyBaseDockerProcessConnectionData data, @NotNull String serviceName) {
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(13);
        }
        if (serviceName == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(14);
        }
        String string = serviceName + ":" + data.getInterpreterPath();
        if (string == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull PyDockerProcessConnectionData data, @NotNull PyRemotePathMapper pathMapper, @NonNls String[] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        ProcessOutput processOutput;
        if (data == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(16);
        }
        if (pathMapper == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(17);
        }
        if (askForSudo) {
            LOG.warn("Docker process is asked to be run using sudo what is not supported and will be ignored");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        PythonEnvUtil.setPythonUnbuffered(env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            env.put("JETBRAINS_REMOTE_RUN", "1");
            PyDockerAgentDeploymentConfigImpl config = new PyDockerAgentDeploymentConfigImpl(data.getImage(), DockerProcessUtil.setupVolumesBinds(null).build(), null);
            config.withEnvs(env);
            config.withEntrypoint(new String[0]);
            config.setupHelpers(dockerRuntime);
            config.setupRemoteCommandLine(pathMapper, command, workingDir, data.getInterpreterPath());
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            processOutput = applicationRuntime.startAndGetOutput();
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)data.getImage());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (processOutput == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(18);
        }
        return processOutput;
    }

    @NotNull
    public static PyDockerProcessConnectionData getPyDockerProcessConnectionData(@NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(19);
        }
        PyDockerProcessConnectionData pyDockerProcessConnectionData = PyDockerProcessConnectionData.from(sdkAdditionalData, DockerProcessUtil.getDockerCredentialsHolder((RemoteSdkAdditionalData)sdkAdditionalData));
        if (pyDockerProcessConnectionData == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(20);
        }
        return pyDockerProcessConnectionData;
    }

    @NotNull
    public static PyDockerComposeProcessConnectionData getPyDockerComposeProcessConnectionData(@NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(21);
        }
        return new PyDockerComposeProcessConnectionData(sdkAdditionalData, PyDockerProcessUtil.getDockerComposeCredentialsHolder(sdkAdditionalData));
    }

    @NotNull
    private static DockerComposeCredentialsHolder getDockerComposeCredentialsHolder(@NotNull PyRemoteSdkAdditionalDataBase commonCredentials) {
        if (commonCredentials == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(22);
        }
        final Ref result = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                result.set((Object)credentials);
            }
        }});
        if (result.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerComposeCredentialsHolder dockerComposeCredentialsHolder = (DockerComposeCredentialsHolder)result.get();
        if (dockerComposeCredentialsHolder == null) {
            PyDockerProcessUtil.$$$reportNull$$$0(23);
        }
        return dockerComposeCredentialsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 12, 15, 18, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/PyDockerProcessUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/PyDockerProcessUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPyCharmHelpersSharedVolume";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullInterpreterPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPyDockerProcessConnectionData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDockerProcess";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPyCharmHelpersSharedVolume";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startDockerProcess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFullInterpreterPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPyDockerProcessConnectionData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPyDockerComposeProcessConnectionData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCredentialsHolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 12, 15, 18, 20, 23 -> new IllegalStateException(string);
        };
    }
}

