/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.uml.python;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.uml.python.PyDiagramNode;
import com.intellij.python.uml.python.PyDiagramProvider;
import com.intellij.python.uml.python.PyDummyFileClass;
import com.intellij.python.uml.python.PyDummyPackageClass;
import com.intellij.python.uml.python.PyUmlEdge;
import com.intellij.python.uml.python.PyUmlRelationships;
import com.intellij.python.uml.python.PythonDummyClass;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDiagramModel
extends DiagramDataModel<PyClass> {
    private final HashSet<DiagramNode<PyClass>> myNodes = new HashSet();
    private final Collection<DiagramEdge<PyClass>> myEdges = new HashSet<DiagramEdge<PyClass>>();
    private PyClass myObjectClass;
    @Nullable
    private PyFile myCollectionsFile = null;
    @Nullable
    private PyFile myTypingFile = null;
    private final Set<String> myNames = new HashSet<String>();

    public PyDiagramModel(Project project, @Nullable PyClass element) {
        super(project, PyDiagramProvider.getInstance());
        if (element != null) {
            this.myCollectionsFile = PyDiagramModel.findModule(element, "collections");
            this.myTypingFile = PyDiagramModel.findModule(element, "typing");
        }
        this.myNodes.clear();
        this.myEdges.clear();
        this.myNames.clear();
        PyPsiUtils.assertValid((PsiElement)element);
        if (element != null && element.isValid()) {
            if (element instanceof PyDummyFileClass || element instanceof PyDummyPackageClass) {
                for (PyClass cl : element.getNestedClasses()) {
                    this.init(cl);
                }
            } else {
                this.init(element);
            }
        }
    }

    @Nullable
    private static PyFile findModule(@NotNull PyClass element, @NotNull String name) {
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PyDiagramModel.$$$reportNull$$$0(1);
        }
        return StreamEx.of((Collection)ResolveImportUtil.resolveModule((QualifiedName)QualifiedName.fromDottedString((String)name), (PsiFile)element.getContainingFile(), (boolean)false, (int)0)).map(e -> PyUtil.turnDirIntoInit((PsiElement)e)).select(PyFile.class).findFirst().orElse(null);
    }

    @Nullable
    private static PyClass getMetaClass(@NotNull PyClass cls) {
        PyClassLikeType type;
        if (cls == null) {
            PyDiagramModel.$$$reportNull$$$0(2);
        }
        if ((type = cls.getMetaClassType(false, TypeEvalContext.userInitiated((Project)cls.getProject(), null))) instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    private void init(@NotNull PyClass element) {
        PyExpression[] classExpressions;
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        PyFile file = (PyFile)element.getContainingFile();
        this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(element));
        this.myNames.add(element.getName());
        this.addInterfaces(element);
        PyClass metaClass = PyDiagramModel.getMetaClass(element);
        if (metaClass != null) {
            this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(metaClass));
            this.myNames.add(metaClass.getName());
        }
        List superClasses = element.getAncestorClasses(null);
        for (PyClass aClass : superClasses) {
            this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(aClass));
            this.myNames.add(aClass.getName());
            this.addInterfaces(aClass);
            metaClass = PyDiagramModel.getMetaClass(aClass);
            if (metaClass != null) {
                this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(metaClass));
                this.myNames.add(metaClass.getName());
            }
            if (!LanguageLevel.forElement((PsiElement)element).isPy3K() || !"object".equals(aClass.getName())) continue;
            this.myObjectClass = aClass;
        }
        for (PyExpression e : classExpressions = element.getSuperClassExpressions()) {
            String name;
            if (e instanceof PyKeywordArgument || this.myNames.contains(name = e.getName()) || name == null) continue;
            this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(new PythonDummyClass(e, project, file)));
            this.myNames.add(name);
        }
    }

    private void addInterfaces(@NotNull PyClass element) {
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(4);
        }
        for (String name : PyNames.BUILTIN_INTERFACES) {
            PyClass aClass;
            if (!PyABCUtil.isSubclass((PyClass)element, (String)name, (boolean)false, null) || name.equals(element.getName()) || (aClass = this.findClass(name)) == null) continue;
            this.myNodes.add((DiagramNode<PyClass>)new PyDiagramNode(aClass));
        }
    }

    @Nullable
    private PyClass findClass(@NotNull String name) {
        if (name == null) {
            PyDiagramModel.$$$reportNull$$$0(5);
        }
        PsiElement aClass = null;
        if (this.myTypingFile != null) {
            aClass = ResolveImportUtil.resolveChild((PsiElement)this.myTypingFile, (String)name, (PsiFile)this.myTypingFile, (boolean)false, (boolean)false, (boolean)false);
        }
        if (aClass == null && this.myCollectionsFile != null) {
            aClass = ResolveImportUtil.resolveChild((PsiElement)this.myCollectionsFile, (String)name, (PsiFile)this.myCollectionsFile, (boolean)false, (boolean)false, (boolean)false);
        }
        if (aClass instanceof PyClass) {
            PyClass pyClass = (PyClass)aClass;
            return pyClass;
        }
        return null;
    }

    @NotNull
    public Collection<DiagramNode<PyClass>> getNodes() {
        HashSet<DiagramNode<PyClass>> hashSet = this.myNodes;
        if (hashSet == null) {
            PyDiagramModel.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public Collection<DiagramEdge<PyClass>> getEdges() {
        Collection<DiagramEdge<PyClass>> collection = this.myEdges;
        if (collection == null) {
            PyDiagramModel.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<PyClass> node) {
        String name;
        if (node == null) {
            PyDiagramModel.$$$reportNull$$$0(8);
        }
        String string = (name = ((PyClass)node.getIdentifyingElement()).getName()) == null ? "" : name;
        if (string == null) {
            PyDiagramModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    public DiagramNode<PyClass> addElement(@Nullable PyClass element) {
        if (element == null || this.isAlreadyDrawn(element)) {
            return null;
        }
        PyDiagramNode node = new PyDiagramNode(element);
        this.myNodes.add((DiagramNode<PyClass>)node);
        return node;
    }

    private boolean isAlreadyDrawn(PyClass element) {
        if (element != null) {
            String elementFQN = element.getQualifiedName();
            for (DiagramNode<PyClass> node : this.myNodes) {
                PyClass container = (PyClass)node.getIdentifyingElement();
                String nodeFQN = container.getName();
                if (elementFQN == null || nodeFQN == null || !elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeNode(@NotNull DiagramNode<PyClass> node) {
        if (node == null) {
            PyDiagramModel.$$$reportNull$$$0(10);
        }
        this.removeElement((PyClass)node.getIdentifyingElement());
    }

    private void removeElement(PyClass element) {
        DiagramNode node = this.findNode(element);
        if (node != null) {
            ArrayList<DiagramEdge<PyClass>> edges = new ArrayList<DiagramEdge<PyClass>>();
            for (DiagramEdge<PyClass> edge : this.myEdges) {
                if (!edge.getTarget().equals((Object)node) && !edge.getSource().equals((Object)node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
            this.myNodes.remove(node);
        }
    }

    @Nullable
    private DiagramNode findNode(PyClass element) {
        if (element == null) {
            return null;
        }
        String elementFQN = element.getQualifiedName();
        for (DiagramNode<PyClass> node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private DiagramNode findNode(@Nullable String elementFQN) {
        for (DiagramNode<PyClass> node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    public void refreshDataModel() {
        for (DiagramNode<PyClass> node : this.myNodes) {
            PyClass aClass;
            if (this.addSuperclassEdges(node, aClass = (PyClass)node.getIdentifyingElement())) continue;
            this.addMetaclassEdges(node, aClass);
            this.addInterfaceEdges(node, aClass);
        }
    }

    private void addInterfaceEdges(DiagramNode<PyClass> node, PyClass aClass) {
        for (String name : PyNames.BUILTIN_INTERFACES) {
            DiagramNode interfaceNode;
            PyClass foundClass;
            if (!PyABCUtil.isSubclass((PyClass)aClass, (String)name, (boolean)false, null) || name.equals(aClass.getName()) || (foundClass = this.findClass(name)) == null || aClass.isSubclass(foundClass, null) || (interfaceNode = this.findNode(foundClass)) == null || !this.myNodes.contains(interfaceNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)interfaceNode, PyUmlRelationships.INTERFACE);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
        }
    }

    private void addMetaclassEdges(DiagramNode<PyClass> node, PyClass aClass) {
        PyClass metaClass = PyDiagramModel.getMetaClass(aClass);
        if (metaClass == null) {
            return;
        }
        DiagramNode metaclassNode = this.findNode(metaClass);
        if (metaclassNode != null && this.myNodes.contains(metaclassNode)) {
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)metaclassNode, PyUmlRelationships.INSTANCEOF);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
        }
    }

    private boolean addSuperclassEdges(DiagramNode<PyClass> node, PyClass aClass) {
        String className = aClass.getName();
        if (className != null && PyNames.BUILTIN_INTERFACES.contains(className)) {
            return true;
        }
        PyClass[] superClasses = aClass.getSuperClasses(null);
        HashSet<String> processed = new HashSet<String>();
        for (PyClass pyClass : superClasses) {
            DiagramNode superclassNode = this.findNode(pyClass);
            if (superclassNode == null || !this.myNodes.contains(superclassNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)superclassNode, PyUmlRelationships.SUBCLASS);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
            processed.add(pyClass.getName());
        }
        for (PyClass pyClass : aClass.getSuperClassExpressions()) {
            String name = pyClass.getName();
            DiagramNode superclassNode = this.findNode(name);
            if (superclassNode == null || processed.contains(name) || !this.myNodes.contains(superclassNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)superclassNode, PyUmlRelationships.SUBCLASS);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
            processed.add(name);
        }
        if (superClasses.length == 0 && this.myObjectClass != null && !"object".equals(className)) {
            DiagramNode classNode = this.findNode(aClass);
            DiagramNode objectNode = this.findNode(this.myObjectClass);
            if (classNode != null && objectNode != null) {
                PyUmlEdge edge = new PyUmlEdge((DiagramNode<PyClass>)classNode, (DiagramNode<PyClass>)objectNode, PyUmlRelationships.SUBCLASS);
                this.myEdges.add((DiagramEdge<PyClass>)edge);
            }
        }
        return false;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        Object object = Registry.is((String)"diagrams.uml.python.use.psi.modification.tracker") ? PsiManager.getInstance((Project)this.getProject()).getModificationTracker() : ModificationTracker.NEVER_CHANGED;
        if (object == null) {
            PyDiagramModel.$$$reportNull$$$0(11);
        }
        return object;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/uml/python/PyDiagramModel";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/uml/python/PyDiagramModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

