/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.ChannelNumberAttribute;
import org.ice4j.attribute.EvenPortAttribute;
import org.ice4j.attribute.LifetimeAttribute;
import org.ice4j.attribute.RequestedTransportAttribute;
import org.ice4j.attribute.XorPeerAddressAttribute;
import org.ice4j.attribute.XorRelayedAddressAttribute;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.ComponentSocket;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RelayedCandidate;
import org.ice4j.ice.harvest.StunCandidateHarvest;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.RelayedCandidateDatagramSocket;
import org.ice4j.stack.TransactionID;

public class TurnCandidateHarvest
extends StunCandidateHarvest {
    private static final Logger logger = Logger.getLogger(TurnCandidateHarvest.class.getName());
    private Request requestToStartResolvingCandidate;

    public TurnCandidateHarvest(TurnCandidateHarvester harvester, HostCandidate hostCandidate) {
        super(harvester, hostCandidate);
    }

    public void close(RelayedCandidateDatagramSocket relayedCandidateSocket) {
        this.setSendKeepAliveMessageInterval(0L);
        try {
            this.sendRequest(MessageFactory.createRefreshRequest(0), false, null);
        }
        catch (StunException sex) {
            logger.log(Level.INFO, "Failed to send TURN Refresh request to delete Allocation", sex);
        }
    }

    @Override
    protected boolean completedResolvingCandidate(Request request, Response response) {
        if (response == null || !response.isSuccessResponse() && request.getMessageType() == '\u0003') {
            try {
                if (this.startResolvingCandidate()) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.completedResolvingCandidate(request, response);
    }

    @Override
    protected void createCandidates(Response response) {
        this.createRelayedCandidate(response);
        super.createCandidates(response);
    }

    @Override
    protected Message createKeepAliveMessage(LocalCandidate candidate) throws StunException {
        switch (candidate.getType()) {
            case RELAYED_CANDIDATE: {
                return MessageFactory.createRefreshRequest();
            }
            case SERVER_REFLEXIVE_CANDIDATE: {
                boolean existsRelayedCandidate = false;
                for (LocalCandidate aCandidate : this.getCandidates()) {
                    if (!CandidateType.RELAYED_CANDIDATE.equals((Object)aCandidate.getType())) continue;
                    existsRelayedCandidate = true;
                    break;
                }
                return existsRelayedCandidate ? null : super.createKeepAliveMessage(candidate);
            }
        }
        return super.createKeepAliveMessage(candidate);
    }

    private void createRelayedCandidate(Response response) {
        TransportAddress relayedAddress;
        RelayedCandidate relayedCandidate;
        Attribute attribute = response.getAttribute('\u0016');
        if (attribute instanceof XorRelayedAddressAttribute && (relayedCandidate = this.createRelayedCandidate(relayedAddress = ((XorRelayedAddressAttribute)attribute).getAddress(response.getTransactionID()), this.getMappedAddress(response))) != null) {
            this.harvester.getStunStack().addSocket(relayedCandidate.getStunSocket(null));
            ComponentSocket componentSocket = relayedCandidate.getParentComponent().getComponentSocket();
            if (componentSocket != null) {
                componentSocket.add(relayedCandidate.getCandidateIceSocketWrapper());
            }
            this.addCandidate(relayedCandidate);
        }
    }

    protected RelayedCandidate createRelayedCandidate(TransportAddress transportAddress, TransportAddress mappedAddress) {
        return new RelayedCandidate(transportAddress, this, mappedAddress);
    }

    @Override
    protected Request createRequestToRetry(Request request) {
        switch (request.getMessageType()) {
            case '\u0003': {
                RequestedTransportAttribute requestedTransportAttribute = (RequestedTransportAttribute)request.getAttribute('\u0019');
                int requestedTransport = requestedTransportAttribute == null ? 17 : requestedTransportAttribute.getRequestedTransport();
                EvenPortAttribute evenPortAttribute = (EvenPortAttribute)request.getAttribute('\u0018');
                boolean rFlag = evenPortAttribute != null && evenPortAttribute.isRFlag();
                return MessageFactory.createAllocateRequest((byte)requestedTransport, rFlag);
            }
            case '\t': {
                ChannelNumberAttribute channelNumberAttribute = (ChannelNumberAttribute)request.getAttribute('\f');
                char channelNumber = channelNumberAttribute.getChannelNumber();
                XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request.getAttribute('\u0012');
                TransportAddress peerAddress = peerAddressAttribute.getAddress(request.getTransactionID());
                byte[] retryTransactionID = TransactionID.createNewTransactionID().getBytes();
                Request retryChannelBindRequest = MessageFactory.createChannelBindRequest(channelNumber, peerAddress, retryTransactionID);
                try {
                    retryChannelBindRequest.setTransactionID(retryTransactionID);
                }
                catch (StunException sex) {
                    throw new UndeclaredThrowableException(sex);
                }
                return retryChannelBindRequest;
            }
            case '\b': {
                XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request.getAttribute('\u0012');
                TransportAddress peerAddress = peerAddressAttribute.getAddress(request.getTransactionID());
                byte[] retryTransactionID = TransactionID.createNewTransactionID().getBytes();
                Request retryCreatePermissionRequest = MessageFactory.createCreatePermissionRequest(peerAddress, retryTransactionID);
                try {
                    retryCreatePermissionRequest.setTransactionID(retryTransactionID);
                }
                catch (StunException sex) {
                    throw new UndeclaredThrowableException(sex);
                }
                return retryCreatePermissionRequest;
            }
            case '\u0004': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)request.getAttribute('\r');
                if (lifetimeAttribute == null) {
                    return MessageFactory.createRefreshRequest();
                }
                return MessageFactory.createRefreshRequest(lifetimeAttribute.getLifetime());
            }
        }
        return super.createRequestToRetry(request);
    }

    @Override
    protected Request createRequestToStartResolvingCandidate() {
        if (this.requestToStartResolvingCandidate == null) {
            this.requestToStartResolvingCandidate = MessageFactory.createAllocateRequest((byte)17, false);
            return this.requestToStartResolvingCandidate;
        }
        if (this.requestToStartResolvingCandidate.getMessageType() == '\u0003') {
            this.requestToStartResolvingCandidate = super.createRequestToStartResolvingCandidate();
            return this.requestToStartResolvingCandidate;
        }
        return null;
    }

    @Override
    protected boolean processErrorOrFailure(Response response, Request request, TransactionID transactionID) {
        Object applicationData = transactionID.getApplicationData();
        if (applicationData instanceof RelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response, request)) {
            return true;
        }
        return super.processErrorOrFailure(response, request, transactionID);
    }

    @Override
    protected void processSuccess(Response response, Request request, TransactionID transactionID) {
        Object applicationData;
        super.processSuccess(response, request, transactionID);
        int lifetime = -1;
        switch (response.getMessageType()) {
            case '\u0103': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response.getAttribute('\r');
                lifetime = lifetimeAttribute == null ? 600 : lifetimeAttribute.getLifetime();
                break;
            }
            case '\u0104': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response.getAttribute('\r');
                if (lifetimeAttribute == null) break;
                lifetime = lifetimeAttribute.getLifetime();
            }
        }
        if (lifetime >= 0) {
            this.setSendKeepAliveMessageInterval(1000L * (long)lifetime);
        }
        if ((applicationData = transactionID.getApplicationData()) instanceof RelayedCandidateDatagramSocket) {
            ((RelayedCandidateDatagramSocket)applicationData).processSuccess(response, request);
        }
    }

    public byte[] sendRequest(RelayedCandidateDatagramSocket relayedCandidateDatagramSocket, Request request) throws StunException {
        TransactionID transactionID = TransactionID.createNewTransactionID();
        transactionID.setApplicationData(relayedCandidateDatagramSocket);
        transactionID = this.sendRequest(request, false, transactionID);
        return transactionID == null ? null : transactionID.getBytes();
    }
}

