/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class InplaceBoxBlurFilter {
    private InplaceBoxBlurFilter() {
    }

    public static void horizontalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int width2 = src.getWidth();
        int height = src.getHeight();
        if (width2 < 2 * skipX + boxSize) {
            return;
        }
        if (height < 2 * skipY) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale2 = 0x1000000 / boxSize;
        for (int y2 = skipY; y2 < height - skipY; ++y2) {
            int curr;
            int sp = srcOff + y2 * srcScanStride;
            int dp = dstOff + y2 * dstScanStride;
            int rowEnd = sp + (width2 - skipX);
            int k = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp += skipX) + boxSize;
            while (sp < end) {
                curr = buffer[k] = srcPixels[sp];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k;
                ++sp;
            }
            int prev = dstPixels[dp += skipX + loc] = sumA * scale2 & 0xFF000000 | (sumR * scale2 & 0xFF000000) >>> 8 | (sumG * scale2 & 0xFF000000) >>> 16 | (sumB * scale2 & 0xFF000000) >>> 24;
            ++dp;
            k = 0;
            while (sp < rowEnd) {
                curr = buffer[k];
                if (curr == srcPixels[sp]) {
                    dstPixels[dp] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k] = srcPixels[sp];
                    prev = dstPixels[dp] = (sumA += curr >>> 24) * scale2 & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale2 & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale2 & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale2 & 0xFF000000) >>> 24;
                }
                k = (k + 1) % boxSize;
                ++sp;
                ++dp;
            }
        }
    }

    public static void verticalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int w = src.getWidth();
        int h = src.getHeight();
        if (w < 2 * skipX) {
            return;
        }
        if (h < 2 * skipY + boxSize) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale2 = 0x1000000 / boxSize;
        for (int x2 = skipX; x2 < w - skipX; ++x2) {
            int curr;
            int sp = srcOff + x2;
            int dp = dstOff + x2;
            int colEnd = sp + (h - skipY) * srcScanStride;
            int k = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp += skipY * srcScanStride) + boxSize * srcScanStride;
            while (sp < end) {
                curr = buffer[k] = srcPixels[sp];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k;
                sp += srcScanStride;
            }
            int prev = dstPixels[dp += (skipY + loc) * dstScanStride] = sumA * scale2 & 0xFF000000 | (sumR * scale2 & 0xFF000000) >>> 8 | (sumG * scale2 & 0xFF000000) >>> 16 | (sumB * scale2 & 0xFF000000) >>> 24;
            dp += dstScanStride;
            k = 0;
            while (sp < colEnd) {
                curr = buffer[k];
                if (curr == srcPixels[sp]) {
                    dstPixels[dp] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k] = srcPixels[sp];
                    prev = dstPixels[dp] = (sumA += curr >>> 24) * scale2 & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale2 & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale2 & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale2 & 0xFF000000) >>> 24;
                }
                k = (k + 1) % boxSize;
                sp += srcScanStride;
                dp += dstScanStride;
            }
        }
    }
}

