/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache;", "", "<init>", "()V", "JUPYTER_NOTEBOOK_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "JUPYTER_PERSISTENT_COUNT", "Ljava/util/concurrent/atomic/AtomicInteger;", "JUPYTER_DISPOSABLE", "Lcom/intellij/openapi/Disposable;", "getForFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadNotebook", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "customNotebook", "getDisposable", "registryForDisposable", "disposable", "get", "updateLineSeparatorsIfRequired", "file", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileModelCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n23#2:117\n11#3:118\n12#3:120\n11#3:121\n12#3:123\n1#4:119\n1#4:122\n*S KotlinDebug\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n*L\n63#1:117\n68#1:118\n68#1:120\n69#1:121\n69#1:123\n68#1:119\n69#1:122\n*E\n"})
public final class JupyterFileModelCache {
    @NotNull
    public static final JupyterFileModelCache INSTANCE = new JupyterFileModelCache();
    @NotNull
    private static final Key<JupyterNotebook> JUPYTER_NOTEBOOK_KEY = new Key("JUPYTER_NOTEBOOK_KEY");
    @NotNull
    private static final Key<AtomicInteger> JUPYTER_PERSISTENT_COUNT = new Key("JUPYTER_NOTEBOOK_USE_COUNT");
    @NotNull
    private static final Key<Disposable> JUPYTER_DISPOSABLE = new Key("JUPYTER_DISPOSABLE");

    private JupyterFileModelCache() {
    }

    @Nullable
    public final JupyterNotebook getForFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.get(virtualFile);
    }

    public final void loadNotebook(@NotNull BackedNotebookVirtualFile virtualFile, @Nullable JupyterNotebook customNotebook) {
        JupyterNotebook newNotebook;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        JupyterNotebook exists = (JupyterNotebook)virtualFile.getFile().getUserData(JUPYTER_NOTEBOOK_KEY);
        JupyterNotebook jupyterNotebook = customNotebook;
        if (jupyterNotebook == null) {
            jupyterNotebook = newNotebook = (JupyterNotebook)JupyterFileUtils.INSTANCE.readNotebook(virtualFile.getFile());
        }
        if (exists != null && !PlatformUtils.isJetBrainsClient()) {
            exists.getJson().removeAll();
            exists.getJson().setAll(newNotebook.getJson());
        } else {
            virtualFile.getFile().putUserData(JUPYTER_NOTEBOOK_KEY, (Object)newNotebook);
        }
    }

    public static /* synthetic */ void loadNotebook$default(JupyterFileModelCache jupyterFileModelCache, BackedNotebookVirtualFile backedNotebookVirtualFile, JupyterNotebook jupyterNotebook, int n, Object object) {
        if ((n & 2) != 0) {
            jupyterNotebook = null;
        }
        jupyterFileModelCache.loadNotebook(backedNotebookVirtualFile, jupyterNotebook);
    }

    @Nullable
    public final Disposable getDisposable(@NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (virtualFile.getNotebookOrNull() == null) {
            return null;
        }
        return (Disposable)virtualFile.getFile().getUserData(JUPYTER_DISPOSABLE);
    }

    /*
     * WARNING - void declaration
     */
    public final void registryForDisposable(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull Disposable disposable) {
        Object object;
        void $this$getOrCreateUserData$iv;
        Object object2;
        void var12_16;
        Key<AtomicInteger> key;
        Object object3;
        void $this$getOrCreateUserData$iv2;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (virtualFile.getNotebookOrNull() == null) {
            JupyterFileModelCache $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileModelCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Notebook is not loaded for " + virtualFile.getFile().getPath());
            return;
        }
        VirtualFile file = virtualFile.getFile();
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)file;
        Key<AtomicInteger> key$iv = JUPYTER_DISPOSABLE;
        boolean $i$f$getOrCreateUserData = false;
        Object object4 = $this$getOrCreateUserData$iv2.getUserData(key$iv);
        if (object4 != null) {
            Object it$iv = object4;
            boolean bl = false;
            object3 = it$iv;
        } else {
            key = key$iv;
            var12_16 = $this$getOrCreateUserData$iv2;
            boolean bl = false;
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
            object2 = disposable2;
            Object object5 = var12_16.putUserDataIfAbsent((Key)key, object2);
            object3 = object5;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"putUserDataIfAbsent(...)");
        }
        Disposable fileDisposable = (Disposable)object3;
        key$iv = (Key<AtomicInteger>)file;
        Key<AtomicInteger> key$iv2 = JUPYTER_PERSISTENT_COUNT;
        boolean $i$f$getOrCreateUserData2 = false;
        Object object6 = $this$getOrCreateUserData$iv.getUserData(key$iv2);
        if (object6 != null) {
            Object it$iv = object6;
            boolean bl = false;
            object = it$iv;
        } else {
            key = key$iv2;
            var12_16 = $this$getOrCreateUserData$iv;
            boolean bl = false;
            object2 = new AtomicInteger(0);
            Object object7 = var12_16.putUserDataIfAbsent(key, object2);
            object = object7;
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"putUserDataIfAbsent(...)");
        }
        AtomicInteger counter = (AtomicInteger)object;
        Disposer.register((Disposable)disposable, () -> JupyterFileModelCache.registryForDisposable$lambda$2(counter, file, virtualFile, fileDisposable));
        counter.incrementAndGet();
    }

    @Nullable
    public final JupyterNotebook get(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return (JupyterNotebook)virtualFile.getUserData(JUPYTER_NOTEBOOK_KEY);
    }

    private final void updateLineSeparatorsIfRequired(BackedNotebookVirtualFile virtualFile, VirtualFile file) {
        String checked;
        String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile.getFile(), (boolean)false);
        if (separator == null && (checked = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile.getFile(), (boolean)true)) == null) {
            file.setDetectedLineSeparator("\n");
        }
    }

    private static final void registryForDisposable$lambda$2(AtomicInteger $counter, VirtualFile $file, BackedNotebookVirtualFile $virtualFile, Disposable $fileDisposable) {
        int count = $counter.decrementAndGet();
        if (count == 0) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            Document cachedDocument = fileDocumentManager2.getCachedDocument($file);
            if (cachedDocument != null && fileDocumentManager2.isDocumentUnsaved(cachedDocument)) {
                INSTANCE.updateLineSeparatorsIfRequired($virtualFile, $file);
                ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.nonModal(), () -> JupyterFileModelCache.registryForDisposable$lambda$2$0(fileDocumentManager2, cachedDocument));
            }
            Disposer.dispose((Disposable)$fileDisposable);
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$file), JUPYTER_DISPOSABLE);
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$file), JUPYTER_NOTEBOOK_KEY);
        }
    }

    private static final Unit registryForDisposable$lambda$2$0(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        ActionsKt.runWriteAction(() -> JupyterFileModelCache.registryForDisposable$lambda$2$0$0($fileDocumentManager, $cachedDocument));
        return Unit.INSTANCE;
    }

    private static final Unit registryForDisposable$lambda$2$0$0(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        $fileDocumentManager.saveDocument($cachedDocument);
        return Unit.INSTANCE;
    }
}

