/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.kernel;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelTaskExecutor;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.executor.task.JupyterTaskPurpose;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskPriority;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.kernel.executor.JupyterTaskBaseCallback;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001)B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0094@\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask;", "Lcom/intellij/jupyter/core/executor/task/JupyterExecutionTask;", "source", "", "options", "Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options;", "callbacks", "", "Lcom/intellij/jupyter/core/kernel/executor/JupyterTaskBaseCallback;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options;Ljava/util/List;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/openapi/project/Project;)V", "getSource", "()Ljava/lang/String;", "getOptions", "()Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options;", "getCallbacks", "()Ljava/util/List;", "doExecuteTask", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeKernelTask", "overrideSession", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cellIndex", "", "getCellIndex", "()Ljava/lang/Integer;", "jupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getJupyterCell", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "isValid", "", "toString", "Options", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterKernelTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKernelTask.kt\ncom/intellij/jupyter/core/executor/kernel/JupyterKernelTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public class JupyterKernelTask
extends JupyterExecutionTask {
    @NotNull
    private final String source;
    @NotNull
    private final Options options;
    @NotNull
    private final List<JupyterTaskBaseCallback> callbacks;

    public JupyterKernelTask(@NotNull String source, @NotNull Options options, @NotNull List<? extends JupyterTaskBaseCallback> callbacks, @NotNull BackedNotebookVirtualFile notebookVirtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(notebookVirtualFile2, project, options.getPriority());
        this.source = source;
        this.options = options;
        this.callbacks = callbacks;
    }

    public /* synthetic */ JupyterKernelTask(String string, Options options, List list, BackedNotebookVirtualFile backedNotebookVirtualFile, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, options, list, backedNotebookVirtualFile, project);
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    @NotNull
    public List<JupyterTaskBaseCallback> getCallbacks() {
        return this.callbacks;
    }

    @Override
    @Nullable
    public Object doExecuteTask(@NotNull CoroutineScope scope, @NotNull Continuation<? super JupyterTaskExecutorResult> $completion) {
        return JupyterKernelTask.executeKernelTask$default(this, scope, null, $completion, 2, null);
    }

    @Nullable
    protected Object executeKernelTask(@NotNull CoroutineScope scope, @Nullable JupyterNotebookSession overrideSession, @NotNull Continuation<? super JupyterTaskExecutorResult> $completion) {
        return JupyterKernelTaskExecutor.INSTANCE.execute(scope, this, overrideSession, $completion);
    }

    public static /* synthetic */ Object executeKernelTask$default(JupyterKernelTask jupyterKernelTask, CoroutineScope coroutineScope, JupyterNotebookSession jupyterNotebookSession, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeKernelTask");
        }
        if ((n & 2) != 0) {
            jupyterNotebookSession = null;
        }
        return jupyterKernelTask.executeKernelTask(coroutineScope, jupyterNotebookSession, (Continuation<? super JupyterTaskExecutorResult>)continuation);
    }

    @Nullable
    public final Integer getCellIndex() {
        NotebookIntervalPointer notebookIntervalPointer = this.options.getCellPointer();
        return notebookIntervalPointer != null && (notebookIntervalPointer = notebookIntervalPointer.get()) != null ? Integer.valueOf(notebookIntervalPointer.getOrdinal()) : null;
    }

    @Nullable
    public final JupyterCell getJupyterCell() {
        JupyterCell jupyterCell;
        Integer n = this.getCellIndex();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            jupyterCell = this.getNotebookVirtualFile().getNotebook().getCell(it);
        } else {
            jupyterCell = null;
        }
        return jupyterCell;
    }

    public final boolean isValid() {
        return this.getProject() != null;
    }

    @NotNull
    public String toString() {
        return "JupyterKernelTask(source='" + StringsKt.replace$default((String)StringsKt.take((String)this.source, (int)300), (char)'\n', (char)' ', (boolean)false, (int)4, null) + ", priority=" + this.getPriority() + "',cellIndex=" + this.getCellIndex() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\u0017\u0010*\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0002\b\u00030\u000eH\u00c6\u0003Ji\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0002\b\u00030\u000eH\u00c6\u0001J\u0013\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u001f\u0010\r\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options;", "", "purpose", "Lcom/intellij/jupyter/core/executor/task/JupyterTaskPurpose;", "priority", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskPriority;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "shouldNotifyWhenSubmitted", "", "ignoreOutput", "cleanOutput", "silent", "data", "", "Lcom/intellij/openapi/util/Key;", "<init>", "(Lcom/intellij/jupyter/core/executor/task/JupyterTaskPurpose;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskPriority;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;ZZZZLjava/util/Map;)V", "getPurpose", "()Lcom/intellij/jupyter/core/executor/task/JupyterTaskPurpose;", "getPriority", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskPriority;", "getCellPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getShouldNotifyWhenSubmitted", "()Z", "getIgnoreOutput", "getCleanOutput", "getSilent", "getData", "()Ljava/util/Map;", "get", "T", "key", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.jupyter.core"})
    public static final class Options {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JupyterTaskPurpose purpose;
        @NotNull
        private final JupyterTaskPriority priority;
        @Nullable
        private final NotebookIntervalPointer cellPointer;
        private final boolean shouldNotifyWhenSubmitted;
        private final boolean ignoreOutput;
        private final boolean cleanOutput;
        private final boolean silent;
        @NotNull
        private final Map<Key<?>, ?> data;

        public Options(@NotNull JupyterTaskPurpose purpose, @NotNull JupyterTaskPriority priority, @Nullable NotebookIntervalPointer cellPointer, boolean shouldNotifyWhenSubmitted, boolean ignoreOutput, boolean cleanOutput, boolean silent, @NotNull Map<Key<?>, ?> data) {
            Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.purpose = purpose;
            this.priority = priority;
            this.cellPointer = cellPointer;
            this.shouldNotifyWhenSubmitted = shouldNotifyWhenSubmitted;
            this.ignoreOutput = ignoreOutput;
            this.cleanOutput = cleanOutput;
            this.silent = silent;
            this.data = data;
            boolean requiresCell = this.shouldNotifyWhenSubmitted || !this.ignoreOutput || this.cleanOutput || !this.silent;
            if (!(this.cellPointer != null || !requiresCell)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Options(JupyterTaskPurpose jupyterTaskPurpose, JupyterTaskPriority jupyterTaskPriority, NotebookIntervalPointer notebookIntervalPointer, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                map = MapsKt.emptyMap();
            }
            this(jupyterTaskPurpose, jupyterTaskPriority, notebookIntervalPointer, bl, bl2, bl3, bl4, map);
        }

        @NotNull
        public final JupyterTaskPurpose getPurpose() {
            return this.purpose;
        }

        @NotNull
        public final JupyterTaskPriority getPriority() {
            return this.priority;
        }

        @Nullable
        public final NotebookIntervalPointer getCellPointer() {
            return this.cellPointer;
        }

        public final boolean getShouldNotifyWhenSubmitted() {
            return this.shouldNotifyWhenSubmitted;
        }

        public final boolean getIgnoreOutput() {
            return this.ignoreOutput;
        }

        public final boolean getCleanOutput() {
            return this.cleanOutput;
        }

        public final boolean getSilent() {
            return this.silent;
        }

        @NotNull
        public final Map<Key<?>, ?> getData() {
            return this.data;
        }

        @Nullable
        public final <T> T get(@NotNull Key<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return (T)this.data.get(key);
        }

        @NotNull
        public final JupyterTaskPurpose component1() {
            return this.purpose;
        }

        @NotNull
        public final JupyterTaskPriority component2() {
            return this.priority;
        }

        @Nullable
        public final NotebookIntervalPointer component3() {
            return this.cellPointer;
        }

        public final boolean component4() {
            return this.shouldNotifyWhenSubmitted;
        }

        public final boolean component5() {
            return this.ignoreOutput;
        }

        public final boolean component6() {
            return this.cleanOutput;
        }

        public final boolean component7() {
            return this.silent;
        }

        @NotNull
        public final Map<Key<?>, ?> component8() {
            return this.data;
        }

        @NotNull
        public final Options copy(@NotNull JupyterTaskPurpose purpose, @NotNull JupyterTaskPriority priority, @Nullable NotebookIntervalPointer cellPointer, boolean shouldNotifyWhenSubmitted, boolean ignoreOutput, boolean cleanOutput, boolean silent, @NotNull Map<Key<?>, ?> data) {
            Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new Options(purpose, priority, cellPointer, shouldNotifyWhenSubmitted, ignoreOutput, cleanOutput, silent, data);
        }

        public static /* synthetic */ Options copy$default(Options options, JupyterTaskPurpose jupyterTaskPurpose, JupyterTaskPriority jupyterTaskPriority, NotebookIntervalPointer notebookIntervalPointer, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                jupyterTaskPurpose = options.purpose;
            }
            if ((n & 2) != 0) {
                jupyterTaskPriority = options.priority;
            }
            if ((n & 4) != 0) {
                notebookIntervalPointer = options.cellPointer;
            }
            if ((n & 8) != 0) {
                bl = options.shouldNotifyWhenSubmitted;
            }
            if ((n & 0x10) != 0) {
                bl2 = options.ignoreOutput;
            }
            if ((n & 0x20) != 0) {
                bl3 = options.cleanOutput;
            }
            if ((n & 0x40) != 0) {
                bl4 = options.silent;
            }
            if ((n & 0x80) != 0) {
                map = options.data;
            }
            return options.copy(jupyterTaskPurpose, jupyterTaskPriority, notebookIntervalPointer, bl, bl2, bl3, bl4, map);
        }

        @NotNull
        public String toString() {
            return "Options(purpose=" + this.purpose + ", priority=" + this.priority + ", cellPointer=" + this.cellPointer + ", shouldNotifyWhenSubmitted=" + this.shouldNotifyWhenSubmitted + ", ignoreOutput=" + this.ignoreOutput + ", cleanOutput=" + this.cleanOutput + ", silent=" + this.silent + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = this.purpose.hashCode();
            result2 = result2 * 31 + this.priority.hashCode();
            result2 = result2 * 31 + (this.cellPointer == null ? 0 : this.cellPointer.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.shouldNotifyWhenSubmitted);
            result2 = result2 * 31 + Boolean.hashCode(this.ignoreOutput);
            result2 = result2 * 31 + Boolean.hashCode(this.cleanOutput);
            result2 = result2 * 31 + Boolean.hashCode(this.silent);
            result2 = result2 * 31 + ((Object)this.data).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (this.purpose != options.purpose) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priority, (Object)options.priority)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cellPointer, (Object)options.cellPointer)) {
                return false;
            }
            if (this.shouldNotifyWhenSubmitted != options.shouldNotifyWhenSubmitted) {
                return false;
            }
            if (this.ignoreOutput != options.ignoreOutput) {
                return false;
            }
            if (this.cleanOutput != options.cleanOutput) {
                return false;
            }
            if (this.silent != options.silent) {
                return false;
            }
            return Intrinsics.areEqual(this.data, options.data);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options$Companion;", "", "<init>", "()V", "cellExecution", "Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask$Options;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "silentExecution", "priority", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskPriority;", "intellij.jupyter.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Options cellExecution(@NotNull NotebookIntervalPointer cellPointer) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                JupyterTaskPurpose jupyterTaskPurpose = JupyterTaskPurpose.CELL_EXECUTION;
                JupyterTaskPriority jupyterTaskPriority = JupyterTaskPriority.Companion.getNORMAL();
                return new Options(jupyterTaskPurpose, jupyterTaskPriority, cellPointer, true, false, true, false, null, 128, null);
            }

            @NotNull
            public final Options silentExecution(@NotNull JupyterTaskPriority priority) {
                Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
                JupyterTaskPurpose jupyterTaskPurpose = JupyterTaskPurpose.SERVICE;
                return new Options(jupyterTaskPurpose, priority, null, false, true, false, true, null, 128, null);
            }

            public static /* synthetic */ Options silentExecution$default(Companion companion, JupyterTaskPriority jupyterTaskPriority, int n, Object object) {
                if ((n & 1) != 0) {
                    jupyterTaskPriority = JupyterTaskPriority.Companion.getHIGH();
                }
                return companion.silentExecution(jupyterTaskPriority);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

