/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.sorting;

import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewModel;
import com.intellij.jupyter.core.jupyter.structure.sorting.JupyterStructureSortingOptionsState;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J4\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\"\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0017j\b\u0012\u0004\u0012\u00020\n`\u0018*\b\u0012\u0004\u0012\u00020\n0\tH\u0002J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0017j\b\u0012\u0004\u0012\u00020\n`\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0017j\b\u0012\u0004\u0012\u00020\n`\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils;", "", "<init>", "()V", "getSettings", "Lcom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingOptionsState;", "project", "Lcom/intellij/openapi/project/Project;", "applySorting", "", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "elements", "", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "model", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "sortByExecutionOrder", "settings", "splitIntoContainers", "sortContainer", "container", "toIndexComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "applyPriorityFilters", "createExecutionOrderComparator", "createPriorityComparator", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureSortingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureSortingUtils.kt\ncom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1193#2,2:164\n1267#2,4:166\n3301#2,10:170\n1056#2:180\n1#3:181\n*S KotlinDebug\n*F\n+ 1 JupyterStructureSortingUtils.kt\ncom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils\n*L\n100#1:164,2\n100#1:166,4\n113#1:170,10\n122#1:180\n*E\n"})
public final class JupyterStructureSortingUtils {
    @NotNull
    public static final JupyterStructureSortingUtils INSTANCE = new JupyterStructureSortingUtils();

    private JupyterStructureSortingUtils() {
    }

    @NotNull
    public final JupyterStructureSortingOptionsState getSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JupyterStructureSortingOptionsState.Companion.getInstance(project);
    }

    @NotNull
    public final List<JupyterStructureViewCellElement> applySorting(@NotNull List<JupyterStructureViewCellElement> elements, @NotNull JupyterFile psiFile, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterStructureSortingOptionsState settings = this.getSettings(project);
        return settings.getSortBy() == JupyterStructureSortingOptionsState.SortBy.CELLS_ORDER ? this.applyPriorityFilters(elements, settings, model) : this.sortByExecutionOrder(elements, psiFile, model, settings);
    }

    private final List<JupyterStructureViewCellElement> sortByExecutionOrder(List<JupyterStructureViewCellElement> elements, JupyterFile psiFile, JupyterStructureViewModel model, JupyterStructureSortingOptionsState settings) {
        List<List<JupyterStructureViewCellElement>> containers = this.splitIntoContainers(elements);
        List result2 = new ArrayList();
        for (List<JupyterStructureViewCellElement> container : containers) {
            result2.addAll((Collection)this.sortContainer(container, psiFile, model, settings));
        }
        for (JupyterStructureViewCellElement element : result2) {
            List<JupyterStructureViewCellElement> children = element.getCellChildren$intellij_jupyter_core();
            if (!(!((Collection)children).isEmpty())) continue;
            List<JupyterStructureViewCellElement> sortedChildren = this.sortByExecutionOrder(children, psiFile, model, settings);
            element.sortChildren$intellij_jupyter_core(this.toIndexComparator(sortedChildren));
        }
        return result2;
    }

    private final List<List<JupyterStructureViewCellElement>> splitIntoContainers(List<JupyterStructureViewCellElement> elements) {
        List list;
        if (elements.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List $this$splitIntoContainers_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List currentContainer = new ArrayList();
        for (JupyterStructureViewCellElement element : elements) {
            if (element.getInterval().getType() == CellType.MARKDOWN) {
                if (!((Collection)currentContainer).isEmpty()) {
                    $this$splitIntoContainers_u24lambda_u240.add(currentContainer);
                }
                Object[] objectArray = new JupyterStructureViewCellElement[]{element};
                currentContainer = CollectionsKt.mutableListOf((Object[])objectArray);
                continue;
            }
            currentContainer.add(element);
        }
        if (!((Collection)currentContainer).isEmpty()) {
            $this$splitIntoContainers_u24lambda_u240.add(currentContainer);
        }
        return CollectionsKt.build((List)list);
    }

    private final List<JupyterStructureViewCellElement> sortContainer(List<JupyterStructureViewCellElement> container, JupyterFile psiFile, JupyterStructureViewModel model, JupyterStructureSortingOptionsState settings) {
        JupyterStructureViewCellElement jupyterStructureViewCellElement;
        JupyterStructureViewCellElement jupyterStructureViewCellElement2 = (JupyterStructureViewCellElement)CollectionsKt.firstOrNull(container);
        if (jupyterStructureViewCellElement2 != null) {
            JupyterStructureViewCellElement jupyterStructureViewCellElement3;
            JupyterStructureViewCellElement it = jupyterStructureViewCellElement3 = jupyterStructureViewCellElement2;
            boolean bl = false;
            jupyterStructureViewCellElement = it.getInterval().getType() == CellType.MARKDOWN ? jupyterStructureViewCellElement3 : null;
        } else {
            jupyterStructureViewCellElement = null;
        }
        JupyterStructureViewCellElement header = jupyterStructureViewCellElement;
        List codeCells = header != null ? CollectionsKt.drop((Iterable)container, (int)1) : container;
        Comparator<JupyterStructureViewCellElement> comparator = this.createExecutionOrderComparator(psiFile, model);
        List sortedCodeCells = this.applyPriorityFilters(CollectionsKt.sortedWith((Iterable)codeCells, comparator), settings, model);
        return header != null ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)header), (Iterable)sortedCodeCells) : sortedCodeCells;
    }

    /*
     * WARNING - void declaration
     */
    private final Comparator<JupyterStructureViewCellElement> toIndexComparator(List<JupyterStructureViewCellElement> $this$toIndexComparator) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)$this$toIndexComparator);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map indexMap = destination$iv$iv;
        return (arg_0, arg_1) -> JupyterStructureSortingUtils.toIndexComparator$lambda$1(indexMap, arg_0, arg_1);
    }

    private final List<JupyterStructureViewCellElement> applyPriorityFilters(List<JupyterStructureViewCellElement> elements, JupyterStructureSortingOptionsState settings, JupyterStructureViewModel model) {
        List list;
        if (!settings.getAreErrorsAndDeclinedOnTop() && !settings.getAreNonExecutedOnTop()) {
            return elements;
        }
        Iterable $this$partition$iv = elements;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            JupyterStructureViewCellElement element = (JupyterStructureViewCellElement)element$iv;
            boolean bl = false;
            ProgressStatus status = model.getCellStatus(element.getInterval().getOrdinal());
            boolean bl2 = settings.getAreErrorsAndDeclinedOnTop() && status == ProgressStatus.STOPPED_ERROR || settings.getAreNonExecutedOnTop() && status == ProgressStatus.NOT_STARTED ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List prioritized = (List)pair.component1();
        List normal = (List)pair.component2();
        if (settings.getAreErrorsAndDeclinedOnTop() && settings.getAreNonExecutedOnTop()) {
            list = CollectionsKt.sortedWith((Iterable)prioritized, this.createPriorityComparator(model));
        } else {
            Iterable $this$sortedBy$iv = prioritized;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    JupyterStructureViewCellElement it = (JupyterStructureViewCellElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                    it = (JupyterStructureViewCellElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
                }
            });
        }
        List sortedPrioritized = list;
        return CollectionsKt.plus((Collection)sortedPrioritized, (Iterable)normal);
    }

    private final Comparator<JupyterStructureViewCellElement> createExecutionOrderComparator(JupyterFile psiFile, JupyterStructureViewModel model) {
        return (arg_0, arg_1) -> JupyterStructureSortingUtils.createExecutionOrderComparator$lambda$0(model, psiFile, arg_0, arg_1);
    }

    private final Comparator<JupyterStructureViewCellElement> createPriorityComparator(JupyterStructureViewModel model) {
        Comparator comparator = new Comparator(model){
            final /* synthetic */ JupyterStructureViewModel $model$inlined;
            {
                this.$model$inlined = jupyterStructureViewModel;
            }

            public final int compare(T a, T b) {
                Comparable comparable;
                Comparable comparable2;
                JupyterStructureViewCellElement element = (JupyterStructureViewCellElement)a;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[this.$model$inlined.getCellStatus(element.getInterval().getOrdinal()).ordinal()]) {
                    case 1: {
                        comparable2 = Integer.valueOf(0);
                        break;
                    }
                    case 2: {
                        comparable2 = Integer.valueOf(1);
                        break;
                    }
                    default: {
                        comparable2 = Integer.valueOf(2);
                    }
                }
                element = (JupyterStructureViewCellElement)b;
                Comparable comparable3 = comparable2;
                bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[this.$model$inlined.getCellStatus(element.getInterval().getOrdinal()).ordinal()]) {
                    case 1: {
                        comparable = Integer.valueOf(0);
                        break;
                    }
                    case 2: {
                        comparable = Integer.valueOf(1);
                        break;
                    }
                    default: {
                        comparable = Integer.valueOf(2);
                    }
                }
                return ComparisonsKt.compareValues((Comparable)comparable3, (Comparable)comparable);
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    JupyterStructureViewCellElement it = (JupyterStructureViewCellElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                    it = (JupyterStructureViewCellElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
                }
                return n;
            }
        };
    }

    private static final int toIndexComparator$lambda$1(Map $indexMap, JupyterStructureViewCellElement e1, JupyterStructureViewCellElement e2) {
        Integer n = (Integer)$indexMap.get(e1);
        Integer n2 = (Integer)$indexMap.get(e2);
        return Intrinsics.compare((int)(n != null ? n : Integer.MAX_VALUE), (int)(n2 != null ? n2 : Integer.MAX_VALUE));
    }

    private static final int createExecutionOrderComparator$lambda$0(JupyterStructureViewModel $model, JupyterFile $psiFile, JupyterStructureViewCellElement e1, JupyterStructureViewCellElement e2) {
        int n;
        NotebookCellLines.Interval interval1 = e1.getInterval();
        NotebookCellLines.Interval interval2 = e2.getInterval();
        boolean isExecuted1 = $model.getCellStatus(interval1.getOrdinal()) != ProgressStatus.NOT_STARTED;
        boolean isExecuted2 = $model.getCellStatus(interval2.getOrdinal()) != ProgressStatus.NOT_STARTED;
        if (isExecuted1 && !isExecuted2) {
            n = -1;
        } else if (!isExecuted1 && isExecuted2) {
            n = 1;
        } else if (isExecuted1 && isExecuted2) {
            Long time2;
            Object object = JupyterCellLinesExtensionsKt.toJupyterCell(interval1, $psiFile);
            Long time1 = object != null && (object = object.getExecutionEndTime()) != null ? Long.valueOf(object.toEpochSecond()) : null;
            Object object2 = JupyterCellLinesExtensionsKt.toJupyterCell(interval2, $psiFile);
            Long l = object2 != null && (object2 = object2.getExecutionEndTime()) != null ? Long.valueOf(object2.toEpochSecond()) : (time2 = null);
            if (time1 != null && time2 != null) {
                Integer n2 = Intrinsics.compare((long)time1, (long)time2);
                int it = ((Number)n2).intValue();
                boolean bl = false;
                Integer n3 = it != 0 ? n2 : null;
                n = n3 != null ? n3 : Intrinsics.compare((int)interval1.getOrdinal(), (int)interval2.getOrdinal());
            } else {
                n = Intrinsics.compare((int)interval1.getOrdinal(), (int)interval2.getOrdinal());
            }
        } else {
            n = Intrinsics.compare((int)interval1.getOrdinal(), (int)interval2.getOrdinal());
        }
        return n;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.NOT_STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

