/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.storage;

import com.intellij.jupyter.py.colab.assignments.ColabAssignedServer;
import com.intellij.jupyter.py.colab.assignments.ColabConnectionInformation;
import com.intellij.jupyter.py.colab.client.Variant;
import com.intellij.jupyter.py.colab.storage.StoredConnectionInfo;
import com.intellij.jupyter.py.colab.storage.StoredServer;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"ASSIGNED_SERVERS_KEY", "", "toAssignedServer", "Lcom/intellij/jupyter/py/colab/assignments/ColabAssignedServer;", "Lcom/intellij/jupyter/py/colab/storage/StoredServer;", "toStoredServer", "intellij.jupyter.py.colab"})
public final class ServerStorageKt {
    @NotNull
    private static final String ASSIGNED_SERVERS_KEY = "colab.assigned_servers";

    private static final ColabAssignedServer toAssignedServer(StoredServer $this$toAssignedServer) {
        String string = $this$toAssignedServer.getId();
        String string2 = $this$toAssignedServer.getLabel();
        Variant variant = $this$toAssignedServer.getVariant();
        String string3 = $this$toAssignedServer.getAccelerator();
        String string4 = $this$toAssignedServer.getEndpoint();
        URI uRI = URI.create($this$toAssignedServer.getConnectionInformation().getBaseUrl());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        String string5 = $this$toAssignedServer.getConnectionInformation().getToken();
        Instant instant = Instant.ofEpochMilli($this$toAssignedServer.getConnectionInformation().getTokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        Map map = $this$toAssignedServer.getConnectionInformation().getHeaders();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        ColabConnectionInformation colabConnectionInformation = new ColabConnectionInformation(uRI, string5, instant, map);
        Instant instant2 = Instant.ofEpochMilli($this$toAssignedServer.getDateAssigned());
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochMilli(...)");
        return new ColabAssignedServer(string, string2, variant, string3, string4, colabConnectionInformation, instant2);
    }

    private static final StoredServer toStoredServer(ColabAssignedServer $this$toStoredServer) {
        String string = $this$toStoredServer.getId();
        String string2 = $this$toStoredServer.getName();
        Variant variant = $this$toStoredServer.getVariant();
        String string3 = $this$toStoredServer.getAccelerator();
        String string4 = $this$toStoredServer.getEndpoint();
        String string5 = $this$toStoredServer.getConnectionInformation().getBaseUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return new StoredServer(string, string2, variant, string3, string4, new StoredConnectionInfo(string5, $this$toStoredServer.getConnectionInformation().getToken(), $this$toStoredServer.getConnectionInformation().getTokenExpiry().toEpochMilli(), $this$toStoredServer.getConnectionInformation().getHeaders()), $this$toStoredServer.getDateAssigned().toEpochMilli());
    }

    public static final /* synthetic */ StoredServer access$toStoredServer(ColabAssignedServer $receiver) {
        return ServerStorageKt.toStoredServer($receiver);
    }

    public static final /* synthetic */ ColabAssignedServer access$toAssignedServer(StoredServer $receiver) {
        return ServerStorageKt.toAssignedServer($receiver);
    }
}

