/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.codeInsight.highlighting.HyperlinkAnnotator;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspBundle;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspDocumentLinkCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentLinkDisabled;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensCustomizer;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspAnnotatorKt;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticInfo;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLink;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLinkInfo;
import com.intellij.platform.lsp.impl.highlighting.LspHighlightingInfo;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticToken;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticTokenInfo;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002Jr\u0010\u0017\u001a\u00020\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001c0\u001b2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180 0\u001e2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00060\"H\u0002J<\u0010#\u001a\u00020\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00060\u001eH\u0002\u00a8\u0006("}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "LspAnnotator", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "v", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "v", "document", "Lcom/intellij/openapi/editor/Document;", "Y", "v", "", "Lcom/intellij/openapi/util/NlsSafe;", "documentLink", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;", "v", "T", "Lcom/intellij/platform/lsp/impl/highlighting/LspHighlightingInfo;", "key", "Lcom/intellij/openapi/util/Key;", "", "getHighlightingInfos", "Lkotlin/Function1;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "", "createAnnotation", "Lkotlin/Function2;", "v", "highlightingInfos", "elementRange", "Lcom/intellij/openapi/util/TextRange;", "processor", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1374#2:194\n1460#2,5:195\n1056#2:200\n1563#2:201\n1634#2,3:202\n1617#2,9:205\n1869#2:214\n1870#2:216\n1626#2:217\n1563#2:218\n1634#2,3:219\n1#3:215\n*S KotlinDebug\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n*L\n156#1:194\n156#1:195,5\n157#1:200\n79#1:201\n79#1:202,3\n99#1:205,9\n99#1:214\n99#1:216\n99#1:217\n115#1:218\n115#1:219,3\n99#1:215\n*E\n"})
public final class LspAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null || virtualFile instanceof VirtualFileWindow) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        this.v(element, virtualFile, holder);
        this.v(element, virtualFile, document2, holder);
        this.Y(element, virtualFile, holder);
    }

    private final void v(PsiElement psiElement, VirtualFile virtualFile, AnnotationHolder annotationHolder) {
        this.v(psiElement, virtualFile, annotationHolder, LspAnnotatorKt.access$getLSP_SEMANTIC_TOKEN_INFOS$p(), (Function1)new Function1<LspServerImpl, List<? extends LspSemanticTokenInfo>>(virtualFile){
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
                super(1, Intrinsics.Kotlin.class, "getSemanticTokenInfos", "applySemanticTokens$getSemanticTokenInfos(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/platform/lsp/impl/LspServerImpl;)Ljava/util/List;", 0);
            }

            public final List<LspSemanticTokenInfo> invoke(LspServerImpl p02) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                return LspAnnotator.access$applySemanticTokens$getSemanticTokenInfos(this.$file, p02);
            }
        }, LspAnnotator::v);
    }

    private final void v(PsiElement psiElement, VirtualFile virtualFile, Document document, AnnotationHolder annotationHolder) {
        this.v(psiElement, virtualFile, annotationHolder, LspAnnotatorKt.access$getLSP_DIAGNOSTIC_INFOS$p(), (Function1)new Function1<LspServerImpl, List<? extends LspDiagnosticInfo>>(virtualFile, document){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Document $document;
            {
                this.$file = $file;
                this.$document = $document;
                super(1, Intrinsics.Kotlin.class, "getDiagnosticInfos", "applyDiagnostics$getDiagnosticInfos(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;Lcom/intellij/platform/lsp/impl/LspServerImpl;)Ljava/util/List;", 0);
            }

            public final List<LspDiagnosticInfo> invoke(LspServerImpl p02) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                return LspAnnotator.access$applyDiagnostics$getDiagnosticInfos(this.$file, this.$document, p02);
            }
        }, LspAnnotator::v);
    }

    private final void Y(PsiElement psiElement, VirtualFile virtualFile, AnnotationHolder annotationHolder) {
        this.v(psiElement, virtualFile, annotationHolder, LspAnnotatorKt.access$getLSP_DOCUMENT_LINK_INFOS$p(), (Function1)new Function1<LspServerImpl, List<? extends LspDocumentLinkInfo>>(virtualFile){
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
                super(1, Intrinsics.Kotlin.class, "getDocumentLinkInfos", "applyDocumentLinks$getDocumentLinkInfos(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/platform/lsp/impl/LspServerImpl;)Ljava/util/List;", 0);
            }

            public final List<LspDocumentLinkInfo> invoke(LspServerImpl p02) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                return LspAnnotator.access$applyDocumentLinks$getDocumentLinkInfos(this.$file, p02);
            }
        }, (arg_0, arg_1) -> LspAnnotator.v(this, arg_0, arg_1));
    }

    private final String v(LspDocumentLink lspDocumentLink) {
        if (lspDocumentLink.getTooltip() != null) {
            return lspDocumentLink.getTooltip();
        }
        String string = lspDocumentLink.getTargetUri();
        if (string != null && (StringsKt.startsWith$default((String)string, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"https://", (boolean)false, (int)2, null))) {
            String string2 = IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        return LspBundle.INSTANCE.message("follow.link.tooltip", new Object[0]);
    }

    private final <T extends LspHighlightingInfo> void v(PsiElement psiElement, VirtualFile virtualFile, AnnotationHolder annotationHolder, Key<List<T>> key, Function1<? super LspServerImpl, ? extends List<? extends T>> function1, Function2<? super AnnotationHolder, ? super T, Unit> function2) {
        List list = (List)annotationHolder.getCurrentAnnotationSession().getUserData(key);
        if (list == null) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t10 : iterable2) {
                Object object = (LspServerImpl)t10;
                boolean bl3 = false;
                object = (Iterable)function1.invoke(object);
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            iterable = (List)collection;
            bl = false;
            list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    LspHighlightingInfo lspHighlightingInfo = (LspHighlightingInfo)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(lspHighlightingInfo.getTextRange().getStartOffset());
                    lspHighlightingInfo = (LspHighlightingInfo)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(lspHighlightingInfo.getTextRange().getStartOffset()));
                }
            }));
            annotationHolder.getCurrentAnnotationSession().putUserData(key, (Object)list);
        }
        TextRange textRange = psiElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.v(list, textRange, arg_0 -> LspAnnotator.v(function2, annotationHolder, arg_0));
    }

    private final <T extends LspHighlightingInfo> void v(List<T> list, TextRange textRange, Function1<? super T, Unit> function1) {
        if (list.isEmpty()) {
            return;
        }
        int n2 = CollectionsKt.binarySearch$default(list, (int)0, (int)0, arg_0 -> LspAnnotator.v(textRange, arg_0), (int)3, null);
        if ((n2 = Math.max(0, -n2 - 1)) >= list.size()) {
            return;
        }
        LspHighlightingInfo lspHighlightingInfo = (LspHighlightingInfo)list.get(n2);
        while (lspHighlightingInfo != null && lspHighlightingInfo.getTextRange().getStartOffset() < textRange.getEndOffset()) {
            ProgressManager.checkCanceled();
            if (textRange.contains(lspHighlightingInfo.getTextRange())) {
                list.remove(n2);
                function1.invoke((Object)lspHighlightingInfo);
            } else {
                ++n2;
            }
            lspHighlightingInfo = n2 < list.size() ? (LspHighlightingInfo)list.get(n2) : null;
        }
    }

    private static final List<LspSemanticTokenInfo> v(VirtualFile virtualFile, LspServerImpl lspServerImpl) {
        LspSemanticTokensCustomizer lspSemanticTokensCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getSemanticTokensCustomizer();
        LspSemanticTokensSupport lspSemanticTokensSupport = lspSemanticTokensCustomizer instanceof LspSemanticTokensSupport ? (LspSemanticTokensSupport)lspSemanticTokensCustomizer : null;
        if (lspSemanticTokensSupport == null) {
            return CollectionsKt.emptyList();
        }
        LspSemanticTokensSupport lspSemanticTokensSupport2 = lspSemanticTokensSupport;
        Iterable iterable = lspServerImpl.getSemanticTokens$intellij_platform_lsp_impl(virtualFile);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            LspCachedHighlighting lspCachedHighlighting = (LspCachedHighlighting)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new LspSemanticTokenInfo(lspCachedHighlighting.getTextRange(), lspSemanticTokensSupport2, ((LspSemanticToken)lspCachedHighlighting.getHighlightingInfo()).getTokenType(), ((LspSemanticToken)lspCachedHighlighting.getHighlightingInfo()).getTokenModifiers()));
        }
        return (List)collection;
    }

    private static final Unit v(AnnotationHolder annotationHolder, LspSemanticTokenInfo lspSemanticTokenInfo) {
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)lspSemanticTokenInfo, (String)"tokenInfo");
        TextAttributesKey textAttributesKey = lspSemanticTokenInfo.getSemanticTokensSupport().getTextAttributesKey(lspSemanticTokenInfo.getTokenType(), lspSemanticTokenInfo.getTokenModifiers());
        if (textAttributesKey == null) {
            return Unit.INSTANCE;
        }
        TextAttributesKey textAttributesKey2 = textAttributesKey;
        annotationHolder.newSilentAnnotation(HighlightSeverity.TEXT_ATTRIBUTES).range(lspSemanticTokenInfo.getTextRange()).textAttributes(textAttributesKey2).create();
        return Unit.INSTANCE;
    }

    private static final List<LspDiagnosticInfo> v(VirtualFile virtualFile, Document document, LspServerImpl lspServerImpl) {
        LspDiagnosticsCustomizer lspDiagnosticsCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getDiagnosticsCustomizer();
        LspDiagnosticsSupport lspDiagnosticsSupport = lspDiagnosticsCustomizer instanceof LspDiagnosticsSupport ? (LspDiagnosticsSupport)lspDiagnosticsCustomizer : null;
        if (lspDiagnosticsSupport == null) {
            return CollectionsKt.emptyList();
        }
        LspDiagnosticsSupport lspDiagnosticsSupport2 = lspDiagnosticsSupport;
        Iterable iterable = lspServerImpl.getDiagnosticsAndQuickFixes(virtualFile);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            LspDiagnosticInfo lspDiagnosticInfo;
            TextRange textRange;
            Object t10;
            Object t11 = t10 = iterator.next();
            boolean bl4 = false;
            DiagnosticAndQuickFixes diagnosticAndQuickFixes = (DiagnosticAndQuickFixes)t11;
            boolean bl5 = false;
            Range range = diagnosticAndQuickFixes.getDiagnostic().getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
            if ((Lsp4jUtilKt.getRangeInDocument(document, range) == null ? null : new LspDiagnosticInfo(textRange, lspDiagnosticsSupport2, diagnosticAndQuickFixes.getDiagnostic(), diagnosticAndQuickFixes.getQuickFixes())) == null) continue;
            lspDiagnosticInfo = lspDiagnosticInfo;
            boolean bl6 = false;
            collection.add(lspDiagnosticInfo);
        }
        return (List)collection;
    }

    private static final Unit v(AnnotationHolder annotationHolder, LspDiagnosticInfo lspDiagnosticInfo) {
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)lspDiagnosticInfo, (String)"diagnosticInfo");
        lspDiagnosticInfo.getDiagnosticsSupport().createAnnotation(annotationHolder, lspDiagnosticInfo.getDiagnostic(), lspDiagnosticInfo.getTextRange(), lspDiagnosticInfo.getQuickFixes());
        return Unit.INSTANCE;
    }

    private static final List<LspDocumentLinkInfo> Y(VirtualFile virtualFile, LspServerImpl lspServerImpl) {
        LspDocumentLinkCustomizer lspDocumentLinkCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getDocumentLinkCustomizer();
        if (lspDocumentLinkCustomizer instanceof LspDocumentLinkDisabled) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = lspServerImpl.getDocumentLinkInfos$intellij_platform_lsp_impl(virtualFile);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            LspCachedHighlighting lspCachedHighlighting = (LspCachedHighlighting)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new LspDocumentLinkInfo(lspCachedHighlighting.getTextRange(), (LspDocumentLink)lspCachedHighlighting.getHighlightingInfo()));
        }
        return (List)collection;
    }

    private static final Unit v(LspAnnotator lspAnnotator, AnnotationHolder annotationHolder, LspDocumentLinkInfo lspDocumentLinkInfo) {
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)lspDocumentLinkInfo, (String)"documentLinkInfo");
        String string = lspAnnotator.v(lspDocumentLinkInfo.getDocumentLink());
        String string2 = HyperlinkAnnotator.getGoToDeclarationShortcutsText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getGoToDeclarationShortcutsText(...)");
        String string3 = string2;
        String string4 = ((CharSequence)string3).length() > 0 ? string + " (" + string3 + ")" : string;
        annotationHolder.newAnnotation(HighlightSeverity.TEXT_ATTRIBUTES, string4).range(lspDocumentLinkInfo.getTextRange()).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
        return Unit.INSTANCE;
    }

    private static final Unit v(Function2 function2, AnnotationHolder annotationHolder, LspHighlightingInfo lspHighlightingInfo) {
        Intrinsics.checkNotNullParameter((Object)lspHighlightingInfo, (String)"it");
        function2.invoke((Object)annotationHolder, (Object)lspHighlightingInfo);
        return Unit.INSTANCE;
    }

    private static final int v(TextRange textRange, LspHighlightingInfo lspHighlightingInfo) {
        Intrinsics.checkNotNullParameter((Object)lspHighlightingInfo, (String)"it");
        return lspHighlightingInfo.getTextRange().getStartOffset() < textRange.getStartOffset() ? -1 : 1;
    }

    public static final /* synthetic */ List access$applySemanticTokens$getSemanticTokenInfos(VirtualFile $file, LspServerImpl lspServer) {
        return LspAnnotator.v($file, lspServer);
    }

    public static final /* synthetic */ List access$applyDiagnostics$getDiagnosticInfos(VirtualFile $file, Document $document, LspServerImpl lspServer) {
        return LspAnnotator.v($file, $document, lspServer);
    }

    public static final /* synthetic */ List access$applyDocumentLinks$getDocumentLinkInfos(VirtualFile $file, LspServerImpl lspServer) {
        return LspAnnotator.Y($file, lspServer);
    }
}

