/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebResourceFileReferenceHelper
extends FileReferenceHelper {
    @Nullable
    public PsiFileSystemItem findRoot(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            WebResourceFileReferenceHelper.v(0);
        }
        if (file == null) {
            WebResourceFileReferenceHelper.v(1);
        }
        if (WebResourceFileReferenceHelper.v(project).isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file);
        return virtualFile != null ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        List<VirtualFile> list;
        if (module == null) {
            WebResourceFileReferenceHelper.v(2);
        }
        if ((list = WebResourceFileReferenceHelper.v(module.getProject())).isEmpty()) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                WebResourceFileReferenceHelper.v(3);
            }
            return set;
        }
        ArrayList<PsiFileSystemItem> arrayList = new ArrayList<PsiFileSystemItem>(ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots(), virtualFile -> PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile)));
        for (VirtualFile virtualFile2 : list) {
            ContainerUtil.addIfNotNull(arrayList, (Object)PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile2));
        }
        ArrayList<PsiFileSystemItem> arrayList2 = arrayList;
        if (arrayList2 == null) {
            WebResourceFileReferenceHelper.v(4);
        }
        return arrayList2;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        WebResourcesPathsConfiguration webResourcesPathsConfiguration;
        if (project == null) {
            WebResourceFileReferenceHelper.v(5);
        }
        if (file == null) {
            WebResourceFileReferenceHelper.v(6);
        }
        if ((webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project)) == null) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                WebResourceFileReferenceHelper.v(7);
            }
            return set;
        }
        List<VirtualFile> list = webResourcesPathsConfiguration.getResourceDirectories();
        if (list.isEmpty()) {
            Set<PsiFileSystemItem> set = Collections.emptySet();
            if (set == null) {
                WebResourceFileReferenceHelper.v(8);
            }
            return set;
        }
        ArrayList<PsiFileSystemItem> arrayList = new ArrayList<PsiFileSystemItem>(list.size());
        for (VirtualFile virtualFile : list) {
            ContainerUtil.addIfNotNull(arrayList, (Object)PsiManager.getInstance((Project)project).findDirectory(virtualFile));
        }
        ArrayList<PsiFileSystemItem> arrayList2 = arrayList;
        if (arrayList2 == null) {
            WebResourceFileReferenceHelper.v(9);
        }
        return arrayList2;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            WebResourceFileReferenceHelper.v(10);
        }
        if (file == null) {
            WebResourceFileReferenceHelper.v(11);
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @NotNull
    private static List<VirtualFile> v(@NotNull Project project) {
        WebResourcesPathsConfiguration webResourcesPathsConfiguration;
        if (project == null) {
            WebResourceFileReferenceHelper.v(12);
        }
        List<Object> list = (webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project)) != null ? webResourcesPathsConfiguration.getResourceDirectories() : Collections.emptyList();
        if (list == null) {
            WebResourceFileReferenceHelper.v(13);
        }
        return list;
    }

    private static /* synthetic */ void v(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 4, 7, 8, 9, 13 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/resourceRoots/WebResourceFileReferenceHelper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebResourceDirectories";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWebResourceDirectories";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9, 13 -> new IllegalStateException(string);
        };
    }
}

