/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;

public class MuxServerSocketChannelFactory {
    public static final int SOCKET_CHANNEL_READ_TIMEOUT = 15000;
    public static final String SOCKET_REUSE_ADDRESS_PROPERTY_NAME = "socket.reuseAddress";

    public static ServerSocketChannel openAndBindServerSocketChannel(Map<String, Object> properties, SocketAddress endpoint, int backlog) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        ServerSocket socket = channel.socket();
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String name = property.getKey();
                if (!SOCKET_REUSE_ADDRESS_PROPERTY_NAME.equals(name)) continue;
                Object value = property.getValue();
                boolean on = value == null ? false : (value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString()));
                socket.setReuseAddress(on);
            }
        }
        socket.bind(endpoint, backlog);
        return channel;
    }
}

