/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForAtRuleCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForMixinCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForRulesetCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForAtRuleCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForFunctionCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForMixinCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForRulesetCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForStatementCommentFix;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssParameter;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;

public final class SassScssSuppressionUtil {
    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (SassScssSuppressionUtil.getSuppressedInCssStatement(element, toolId) != null) {
                return true;
            }
            if (SassScssSuppressionUtil.getSuppressedInSassStatement(element, toolId) != null) {
                return true;
            }
            if (SassScssSuppressionUtil.getSuppressedInCssRuleset(element, toolId) != null) {
                return true;
            }
            if (SassScssSuppressionUtil.getSuppressedInSassRuleset(element, toolId) != null) {
                return true;
            }
            if (SassScssSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        PsiElement statement = PsiTreeUtil.getTopmostParentOfType((PsiElement)context, CssOneLineStatement.class);
        if (statement != null && statement.getParent() instanceof SassScssParameter) {
            return null;
        }
        return statement;
    }

    @Nullable
    public static PsiElement getSuppressibleCssRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleMixin(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{SassScssMixinDeclaration.class});
    }

    @Nullable
    public static PsiElement getSuppressibleFunction(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{SassScssFunctionDeclaration.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInSassStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(2);
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, SassScssStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(3);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(4);
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssOneLineStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInSassRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(5);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(6);
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, SassScssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(7);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(8);
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(10);
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssAtRule.class);
    }

    @Nullable
    private static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement element, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (element == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(11);
        }
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(12);
        }
        if (statementClass == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(13);
        }
        PsiElement current = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{statementClass});
        while (current != null) {
            PsiElement result = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)current, (String)toolId, statementClass);
            if (result != null) {
                return result;
            }
            current = PsiTreeUtil.getParentOfType((PsiElement)current, statementClass, (boolean)true);
        }
        return null;
    }

    public static SuppressQuickFix @NotNull [] getSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(14);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SassScssSuppressForStatementCommentFix(toolId), new SassScssSuppressForFunctionCommentFix(toolId), new SassScssSuppressForMixinCommentFix(toolId), new SassScssSuppressAllForMixinCommentFix(), new SassScssSuppressForRulesetCommentFix(toolId), new SassScssSuppressAllForRulesetCommentFix(), new SassScssSuppressForAtRuleCommentFix(toolId), new SassScssSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            SassScssSuppressionUtil.$$$reportNull$$$0(15);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInSassStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInCssStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInSassRuleset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInCssRuleset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInBlockAtRule";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatementToolSuppressedIn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

