/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u00020\u00102$\u0010\u0011\u001a \u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00100\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J&\u0010\u0016\u001a\u00020\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0012J\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "myAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geometryFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lkotlin/jvm/functions/Function1;)V", "createNonLinearRectangles", "", "handler", "Lkotlin/Function3;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "createRectangles", "", "createSvgRectHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper$SvgRectHelper;", "SvgRectHelper", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRectanglesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectanglesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n1855#2,2:153\n*S KotlinDebug\n*F\n+ 1 RectanglesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper\n*L\n31#1:151,2\n54#1:153,2\n*E\n"})
public final class RectanglesHelper
extends GeomHelper {
    @NotNull
    private final Aesthetics myAesthetics;
    @NotNull
    private final Function1<DataPointAesthetics, DoubleRectangle> geometryFactory;

    public RectanglesHelper(@NotNull Aesthetics myAesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)myAesthetics, (String)"myAesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter(geometryFactory, (String)"geometryFactory");
        super(pos, coord, ctx2);
        this.myAesthetics = myAesthetics;
        this.geometryFactory = geometryFactory;
    }

    public final void createNonLinearRectangles(@NotNull Function3<? super DataPointAesthetics, ? super SvgNode, ? super List<DoubleVector>, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Iterable<DataPointAesthetics> $this$forEach$iv = this.myAesthetics.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            DoubleRectangle rect2;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator2.next();
            boolean bl = false;
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            boolean bl2 = false;
            AdaptiveResampler.Companion companion = AdaptiveResampler.Companion;
            Object[] objectArray = new DoubleVector[]{new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getBottom()), new DoubleVector(rect2.getLeft(), rect2.getBottom()), new DoubleVector(rect2.getLeft(), rect2.getTop())};
            List list2 = CollectionsKt.listOf((Object[])objectArray);
            List<DoubleVector> polyRect2 = companion.resample(list2, 0.95, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(this, p){
                final /* synthetic */ RectanglesHelper this$0;
                final /* synthetic */ DataPointAesthetics $p;
                {
                    this.this$0 = $receiver;
                    this.$p = $p;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DoubleVector it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.toClient(it, this.$p);
                }
            }));
            SvgPathElement svgPoly = new SvgPathElement();
            svgPoly.d().set(PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), polyRect2).build());
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgPoly, p, false, null, false, 28, null);
            handler2.invoke((Object)p, (Object)svgPoly, polyRect2);
        }
    }

    public final void createRectangles(@NotNull Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Iterable<DataPointAesthetics> $this$forEach$iv = this.myAesthetics.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            DoubleRectangle clientRect;
            DoubleRectangle rect2;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator2.next();
            boolean bl = false;
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            boolean bl2 = false;
            if (this.toClient(rect2, p) == null) continue;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgRect, p, false, null, false, 28, null);
            handler2.invoke((Object)p, (Object)svgRect, (Object)clientRect);
        }
    }

    @NotNull
    public final List<SvgNode> createRectangles() {
        ArrayList<SvgRectElement> result2 = new ArrayList<SvgRectElement>();
        int n = this.myAesthetics.dataPointCount();
        for (int index = 0; index < n; ++index) {
            DoubleRectangle clientRect;
            DataPointAesthetics p = this.myAesthetics.dataPointAt(index);
            if ((DoubleRectangle)this.geometryFactory.invoke((Object)p) == null) continue;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgRect, p, false, null, false, 28, null);
            result2.add(svgRect);
        }
        return result2;
    }

    @NotNull
    public final SvgRectHelper createSvgRectHelper() {
        return new SvgRectHelper();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ0\u0010\u0007\u001a\u00020\r2(\u0010\u0010\u001a$\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0004\u0012\u00020\r0\bJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a$\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0004\u0012\u00020\r0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper$SvgRectHelper;", "", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper;)V", "myResamplingEnabled", "", "myResamplingPrecision", "", "onGeometry", "Lkotlin/Function3;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "", "createSlimRectangles", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimGroup;", "handler", "setResamplingEnabled", "b", "setResamplingPrecision", "precision", "plot-base"})
    public final class SvgRectHelper {
        @NotNull
        private Function3<? super DataPointAesthetics, ? super DoubleRectangle, ? super List<DoubleVector>, Unit> onGeometry = onGeometry.1.INSTANCE;
        private boolean myResamplingEnabled;
        private double myResamplingPrecision = 0.95;

        public final void setResamplingEnabled(boolean b2) {
            this.myResamplingEnabled = b2;
        }

        public final void setResamplingPrecision(double precision) {
            this.myResamplingPrecision = precision;
        }

        public final void onGeometry(@NotNull Function3<? super DataPointAesthetics, ? super DoubleRectangle, ? super List<DoubleVector>, Unit> handler2) {
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            this.onGeometry = handler2;
        }

        @NotNull
        public final SvgSlimGroup createSlimRectangles() {
            int pointCount = RectanglesHelper.this.myAesthetics.dataPointCount();
            SvgSlimGroup group2 = SvgSlimElements.INSTANCE.g(pointCount);
            for (int index = 0; index < pointCount; ++index) {
                DoubleRectangle clientRect;
                DoubleRectangle rect2;
                DataPointAesthetics p = RectanglesHelper.this.myAesthetics.dataPointAt(index);
                if ((DoubleRectangle)RectanglesHelper.this.geometryFactory.invoke((Object)p) == null) continue;
                if (this.myResamplingEnabled) {
                    List list2;
                    AdaptiveResampler.Companion companion = AdaptiveResampler.Companion;
                    double d = this.myResamplingPrecision;
                    Object[] objectArray = new DoubleVector[]{new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getBottom()), new DoubleVector(rect2.getLeft(), rect2.getBottom()), new DoubleVector(rect2.getLeft(), rect2.getTop())};
                    List list3 = CollectionsKt.listOf((Object[])objectArray);
                    List<DoubleVector> polyRect2 = companion.resample(list3, d, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(RectanglesHelper.this, p){
                        final /* synthetic */ RectanglesHelper this$0;
                        final /* synthetic */ DataPointAesthetics $p;
                        {
                            this.this$0 = $receiver;
                            this.$p = $p;
                            super(1);
                        }

                        @Nullable
                        public final DoubleVector invoke(@NotNull DoubleVector it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.toClient(it, this.$p);
                        }
                    }));
                    List<List<DoubleVector>> it = PolylineSimplifier.Companion.douglasPeucker(polyRect2).setWeightLimit(0.25).getPoints();
                    boolean bl = false;
                    if (it.size() != 1) {
                        System.out.println((Object)("RectanglesHelper: expected a single path, but got " + it.size()));
                    }
                    if ((list2 = (List)CollectionsKt.firstOrNull(it)) == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List simplified = list2;
                    this.onGeometry.invoke((Object)p, null, (Object)simplified);
                    SvgSlimShape slimShape = SvgSlimElements.INSTANCE.path(PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), simplified).build());
                    GeomHelper.Companion.decorateSlimShape$plot_base$default(GeomHelper.Companion, slimShape, p, false, 4, null);
                    slimShape.appendTo(group2);
                    continue;
                }
                if (RectanglesHelper.this.toClient(rect2, p) == null) continue;
                this.onGeometry.invoke((Object)p, (Object)clientRect, null);
                SvgSlimShape slimShape = SvgSlimElements.INSTANCE.rect(clientRect.getLeft(), clientRect.getTop(), clientRect.getWidth(), clientRect.getHeight());
                GeomHelper.Companion.decorateSlimShape$plot_base$default(GeomHelper.Companion, slimShape, p, false, 4, null);
                slimShape.appendTo(group2);
            }
            return group2;
        }
    }
}

