/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportErrorHandlerImpl;
import com.intellij.database.dbimport.ImportHead;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportNotificationListenerFactory;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ImportUtil
extends ImportUtilCore {
    private ImportUtil() {
    }

    @NotNull
    public static ImportHead createImportHead(@NotNull Project project, @NotNull ImportInfo info2, @NotNull ReaderTask.Source source) {
        if (project == null) {
            ImportUtil.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            ImportUtil.$$$reportNull$$$0(1);
        }
        if (source == null) {
            ImportUtil.$$$reportNull$$$0(2);
        }
        ImportErrorHandlerImpl importErrorHandler = new ImportErrorHandlerImpl(project, info2);
        ImportNotificationListenerFactoryImpl importNotificationListenerFactory = new ImportNotificationListenerFactoryImpl();
        return new ImportHead(project, info2, source, (ImportErrorHandler)importErrorHandler, (ImportNotificationListenerFactory)importNotificationListenerFactory);
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        VirtualFileSystem system;
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(3);
        }
        InputStream stream = (system = file.getFileSystem()) instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            ImportUtil.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    @NotNull
    public static List<? extends GridRow> getRows(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(5);
        }
        List list = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static BasicNamespace getContextNamespace(@NotNull ImportEditorContext context) {
        DbNamespace dbNamespace;
        BasicNamespace namespace;
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(7);
        }
        BasicNamespace basicNamespace = namespace = (dbNamespace = context.getNamespace()) == null ? null : (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)dbNamespace), BasicNamespace.class);
        if (namespace == null) {
            namespace = (BasicNamespace)ObjectUtils.tryCast((Object)context.getDataSource().getModel().getCurrentRootNamespace(), BasicNamespace.class);
        }
        return namespace;
    }

    @NotNull
    public static @Unmodifiable List<? extends GridColumn> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(8);
        }
        List columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(GridUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static @Unmodifiable List<? extends GridColumn> getVisibleColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(10);
        }
        ModelIndexSet indices = grid.getVisibleColumns();
        ArrayList columns = new ArrayList(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indices));
        ContainerUtil.sort(columns, Comparator.comparingInt(c2 -> c2.getColumnNumber()));
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(GridUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String getSqlTypeName(@Nullable Domain domain, @NotNull ColumnDescriptor column, @Nullable List<? extends GridRow> rows, @NotNull Dbms dbms, @Nullable Version version) {
        if (column == null) {
            ImportUtil.$$$reportNull$$$0(12);
        }
        if (dbms == null) {
            ImportUtil.$$$reportNull$$$0(13);
        }
        String string = ImportUtil.getSqlTypeName((Domain)domain, (ColumnDescriptor)column, rows, (Dbms)dbms, (Dbms)dbms, (Version)version);
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static List<? extends GridColumn> unambiguous(@NotNull DataGrid grid, @NotNull List<? extends GridColumn> columns) {
        DatabaseGridDataHookUp hookUp;
        SqlTableType type;
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(15);
        }
        if (columns == null) {
            ImportUtil.$$$reportNull$$$0(16);
        }
        SqlTableType sqlTableType = type = (hookUp = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)grid)) == null ? null : hookUp.getTableType();
        if (type == null) {
            List<? extends GridColumn> list = columns;
            if (list == null) {
                ImportUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        List names = DbSqlUtil.getUnambiguousColumnNames((Project)grid.getProject(), (DatabaseDialectEx)DataGridUtil.getDatabaseDialect(grid), (SqlTableType)type, null);
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (GridColumn gridColumn : columns) {
            if (gridColumn.getColumnNumber() >= names.size()) {
                result2.add(gridColumn);
                continue;
            }
            JdbcGridColumn c2 = (JdbcGridColumn)ObjectUtils.tryCast((Object)gridColumn, JdbcGridColumn.class);
            result2.add(new DataConsumer.Column(gridColumn.getColumnNumber(), (String)names.get(gridColumn.getColumnNumber()), gridColumn.getType(), gridColumn.getTypeName(), c2 == null ? null : c2.getJavaClassName(), c2 == null ? -1 : c2.getSize(), c2 == null ? -1 : c2.getScale(), c2 == null ? null : c2.getCatalog(), c2 == null ? null : c2.getSchema(), c2 == null ? null : c2.getTable(), c2 == null ? Collections.emptySet() : c2.getAttributes()));
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(19);
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root = instance.getJarRootForLocalFile(Objects.requireNonNull(jar));
        ZipFile zipFile = new ZipFile(Objects.requireNonNull(jar).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)Objects.requireNonNull(root));
        ZipEntry entry = zipFile.getEntry(Objects.requireNonNull(relativePath));
        return new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
    }

    public static boolean canBeProducer(@Nullable DbElement element) {
        return element != null && DbImplUtilCore.canConnectTo((DbElement)element) && DbImplUtilCore.isDataTable((ObjectKind)element.getKind());
    }

    public static boolean canBeConsumer(@Nullable DbElement element) {
        return ImportUtil.canBeConsumerFast((DasObject)element) && ImportUtil.canConnectToAndModify(element) && !DbImplUtilCore.getDbms((DbElement)element).in(Dbms.DOCUMENT_ORIENTED);
    }

    public static boolean canBeConsumerFast(@Nullable DasObject element) {
        return element != null && (!(element instanceof DasNamespace) && !(element instanceof DbDataSource) || DbImplUtilCore.getTopSingleNamespace((DasObject)element) != null) && ImportType.of((DasObject)element) != null;
    }

    public static boolean canModify(@Nullable DbElement element) {
        return element != null && element.isWritable() && !DataImporter.isBusy(element);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element) {
        return element != null && element.isWritable() && DbImplUtilCore.canConnectTo((DbElement)element) && !DataImporter.isBusy(element);
    }

    @Nullable
    public static BasicModTable instantiateTable(@NotNull ImportEditorContext context, BasicModModel model) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(20);
        }
        BasicMetaObject metaTable = (BasicMetaObject)model.getMetaModel().findMetaObjects(ObjectKind.TABLE).filterMap(m -> m.tryCast(BasicModTable.class)).first();
        Objects.requireNonNull(metaTable);
        BasicNamespace namespace = ImportUtil.getContextNamespace(context);
        Map parents = JBIterable.generate((Object)namespace, BasicMixinElement::getParent).toReverseMap(BasicObjectNode::getMetaObject);
        return (BasicModTable)ImportUtil.instantiate(model.getRoot(), metaTable, parents);
    }

    public static void fillTableColumns(@NotNull BasicModTable res2, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull Function<? super Integer, String> typeGetter) {
        if (res2 == null) {
            ImportUtil.$$$reportNull$$$0(21);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(22);
        }
        if (typeGetter == null) {
            ImportUtil.$$$reportNull$$$0(23);
        }
        for (int i = 0; i < descriptors.size(); ++i) {
            ColumnDescriptor descriptor2 = descriptors.get(i);
            BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)res2.getColumns().renewAt((short)(i + 1), descriptor2.getName());
            String typeName = (String)typeGetter.fun((Object)i);
            column.setStoredType((DasType)(typeName == null ? DasTypeSystemBase.UNKNOWN : DasUnresolvedTypeReference.of((DataType)DataTypeFactory.of((String)typeName))));
        }
    }

    @Nullable
    public static <T extends BasicModElement> T instantiate(@NotNull BasicRoot r, @NotNull BasicMetaObject<T> meta, @NotNull Map<? extends BasicMetaObject<?>, BasicElement> parents) {
        T parent2;
        ModFamily family;
        BasicMetaObject parentMeta;
        if (r == null) {
            ImportUtil.$$$reportNull$$$0(24);
        }
        if (meta == null) {
            ImportUtil.$$$reportNull$$$0(25);
        }
        if (parents == null) {
            ImportUtil.$$$reportNull$$$0(26);
        }
        BasicMetaObject basicMetaObject = parentMeta = meta.getParent() == null ? null : meta.getParent().tryCast(BasicModElement.class);
        BasicModElement res2 = meta == r.getMetaObject() || parentMeta == null ? (BasicModElement)meta.tryCast((BasicElement)r) : ((family = (ModFamily)BasicMetaUtils.getFamily(parent2 = ImportUtil.instantiate(r, parentMeta, parents), meta)) == null ? null : family.createNewOne());
        BasicElement example = parents.get(meta);
        if (res2 == null || example == null) {
            return (T)res2;
        }
        ModelLightCopier.copyProperties((BasicElement)example, (BasicModElement)res2, (boolean)false, (boolean)true);
        return (T)res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9, 11, 14, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeGetter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "unambiguous";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createImportHead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContextNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleColumns";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSqlTypeName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unambiguous";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInputStreamForZip";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTable";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillTableColumns";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9, 11, 14, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class ImportNotificationListenerFactoryImpl
    implements ImportNotificationListenerFactory {
        private ImportNotificationListenerFactoryImpl() {
        }

        @NotNull
        public NotificationListener createNotificationListener(@NotNull Project project, DbDataSource system, String path, @NotNull ObjectPath tablePath) {
            if (project == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(0);
            }
            if (tablePath == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(1);
            }
            GridUtil.FileNotificationListener fileNotificationListener = path == null ? null : new GridUtil.FileNotificationListener(project, path);
            OpenTableNotificationListener openTableNotificationListener = new OpenTableNotificationListener(system, tablePath);
            NotificationListener notificationListener = (notification, event) -> {
                if (fileNotificationListener != null) {
                    fileNotificationListener.hyperlinkUpdate(notification, event);
                }
                openTableNotificationListener.hyperlinkUpdate(notification, event);
            };
            if (notificationListener == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(2);
            }
            return notificationListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tablePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportUtil$ImportNotificationListenerFactoryImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$ImportNotificationListenerFactoryImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotificationListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotificationListener";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                MyDelegateInputStream.$$$reportNull$$$0(0);
            }
            if (closeable == null) {
                MyDelegateInputStream.$$$reportNull$$$0(1);
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                MyDelegateInputStream.$$$reportNull$$$0(2);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int read(byte @NotNull [] b) throws IOException {
            if (b == null) {
                MyDelegateInputStream.$$$reportNull$$$0(3);
            }
            return this.myStream.read(b);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenTableNotificationListener
    implements NotificationListener {
        private final DbDataSource mySystem;
        private final ObjectPath myTablePath;

        OpenTableNotificationListener(@Nullable DbDataSource system, @NotNull ObjectPath tablePath) {
            if (tablePath == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(0);
            }
            this.mySystem = system;
            this.myTablePath = tablePath;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            DbElement dbTable;
            if (notification == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(2);
            }
            if (!"open_table".equals(event.getDescription())) {
                return;
            }
            DbElement dbElement = dbTable = this.mySystem == null ? null : DbSqlUtilCore.findElement((DbDataSource)this.mySystem, (ObjectPath)this.myTablePath);
            if (dbTable != null) {
                DbNavigationUtils.navigateToData(dbTable, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tablePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$OpenTableNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ColumnTypePredictorInfo {
        public final Dbms dbms;
        public final DbDataSource dataSource;
        public final ColumnDescriptor column;
        public final List<? extends GridRow> rows;

        public ColumnTypePredictorInfo(@NotNull Dbms dbms, @Nullable DbDataSource dataSource, @NotNull ColumnDescriptor column, @Nullable List<? extends GridRow> rows) {
            if (dbms == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(0);
            }
            if (column == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(1);
            }
            this.dbms = dbms;
            this.dataSource = dataSource;
            this.column = column;
            this.rows = rows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

