/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.wip.WipScript;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\"\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u0018"}, d2={"isFileMatchingScript", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "isFileMatchingContent", "sourceContent", "", "project", "Lcom/intellij/openapi/project/Project;", "url", "Lcom/intellij/util/Url;", "checkLineCount", "scriptLineCount", "", "fileLineCount", "countLinesAndChars", "Lkotlin/Pair;", "possibleWrapperLengths", "", "[Ljava/lang/Integer;", "checkLength", "fileLength", "intellij.javascript.debugger.backend"})
public final class JSCachingFileFinderKt {
    @NotNull
    private static final Integer[] possibleWrapperLengths;

    public static final boolean isFileMatchingScript(@NotNull VirtualFile file, @NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (file.isDirectory()) {
            return false;
        }
        if (script.getLine() != 0) {
            return true;
        }
        int scriptLineCount = script.getEndLine();
        Pair<Integer, Integer> pair = JSCachingFileFinderKt.countLinesAndChars(file);
        int fileCount = ((Number)pair.component1()).intValue();
        int newLineCount = ((Number)pair.component2()).intValue();
        if (!JSCachingFileFinderKt.checkLineCount(scriptLineCount, newLineCount, file, script.getUrl())) {
            return false;
        }
        return JSCachingFileFinderKt.checkLength(script, fileCount, file);
    }

    public static final boolean isFileMatchingContent(@NotNull VirtualFile file, @NotNull String sourceContent, @NotNull Project project, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (file.isDirectory()) {
            return false;
        }
        VirtualFile selectMostSimilarFile = FileResolverByContentKt.selectMostSimilarFile((Collection)new SmartList((Object)file), sourceContent, project);
        if (selectMostSimilarFile == null) {
            JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url {" + url + "}, sourceContent doesn't match");
        }
        return selectMostSimilarFile != null;
    }

    private static final boolean checkLineCount(int scriptLineCount, int fileLineCount, VirtualFile file, Url url) {
        if (scriptLineCount < fileLineCount || scriptLineCount > fileLineCount + 2) {
            JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + url + ": script line count = " + scriptLineCount + ", file line count = " + fileLineCount);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Integer, Integer> countLinesAndChars(VirtualFile file) {
        int fileCount = 0;
        int newLineCount = 0;
        Closeable closeable = new BufferedReader(new InputStreamReader(file.getInputStream(), file.getCharset()));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            int c = reader.read();
            while (c != -1) {
                ++fileCount;
                if (c == 10) {
                    ++newLineCount;
                }
                c = reader.read();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new Pair((Object)fileCount, (Object)newLineCount);
    }

    private static final boolean checkLength(Script script, int fileLength, VirtualFile file) {
        if (script.getUrl().isInLocalFileSystem()) {
            return true;
        }
        int sourceParam = ("\n//# sourceURL=" + script.getUrl()).length();
        if (script instanceof WipScript && !ArraysKt.contains((Object[])possibleWrapperLengths, (Object)(((WipScript)script).getLength() - fileLength)) && (!((WipScript)script).getHasSourceUrl() || ((WipScript)script).getLength() - sourceParam != fileLength && ((WipScript)script).getLength() - sourceParam + 1 != fileLength)) {
            JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + ((WipScript)script).getUrl() + ": script.length = " + ((WipScript)script).getLength() + ", file.length = " + file.getLength());
            return false;
        }
        return true;
    }

    static {
        Integer[] integerArray = new Integer[]{0, 66, 65, 67, 63, 222};
        possibleWrapperLengths = integerArray;
    }
}

