/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.util.io.NetUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b\u001a\u001d\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u0019\u0010\u0016\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002\"!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"toTimeoutInMillis", "", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "linuxPamPasswordPromptTranslations", "", "", "P", "()Ljava/util/Set;", "linuxPamPasswordPromptTranslations$delegate", "Lkotlin/Lazy;", "A", "", "message", "isPamUnixPasswordPrompted", "getMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "throwable", "", "full", "P", "Lorg/jetbrains/annotations/Nls;", "t", "intellij.platform.ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    @NotNull
    private static final Lazy linuxPamPasswordPromptTranslations$delegate = LazyKt.lazy(SshConnectionUtil::A);

    public static final int toTimeoutInMillis(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        long l = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + l);
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private static final Set<String> P() {
        Lazy lazy = linuxPamPasswordPromptTranslations$delegate;
        return (Set)lazy.getValue();
    }

    private static final boolean A(String string) {
        return Intrinsics.areEqual((Object)string, (Object)"Password:") || Pattern.compile("^Password for [^ ]+@[^ ]+:$").matcher(string).matches();
    }

    public static final boolean isPamUnixPasswordPrompted(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SshConnectionUtil.P().contains(message) || SshConnectionUtil.A(message);
    }

    @NotNull
    public static final String getMessage(@Nullable Throwable throwable, boolean full) {
        Object object;
        Object object2;
        Throwable throwable2 = throwable;
        Intrinsics.checkNotNull((Object)throwable2);
        String string = NetUtils.INSTANCE.getNetworkErrorSolutionMessage(throwable2, full);
        if (string != null) {
            return string;
        }
        Object object3 = throwable.getMessage();
        Throwable throwable3 = throwable.getCause();
        if (throwable3 != throwable && (throwable3 instanceof ConnectException || throwable3 instanceof UnknownHostException || throwable3 instanceof SshException)) {
            if (((Exception)throwable3).getCause() != null) {
                object3 = SshConnectionUtil.P(((Exception)throwable3).getCause());
            }
            if (object3 == null || ((Exception)throwable3).getCause() == null) {
                object3 = SshConnectionUtil.P(throwable3);
            }
            if (object3 == null) {
                object3 = throwable.getMessage();
            }
        }
        if (throwable3 instanceof SSLHandshakeException && (object2 = ((SSLHandshakeException)throwable3).getCause()) instanceof CertificateException && !StringUtil.isEmptyOrSpaces((String)((CertificateException)object2).getMessage())) {
            object3 = object2 instanceof CertificateExpiredException ? SshBundle.message("expired.certificate", new Object[0]) + " " : SshBundle.message("invalid.certificate", new Object[0]) + " ";
            object3 = (String)object3 + ((CertificateException)object2).getMessage();
        }
        if (object3 == null) {
            object3 = SshBundle.message("unknown.reason", new Object[0]);
        }
        if (full) {
            if (!Intrinsics.areEqual((Object)object3, (Object)throwable.getMessage())) {
                Object[] objectArray = new Object[]{throwable.getMessage(), object3};
                object2 = MessageFormat.format("{0} ({1})", objectArray);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            } else {
                String string2 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                object = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
            }
        } else {
            object = StringsKt.replace$default((String)StringsKt.replace$default((String)object3, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        }
        return object;
    }

    private static final String P(Throwable throwable) {
        String string;
        if (throwable instanceof UnknownHostException) {
            string = SshBundle.message("host.not.found", new Object[0]);
        } else {
            Throwable throwable2 = throwable;
            Intrinsics.checkNotNull((Object)throwable2);
            string = throwable2.getMessage();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set A() {
        Object object;
        Closeable closeable = SshConnection.class.getClassLoader().getResource("com/intellij/ssh/pam_unix_password_prompt_translations").openStream();
        Throwable throwable = null;
        try {
            object = (InputStream)closeable;
            boolean bl = false;
            object = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)TextStreamsKt.lineSequence((BufferedReader)new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"))), SshConnectionUtil::P), SshConnectionUtil::P));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    private static final boolean P(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        return !StringsKt.isBlank((CharSequence)string) && !StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null);
    }

    private static final String P(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        byte[] byArray = Base64.getDecoder().decode(string);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }
}

