/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 134169671840596L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-811585440 - -((char)-7168), -811585440 - -((char)-364), (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-811585440 - -((char)-7167), -811585440 - -((char)-9481), (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 13631459366712L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.P();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-766759500 + -((char)-602), 766890570 - (char)-1904, (int)l) + string + WindowsNamedPipeAgentIpc.b(-766759500 + -((char)-603), -766759500 + -((char)-3140), (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(-766759500 + -((char)-596), 766890570 - (char)-3119, (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l = 113687741462814L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.P();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-42859890 + -9311, 42859890 + 31328, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-42859890 + -9314, -42859890 + -4915, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-42859890 + -9313, -42859890 + -18911, (int)l));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-42859890 + -9324, 42859890 + 28605, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-42859890 + -9323, 42859890 + 21914, (int)l) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-42859890 + -9326, -42859890 + -4502, (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(-42859890 + -9324, 42859890 + 28605, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-42859890 + -9325, -42859890 + -4496, (int)l));
            if (ActionTimestamp.P() == null) {
                SshAgentIpcService.P(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l = 79446881301517L;
                    actionTimestampArray = SshAgentIpcService.P();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l;
        block27: {
            block28: {
                l = 52560355955204L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.P();
                this.assertConnectionThread();
                Object object3 = this.lock;
                actionTimestampArray = actionTimestampArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1453828440 - -24212, -1453828440 - -31575, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24213, -1453828440 - -28859, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24214, 1453828440 - 24642, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1453828440 - -24212, -1453828440 - -31575, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24215, 1453828440 - (char)-24902, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1453828440 - -24212, -1453828440 - -31575, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24184, -1453828440 - -((char)-31152), (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24185, 1453828440 - (char)-32747, (int)l) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24214, 1453828440 - 24642, (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1453828440 - -24212, -1453828440 - -31575, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1453828440 - -24208, 1453828440 - (char)-23773, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1453828440 - -24186, 1453828440 - 14637, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 105476703152312L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-896256660 + -14088, -896256660 + -26130, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 130860346391559L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1282782090 + -((char)-24164), 1282782090 + (char)-20642, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ab\u00b6\u00ea-\u0004\u00a8\u00f1\u0081\u008b\u00f5A\u008fh\u00f2\u00f6\u008d\u0096\u000f\u00be\u0014R\u0087\u00d5\r\u00f8n\u0013\u00dcUX_\u00eei'\u0017\u00bcG\u00ef\u0083\"";
                        var4_3 = "\u00ab\u00b6\u00ea-\u0004\u00a8\u00f1\u0081\u008b\u00f5A\u008fh\u00f2\u00f6\u008d\u0096\u000f\u00be\u0014R\u0087\u00d5\r\u00f8n\u0013\u00dcUX_\u00eei'\u0017\u00bcG\u00ef\u0083\"".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 95;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 39;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 14;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 27;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 14;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 121;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 104;
                                        break;
                                    }
                                    default: {
                                        v11 = 60;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF96DC) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 92;
                            case 1 -> 69;
                            case 2 -> 213;
                            case 3 -> 214;
                            case 4 -> 243;
                            case 5 -> 137;
                            case 6 -> 190;
                            case 7 -> 201;
                            case 8 -> 127;
                            case 9 -> 10;
                            case 10 -> 224;
                            case 11 -> 63;
                            case 12 -> 192;
                            case 13 -> 88;
                            case 14 -> 18;
                            case 15 -> 48;
                            case 16 -> 221;
                            case 17 -> 168;
                            case 18 -> 68;
                            case 19 -> 0;
                            case 20 -> 83;
                            case 21 -> 188;
                            case 22 -> 56;
                            case 23 -> 76;
                            case 24 -> 108;
                            case 25 -> 205;
                            case 26 -> 141;
                            case 27 -> 11;
                            case 28 -> 219;
                            case 29 -> 210;
                            case 30 -> 218;
                            case 31 -> 195;
                            case 32 -> 232;
                            case 33 -> 172;
                            case 34 -> 111;
                            case 35 -> 209;
                            case 36 -> 122;
                            case 37 -> 138;
                            case 38 -> 17;
                            case 39 -> 38;
                            case 40 -> 67;
                            case 41 -> 230;
                            case 42 -> 171;
                            case 43 -> 70;
                            case 44 -> 174;
                            case 45 -> 222;
                            case 46 -> 248;
                            case 47 -> 186;
                            case 48 -> 189;
                            case 49 -> 112;
                            case 50 -> 73;
                            case 51 -> 91;
                            case 52 -> 96;
                            case 53 -> 62;
                            case 54 -> 246;
                            case 55 -> 98;
                            case 56 -> 35;
                            case 57 -> 34;
                            case 58 -> 143;
                            case 59 -> 90;
                            case 60 -> 182;
                            case 61 -> 110;
                            case 62 -> 242;
                            case 63 -> 41;
                            case 64 -> 103;
                            case 65 -> 236;
                            case 66 -> 99;
                            case 67 -> 234;
                            case 68 -> 43;
                            case 69 -> 152;
                            case 70 -> 84;
                            case 71 -> 184;
                            case 72 -> 16;
                            case 73 -> 204;
                            case 74 -> 151;
                            case 75 -> 226;
                            case 76 -> 23;
                            case 77 -> 109;
                            case 78 -> 77;
                            case 79 -> 238;
                            case 80 -> 49;
                            case 81 -> 233;
                            case 82 -> 240;
                            case 83 -> 86;
                            case 84 -> 144;
                            case 85 -> 250;
                            case 86 -> 235;
                            case 87 -> 133;
                            case 88 -> 75;
                            case 89 -> 179;
                            case 90 -> 136;
                            case 91 -> 169;
                            case 92 -> 25;
                            case 93 -> 125;
                            case 94 -> 5;
                            case 95 -> 81;
                            case 96 -> 247;
                            case 97 -> 239;
                            case 98 -> 21;
                            case 99 -> 176;
                            case 100 -> 118;
                            case 101 -> 193;
                            case 102 -> 135;
                            case 103 -> 157;
                            case 104 -> 202;
                            case 105 -> 89;
                            case 106 -> 162;
                            case 107 -> 245;
                            case 108 -> 94;
                            case 109 -> 52;
                            case 110 -> 114;
                            case 111 -> 126;
                            case 112 -> 249;
                            case 113 -> 215;
                            case 114 -> 121;
                            case 115 -> 212;
                            case 116 -> 95;
                            case 117 -> 146;
                            case 118 -> 47;
                            case 119 -> 36;
                            case 120 -> 61;
                            case 121 -> 228;
                            case 122 -> 227;
                            case 123 -> 149;
                            case 124 -> 166;
                            case 125 -> 147;
                            case 126 -> 252;
                            case 127 -> 1;
                            case 128 -> 132;
                            case 129 -> 231;
                            case 130 -> 79;
                            case 131 -> 173;
                            case 132 -> 19;
                            case 133 -> 253;
                            case 134 -> 106;
                            case 135 -> 29;
                            case 136 -> 124;
                            case 137 -> 220;
                            case 138 -> 134;
                            case 139 -> 31;
                            case 140 -> 211;
                            case 141 -> 24;
                            case 142 -> 58;
                            case 143 -> 15;
                            case 144 -> 181;
                            case 145 -> 64;
                            case 146 -> 198;
                            case 147 -> 59;
                            case 148 -> 113;
                            case 149 -> 54;
                            case 150 -> 46;
                            case 151 -> 140;
                            case 152 -> 156;
                            case 153 -> 101;
                            case 154 -> 93;
                            case 155 -> 97;
                            case 156 -> 119;
                            case 157 -> 80;
                            case 158 -> 129;
                            case 159 -> 9;
                            case 160 -> 2;
                            case 161 -> 28;
                            case 162 -> 128;
                            case 163 -> 142;
                            case 164 -> 207;
                            case 165 -> 153;
                            case 166 -> 199;
                            case 167 -> 87;
                            case 168 -> 180;
                            case 169 -> 85;
                            case 170 -> 60;
                            case 171 -> 71;
                            case 172 -> 164;
                            case 173 -> 3;
                            case 174 -> 117;
                            case 175 -> 8;
                            case 176 -> 57;
                            case 177 -> 50;
                            case 178 -> 14;
                            case 179 -> 254;
                            case 180 -> 32;
                            case 181 -> 82;
                            case 182 -> 130;
                            case 183 -> 159;
                            case 184 -> 208;
                            case 185 -> 42;
                            case 186 -> 123;
                            case 187 -> 20;
                            case 188 -> 116;
                            case 189 -> 154;
                            case 190 -> 22;
                            case 191 -> 115;
                            case 192 -> 170;
                            case 193 -> 7;
                            case 194 -> 45;
                            case 195 -> 120;
                            case 196 -> 185;
                            case 197 -> 6;
                            case 198 -> 53;
                            case 199 -> 223;
                            case 200 -> 177;
                            case 201 -> 66;
                            case 202 -> 161;
                            case 203 -> 27;
                            case 204 -> 196;
                            case 205 -> 200;
                            case 206 -> 30;
                            case 207 -> 145;
                            case 208 -> 44;
                            case 209 -> 197;
                            case 210 -> 206;
                            case 211 -> 37;
                            case 212 -> 203;
                            case 213 -> 165;
                            case 214 -> 217;
                            case 215 -> 194;
                            case 216 -> 51;
                            case 217 -> 4;
                            case 218 -> 225;
                            case 219 -> 65;
                            case 220 -> 175;
                            case 221 -> 78;
                            case 222 -> 148;
                            case 223 -> 139;
                            case 224 -> 72;
                            case 225 -> 131;
                            case 226 -> 39;
                            case 227 -> 191;
                            case 228 -> 167;
                            case 229 -> 178;
                            case 230 -> 241;
                            case 231 -> 100;
                            case 232 -> 187;
                            case 233 -> 107;
                            case 234 -> 104;
                            case 235 -> 12;
                            case 236 -> 33;
                            case 237 -> 26;
                            case 238 -> 105;
                            case 239 -> 55;
                            case 240 -> 155;
                            case 241 -> 183;
                            case 242 -> 102;
                            case 243 -> 163;
                            case 244 -> 13;
                            case 245 -> 244;
                            case 246 -> 150;
                            case 247 -> 160;
                            case 248 -> 158;
                            case 249 -> 237;
                            case 250 -> 40;
                            case 251 -> 255;
                            case 252 -> 74;
                            case 253 -> 216;
                            case 254 -> 251;
                            default -> 229;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray != null) {
                ActionTimestamp.P("Naryuc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 42868770796634L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.P();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(702141990 + (char)-708, 702141990 + (char)-7813, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(702141990 + (char)-704, -702141990 + -((char)-13969), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(702141990 + (char)-681, 702141990 + (char)-7706, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(702141990 + (char)-708, 702141990 + (char)-7813, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(702141990 + (char)-704, -702141990 + -((char)-13969), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(702141990 + (char)-684, 702273060 - (char)-1177, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l = 42009345486795L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.P();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(270397410 - (char)-22792, -270397410 - -((char)-30736), (int)l));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(270397410 - (char)-22791, 270397410 - (char)-20630, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l;
        block25: {
            block26: {
                l = 81473804526486L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                actionTimestampArray = SshAgentIpcService.P();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8742), -1725143340 - -((char)-18023), (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8746), 1725143340 - (char)-24187, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8735), 1725143340 - (char)-8863, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8746), 1725143340 - (char)-24187, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8744), 1725143340 - (char)-8024, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8742), -1725143340 - -((char)-18023), (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8746), 1725143340 - (char)-24187, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8730), 1725143340 - (char)-19772, (int)l));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8742), -1725143340 - -((char)-18023), (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8746), 1725143340 - (char)-24187, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8729), 1725143340 - (char)-23192, (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8742), -1725143340 - -((char)-18023), (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8746), 1725143340 - (char)-24187, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1725143340 - -((char)-8732), -1725143340 - -((char)-8845), (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l = 86770563391348L;
                    Object object = this.lock;
                    actionTimestampArray = SshAgentIpcService.P();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28440, -660854940 + -19157, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(-660854940 + -28444, 660854940 + 12969, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-660854940 + -28425, 660854940 + 27680, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(-660854940 + -28424, 660854940 + 19718, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28440, -660854940 + -19157, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-660854940 + -28444, 660854940 + 12969, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-660854940 + -28423, 660854940 + (char)-31624, (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28440, -660854940 + -19157, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(-660854940 + -28444, 660854940 + 12969, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-660854940 + -28422, -660854940 + -21878, (int)l) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28440, -660854940 + -19157, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-660854940 + -28444, 660854940 + 12969, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-660854940 + -28421, 660854940 + 25412, (int)l));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28440, -660854940 + -19157, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-660854940 + -28444, 660854940 + 12969, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-660854940 + -28420, 660854940 + 24010, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-660854940 + -28419, 660854940 + (char)-28560, (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u009dT\u00d2\u00da\u0097\u0093\u000b4\u0014\u0003b9\u00fb\u0014?\u00d4\u00bb\u00ad\u00ed\u00cbs\u00d20\u00a3\u000e\u00ee`\u0002\u00ec\u0006\u00e9\u00df\\\u00ab,\u00fc\u0018\\\u00ca\u00b2\u00de\u00e7^\u00a8W\u00ea\r,\u001fHB\u00a2\u00c2g\u0090\u001do\u00c9\u00e4\u0014\u0007\tWpM8s\u001d\"w\u0087\u0005T\u00d0\u00ebJ\u00c0\bycNMVG5L\u0014\u00a9[\u0014G\u00dc\u00a0\u00f8\u00dfF\u00bc\u001d\u00edB@\n\u00ed\u00c9\u00cf\u001f[\u0005\u00cf\u0018\u0098S\u00ae\u001e\f\u00bd\u00f5\u0083\u009e1%\u00c0\u00fe\u00eb\u00e5D=\t\u00ae\u00cf\u0007\u00a0\u00c3\u009d\u00be\u0095\u00f6\u00e4\u00f7\u00f7\u0001z\rC\u0010\u0019\u00ab\u00b3\u0084\u0001\u00e3 c#-\u00d3a\u00fd\u00f8\u0019n\t\u00f1\u0083OW`\u00d7f\u00b1\u00e1\u0010\u009br\u00e3\u00bf\u000b\u0084a\u008f\u000b\u00b0\u00d6\u00d2]\u008e\r\u00a0?b90\u0013+*\u0016\u00cf\u00e9\u00dbB\u00b9v@\u00fa\u00dfH\u00c7W\u00b4\u00a2\u00e2\u000el\u00f8\u000e\u00ed\u00f1\u00a7d\u001c\u00ab\u00c2J\u00c7J\u00d9\u00cd9y\u00c8S\u00b0\u009c\u0018\u00c1,\u008f\u00f0\t\u00ea`F\u0090\u0015\u0095\u001b\u0099\\>\u00e6\u008f\u00cc\b\f\u008c\u00e0\u00b0\u0083\u00f8\u008f\u00bb\f7|\u0097\u00b5p:\u001f\u00e4\u00ed\u0095XrF\u00e0[mQ/\u00a6\u00f4w\u0090\u00eb\u00fdy\u0017P\u00c9\u00fb\u00d2$\u0004g\u00da\u00ca\u0002[O\u00c3\u00e8C\u00b8\u001b\u00c5x\u00c5\u0086\u00e5\u00f2G\u0097A\u00f6T\u00b7\u00a8\u00fb\u00c5\u00a8\u00c3\u00df\u00ea\u00fb\u00cf\u0094\r\u0098j\u008fk\u00ae\u00c4d\u00c6\u00ad\u0094<\tL\u00c9\u00ebs\u008b\u001f\u0015\u00d0\u00d6.\u00fa\u0084\u00a9vo=\u00d7\u009e{Om\u00b6\u0004g\u00de\u00af\u00d6S,\u0097\u00cdIQa\u001a\u00d1\u0093\u000b\u001c\u00a6\u00f2\u00ee\u00dcQ\u008a\u0089_4\u0004\u0015\u00af\u00fc\u0084\u00a6\u00150_\u00d8\u00db\u00fe\\-\u00b4\u0095\u0089\u00bbcR\u00efp\u00c6)\u0001\u00f1T\n\u00aa\u0000\u00a3\u00e6./\u00ff\u00dcz\r\u00d3\u00fb\u008cF\u0014,\u007f[\u00df\u008e\u00dc#\u00a4T\u008b\u0083#U\u00e7\u0086\u00c7\u007f\u001d;\u0081\u00ca\u00ef\u0007\u00a4+\u00eaKYuF\u0007\u00d6\u0001\u00c0b\u00fb\u00bf\u0004(\u00fca\u00a79d\f\u008c@\u00bb,g\u008aJF\u0097\u0011\u0003\u00b6Kq\u00f5\u00ce\u00e1\u00f7\u008b\u00b0\u00f8]7\u00c2od\u0095\u00cb\u0017{\u00bd\u00c6\u0006\u0086\u000f\u00bax!3\\!.&\u009am\u00e2\u00f3Z=\u000b\"#(\u00101\"g\u00b2\n\f\u00b2\u00bbo\u00f1w\u00c6z\u00c5_\u00b7M\u00e1w\u00ac[!\u00cd\u00d6W\u00e1\u00d1\u00cc\u00184\u00dc\u000eL\u00bb\u00ffK\u0087.U\u00c7\u00f5Q\u000ft\u00eb\u00c7\u001b\u00c1}I\u0096\u00aa eZ\u00a4e\u00a8\u00f3O\u00017\u00a2S\u00ee\u00d8\u00e77\u0016\u0005\u00d1_\u00f1L\n8\u008b\u00b2O\u00c1\u00ff\u00db\u008b\u00d8=\u0018\u0016\u00e1\u00b3\b\u00f4O\u008f\u00e9\u00e7\u00da\u0002\u009b\u00a3_VH\b\u00b2d\u0015\u00d8\u0003\u00a3 )7\u00b2\u0092br\r\u00b8GM\u001b\u0093Z\u00f3\u00d4}\u00bb';\u00beF\u0010\u0006{)=E\u0005t\u00ec\u00dbt\u00cf(\u000b\u00ebZF\u00bb\u00ea\u00da\u0082\tV\u000f\u00bb\u00d8\u00f4\u00e9\u00a2-\u00c4";
                var4_3 = "\u009dT\u00d2\u00da\u0097\u0093\u000b4\u0014\u0003b9\u00fb\u0014?\u00d4\u00bb\u00ad\u00ed\u00cbs\u00d20\u00a3\u000e\u00ee`\u0002\u00ec\u0006\u00e9\u00df\\\u00ab,\u00fc\u0018\\\u00ca\u00b2\u00de\u00e7^\u00a8W\u00ea\r,\u001fHB\u00a2\u00c2g\u0090\u001do\u00c9\u00e4\u0014\u0007\tWpM8s\u001d\"w\u0087\u0005T\u00d0\u00ebJ\u00c0\bycNMVG5L\u0014\u00a9[\u0014G\u00dc\u00a0\u00f8\u00dfF\u00bc\u001d\u00edB@\n\u00ed\u00c9\u00cf\u001f[\u0005\u00cf\u0018\u0098S\u00ae\u001e\f\u00bd\u00f5\u0083\u009e1%\u00c0\u00fe\u00eb\u00e5D=\t\u00ae\u00cf\u0007\u00a0\u00c3\u009d\u00be\u0095\u00f6\u00e4\u00f7\u00f7\u0001z\rC\u0010\u0019\u00ab\u00b3\u0084\u0001\u00e3 c#-\u00d3a\u00fd\u00f8\u0019n\t\u00f1\u0083OW`\u00d7f\u00b1\u00e1\u0010\u009br\u00e3\u00bf\u000b\u0084a\u008f\u000b\u00b0\u00d6\u00d2]\u008e\r\u00a0?b90\u0013+*\u0016\u00cf\u00e9\u00dbB\u00b9v@\u00fa\u00dfH\u00c7W\u00b4\u00a2\u00e2\u000el\u00f8\u000e\u00ed\u00f1\u00a7d\u001c\u00ab\u00c2J\u00c7J\u00d9\u00cd9y\u00c8S\u00b0\u009c\u0018\u00c1,\u008f\u00f0\t\u00ea`F\u0090\u0015\u0095\u001b\u0099\\>\u00e6\u008f\u00cc\b\f\u008c\u00e0\u00b0\u0083\u00f8\u008f\u00bb\f7|\u0097\u00b5p:\u001f\u00e4\u00ed\u0095XrF\u00e0[mQ/\u00a6\u00f4w\u0090\u00eb\u00fdy\u0017P\u00c9\u00fb\u00d2$\u0004g\u00da\u00ca\u0002[O\u00c3\u00e8C\u00b8\u001b\u00c5x\u00c5\u0086\u00e5\u00f2G\u0097A\u00f6T\u00b7\u00a8\u00fb\u00c5\u00a8\u00c3\u00df\u00ea\u00fb\u00cf\u0094\r\u0098j\u008fk\u00ae\u00c4d\u00c6\u00ad\u0094<\tL\u00c9\u00ebs\u008b\u001f\u0015\u00d0\u00d6.\u00fa\u0084\u00a9vo=\u00d7\u009e{Om\u00b6\u0004g\u00de\u00af\u00d6S,\u0097\u00cdIQa\u001a\u00d1\u0093\u000b\u001c\u00a6\u00f2\u00ee\u00dcQ\u008a\u0089_4\u0004\u0015\u00af\u00fc\u0084\u00a6\u00150_\u00d8\u00db\u00fe\\-\u00b4\u0095\u0089\u00bbcR\u00efp\u00c6)\u0001\u00f1T\n\u00aa\u0000\u00a3\u00e6./\u00ff\u00dcz\r\u00d3\u00fb\u008cF\u0014,\u007f[\u00df\u008e\u00dc#\u00a4T\u008b\u0083#U\u00e7\u0086\u00c7\u007f\u001d;\u0081\u00ca\u00ef\u0007\u00a4+\u00eaKYuF\u0007\u00d6\u0001\u00c0b\u00fb\u00bf\u0004(\u00fca\u00a79d\f\u008c@\u00bb,g\u008aJF\u0097\u0011\u0003\u00b6Kq\u00f5\u00ce\u00e1\u00f7\u008b\u00b0\u00f8]7\u00c2od\u0095\u00cb\u0017{\u00bd\u00c6\u0006\u0086\u000f\u00bax!3\\!.&\u009am\u00e2\u00f3Z=\u000b\"#(\u00101\"g\u00b2\n\f\u00b2\u00bbo\u00f1w\u00c6z\u00c5_\u00b7M\u00e1w\u00ac[!\u00cd\u00d6W\u00e1\u00d1\u00cc\u00184\u00dc\u000eL\u00bb\u00ffK\u0087.U\u00c7\u00f5Q\u000ft\u00eb\u00c7\u001b\u00c1}I\u0096\u00aa eZ\u00a4e\u00a8\u00f3O\u00017\u00a2S\u00ee\u00d8\u00e77\u0016\u0005\u00d1_\u00f1L\n8\u008b\u00b2O\u00c1\u00ff\u00db\u008b\u00d8=\u0018\u0016\u00e1\u00b3\b\u00f4O\u008f\u00e9\u00e7\u00da\u0002\u009b\u00a3_VH\b\u00b2d\u0015\u00d8\u0003\u00a3 )7\u00b2\u0092br\r\u00b8GM\u001b\u0093Z\u00f3\u00d4}\u00bb';\u00beF\u0010\u0006{)=E\u0005t\u00ec\u00dbt\u00cf(\u000b\u00ebZF\u00bb\u00ea\u00da\u0082\tV\u000f\u00bb\u00d8\u00f4\u00e9\u00a2-\u00c4".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 30;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e3=p\u00ebVDD\u0016\u00aaI\u0017h\u001b\u00ea\u0018\u0004\u00f3\u00b8\f\u00cak\u00d0\u009fUr\u00ae\u00054\u0004\u0014\u000e\u00d8\u00e0\u00d4W\u00a2\u00c4p\u00d7\u00ec\u00fc+LC\b\u0018\u00e3\u00da\u00db\u00c3";
                    var4_3 = "\u00e3=p\u00ebVDD\u0016\u00aaI\u0017h\u001b\u00ea\u0018\u0004\u00f3\u00b8\f\u00cak\u00d0\u009fUr\u00ae\u00054\u0004\u0014\u000e\u00d8\u00e0\u00d4W\u00a2\u00c4p\u00d7\u00ec\u00fc+LC\b\u0018\u00e3\u00da\u00db\u00c3".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 5;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 28;
                            break;
                        }
                        case 1: {
                            v15 = 79;
                            break;
                        }
                        case 2: {
                            v15 = 49;
                            break;
                        }
                        case 3: {
                            v15 = 69;
                            break;
                        }
                        case 4: {
                            v15 = 24;
                            break;
                        }
                        case 5: {
                            v15 = 21;
                            break;
                        }
                        default: {
                            v15 = 9;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x2734) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 31;
                case 1 -> 187;
                case 2 -> 60;
                case 3 -> 174;
                case 4 -> 206;
                case 5 -> 49;
                case 6 -> 79;
                case 7 -> 134;
                case 8 -> 20;
                case 9 -> 132;
                case 10 -> 39;
                case 11 -> 160;
                case 12 -> 203;
                case 13 -> 5;
                case 14 -> 222;
                case 15 -> 154;
                case 16 -> 218;
                case 17 -> 241;
                case 18 -> 156;
                case 19 -> 30;
                case 20 -> 50;
                case 21 -> 173;
                case 22 -> 98;
                case 23 -> 26;
                case 24 -> 147;
                case 25 -> 172;
                case 26 -> 240;
                case 27 -> 106;
                case 28 -> 145;
                case 29 -> 143;
                case 30 -> 11;
                case 31 -> 155;
                case 32 -> 242;
                case 33 -> 55;
                case 34 -> 175;
                case 35 -> 64;
                case 36 -> 118;
                case 37 -> 238;
                case 38 -> 226;
                case 39 -> 131;
                case 40 -> 104;
                case 41 -> 194;
                case 42 -> 142;
                case 43 -> 184;
                case 44 -> 157;
                case 45 -> 243;
                case 46 -> 229;
                case 47 -> 91;
                case 48 -> 17;
                case 49 -> 130;
                case 50 -> 125;
                case 51 -> 94;
                case 52 -> 76;
                case 53 -> 139;
                case 54 -> 62;
                case 55 -> 113;
                case 56 -> 228;
                case 57 -> 161;
                case 58 -> 192;
                case 59 -> 44;
                case 60 -> 168;
                case 61 -> 189;
                case 62 -> 169;
                case 63 -> 105;
                case 64 -> 59;
                case 65 -> 41;
                case 66 -> 185;
                case 67 -> 121;
                case 68 -> 205;
                case 69 -> 237;
                case 70 -> 28;
                case 71 -> 236;
                case 72 -> 45;
                case 73 -> 233;
                case 74 -> 129;
                case 75 -> 180;
                case 76 -> 250;
                case 77 -> 178;
                case 78 -> 93;
                case 79 -> 77;
                case 80 -> 137;
                case 81 -> 190;
                case 82 -> 80;
                case 83 -> 126;
                case 84 -> 38;
                case 85 -> 200;
                case 86 -> 166;
                case 87 -> 249;
                case 88 -> 97;
                case 89 -> 69;
                case 90 -> 144;
                case 91 -> 248;
                case 92 -> 246;
                case 93 -> 123;
                case 94 -> 66;
                case 95 -> 24;
                case 96 -> 13;
                case 97 -> 150;
                case 98 -> 199;
                case 99 -> 102;
                case 100 -> 112;
                case 101 -> 227;
                case 102 -> 122;
                case 103 -> 54;
                case 104 -> 183;
                case 105 -> 135;
                case 106 -> 162;
                case 107 -> 72;
                case 108 -> 197;
                case 109 -> 68;
                case 110 -> 153;
                case 111 -> 40;
                case 112 -> 110;
                case 113 -> 128;
                case 114 -> 247;
                case 115 -> 216;
                case 116 -> 61;
                case 117 -> 235;
                case 118 -> 152;
                case 119 -> 109;
                case 120 -> 210;
                case 121 -> 170;
                case 122 -> 89;
                case 123 -> 4;
                case 124 -> 198;
                case 125 -> 2;
                case 126 -> 115;
                case 127 -> 32;
                case 128 -> 214;
                case 129 -> 101;
                case 130 -> 47;
                case 131 -> 232;
                case 132 -> 181;
                case 133 -> 151;
                case 134 -> 73;
                case 135 -> 193;
                case 136 -> 52;
                case 137 -> 9;
                case 138 -> 234;
                case 139 -> 186;
                case 140 -> 108;
                case 141 -> 251;
                case 142 -> 195;
                case 143 -> 29;
                case 144 -> 75;
                case 145 -> 196;
                case 146 -> 167;
                case 147 -> 15;
                case 148 -> 78;
                case 149 -> 208;
                case 150 -> 230;
                case 151 -> 158;
                case 152 -> 67;
                case 153 -> 253;
                case 154 -> 211;
                case 155 -> 42;
                case 156 -> 74;
                case 157 -> 165;
                case 158 -> 182;
                case 159 -> 177;
                case 160 -> 213;
                case 161 -> 63;
                case 162 -> 215;
                case 163 -> 33;
                case 164 -> 58;
                case 165 -> 14;
                case 166 -> 239;
                case 167 -> 56;
                case 168 -> 6;
                case 169 -> 159;
                case 170 -> 35;
                case 171 -> 201;
                case 172 -> 81;
                case 173 -> 191;
                case 174 -> 16;
                case 175 -> 70;
                case 176 -> 117;
                case 177 -> 92;
                case 178 -> 146;
                case 179 -> 221;
                case 180 -> 224;
                case 181 -> 254;
                case 182 -> 1;
                case 183 -> 164;
                case 184 -> 124;
                case 185 -> 133;
                case 186 -> 176;
                case 187 -> 21;
                case 188 -> 85;
                case 189 -> 96;
                case 190 -> 141;
                case 191 -> 136;
                case 192 -> 255;
                case 193 -> 219;
                case 194 -> 51;
                case 195 -> 207;
                case 196 -> 84;
                case 197 -> 204;
                case 198 -> 90;
                case 199 -> 223;
                case 200 -> 149;
                case 201 -> 202;
                case 202 -> 252;
                case 203 -> 217;
                case 204 -> 88;
                case 205 -> 116;
                case 206 -> 71;
                case 207 -> 0;
                case 208 -> 138;
                case 209 -> 212;
                case 210 -> 107;
                case 211 -> 8;
                case 212 -> 12;
                case 213 -> 244;
                case 214 -> 188;
                case 215 -> 171;
                case 216 -> 245;
                case 217 -> 179;
                case 218 -> 37;
                case 219 -> 10;
                case 220 -> 114;
                case 221 -> 220;
                case 222 -> 65;
                case 223 -> 140;
                case 224 -> 57;
                case 225 -> 7;
                case 226 -> 36;
                case 227 -> 99;
                case 228 -> 86;
                case 229 -> 95;
                case 230 -> 103;
                case 231 -> 225;
                case 232 -> 3;
                case 233 -> 19;
                case 234 -> 22;
                case 235 -> 231;
                case 236 -> 111;
                case 237 -> 209;
                case 238 -> 148;
                case 239 -> 119;
                case 240 -> 18;
                case 241 -> 27;
                case 242 -> 163;
                case 243 -> 23;
                case 244 -> 48;
                case 245 -> 120;
                case 246 -> 34;
                case 247 -> 83;
                case 248 -> 87;
                case 249 -> 46;
                case 250 -> 82;
                case 251 -> 100;
                case 252 -> 43;
                case 253 -> 53;
                case 254 -> 127;
                default -> 25;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 41813904060831L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1897500390 + -31414, -1897500390 + -31538, (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l = 85572662925692L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.P();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-265416750 + -((char)-3764), 265416750 + (char)-20039, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-265416750 + -((char)-3763), -265416750 + -((char)-13655), (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-265416750 + -((char)-3762), 265416750 + (char)-2542, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00d6\u0001\u00a9b\u00f7\u00b9uz\u0010Z\u00e4\u00c9\u007fA\u00a1Z HW\u00ac!/\u0082H\u0005";
                    var4_3 = "\u00d6\u0001\u00a9b\u00f7\u00b9uz\u0010Z\u00e4\u00c9\u007fA\u00a1Z HW\u00ac!/\u0082H\u0005".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 30;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0003Z\u00ad\u00b7\u00b95\u0017\u00118\u00b2\u00d9\u009f\u00ef\u00f27\bo\u00b4\u001ed\u00d5\u00ed\u001f\u00e4\u009b\u00c2\u00eb\u001c\u0011K\u00d6\u00f4\u00b4H\u00a9\u00f9\u00a0\u00f3\u0018~T8\u00f4\u0005t\u00baR\u00c8\u00c1\u009d\u00cf\u00a6\u0095r\u00bf\u00f5\u008av\u00a3";
                        var4_3 = "\u0003Z\u00ad\u00b7\u00b95\u0017\u00118\u00b2\u00d9\u009f\u00ef\u00f27\bo\u00b4\u001ed\u00d5\u00ed\u001f\u00e4\u009b\u00c2\u00eb\u001c\u0011K\u00d6\u00f4\u00b4H\u00a9\u00f9\u00a0\u00f3\u0018~T8\u00f4\u0005t\u00baR\u00c8\u00c1\u009d\u00cf\u00a6\u0095r\u00bf\u00f5\u008av\u00a3".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 3;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 93;
                                break;
                            }
                            case 1: {
                                v15 = 4;
                                break;
                            }
                            case 2: {
                                v15 = 11;
                                break;
                            }
                            case 3: {
                                v15 = 62;
                                break;
                            }
                            case 4: {
                                v15 = 80;
                                break;
                            }
                            case 5: {
                                v15 = 71;
                                break;
                            }
                            default: {
                                v15 = 114;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7FB) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 13;
                    case 1 -> 225;
                    case 2 -> 106;
                    case 3 -> 77;
                    case 4 -> 3;
                    case 5 -> 32;
                    case 6 -> 240;
                    case 7 -> 80;
                    case 8 -> 96;
                    case 9 -> 140;
                    case 10 -> 129;
                    case 11 -> 65;
                    case 12 -> 219;
                    case 13 -> 138;
                    case 14 -> 11;
                    case 15 -> 105;
                    case 16 -> 95;
                    case 17 -> 157;
                    case 18 -> 89;
                    case 19 -> 165;
                    case 20 -> 195;
                    case 21 -> 34;
                    case 22 -> 124;
                    case 23 -> 42;
                    case 24 -> 229;
                    case 25 -> 29;
                    case 26 -> 230;
                    case 27 -> 20;
                    case 28 -> 121;
                    case 29 -> 243;
                    case 30 -> 130;
                    case 31 -> 53;
                    case 32 -> 211;
                    case 33 -> 43;
                    case 34 -> 194;
                    case 35 -> 206;
                    case 36 -> 145;
                    case 37 -> 154;
                    case 38 -> 85;
                    case 39 -> 48;
                    case 40 -> 216;
                    case 41 -> 83;
                    case 42 -> 97;
                    case 43 -> 200;
                    case 44 -> 180;
                    case 45 -> 38;
                    case 46 -> 27;
                    case 47 -> 224;
                    case 48 -> 74;
                    case 49 -> 163;
                    case 50 -> 254;
                    case 51 -> 223;
                    case 52 -> 133;
                    case 53 -> 172;
                    case 54 -> 198;
                    case 55 -> 161;
                    case 56 -> 137;
                    case 57 -> 117;
                    case 58 -> 155;
                    case 59 -> 58;
                    case 60 -> 66;
                    case 61 -> 188;
                    case 62 -> 136;
                    case 63 -> 203;
                    case 64 -> 8;
                    case 65 -> 250;
                    case 66 -> 91;
                    case 67 -> 220;
                    case 68 -> 114;
                    case 69 -> 238;
                    case 70 -> 193;
                    case 71 -> 187;
                    case 72 -> 87;
                    case 73 -> 201;
                    case 74 -> 242;
                    case 75 -> 15;
                    case 76 -> 176;
                    case 77 -> 116;
                    case 78 -> 151;
                    case 79 -> 252;
                    case 80 -> 182;
                    case 81 -> 160;
                    case 82 -> 144;
                    case 83 -> 67;
                    case 84 -> 210;
                    case 85 -> 192;
                    case 86 -> 35;
                    case 87 -> 104;
                    case 88 -> 241;
                    case 89 -> 5;
                    case 90 -> 12;
                    case 91 -> 28;
                    case 92 -> 78;
                    case 93 -> 40;
                    case 94 -> 247;
                    case 95 -> 108;
                    case 96 -> 86;
                    case 97 -> 107;
                    case 98 -> 90;
                    case 99 -> 141;
                    case 100 -> 128;
                    case 101 -> 166;
                    case 102 -> 75;
                    case 103 -> 46;
                    case 104 -> 245;
                    case 105 -> 171;
                    case 106 -> 186;
                    case 107 -> 120;
                    case 108 -> 109;
                    case 109 -> 196;
                    case 110 -> 153;
                    case 111 -> 246;
                    case 112 -> 212;
                    case 113 -> 0;
                    case 114 -> 22;
                    case 115 -> 179;
                    case 116 -> 251;
                    case 117 -> 123;
                    case 118 -> 126;
                    case 119 -> 143;
                    case 120 -> 197;
                    case 121 -> 227;
                    case 122 -> 93;
                    case 123 -> 71;
                    case 124 -> 170;
                    case 125 -> 159;
                    case 126 -> 204;
                    case 127 -> 239;
                    case 128 -> 191;
                    case 129 -> 31;
                    case 130 -> 25;
                    case 131 -> 84;
                    case 132 -> 248;
                    case 133 -> 255;
                    case 134 -> 142;
                    case 135 -> 39;
                    case 136 -> 37;
                    case 137 -> 50;
                    case 138 -> 152;
                    case 139 -> 148;
                    case 140 -> 88;
                    case 141 -> 45;
                    case 142 -> 181;
                    case 143 -> 6;
                    case 144 -> 103;
                    case 145 -> 56;
                    case 146 -> 26;
                    case 147 -> 131;
                    case 148 -> 139;
                    case 149 -> 146;
                    case 150 -> 73;
                    case 151 -> 19;
                    case 152 -> 64;
                    case 153 -> 112;
                    case 154 -> 228;
                    case 155 -> 30;
                    case 156 -> 231;
                    case 157 -> 209;
                    case 158 -> 213;
                    case 159 -> 100;
                    case 160 -> 125;
                    case 161 -> 52;
                    case 162 -> 174;
                    case 163 -> 102;
                    case 164 -> 167;
                    case 165 -> 127;
                    case 166 -> 235;
                    case 167 -> 61;
                    case 168 -> 111;
                    case 169 -> 55;
                    case 170 -> 16;
                    case 171 -> 18;
                    case 172 -> 236;
                    case 173 -> 150;
                    case 174 -> 41;
                    case 175 -> 185;
                    case 176 -> 9;
                    case 177 -> 99;
                    case 178 -> 59;
                    case 179 -> 94;
                    case 180 -> 132;
                    case 181 -> 221;
                    case 182 -> 218;
                    case 183 -> 164;
                    case 184 -> 147;
                    case 185 -> 232;
                    case 186 -> 14;
                    case 187 -> 237;
                    case 188 -> 226;
                    case 189 -> 24;
                    case 190 -> 4;
                    case 191 -> 49;
                    case 192 -> 51;
                    case 193 -> 177;
                    case 194 -> 54;
                    case 195 -> 76;
                    case 196 -> 158;
                    case 197 -> 44;
                    case 198 -> 82;
                    case 199 -> 156;
                    case 200 -> 190;
                    case 201 -> 69;
                    case 202 -> 189;
                    case 203 -> 119;
                    case 204 -> 233;
                    case 205 -> 134;
                    case 206 -> 199;
                    case 207 -> 36;
                    case 208 -> 118;
                    case 209 -> 202;
                    case 210 -> 162;
                    case 211 -> 23;
                    case 212 -> 173;
                    case 213 -> 249;
                    case 214 -> 244;
                    case 215 -> 68;
                    case 216 -> 135;
                    case 217 -> 2;
                    case 218 -> 168;
                    case 219 -> 207;
                    case 220 -> 208;
                    case 221 -> 7;
                    case 222 -> 72;
                    case 223 -> 1;
                    case 224 -> 253;
                    case 225 -> 10;
                    case 226 -> 92;
                    case 227 -> 98;
                    case 228 -> 217;
                    case 229 -> 70;
                    case 230 -> 115;
                    case 231 -> 184;
                    case 232 -> 63;
                    case 233 -> 101;
                    case 234 -> 205;
                    case 235 -> 62;
                    case 236 -> 81;
                    case 237 -> 47;
                    case 238 -> 17;
                    case 239 -> 113;
                    case 240 -> 110;
                    case 241 -> 149;
                    case 242 -> 57;
                    case 243 -> 33;
                    case 244 -> 234;
                    case 245 -> 214;
                    case 246 -> 122;
                    case 247 -> 183;
                    case 248 -> 79;
                    case 249 -> 175;
                    case 250 -> 21;
                    case 251 -> 169;
                    case 252 -> 222;
                    case 253 -> 60;
                    case 254 -> 178;
                    default -> 215;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 93032072094348L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "qV\t\u001c`BP(\tv\\\u001a\u0016-\u0000M4\u001a";
                    var5_4 = "qV\t\u001c`BP(\tv\\\u001a\u0016-\u0000M4\u001a".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 41;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 51;
                                    break;
                                }
                                case 1: {
                                    v11 = 26;
                                    break;
                                }
                                case 2: {
                                    v11 = 82;
                                    break;
                                }
                                case 3: {
                                    v11 = 91;
                                    break;
                                }
                                case 4: {
                                    v11 = 44;
                                    break;
                                }
                                case 5: {
                                    v11 = 7;
                                    break;
                                }
                                default: {
                                    v11 = 74;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 120024931526619L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "t7x\u001ai\u0010\u0014\u0004r)t\u0000\n~6\u007f\u0000e\u0012\fT7v\t~6\u007f\u0000e\u0012\fX=\ry0b\ro\u001f\u0016X:e\u0007n\u0016";
                    var5_4 = "t7x\u001ai\u0010\u0014\u0004r)t\u0000\n~6\u007f\u0000e\u0012\fT7v\t~6\u007f\u0000e\u0012\fX=\ry0b\ro\u001f\u0016X:e\u0007n\u0016".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "H\u0003H+_))\u0006H\u0003H+S#";
                        var5_4 = "H\u0003H+_))\u0006H\u0003H+S#".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 75;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 64;
                                break;
                            }
                            case 1: {
                                v15 = 36;
                                break;
                            }
                            case 2: {
                                v15 = 108;
                                break;
                            }
                            case 3: {
                                v15 = 19;
                                break;
                            }
                            case 4: {
                                v15 = 125;
                                break;
                            }
                            case 5: {
                                v15 = 12;
                                break;
                            }
                            default: {
                                v15 = 5;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 68882306714401L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(378792300 - 9022, 378792300 - 24089, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 115334431419810L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "Q\u0081\u00157\u00ec\u0003\u0010\u00e8\u0089\u0005\u001a\u00dcZX\u00e6\r\u001f\u00a1\u00cc\u00bd\u00c1\u00eb\u0091\u00bd\u0083\n\u00b7\u00d8-\u0010e\u00f3D\u001c\u00efJ\u007f\u00b4\u0097\u00af\u00d6!\u00e7r\u00b8`\u0005\u00e0\u0015\u0005a\r3\u00c6\u00c5\u00d0\f\u00a8\f\u00a7h\u00f1\u00c9\u0091\u00c4\u00c9\u009fQ\u00c2k%\u00c3\u00c3\tm\u00ee9\u00dd\u0084\u0005^vJ\u00b0\u00e7zc\u00b6\u00a7\u0097`\u0097\u00bd\u008a<\u009c\u00f4\u00c1\u00c6\u009bm\u00b9q\u007f";
                    var4_3 = "Q\u0081\u00157\u00ec\u0003\u0010\u00e8\u0089\u0005\u001a\u00dcZX\u00e6\r\u001f\u00a1\u00cc\u00bd\u00c1\u00eb\u0091\u00bd\u0083\n\u00b7\u00d8-\u0010e\u00f3D\u001c\u00efJ\u007f\u00b4\u0097\u00af\u00d6!\u00e7r\u00b8`\u0005\u00e0\u0015\u0005a\r3\u00c6\u00c5\u00d0\f\u00a8\f\u00a7h\u00f1\u00c9\u0091\u00c4\u00c9\u009fQ\u00c2k%\u00c3\u00c3\tm\u00ee9\u00dd\u0084\u0005^vJ\u00b0\u00e7zc\u00b6\u00a7\u0097`\u0097\u00bd\u008a<\u009c\u00f4\u00c1\u00c6\u009bm\u00b9q\u007f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 126;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "F\u0017\u007f\u00df\u00d7m'\u000f\u00c3\u0087\u0003{\u0002f[\u00bdL\u001d\u001f\u00e3\u0014n\u00dc~Wa\u001f\u00fb\u00d1\u0013\u00bd\u00ea\u00bfF\u0004\u00c6N\u009e\u00e7i\u0095Q\u00a5\u00ee\u00e3\u00ae\u00eb\u001b\u00e3@R\u00df\u00c2\u00d7M\u00fa!N\r\u0094\u00f0\u008a\u00c7f*\u00ab\u00f2\u008a\u0089\u00a9;\u00f2\u00cf^\u0006\u001c8\u0095\u00d2\u00d7\u001b\u0014\u008f\\\u00bd\u008d\u00cbo\u00a1\u0019\u00f8 F";
                        var4_3 = "F\u0017\u007f\u00df\u00d7m'\u000f\u00c3\u0087\u0003{\u0002f[\u00bdL\u001d\u001f\u00e3\u0014n\u00dc~Wa\u001f\u00fb\u00d1\u0013\u00bd\u00ea\u00bfF\u0004\u00c6N\u009e\u00e7i\u0095Q\u00a5\u00ee\u00e3\u00ae\u00eb\u001b\u00e3@R\u00df\u00c2\u00d7M\u00fa!N\r\u0094\u00f0\u008a\u00c7f*\u00ab\u00f2\u008a\u0089\u00a9;\u00f2\u00cf^\u0006\u001c8\u0095\u00d2\u00d7\u001b\u0014\u008f\\\u00bd\u008d\u00cbo\u00a1\u0019\u00f8 F".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 60;
                                break;
                            }
                            case 1: {
                                v15 = 88;
                                break;
                            }
                            case 2: {
                                v15 = 33;
                                break;
                            }
                            case 3: {
                                v15 = 88;
                                break;
                            }
                            case 4: {
                                v15 = 102;
                                break;
                            }
                            case 5: {
                                v15 = 96;
                                break;
                            }
                            default: {
                                v15 = 40;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8D0F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 181;
                    case 1 -> 231;
                    case 2 -> 191;
                    case 3 -> 232;
                    case 4 -> 238;
                    case 5 -> 211;
                    case 6 -> 133;
                    case 7 -> 175;
                    case 8 -> 44;
                    case 9 -> 105;
                    case 10 -> 150;
                    case 11 -> 162;
                    case 12 -> 254;
                    case 13 -> 219;
                    case 14 -> 224;
                    case 15 -> 39;
                    case 16 -> 116;
                    case 17 -> 206;
                    case 18 -> 103;
                    case 19 -> 0;
                    case 20 -> 46;
                    case 21 -> 68;
                    case 22 -> 31;
                    case 23 -> 146;
                    case 24 -> 248;
                    case 25 -> 118;
                    case 26 -> 73;
                    case 27 -> 12;
                    case 28 -> 18;
                    case 29 -> 180;
                    case 30 -> 36;
                    case 31 -> 190;
                    case 32 -> 143;
                    case 33 -> 130;
                    case 34 -> 114;
                    case 35 -> 154;
                    case 36 -> 187;
                    case 37 -> 241;
                    case 38 -> 87;
                    case 39 -> 62;
                    case 40 -> 178;
                    case 41 -> 28;
                    case 42 -> 215;
                    case 43 -> 47;
                    case 44 -> 137;
                    case 45 -> 127;
                    case 46 -> 17;
                    case 47 -> 26;
                    case 48 -> 199;
                    case 49 -> 227;
                    case 50 -> 10;
                    case 51 -> 135;
                    case 52 -> 6;
                    case 53 -> 167;
                    case 54 -> 100;
                    case 55 -> 121;
                    case 56 -> 66;
                    case 57 -> 25;
                    case 58 -> 188;
                    case 59 -> 4;
                    case 60 -> 164;
                    case 61 -> 37;
                    case 62 -> 237;
                    case 63 -> 63;
                    case 64 -> 161;
                    case 65 -> 96;
                    case 66 -> 74;
                    case 67 -> 2;
                    case 68 -> 251;
                    case 69 -> 151;
                    case 70 -> 1;
                    case 71 -> 250;
                    case 72 -> 249;
                    case 73 -> 242;
                    case 74 -> 60;
                    case 75 -> 176;
                    case 76 -> 33;
                    case 77 -> 240;
                    case 78 -> 152;
                    case 79 -> 76;
                    case 80 -> 53;
                    case 81 -> 8;
                    case 82 -> 82;
                    case 83 -> 54;
                    case 84 -> 30;
                    case 85 -> 50;
                    case 86 -> 234;
                    case 87 -> 24;
                    case 88 -> 223;
                    case 89 -> 177;
                    case 90 -> 186;
                    case 91 -> 210;
                    case 92 -> 111;
                    case 93 -> 119;
                    case 94 -> 51;
                    case 95 -> 253;
                    case 96 -> 221;
                    case 97 -> 236;
                    case 98 -> 45;
                    case 99 -> 75;
                    case 100 -> 204;
                    case 101 -> 5;
                    case 102 -> 138;
                    case 103 -> 218;
                    case 104 -> 142;
                    case 105 -> 110;
                    case 106 -> 7;
                    case 107 -> 89;
                    case 108 -> 244;
                    case 109 -> 16;
                    case 110 -> 217;
                    case 111 -> 196;
                    case 112 -> 216;
                    case 113 -> 252;
                    case 114 -> 222;
                    case 115 -> 21;
                    case 116 -> 173;
                    case 117 -> 205;
                    case 118 -> 91;
                    case 119 -> 225;
                    case 120 -> 64;
                    case 121 -> 107;
                    case 122 -> 183;
                    case 123 -> 23;
                    case 124 -> 102;
                    case 125 -> 120;
                    case 126 -> 81;
                    case 127 -> 122;
                    case 128 -> 115;
                    case 129 -> 49;
                    case 130 -> 15;
                    case 131 -> 55;
                    case 132 -> 56;
                    case 133 -> 169;
                    case 134 -> 43;
                    case 135 -> 197;
                    case 136 -> 170;
                    case 137 -> 70;
                    case 138 -> 48;
                    case 139 -> 247;
                    case 140 -> 126;
                    case 141 -> 78;
                    case 142 -> 200;
                    case 143 -> 34;
                    case 144 -> 3;
                    case 145 -> 158;
                    case 146 -> 171;
                    case 147 -> 245;
                    case 148 -> 27;
                    case 149 -> 147;
                    case 150 -> 65;
                    case 151 -> 185;
                    case 152 -> 156;
                    case 153 -> 83;
                    case 154 -> 112;
                    case 155 -> 201;
                    case 156 -> 67;
                    case 157 -> 195;
                    case 158 -> 9;
                    case 159 -> 192;
                    case 160 -> 207;
                    case 161 -> 106;
                    case 162 -> 182;
                    case 163 -> 141;
                    case 164 -> 153;
                    case 165 -> 57;
                    case 166 -> 38;
                    case 167 -> 32;
                    case 168 -> 13;
                    case 169 -> 104;
                    case 170 -> 88;
                    case 171 -> 140;
                    case 172 -> 71;
                    case 173 -> 22;
                    case 174 -> 85;
                    case 175 -> 94;
                    case 176 -> 69;
                    case 177 -> 208;
                    case 178 -> 61;
                    case 179 -> 189;
                    case 180 -> 58;
                    case 181 -> 77;
                    case 182 -> 174;
                    case 183 -> 113;
                    case 184 -> 179;
                    case 185 -> 155;
                    case 186 -> 40;
                    case 187 -> 19;
                    case 188 -> 117;
                    case 189 -> 246;
                    case 190 -> 42;
                    case 191 -> 93;
                    case 192 -> 145;
                    case 193 -> 243;
                    case 194 -> 228;
                    case 195 -> 212;
                    case 196 -> 233;
                    case 197 -> 132;
                    case 198 -> 239;
                    case 199 -> 213;
                    case 200 -> 198;
                    case 201 -> 255;
                    case 202 -> 134;
                    case 203 -> 220;
                    case 204 -> 41;
                    case 205 -> 148;
                    case 206 -> 79;
                    case 207 -> 149;
                    case 208 -> 172;
                    case 209 -> 131;
                    case 210 -> 193;
                    case 211 -> 123;
                    case 212 -> 95;
                    case 213 -> 92;
                    case 214 -> 184;
                    case 215 -> 159;
                    case 216 -> 20;
                    case 217 -> 139;
                    case 218 -> 84;
                    case 219 -> 202;
                    case 220 -> 166;
                    case 221 -> 99;
                    case 222 -> 136;
                    case 223 -> 203;
                    case 224 -> 165;
                    case 225 -> 14;
                    case 226 -> 125;
                    case 227 -> 35;
                    case 228 -> 129;
                    case 229 -> 163;
                    case 230 -> 226;
                    case 231 -> 29;
                    case 232 -> 235;
                    case 233 -> 101;
                    case 234 -> 108;
                    case 235 -> 86;
                    case 236 -> 160;
                    case 237 -> 97;
                    case 238 -> 59;
                    case 239 -> 52;
                    case 240 -> 194;
                    case 241 -> 168;
                    case 242 -> 209;
                    case 243 -> 109;
                    case 244 -> 230;
                    case 245 -> 229;
                    case 246 -> 157;
                    case 247 -> 214;
                    case 248 -> 144;
                    case 249 -> 80;
                    case 250 -> 128;
                    case 251 -> 90;
                    case 252 -> 72;
                    case 253 -> 98;
                    case 254 -> 124;
                    default -> 11;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 730255860425L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(111409500 + 22829, -111409500 + -18659, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 131292008456717L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.P();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-846843270 - -((char)-24622), 846843270 - (char)-28701, (int)l));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 101910557527350L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00b9o3L+\u0003\u0088\u00e1C";
                var4_3 = "\u00b9o3L+\u0003\u0088\u00e1C".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 88;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 90;
                                break;
                            }
                            case 1: {
                                v11 = 33;
                                break;
                            }
                            case 2: {
                                v11 = 52;
                                break;
                            }
                            case 3: {
                                v11 = 51;
                                break;
                            }
                            case 4: {
                                v11 = 37;
                                break;
                            }
                            case 5: {
                                v11 = 22;
                                break;
                            }
                            default: {
                                v11 = 43;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7040) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 126;
                    case 1 -> 60;
                    case 2 -> 40;
                    case 3 -> 228;
                    case 4 -> 250;
                    case 5 -> 187;
                    case 6 -> 186;
                    case 7 -> 175;
                    case 8 -> 53;
                    case 9 -> 15;
                    case 10 -> 233;
                    case 11 -> 82;
                    case 12 -> 116;
                    case 13 -> 244;
                    case 14 -> 139;
                    case 15 -> 11;
                    case 16 -> 65;
                    case 17 -> 169;
                    case 18 -> 254;
                    case 19 -> 27;
                    case 20 -> 44;
                    case 21 -> 152;
                    case 22 -> 163;
                    case 23 -> 143;
                    case 24 -> 236;
                    case 25 -> 37;
                    case 26 -> 1;
                    case 27 -> 109;
                    case 28 -> 112;
                    case 29 -> 77;
                    case 30 -> 113;
                    case 31 -> 154;
                    case 32 -> 155;
                    case 33 -> 102;
                    case 34 -> 142;
                    case 35 -> 198;
                    case 36 -> 12;
                    case 37 -> 157;
                    case 38 -> 81;
                    case 39 -> 165;
                    case 40 -> 66;
                    case 41 -> 99;
                    case 42 -> 148;
                    case 43 -> 35;
                    case 44 -> 73;
                    case 45 -> 231;
                    case 46 -> 78;
                    case 47 -> 107;
                    case 48 -> 101;
                    case 49 -> 138;
                    case 50 -> 80;
                    case 51 -> 248;
                    case 52 -> 84;
                    case 53 -> 95;
                    case 54 -> 133;
                    case 55 -> 202;
                    case 56 -> 170;
                    case 57 -> 234;
                    case 58 -> 160;
                    case 59 -> 150;
                    case 60 -> 21;
                    case 61 -> 14;
                    case 62 -> 203;
                    case 63 -> 185;
                    case 64 -> 115;
                    case 65 -> 69;
                    case 66 -> 211;
                    case 67 -> 207;
                    case 68 -> 16;
                    case 69 -> 190;
                    case 70 -> 98;
                    case 71 -> 97;
                    case 72 -> 135;
                    case 73 -> 149;
                    case 74 -> 242;
                    case 75 -> 222;
                    case 76 -> 251;
                    case 77 -> 195;
                    case 78 -> 153;
                    case 79 -> 137;
                    case 80 -> 125;
                    case 81 -> 8;
                    case 82 -> 74;
                    case 83 -> 96;
                    case 84 -> 192;
                    case 85 -> 196;
                    case 86 -> 177;
                    case 87 -> 161;
                    case 88 -> 235;
                    case 89 -> 255;
                    case 90 -> 217;
                    case 91 -> 110;
                    case 92 -> 83;
                    case 93 -> 0;
                    case 94 -> 38;
                    case 95 -> 29;
                    case 96 -> 68;
                    case 97 -> 32;
                    case 98 -> 225;
                    case 99 -> 201;
                    case 100 -> 130;
                    case 101 -> 167;
                    case 102 -> 54;
                    case 103 -> 3;
                    case 104 -> 71;
                    case 105 -> 220;
                    case 106 -> 206;
                    case 107 -> 124;
                    case 108 -> 56;
                    case 109 -> 174;
                    case 110 -> 24;
                    case 111 -> 237;
                    case 112 -> 90;
                    case 113 -> 188;
                    case 114 -> 106;
                    case 115 -> 88;
                    case 116 -> 75;
                    case 117 -> 94;
                    case 118 -> 168;
                    case 119 -> 128;
                    case 120 -> 57;
                    case 121 -> 216;
                    case 122 -> 105;
                    case 123 -> 164;
                    case 124 -> 25;
                    case 125 -> 249;
                    case 126 -> 210;
                    case 127 -> 59;
                    case 128 -> 166;
                    case 129 -> 48;
                    case 130 -> 159;
                    case 131 -> 42;
                    case 132 -> 136;
                    case 133 -> 31;
                    case 134 -> 17;
                    case 135 -> 132;
                    case 136 -> 45;
                    case 137 -> 127;
                    case 138 -> 181;
                    case 139 -> 19;
                    case 140 -> 178;
                    case 141 -> 189;
                    case 142 -> 173;
                    case 143 -> 121;
                    case 144 -> 76;
                    case 145 -> 36;
                    case 146 -> 239;
                    case 147 -> 162;
                    case 148 -> 158;
                    case 149 -> 6;
                    case 150 -> 246;
                    case 151 -> 34;
                    case 152 -> 140;
                    case 153 -> 70;
                    case 154 -> 67;
                    case 155 -> 30;
                    case 156 -> 55;
                    case 157 -> 119;
                    case 158 -> 141;
                    case 159 -> 103;
                    case 160 -> 62;
                    case 161 -> 5;
                    case 162 -> 194;
                    case 163 -> 18;
                    case 164 -> 205;
                    case 165 -> 226;
                    case 166 -> 232;
                    case 167 -> 63;
                    case 168 -> 52;
                    case 169 -> 2;
                    case 170 -> 214;
                    case 171 -> 104;
                    case 172 -> 49;
                    case 173 -> 7;
                    case 174 -> 64;
                    case 175 -> 13;
                    case 176 -> 176;
                    case 177 -> 229;
                    case 178 -> 227;
                    case 179 -> 92;
                    case 180 -> 180;
                    case 181 -> 9;
                    case 182 -> 58;
                    case 183 -> 215;
                    case 184 -> 20;
                    case 185 -> 240;
                    case 186 -> 28;
                    case 187 -> 46;
                    case 188 -> 87;
                    case 189 -> 131;
                    case 190 -> 252;
                    case 191 -> 122;
                    case 192 -> 22;
                    case 193 -> 172;
                    case 194 -> 43;
                    case 195 -> 191;
                    case 196 -> 230;
                    case 197 -> 223;
                    case 198 -> 241;
                    case 199 -> 120;
                    case 200 -> 184;
                    case 201 -> 117;
                    case 202 -> 4;
                    case 203 -> 197;
                    case 204 -> 51;
                    case 205 -> 100;
                    case 206 -> 72;
                    case 207 -> 123;
                    case 208 -> 204;
                    case 209 -> 10;
                    case 210 -> 144;
                    case 211 -> 199;
                    case 212 -> 26;
                    case 213 -> 212;
                    case 214 -> 91;
                    case 215 -> 23;
                    case 216 -> 86;
                    case 217 -> 47;
                    case 218 -> 243;
                    case 219 -> 219;
                    case 220 -> 200;
                    case 221 -> 118;
                    case 222 -> 208;
                    case 223 -> 156;
                    case 224 -> 245;
                    case 225 -> 182;
                    case 226 -> 61;
                    case 227 -> 108;
                    case 228 -> 193;
                    case 229 -> 218;
                    case 230 -> 41;
                    case 231 -> 171;
                    case 232 -> 146;
                    case 233 -> 253;
                    case 234 -> 224;
                    case 235 -> 209;
                    case 236 -> 238;
                    case 237 -> 33;
                    case 238 -> 114;
                    case 239 -> 221;
                    case 240 -> 89;
                    case 241 -> 183;
                    case 242 -> 179;
                    case 243 -> 93;
                    case 244 -> 85;
                    case 245 -> 247;
                    case 246 -> 145;
                    case 247 -> 111;
                    case 248 -> 50;
                    case 249 -> 129;
                    case 250 -> 134;
                    case 251 -> 213;
                    case 252 -> 79;
                    case 253 -> 151;
                    case 254 -> 39;
                    default -> 147;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

