/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u001f\u001a\u00020\f*\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\fH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\fH\u0002J$\u0010&\u001a\u0004\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J$\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0014\u0010,\u001a\u00020-*\u00020\"2\u0006\u0010.\u001a\u00020\fH\u0002J\u0014\u00101\u001a\u00020-*\u00020\"2\u0006\u0010.\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00020 *\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0018\u0010/\u001a\u00020 *\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010+\u00a8\u00062"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_48;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "START_PROPERTY_NAME", "", "SEQUENCE_IDENTITY_PROPERTY_NAME", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "checkDbms", "", "dbms", "Lcom/intellij/database/Dbms;", "convertSequences", "convertSequence", "elementMem", "Lcom/intellij/database/model/serialization/ModelElementMem;", "version", "Lcom/intellij/database/util/Version;", "updateProperty", "property", "Lcom/intellij/database/model/serialization/MutableNameAndValue;", "name", "value", "checkDbmsMoveNextValueToStartValue", "checkDbmsIncrementNext", "checkDbmsRestoreFiniteMinimumAndMaximum", "checkDbmsClearInfiniteMinimumAndMaximum", "checkDbmsRestoreStartValue", "isAscSequenceIncrement", "Ljava/math/BigInteger;", "dasType", "Lcom/intellij/database/types/DasType;", "finiteMinimum", "isAsc", "finiteMaximum", "infiniteMinimum", "infiniteMaximum", "", "h2LowerBound", "getH2LowerBound", "(Lcom/intellij/database/types/DasType;)Ljava/math/BigInteger;", "decimalLowerBound", "", "exclusive", "h2UpperBound", "getH2UpperBound", "decimalUpperBound", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_48.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_48.kt\ncom/intellij/database/model/serialization/converters/Converter_4_48\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1321#2,2:216\n1#3:218\n1803#4,3:219\n*S KotlinDebug\n*F\n+ 1 Converter_4_48.kt\ncom/intellij/database/model/serialization/converters/Converter_4_48\n*L\n38#1:216,2\n208#1:219,3\n*E\n"})
public final class Converter_4_48
extends Converter {
    @NotNull
    public static final Converter_4_48 INSTANCE = new Converter_4_48();
    @NotNull
    private static final String START_PROPERTY_NAME = "StartValue";
    @NotNull
    private static final String SEQUENCE_IDENTITY_PROPERTY_NAME = "SequenceIdentity";

    private Converter_4_48() {
        int[] nArray = new int[]{4, 48};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (!this.checkDbms(modelMem.getDbms())) {
            return;
        }
        this.convertSequences(modelMem);
    }

    private final boolean checkDbms(Dbms dbms) {
        return Intrinsics.areEqual((Object)dbms, (Object)Dbms.ORACLE) || Intrinsics.areEqual((Object)dbms, (Object)Dbms.POSTGRES) || Intrinsics.areEqual((Object)dbms, (Object)Dbms.COCKROACH) || dbms.isDb2() || dbms.isH2() || dbms.isMicrosoft() || dbms.isVertica();
    }

    private final void convertSequences(ModelMem modelMem) {
        String sequenceCode = ObjectKind.SEQUENCE.code();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)modelMem.getNodes()), arg_0 -> Converter_4_48.convertSequences$lambda$0(sequenceCode, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelElementMem it = (ModelElementMem)element$iv;
            boolean bl = false;
            INSTANCE.convertSequence(it, modelMem.getDbms(), modelMem.getVersion());
        }
    }

    private final void convertSequence(ModelElementMem elementMem, Dbms dbms, Version version) {
        String string;
        Object object;
        BigInteger start2;
        MutableNameAndValue sequenceIdentityProperty;
        MutableNameAndValue startProperty;
        block17: {
            block16: {
                startProperty = ModelSerializationFun.find(elementMem.getProperties(), START_PROPERTY_NAME);
                sequenceIdentityProperty = ModelSerializationFun.find(elementMem.getProperties(), SEQUENCE_IDENTITY_PROPERTY_NAME);
                MutableNameAndValue mutableNameAndValue = startProperty;
                if (mutableNameAndValue != null) {
                    MutableNameAndValue it = mutableNameAndValue;
                    boolean bl = false;
                    v1 = PropertyConverter.importBigInteger(it.getValue());
                } else {
                    v1 = start2 = null;
                }
                if ((object = sequenceIdentityProperty) == null) break block16;
                MutableNameAndValue it = object;
                boolean bl = false;
                SequenceIdentity sequenceIdentity = PropertyConverter.importSequenceIdentity(sequenceIdentityProperty.getValue());
                object = sequenceIdentity;
                if (sequenceIdentity != null) break block17;
            }
            object = SequenceIdentity.UNKNOWN;
        }
        Object sequenceIdentity = object;
        BigInteger min = ((SequenceIdentity)sequenceIdentity).min;
        BigInteger next = ((SequenceIdentity)sequenceIdentity).next;
        BigInteger bigInteger = ((SequenceIdentity)sequenceIdentity).increment;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"increment");
        BigInteger increment = bigInteger;
        BigInteger max = ((SequenceIdentity)sequenceIdentity).max;
        if (this.checkDbmsMoveNextValueToStartValue(dbms)) {
            start2 = next;
            next = null;
        }
        if (this.checkDbmsIncrementNext(dbms) && next != null) {
            BigInteger bigInteger2 = next.add(increment);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
            next = bigInteger2;
        }
        boolean isAsc = this.isAscSequenceIncrement(increment, dbms);
        if (this.checkDbmsRestoreFiniteMinimumAndMaximum(dbms)) {
            if (min == null) {
                min = this.finiteMinimum(dbms, isAsc);
            }
            if (max == null) {
                max = this.finiteMaximum(dbms, isAsc);
            }
        }
        if (this.checkDbmsClearInfiniteMinimumAndMaximum(dbms)) {
            DasType dasType = this.dasType(elementMem, dbms);
            if (Intrinsics.areEqual((Object)min, (Object)this.infiniteMinimum(dbms, isAsc, dasType))) {
                min = null;
            }
            if (Intrinsics.areEqual((Object)max, (Object)this.infiniteMaximum(dbms, isAsc, dasType))) {
                max = null;
            }
        }
        if (this.checkDbmsRestoreStartValue(dbms, version) && start2 == null) {
            start2 = isAsc ? min : max;
        }
        BigInteger bigInteger3 = start2;
        if (bigInteger3 != null) {
            BigInteger it = bigInteger3;
            boolean bl = false;
            string = PropertyConverter.export(it);
        } else {
            string = null;
        }
        String startValue = string;
        this.updateProperty(elementMem, startProperty, START_PROPERTY_NAME, startValue);
        String sequenceIdentityValue = PropertyConverter.export(SequenceIdentity.of(min, next, increment, max));
        this.updateProperty(elementMem, sequenceIdentityProperty, SEQUENCE_IDENTITY_PROPERTY_NAME, sequenceIdentityValue);
    }

    private final void updateProperty(ModelElementMem elementMem, MutableNameAndValue property, String name, String value) {
        if (value == null) {
            MutableNameAndValue mutableNameAndValue = property;
            if (mutableNameAndValue != null) {
                MutableNameAndValue it = mutableNameAndValue;
                boolean bl = false;
                elementMem.getProperties().remove(it);
            }
            return;
        }
        if (property != null) {
            property.setValue(value);
        } else {
            elementMem.getProperties().add(new MutableNameAndValue(name, value));
        }
    }

    private final boolean checkDbmsMoveNextValueToStartValue(Dbms dbms) {
        return dbms.isPostgres() || dbms.isDb2();
    }

    private final boolean checkDbmsIncrementNext(Dbms dbms) {
        return dbms.isVertica();
    }

    private final boolean checkDbmsRestoreFiniteMinimumAndMaximum(Dbms dbms) {
        return this.checkDbms(dbms);
    }

    private final boolean checkDbmsClearInfiniteMinimumAndMaximum(Dbms dbms) {
        return dbms.isPostgres() || dbms.isVertica() || dbms.isMicrosoft() || dbms.isH2();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkDbmsRestoreStartValue(Dbms dbms, Version version) {
        if (dbms.isPostgres()) return true;
        if (!dbms.isH2()) return false;
        int[] nArray = new int[]{2};
        if (!version.isOrGreater(nArray)) return false;
        return true;
    }

    private final boolean isAscSequenceIncrement(BigInteger $this$isAscSequenceIncrement, Dbms dbms) {
        int it = $this$isAscSequenceIncrement.signum();
        boolean bl = false;
        return dbms.isVertica() ? it > 0 : it >= 0;
    }

    private final DasType dasType(ModelElementMem $this$dasType, Dbms dbms) {
        MutableNameAndValue mutableNameAndValue = dbms.isMicrosoft() ? ModelSerializationFun.find($this$dasType.getProperties(), "UnderlyingDasType") : ModelSerializationFun.find($this$dasType.getProperties(), "DasType");
        if (mutableNameAndValue == null) {
            return null;
        }
        MutableNameAndValue dasTypeProperty = mutableNameAndValue;
        return PropertyConverter.importDasType(dasTypeProperty.getValue());
    }

    private final BigInteger finiteMinimum(Dbms dbms, boolean isAsc) {
        return dbms.isVertica() ? BigInteger.ONE : (dbms.isMicrosoft() ? null : (isAsc ? BigInteger.ONE : null));
    }

    private final BigInteger finiteMaximum(Dbms dbms, boolean isAsc) {
        return dbms.isVertica() ? null : (dbms.isMicrosoft() ? null : (isAsc ? null : BigInteger.ONE.negate()));
    }

    private final BigInteger infiniteMinimum(Dbms dbms, boolean isAsc, DasType dasType) {
        BigInteger bigInteger;
        if (dbms.isPostgres()) {
            if (isAsc) {
                bigInteger = null;
            } else {
                DasType dasType2 = dasType;
                bigInteger = dasType2 != null ? DasTypeUtilsKt.getMinValue(dasType2) : null;
            }
        } else if (dbms.isH2()) {
            if (isAsc) {
                bigInteger = null;
            } else {
                DasType dasType3 = dasType;
                bigInteger = dasType3 != null ? this.getH2LowerBound(dasType3) : null;
            }
        } else if (dbms.isMicrosoft()) {
            DasType dasType4 = dasType;
            bigInteger = dasType4 != null ? DasTypeUtilsKt.getMinValue(dasType4) : null;
        } else {
            bigInteger = null;
        }
        return bigInteger;
    }

    private final Object infiniteMaximum(Dbms dbms, boolean isAsc, DasType dasType) {
        Number number;
        if (dbms.isPostgres()) {
            if (isAsc) {
                DasType dasType2 = dasType;
                number = dasType2 != null ? DasTypeUtilsKt.getMaxValue(dasType2) : null;
            } else {
                number = null;
            }
        } else if (dbms.isH2()) {
            if (isAsc) {
                DasType dasType3 = dasType;
                number = dasType3 != null ? this.getH2UpperBound(dasType3) : null;
            } else {
                number = null;
            }
        } else if (dbms.isMicrosoft()) {
            DasType dasType4 = dasType;
            number = dasType4 != null ? DasTypeUtilsKt.getMaxValue(dasType4) : null;
        } else {
            number = dbms.isVertica() ? Long.valueOf(Long.MAX_VALUE) : null;
        }
        return number;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BigInteger getH2LowerBound(DasType $this$h2LowerBound) {
        BigInteger bigInteger;
        String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$h2LowerBound));
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1282431251: {
                    if (!string.equals("NUMERIC")) break;
                    n = 1;
                    break;
                }
                case 2511262: {
                    if (!string.equals("REAL")) break;
                    n = 2;
                    break;
                }
                case -2034720975: {
                    if (!string.equals("DECIMAL")) break;
                    n = 1;
                    break;
                }
                case 1345372058: {
                    if (!string.equals("DECFLOAT")) break;
                    n = 3;
                    break;
                }
                case -594415409: {
                    if (!string.equals("TINYINT")) break;
                    n = 4;
                    break;
                }
                case 1770063567: {
                    if (!string.equals("DOUBLE PRECISION")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    BigInteger bigInteger2 = BigInteger.valueOf(-128);
                    bigInteger = bigInteger2;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 2: {
                    BigInteger bigInteger3 = BigInteger.valueOf(-16777216);
                    bigInteger = bigInteger3;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 5: {
                    BigInteger bigInteger4 = BigInteger.valueOf(-9007199254740992L);
                    bigInteger = bigInteger4;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 1: {
                    BigInteger bigInteger5 = BigInteger.valueOf(this.decimalLowerBound($this$h2LowerBound, true));
                    bigInteger = bigInteger5;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 3: {
                    BigInteger bigInteger6 = BigInteger.valueOf(this.decimalLowerBound($this$h2LowerBound, false));
                    bigInteger = bigInteger6;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                    return bigInteger;
                }
            }
        }
        BigInteger bigInteger7 = DasTypeUtilsKt.getMinValue($this$h2LowerBound);
        bigInteger = bigInteger7;
        if (bigInteger7 != null) return bigInteger;
        BigInteger bigInteger8 = BigInteger.valueOf(Long.MIN_VALUE);
        bigInteger = bigInteger8;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
        return bigInteger;
    }

    private final long decimalLowerBound(DasType $this$decimalLowerBound, boolean exclusive) {
        long upperBound = this.decimalUpperBound($this$decimalLowerBound, exclusive);
        return upperBound == Long.MAX_VALUE ? Long.MIN_VALUE : -upperBound;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BigInteger getH2UpperBound(DasType $this$h2UpperBound) {
        BigInteger bigInteger;
        String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$h2UpperBound));
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1282431251: {
                    if (!string.equals("NUMERIC")) break;
                    n = 1;
                    break;
                }
                case 2511262: {
                    if (!string.equals("REAL")) break;
                    n = 2;
                    break;
                }
                case -2034720975: {
                    if (!string.equals("DECIMAL")) break;
                    n = 1;
                    break;
                }
                case 1345372058: {
                    if (!string.equals("DECFLOAT")) break;
                    n = 3;
                    break;
                }
                case -594415409: {
                    if (!string.equals("TINYINT")) break;
                    n = 4;
                    break;
                }
                case 1770063567: {
                    if (!string.equals("DOUBLE PRECISION")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    BigInteger bigInteger2 = BigInteger.valueOf(127);
                    bigInteger = bigInteger2;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 2: {
                    BigInteger bigInteger3 = BigInteger.valueOf(0x1000000);
                    bigInteger = bigInteger3;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 5: {
                    BigInteger bigInteger4 = BigInteger.valueOf(0x20000000000000L);
                    bigInteger = bigInteger4;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 1: {
                    BigInteger bigInteger5 = BigInteger.valueOf(this.decimalUpperBound($this$h2UpperBound, true));
                    bigInteger = bigInteger5;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                    return bigInteger;
                }
                case 3: {
                    BigInteger bigInteger6 = BigInteger.valueOf(this.decimalUpperBound($this$h2UpperBound, false));
                    bigInteger = bigInteger6;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                    return bigInteger;
                }
            }
        }
        BigInteger bigInteger7 = DasTypeUtilsKt.getMaxValue($this$h2UpperBound);
        bigInteger = bigInteger7;
        if (bigInteger7 != null) return bigInteger;
        BigInteger bigInteger8 = BigInteger.valueOf(Long.MAX_VALUE);
        bigInteger = bigInteger8;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    private final long decimalUpperBound(DasType $this$decimalUpperBound, boolean exclusive) {
        long l;
        DataType dataType = $this$decimalUpperBound.toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        DataType dt = dataType;
        int p = dt.getPrecision() - dt.scale;
        boolean bl = 1 <= p ? p < 19 : false;
        if (bl) {
            void $this$fold$iv;
            Iterable iterable = (Iterable)new IntRange(1, p);
            long initial$iv = 1L;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv = ((IntIterator)iterator).nextInt();
                long res = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = res * (long)10;
            }
            long result = accumulator$iv;
            if (exclusive) {
                long l2 = result;
                result = l2 + -1L;
            }
            l = result;
        } else {
            l = Long.MAX_VALUE;
        }
        return l;
    }

    private static final boolean convertSequences$lambda$0(String $sequenceCode, ModelElementMem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$sequenceCode);
    }
}

