/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.DjangoRunnerUtilsKt;
import com.intellij.python.django.run.DjangoServerRunConfiguration;
import com.intellij.python.django.run.UrlFilterWithRedirection;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.python.remote.RemoteProcessControl;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoServerRunCommandLineState
extends PythonCommandLineState {
    private static final String COMMAND_RUNSERVER = "runserver";
    private static final String COMMAND_TESTSERVER = "testserver";
    private static final String COMMAND_RUNCONCURRENTSERVER = "runconcurrentserver";
    private static final String OPTION_NO_RELOAD = "--noreload";
    private static final String OPTION_ADDRPORT = "--addrport";
    private static final int DEFAULT_DJANGO_SERVER_PORT = 8000;
    private final DjangoServerRunConfiguration myConfig;

    public DjangoServerRunCommandLineState(DjangoServerRunConfiguration config, ExecutionEnvironment environment) {
        super((AbstractPythonRunConfiguration)config, environment);
        this.myConfig = config;
        Module module = this.myConfig.getModule();
        if (module != null && !this.myConfig.getEnvs().containsKey("DJANGO_SETTINGS_MODULE") && !System.getenv().containsKey("DJANGO_SETTINGS_MODULE")) {
            DjangoUtil.addDjangoSettingsToEnv(module, this.myConfig.getEnvs(), false);
        }
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.withEnvironment(DjangoRunnerUtilsKt.fixEnvsIfNeeded(SystemInfo.isWin10OrNewer, commandLine.getEnvironment(), System.getenv()));
        return PythonProcessRunner.createProcessHandlingCtrlC((GeneralCommandLine)commandLine);
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        Module module = this.myConfig.getModule();
        commandLine.setWorkDirectory(DjangoServerRunCommandLineState.getWorkingDir(this.myConfig));
        ParametersList params = commandLine.getParametersList();
        ParamsGroup exe_options = params.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParams = params.getParamsGroup("Script");
        assert (scriptParams != null);
        String manageScript = DjangoServerRunCommandLineState.getManageScriptPath(module, this.myConfig.getInterpreterPath());
        if (manageScript != null) {
            scriptParams.addParameter(manageScript);
        }
        List<String> paramsList = DjangoServerRunCommandLineState.getParametersForManageScript(this.myConfig);
        paramsList.forEach(param -> scriptParams.addParameter(param));
        List<String> hostPortParams = DjangoServerRunCommandLineState.getHostPortParams(this.myConfig);
        hostPortParams.forEach(param -> scriptParams.addParameter(param));
        String additionalOptions = this.myConfig.getAdditionalOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            scriptParams.addParametersString(additionalOptions);
        }
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        if (helpersAwareRequest == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        PythonScriptExecution djangoExecution = new PythonScriptExecution();
        Module module = this.myConfig.getModule();
        String manageScript = DjangoServerRunCommandLineState.getManageScriptPath(module, this.myConfig.getInterpreterPath());
        if (manageScript != null) {
            djangoExecution.setPythonScriptPath(TargetEnvironmentFunctions.targetPath((Path)Path.of(manageScript, new String[0])));
        }
        List<String> paramsList = DjangoServerRunCommandLineState.getParametersForManageScript(this.myConfig);
        paramsList.forEach(param -> djangoExecution.addParameter(param));
        List<String> hostPortParams = DjangoServerRunCommandLineState.getHostPortParams(this.myConfig);
        hostPortParams.forEach(param -> djangoExecution.addParameter(param));
        String additionalOptions = this.myConfig.getAdditionalOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            PythonScripts.addParametersString((PythonExecution)djangoExecution, (String)additionalOptions);
        }
        PythonScriptExecution pythonScriptExecution = djangoExecution;
        if (pythonScriptExecution == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(1);
        }
        return pythonScriptExecution;
    }

    @Nullable
    protected Function<TargetEnvironment, String> getPythonExecutionWorkingDir(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (targetEnvironmentRequest == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(2);
        }
        Module module = this.myConfig.getModule();
        String workingDir = !StringUtil.isEmpty((String)this.myConfig.getWorkingDirectory()) ? PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)this.myConfig) : (module != null ? DjangoUtil.getProjectRoot((Module)module) : null);
        if (workingDir == null) {
            return null;
        }
        return TargetEnvironmentFunctions.targetPath((Path)Path.of(workingDir, new String[0]));
    }

    private static boolean isRunServerCommand(DjangoServerRunConfiguration configuration) {
        String command = configuration.getCustomRunCommand();
        return COMMAND_RUNSERVER.equals(command) || COMMAND_RUNCONCURRENTSERVER.equals(command);
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler processHandler) {
        int port;
        HostAndPort localTunnel;
        if (processHandler instanceof RemoteProcessControl && this.myConfig.getHost() != null && (localTunnel = ((RemoteProcessControl)processHandler).getLocalTunnel(port = this.myConfig.getPort() != null ? this.myConfig.getPort() : 8000)) != null) {
            return new UrlFilterWithRedirection(Collections.singletonMap(HostAndPort.fromParts((String)this.myConfig.getHost(), (int)port), localTunnel));
        }
        UrlFilter urlFilter = super.createUrlFilter(processHandler);
        if (urlFilter == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(3);
        }
        return urlFilter;
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = super.createAndAttachConsole(project, processHandler, executor);
        if (DjangoUtil.getManageScript((Module)this.myConfig.getModule()).isEmpty()) {
            consoleView.print("No manage.py file specified in Settings->Django Support\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(4);
        }
        return consoleView2;
    }

    private boolean needNoReload() {
        return this.myConfig.isRunNoReload();
    }

    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = super.startProcess(processStarter, patchers);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler, this.myConfig.getBrowserUrl(), "development server", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(5);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler startProcess(@NotNull PythonScriptTargetedCommandLineBuilder builder) throws ExecutionException {
        if (builder == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(6);
        }
        ProcessHandler processHandler = super.startProcess(builder);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler, this.myConfig.getBrowserUrl(), "development server", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(7);
        }
        return processHandler2;
    }

    public static void addRunBrowserListener(ProcessHandler processHandler, final String url, final String signature, RunConfiguration runConfiguration, boolean launchJavascriptDebugger) {
        if (launchJavascriptDebugger && JavaScriptDebuggerStarter.Util.start((RunConfiguration)runConfiguration, (String)url)) {
            return;
        }
        if (!StringUtil.isEmpty((String)url)) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    if (StringUtil.toLowerCase((String)event.getText()).contains(signature)) {
                        browserStarted.set((Object)true);
                        BrowserUtil.browse((String)url);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/python/django/run/DjangoServerRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static String getWorkingDir(DjangoServerRunConfiguration configuration) {
        Module module = configuration.getModule();
        if (module != null && StringUtil.isEmpty((String)configuration.getWorkingDirectory())) {
            return DjangoCoreUtil.getProjectRoot((Module)module);
        }
        return PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)configuration);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getManageScriptPath(@Nullable Module module, @Nullable String interpreterPath) {
        String manageScript = DjangoCoreUtil.getManageScript((Module)module);
        if (manageScript.isEmpty()) {
            manageScript = DjangoCoreUtil.getDjangoAdmin((String)interpreterPath);
        }
        return manageScript;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<String> getParametersForManageScript(@NotNull DjangoServerRunConfiguration configuration) {
        if (configuration == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(8);
        }
        ArrayList<String> params = new ArrayList<String>();
        if (configuration.isUseCustomRunCommand()) {
            params.add(configuration.getCustomRunCommand());
            if (DjangoServerRunCommandLineState.isRunServerCommand(configuration) && configuration.isRunNoReload() || configuration.isRunNoReload()) {
                params.add(OPTION_NO_RELOAD);
            }
        } else if (!configuration.isRunTestServer()) {
            params.add(COMMAND_RUNSERVER);
            if (configuration.isRunNoReload()) {
                params.add(OPTION_NO_RELOAD);
            }
        } else {
            params.add(COMMAND_TESTSERVER);
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<String> getHostPortParams(@NotNull DjangoServerRunConfiguration configuration) {
        String host;
        if (configuration == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(10);
        }
        ArrayList<String> params = new ArrayList<String>();
        Object hostPort = null;
        Integer port = configuration.getPort();
        if (port != null) {
            hostPort = Integer.toString(port);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(host = configuration.getHost()))) {
            if (hostPort == null) {
                hostPort = "8000";
            }
            hostPort = host + ":" + (String)hostPort;
        }
        if (hostPort != null) {
            if (configuration.isRunTestServer()) {
                params.add(OPTION_ADDRPORT);
            }
            params.add((String)hostPort);
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareRequest";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/run/DjangoServerRunCommandLineState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/run/DjangoServerRunCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersForManageScript";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostPortParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutionWorkingDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParametersForManageScript";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHostPortParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

