/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.run.BrowserUrlPanel;
import com.intellij.python.django.run.DjangoServerRunConfiguration;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class DjangoServerRunConfigurationEditor
extends SettingsEditor<DjangoServerRunConfiguration>
implements PanelWithAnchor {
    private JPanel myPanel;
    private JTextField myPort;
    private JTextField myAdditionalOptionsTextField;
    private JTextField myHostTextField;
    private JCheckBox myRunTestServerCheckBox;
    private JCheckBox myRunNoReloadCheckBox;
    private JPanel myRunBrowserPanelHolder;
    private JPanel myCommonOptionsFormPlaceholder;
    private JBCheckBox myCustomRunCommandCheckBox;
    private JTextField myCustomRunCommandTextField;
    private JBLabel myAdditionalOptionsLabel;
    private final BrowserUrlPanel myBrowserUrlPanel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;

    public DjangoServerRunConfigurationEditor(DjangoServerRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsFormPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.myBrowserUrlPanel = new BrowserUrlPanel(){

            @Override
            protected String getHost() {
                return DjangoServerRunConfigurationEditor.this.myHostTextField.getText();
            }

            @Override
            protected String getPort() {
                return DjangoServerRunConfigurationEditor.this.myPort.getText();
            }
        };
        this.myRunBrowserPanelHolder.add((Component)this.myBrowserUrlPanel, "Center");
        this.myBrowserUrlPanel.watch(this.myHostTextField, this.myPort);
        this.myRunTestServerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = !DjangoServerRunConfigurationEditor.this.myRunTestServerCheckBox.isSelected();
                DjangoServerRunConfigurationEditor.this.myRunNoReloadCheckBox.setEnabled(selected);
                DjangoServerRunConfigurationEditor.this.myCustomRunCommandCheckBox.setEnabled(selected);
            }
        });
        this.myCustomRunCommandCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = DjangoServerRunConfigurationEditor.this.myCustomRunCommandCheckBox.isSelected();
                DjangoServerRunConfigurationEditor.this.myCustomRunCommandTextField.setEnabled(selected);
                DjangoServerRunConfigurationEditor.this.myRunTestServerCheckBox.setEnabled(!selected);
            }
        });
        this.myCustomRunCommandTextField.setEnabled(false);
        this.setAnchor((JComponent)this.myCustomRunCommandCheckBox);
    }

    protected void resetEditorFrom(@NotNull DjangoServerRunConfiguration s) {
        if (s == null) {
            DjangoServerRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)s, (AbstractPythonRunConfigurationParams)this.myCommonOptionsForm);
        Integer port = s.getPort();
        this.myPort.setText(port != null ? Integer.toString(port) : "");
        this.myHostTextField.setText(s.getHost());
        this.myAdditionalOptionsTextField.setText(s.getAdditionalOptions());
        this.myBrowserUrlPanel.setBrowserUrl(s.getBrowserUrl());
        this.myRunTestServerCheckBox.setSelected(s.isRunTestServer());
        this.myRunNoReloadCheckBox.setSelected(s.isRunNoReload());
        this.myCustomRunCommandCheckBox.setSelected(s.isUseCustomRunCommand());
        this.myCustomRunCommandTextField.setText(s.getCustomRunCommand());
        this.myBrowserUrlPanel.setLaunchJavascriptDebugger(s.isLaunchJavascriptDebugger());
    }

    protected void applyEditorTo(@NotNull DjangoServerRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            DjangoServerRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)this.myCommonOptionsForm, (AbstractPythonRunConfigurationParams)s);
        Integer port = null;
        String strPort = this.myPort.getText();
        if (!StringUtil.isEmpty((String)strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(DjangoBundle.message((String)"port-error", (Object[])new Object[0]));
            }
        }
        s.setPort(port);
        s.setHost(this.myHostTextField.getText());
        s.setAdditionalOptions(this.myAdditionalOptionsTextField.getText());
        s.setBrowserUrl(this.myBrowserUrlPanel.getBrowserUrl());
        s.setRunTestServer(this.myRunTestServerCheckBox.isSelected());
        s.setRunNoReload(this.myRunNoReloadCheckBox.isSelected());
        s.setUseCustomRunCommand(this.myCustomRunCommandCheckBox.isSelected());
        s.setCustomRunCommand(this.myCustomRunCommandTextField.getText());
        s.setLaunchJavascriptDebugger(this.myBrowserUrlPanel.isLaunchJavascriptDebugger());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DjangoServerRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myCommonOptionsForm.setAnchor(anchor);
        this.myAdditionalOptionsLabel.setAnchor(anchor);
        this.myBrowserUrlPanel.setAnchor(anchor);
        this.myCustomRunCommandCheckBox.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/run/DjangoServerRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/run/DjangoServerRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JTextField jTextField4;
        JBLabel jBLabel;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdditionalOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("django.server.run.config.additional.options"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsTextField = jTextField4 = new JTextField();
        jPanel3.add((Component)jTextField4, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("django.server.run.config.host"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jTextField3 = new JTextField();
        jTextField3.setColumns(20);
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRunTestServerCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("django.server.run.config.test.server"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myRunBrowserPanelHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myRunNoReloadCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("django.server.run.config.no.reload"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myCustomRunCommandCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("django.server.run.config.custom.command"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomRunCommandTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(20);
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCommonOptionsFormPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoServerRunConfigurationEditor.class).getString("port"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPort = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(4);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, new Dimension(70, -1), new Dimension(70, -1)));
        jBLabel.setLabelFor(jTextField4);
        jLabel.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

