/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.util.TarCompressionUtil;
import com.intellij.docker.remoteRunRuntime.WrappedConflictException;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.remoteRunRuntime.WrappedNotModifiedException;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0013H\u0007JV\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0013H\u0007J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0018\u0010\u0016\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017H\u0007J!\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u0002H\u001a\u0012\b\b\u0001\u0012\u0004\u0018\u00010 0\u001fH\u0007\u00a2\u0006\u0002\u0010!JL\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00152\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0013H\u0007JL\u0010\"\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00102\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0013H\u0007JL\u0010\"\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00152\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0013H\u0003J\u0018\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0007J0\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u000201H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/docker/utils/RemoteDockerRuntimeUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "download", "", "application", "Lcom/intellij/docker/agent/DockerAgentContainer;", "resourcePath", "", "targetFile", "Ljava/io/File;", "remoteToLocalPathName", "", "machineName", "remotePathFilter", "Ljava/util/function/Predicate;", "remoteToLocalMapping", "Lcom/intellij/util/Function;", "extractor", "Lcom/intellij/util/ThrowableConsumer;", "Ljava/io/IOException;", "executeAgentTask", "T", "future", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "Lcom/intellij/remoteServer/util/ServerRuntimeException;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "extractTar", "tarFile", "inputStream", "Ljava/io/InputStream;", "replacePathPrefix", "path", "newPrefix", "copyTarEntry", "tarInputStream", "Lorg/apache/commons/compress/archivers/tar/TarArchiveInputStream;", "tarEntry", "Lorg/apache/commons/compress/archivers/tar/TarArchiveEntry;", "targetDir", "localPathName", "isStubbed", "", "intellij.clouds.docker"})
public final class RemoteDockerRuntimeUtil {
    @NotNull
    public static final RemoteDockerRuntimeUtil INSTANCE = new RemoteDockerRuntimeUtil();
    @NotNull
    private static final Logger LOG;

    private RemoteDockerRuntimeUtil() {
    }

    @JvmStatic
    public static final void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName, @Nullable Predicate<String> remotePathFilter) throws IOException, ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        RemoteDockerRuntimeUtil.download(application, resourcePath, targetFile, (Function<String, String>)(remoteToLocalPathName == null ? null : arg_0 -> RemoteDockerRuntimeUtil.download$lambda$0(remoteToLocalPathName, arg_0)), machineName, remotePathFilter);
    }

    @JvmStatic
    public static final void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable String machineName, @Nullable Predicate<String> remotePathFilter) throws IOException, ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        RemoteDockerRuntimeUtil.download(application, resourcePath, machineName, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)arg_0 -> RemoteDockerRuntimeUtil.download$lambda$2(arg_0 -> RemoteDockerRuntimeUtil.download$lambda$1(resourcePath, targetFile, remoteToLocalMapping, remotePathFilter, arg_0), arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @Nullable String machineName, @NotNull ThrowableConsumer<? super File, ? extends IOException> extractor) throws IOException, ServerRuntimeException {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        File file = FileUtil.createTempFile((String)String.valueOf(application.getContainerId().hashCode()), (String)".download.tar");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tarFile = file;
        try {
            objectArray = (Object[])new FileOutputStream(tarFile);
            Throwable throwable = null;
            try {
                FileOutputStream tarOutputStream = (FileOutputStream)objectArray;
                boolean bl = false;
                Object[] objectArray2 = new Object[]{resourcePath, "' resource from Docker container '", application.getContainerId(), "' created at Docker machine ", "'", machineName, "' to '", tarFile.getAbsolutePath(), "'"};
                LOG.debug("Downloading '", objectArray2);
                Closeable closeable = (Closeable)RemoteDockerRuntimeUtil.executeAgentTask(application.copyArchiveFromContainer(resourcePath));
                Throwable throwable2 = null;
                try {
                    InputStream requestInputStream = (InputStream)closeable;
                    boolean bl2 = false;
                    long size = IOUtils.copyLarge((InputStream)requestInputStream, (OutputStream)tarOutputStream);
                    Object[] objectArray3 = new Object[]{size, " bytes from container '", application.getContainerId(), "' to '", tarFile.getAbsolutePath(), "'"};
                    LOG.debug("Downloaded ", objectArray3);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)objectArray, (Throwable)throwable);
            }
            extractor.consume((Object)tarFile);
            if (tarFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tarFile.delete()) throw throwable;
            Object[] objectArray4 = new Object[]{tarFile.getPath(), "'"};
            LOG.debug("Failed to delete temporary tar file '", objectArray4);
            throw throwable;
        }
        objectArray = new Object[]{tarFile.getPath(), "'"};
        LOG.debug("Failed to delete temporary tar file '", objectArray);
    }

    @JvmStatic
    public static final <T> T executeAgentTask(@NotNull CompletableFuture<T> future) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        return RemoteDockerRuntimeUtil.executeAgentTask(() -> RemoteDockerRuntimeUtil.executeAgentTask$lambda$0(future));
    }

    @JvmStatic
    public static final <T> T executeAgentTask(@NotNull ThrowableComputable<T, ? extends ServerRuntimeException> computable) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        try {
            return (T)computable.compute();
        }
        catch (ServerRuntimeException e) {
            String message;
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            if (StringsKt.contains$default((CharSequence)(message = string), (CharSequence)"NotFoundException", (boolean)false, (int)2, null)) {
                throw new WrappedNotFoundException(message);
            }
            if (StringsKt.contains$default((CharSequence)message, (CharSequence)"InternalServerErrorException", (boolean)false, (int)2, null)) {
                throw new WrappedInternalServerErrorException(message);
            }
            if (StringsKt.contains$default((CharSequence)message, (CharSequence)"NotModifiedException", (boolean)false, (int)2, null)) {
                throw new WrappedNotModifiedException(message);
            }
            if (StringsKt.contains$default((CharSequence)message, (CharSequence)"ConflictException", (boolean)false, (int)2, null)) {
                throw new WrappedConflictException(message);
            }
            throw e;
        }
    }

    @JvmStatic
    public static final void extractTar(@NotNull File tarFile, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable Predicate<String> remotePathFilter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Object[] objectArray = new Object[]{tarFile.getAbsoluteFile(), "' to '", targetFile.getPath(), "'"};
        LOG.debug("Extracting '", objectArray);
        RemoteDockerRuntimeUtil.extractTar((InputStream)new BufferedInputStream(new FileInputStream(tarFile)), resourcePath, targetFile, remoteToLocalMapping, remotePathFilter);
    }

    @JvmStatic
    public static final void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable Predicate<String> remotePathFilter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        RemoteDockerRuntimeUtil.extractTar(inputStream, resourcePath, targetFile, (Function<String, String>)(remoteToLocalPathName == null ? null : arg_0 -> RemoteDockerRuntimeUtil.extractTar$lambda$0(remoteToLocalPathName, arg_0)), remotePathFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final void extractTar(InputStream inputStream, String resourcePath, File targetFile, Function<String, String> remoteToLocalMapping, Predicate<String> remotePathFilter) throws IOException {
        Closeable closeable = (Closeable)new TarArchiveInputStream(TarCompressionUtil.decompressStream((InputStream)inputStream));
        Throwable throwable = null;
        try {
            TarArchiveInputStream tarInputStream = (TarArchiveInputStream)closeable;
            boolean bl = false;
            TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
            while (tarEntry != null) {
                if ((tarEntry.isFile() || tarEntry.isDirectory()) && StringUtil.isNotEmpty((String)tarEntry.getName())) {
                    boolean isStubbed;
                    String remoteParentPathName;
                    Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)resourcePath), (String)"getParentPath(...)");
                    CharSequence[] charSequenceArray = new CharSequence[]{remoteParentPathName, tarEntry.getName()};
                    String remotePathName = FileUtil.toCanonicalPath((String)String.join((CharSequence)"/", charSequenceArray), (char)'/');
                    boolean bl2 = isStubbed = remotePathFilter != null && !remotePathFilter.test(remotePathName);
                    if (remoteToLocalMapping == null) {
                        String string = tarEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = targetFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        localPathName = RemoteDockerRuntimeUtil.replacePathPrefix(string, string2);
                        File file = targetFile.getParentFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                        INSTANCE.copyTarEntry(tarInputStream, tarEntry, file, localPathName, isStubbed);
                    } else {
                        localPathName = (String)remoteToLocalMapping.fun((Object)remotePathName);
                        if (localPathName != null) {
                            INSTANCE.copyTarEntry(tarInputStream, tarEntry, targetFile, localPathName, isStubbed);
                        } else {
                            LOG.debug("Remote file '" + remotePathName + "' skipped");
                        }
                    }
                }
                tarEntry = tarInputStream.getNextTarEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final String replacePathPrefix(@NotNull String path2, @NotNull String newPrefix) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)newPrefix, (String)"newPrefix");
        int index = StringsKt.indexOf$default((CharSequence)path2, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            index = path2.length();
        }
        String string = path2.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return newPrefix + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyTarEntry(TarArchiveInputStream tarInputStream, TarArchiveEntry tarEntry, File targetDir, String localPathName, boolean isStubbed) throws IOException {
        if (SystemInfo.isWindows && StringsKt.contains$default((CharSequence)localPathName, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            LOG.info("Extraction path '" + localPathName + "' contains backslashes, which will be treated as path separators");
        }
        File targetFile = new File(targetDir, localPathName);
        if (tarEntry.isFile()) {
            if (!FileUtil.createParentDirs((File)targetFile)) {
                LOG.warn("Failed to create parent directories for file '" + targetFile + "' it will be skipped");
                return;
            }
            if (isStubbed) {
                FileUtil.createIfDoesntExist((File)targetFile);
                return;
            }
            Closeable closeable = new FileOutputStream(targetFile);
            Throwable throwable = null;
            try {
                FileOutputStream entryOutputStream = (FileOutputStream)closeable;
                boolean bl = false;
                Long l = IOUtils.copyLarge((InputStream)((InputStream)tarInputStream), (OutputStream)entryOutputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (tarEntry.isDirectory()) {
            FileUtil.createDirectory((File)targetFile);
        } else {
            LOG.warn("Failed to copy entry of unknown type '" + targetFile + "', it will be skipped");
        }
    }

    private static final String download$lambda$0(Map $remoteToLocalPathName, String key) {
        return (String)$remoteToLocalPathName.get(key);
    }

    private static final Unit download$lambda$1(String $resourcePath, File $targetFile, Function $remoteToLocalMapping, Predicate $remotePathFilter, File tarFile) {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        RemoteDockerRuntimeUtil.extractTar(tarFile, $resourcePath, $targetFile, (Function<String, String>)$remoteToLocalMapping, (Predicate<String>)$remotePathFilter);
        return Unit.INSTANCE;
    }

    private static final void download$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object executeAgentTask$lambda$0(CompletableFuture $future) {
        Object object;
        try {
            object = CoroutinesKt.runBlockingMaybeCancellable((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>($future, null){
                int label;
                final /* synthetic */ CompletableFuture<T> $future;
                {
                    this.$future = $future;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InternalUtilsKt.awaitOnIO(this.$future, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof ServerRuntimeException) {
                throw e;
            }
            if (exception instanceof CancellationException) {
                throw e;
            }
            throw new ServerRuntimeException((Throwable)e);
        }
        return object;
    }

    private static final String extractTar$lambda$0(Map $remoteToLocalPathName, String key) {
        return (String)$remoteToLocalPathName.get(key);
    }

    static {
        Logger logger = Logger.getInstance(RemoteDockerRuntimeUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

