/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.jupyter.py.colab.assignments.ColabAssignedServer;
import com.intellij.jupyter.py.colab.auth.GoogleOAuthService;
import com.intellij.jupyter.py.colab.storage.ServerStorage;
import com.intellij.jupyter.py.colab.storage.ServerStorageKt;
import com.intellij.jupyter.py.colab.storage.StoredServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\rJ \u0010\u0017\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0002J\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00180\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/py/colab/storage/ServerStorage;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cache", "", "Lcom/intellij/jupyter/py/colab/assignments/ColabAssignedServer;", "listCached", "refreshAndListServers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refresh", "", "get", "id", "", "store", "servers", "remove", "", "serverId", "clear", "storeServers", "Lcom/intellij/jupyter/py/colab/storage/StoredServer;", "existingServersJson", "mapServersById", "", "json", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "intellij.jupyter.py.colab"})
@SourceDebugExtension(value={"SMAP\nServerStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerStorage.kt\ncom/intellij/jupyter/py/colab/storage/ServerStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1563#2:226\n1634#2,3:227\n1056#2:231\n1208#2,2:232\n1236#2,4:234\n1#3:230\n*S KotlinDebug\n*F\n+ 1 ServerStorage.kt\ncom/intellij/jupyter/py/colab/storage/ServerStorage\n*L\n73#1:226\n73#1:227,3\n164#1:231\n184#1:232,2\n184#1:234,4\n*E\n"})
public final class ServerStorage
implements Disposable.Default {
    @NotNull
    private final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
    @Nullable
    private volatile List<ColabAssignedServer> cache;

    @NotNull
    public final List<ColabAssignedServer> listCached() {
        List list = this.cache;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object refreshAndListServers(@NotNull Continuation<? super List<ColabAssignedServer>> $completion) {
        if (!($completion instanceof refreshAndListServers.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ServerStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.refreshAndListServers((Continuation<? super List<ColabAssignedServer>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.refresh((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return this.listCached();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object refresh(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof refresh.1)) ** GOTO lbl-1000
        var17_2 = $completion;
        if ((var17_2.label & -2147483648) != 0) {
            var17_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ServerStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.refresh((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!GoogleOAuthService.Companion.getInstance().isSingIn()) {
                    this.cache = CollectionsKt.emptyList();
                    return Unit.INSTANCE;
                }
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    return Unit.INSTANCE;
                }
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Credentials>, Object>(this, null){
                    int label;
                    final /* synthetic */ ServerStorage this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return PasswordSafe.Companion.getInstance().get(ServerStorage.access$createCredentialAttributes(this.this$0));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Credentials> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var18_4) {
                    return var18_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = credentials = (Credentials)v0;
                v2 = serversJson = v1 != null ? v1.getPasswordAsString() : null;
                if (serversJson != null) {
                    storedServers = (List)this.objectMapper.readValue(serversJson, (TypeReference)new TypeReference<List<? extends StoredServer>>(){});
                    Intrinsics.checkNotNull((Object)storedServers);
                    $this$map$iv = storedServers;
                    $i$f$map = false;
                    var8_10 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var13_15 = (StoredServer)item$iv$iv;
                        var15_17 = destination$iv$iv;
                        $i$a$-map-ServerStorage$refresh$servers$1 = false;
                        var15_17.add(ServerStorageKt.access$toAssignedServer((StoredServer)it));
                    }
                    v3 = (List)destination$iv$iv;
                } else {
                    v3 = CollectionsKt.emptyList();
                }
                this.cache = servers = v3;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final ColabAssignedServer get(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.listCached();
            for (Object t : iterable) {
                ColabAssignedServer it = (ColabAssignedServer)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void store(@NotNull List<ColabAssignedServer> servers2) {
        Credentials credentials2;
        Intrinsics.checkNotNullParameter(servers2, (String)"servers");
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        Credentials credentials3 = credentials2 = PasswordSafe.Companion.getInstance().get(this.createCredentialAttributes());
        String existingServersJson = credentials3 != null ? credentials3.getPasswordAsString() : null;
        Map serversById = MapsKt.toMutableMap(this.mapServersById(existingServersJson));
        for (ColabAssignedServer server : servers2) {
            Instant existingDateAssigned;
            Instant instant;
            Instant instant2;
            if ((StoredServer)serversById.get(server.getId()) != null) {
                StoredServer stored;
                boolean bl = false;
                instant2 = Instant.ofEpochMilli(stored.getDateAssigned());
            } else {
                instant2 = null;
            }
            if ((instant = (existingDateAssigned = instant2)) == null) {
                instant = server.getDateAssigned();
            }
            Instant dateAssigned = instant;
            serversById.put(server.getId(), ServerStorageKt.access$toStoredServer(ColabAssignedServer.copy$default(server, null, null, null, null, null, null, dateAssigned, 63, null)));
        }
        this.storeServers(CollectionsKt.toList((Iterable)serversById.values()), existingServersJson);
    }

    public final boolean remove(@NotNull String serverId) {
        Credentials credentials2;
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        Credentials credentials3 = credentials2 = PasswordSafe.Companion.getInstance().get(this.createCredentialAttributes());
        String existingServersJson = credentials3 != null ? credentials3.getPasswordAsString() : null;
        Map serversById = MapsKt.toMutableMap(this.mapServersById(existingServersJson));
        if (serversById.remove(serverId) == null) {
            return false;
        }
        this.storeServers(CollectionsKt.toList((Iterable)serversById.values()), existingServersJson);
        return true;
    }

    public final void clear() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        PasswordSafe.Companion.getInstance().set(this.createCredentialAttributes(), null);
        this.cache = null;
    }

    private final void storeServers(List<StoredServer> servers2, String existingServersJson) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        Iterable $this$sortedBy$iv = servers2;
        boolean $i$f$sortedBy = false;
        List serversSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StoredServer it = (StoredServer)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (StoredServer)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
        String newServersJson = this.objectMapper.writeValueAsString((Object)serversSorted);
        if (Intrinsics.areEqual((Object)newServersJson, (Object)existingServersJson)) {
            return;
        }
        Credentials credentials2 = new Credentials(null, newServersJson);
        PasswordSafe.Companion.getInstance().set(this.createCredentialAttributes(), credentials2);
        this.cache = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, StoredServer> mapServersById(String json) {
        void $this$associateByTo$iv$iv;
        if (json == null) {
            return MapsKt.emptyMap();
        }
        List servers2 = (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<List<? extends StoredServer>>(){});
        Intrinsics.checkNotNull((Object)servers2);
        Iterable $this$associateBy$iv = servers2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            StoredServer storedServer = (StoredServer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final CredentialAttributes createCredentialAttributes() {
        return new CredentialAttributes("colab.assigned_servers");
    }

    public static final /* synthetic */ CredentialAttributes access$createCredentialAttributes(ServerStorage $this) {
        return $this.createCredentialAttributes();
    }
}

