/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"isPythonNotebook", "", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getCellPositionForJupyterCell", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getPythonJupyterPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "originalFile", "isNotebookEditor", "backedNotebookVirtualFile", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.py"})
public final class JupyterFileUtilKt {
    public static final boolean isPythonNotebook(@Nullable BackedNotebookVirtualFile virtualFile) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = virtualFile;
        return backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getNotebookOrNull()) != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getLanguage()) != null ? backedNotebookVirtualFile.isKindOf((Language)PythonLanguage.INSTANCE) : false;
    }

    @Nullable
    public static final JupyterCellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(file, cell.getLines().getFirst());
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition startSourcePosition = xSourcePosition;
        return new JupyterCellSourcePosition(startSourcePosition);
    }

    @Nullable
    public static final JupyterCellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull NotebookIntervalPointer cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        NotebookCellLines.Interval interval = cell.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return JupyterFileUtilKt.getCellPositionForJupyterCell(file, interval2);
    }

    @Nullable
    public static final PsiFile getPythonJupyterPsiFile(@NotNull Project project, @NotNull VirtualFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        ThreadingAssertions.assertReadAccess();
        if (project.isDisposed()) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterHelper.INSTANCE.getJupyterVirtualFileByOriginalVirtualFile(originalFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(jupyterVirtualFile.getFile());
        return psiFile2 != null && (psiFile2 = psiFile2.getViewProvider()) != null ? psiFile2.getPsi((Language)JupyterPyDialect.INSTANCE) : null;
    }

    public static final boolean isNotebookEditor(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return JupyterEditorExtensionsKt.isJupyter((Editor)editor) && Intrinsics.areEqual((Object)JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor), (Object)backedNotebookVirtualFile);
    }
}

