/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.pyramid.run.PyramidRunConfiguration;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyramidRunCommandLineState
extends PythonCommandLineState {
    @NonNls
    private static final String EVENT_SIGNATURE = "Starting server in";
    @ApiStatus.Internal
    @NonNls
    public static final String PYCHARM_EP_DIST = "PYCHARM_EP_DIST";
    @ApiStatus.Internal
    @NonNls
    public static final String PYCHARM_EP_NAME = "PYCHARM_EP_NAME";
    @ApiStatus.Internal
    @NonNls
    public static final String EP_DIST_PYRAMID = "pyramid";
    @ApiStatus.Internal
    @NonNls
    public static final String EP_NAME_PSERVE = "pserve";
    private final PyramidRunConfiguration myConfig;

    public PyramidRunCommandLineState(PyramidRunConfiguration config, ExecutionEnvironment environment) {
        super((AbstractPythonRunConfiguration)config, environment);
        this.myConfig = config;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String additionalOptions;
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        PythonHelper.LOAD_ENTRY_POINT.addToGroup(scriptParameters, commandLine);
        String myConfigTarget = this.myConfig.getConfigFile();
        if (myConfigTarget != null) {
            scriptParameters.addParametersString("\"" + myConfigTarget + "\"");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            scriptParameters.addParameters(additionalOptions.split(" "));
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)this.myConfig));
        }
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        String additionalOptions;
        if (helpersAwareRequest == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(0);
        }
        PythonScriptExecution pyramidScriptExecution = PythonScripts.prepareHelperScriptExecution((HelperPackage)PythonHelper.LOAD_ENTRY_POINT, (HelpersAwareTargetEnvironmentRequest)helpersAwareRequest);
        String myConfigTarget = this.myConfig.getConfigFile();
        if (myConfigTarget != null) {
            pyramidScriptExecution.addParameter(TargetEnvironmentFunctions.targetPath((Path)Path.of(myConfigTarget, new String[0])));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            for (String additionalOption : additionalOptions.split(" ")) {
                pyramidScriptExecution.addParameter(additionalOption);
            }
        }
        PythonScriptExecution pythonScriptExecution = pyramidScriptExecution;
        if (pythonScriptExecution == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(1);
        }
        return pythonScriptExecution;
    }

    public void customizeEnvironmentVars(Map<String, String> environment, boolean passParentEnvs) {
        super.customizeEnvironmentVars(environment, passParentEnvs);
        environment.put(PYCHARM_EP_DIST, EP_DIST_PYRAMID);
        environment.put(PYCHARM_EP_NAME, EP_NAME_PSERVE);
    }

    protected void customizePythonExecutionEnvironmentVars(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (helpersAwareTargetRequest == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(2);
        }
        if (envs == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(3);
        }
        super.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, envs, passParentEnvs);
        envs.put(PYCHARM_EP_DIST, TargetEnvironmentFunctions.constant((Object)EP_DIST_PYRAMID));
        envs.put(PYCHARM_EP_NAME, TargetEnvironmentFunctions.constant((Object)EP_NAME_PSERVE));
    }

    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = super.startProcess(processStarter, patchers);
        PyramidRunCommandLineState.addRunBrowserListener(processHandler, this.myConfig.getBrowserUrl(), EVENT_SIGNATURE);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(4);
        }
        return processHandler2;
    }

    public static void addRunBrowserListener(ProcessHandler processHandler, final String url, final @NonNls String signature) {
        if (!StringUtil.isEmpty((String)url)) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    if (event.getText().contains(signature)) {
                        browserStarted.set((Object)true);
                        BrowserUtil.browse((String)url);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/python/pyramid/run/PyramidRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareRequest";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pyramid/run/PyramidRunCommandLineState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pyramid/run/PyramidRunCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecution";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

