/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DdlMappingConfigurable
extends AbstractDatabaseConfigurable<DdlMapping> {
    private final DumpSourceScopeEditor myScopeEditor;
    private final AnActionLink myDataSourceLink;
    private final AnActionLink myDdlDataSourceLink;
    private long myLastSaveStamp;
    private final DdlMapping myTempMapping;
    private String myDataSourceId;
    private String myDdlDataSourceId;
    private final DatabaseNameComponent myNameComponent;
    private final JComponent myPanel;

    public DdlMappingConfigurable(@NotNull Project project, @NotNull DdlMapping target, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(1);
        }
        if (controller == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(2);
        }
        super(project, (Object)target);
        this.setController(controller);
        this.myTempMapping = target.copy(null, true);
        this.myNameComponent = new DatabaseNameComponent(this, controller, false);
        int length = 5;
        JPanel topPanel = new JPanel((LayoutManager)new GridLayoutManager(3, length));
        JBLabel dsLabel = new JBLabel(DatabaseBundle.message((String)"label.data.source", (Object[])new Object[0]));
        topPanel.add((Component)this.myNameComponent.getComponent(), DatabaseUIUtils.createSimpleConstraints(0, 0, length));
        topPanel.add((Component)dsLabel, DatabaseUIUtils.createLabelConstraints(1, 0, dsLabel.getPreferredSize().width));
        this.myDataSourceLink = new AnActionLink("", (AnAction)new ChooseLocalDsGroup());
        topPanel.add((Component)this.myDataSourceLink, DatabaseUIUtils.createSimpleConstraints(1, 1, length - 1));
        JBLabel ddlLabel = new JBLabel(DatabaseBundle.message((String)"label.ddl.data.source", (Object[])new Object[0]));
        topPanel.add((Component)ddlLabel, DatabaseUIUtils.createLabelConstraints(2, 0, ddlLabel.getPreferredSize().width));
        this.myDdlDataSourceLink = new AnActionLink("", (AnAction)new ChooseDdlDsGroup());
        topPanel.add((Component)this.myDdlDataSourceLink, DatabaseUIUtils.createSimpleConstraints(2, 1, length - 1));
        topPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myNameComponent.getComponent().setBorder(null);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)topPanel, "North");
        this.myScopeEditor = new DumpSourceScopeEditor();
        JPanel centerPanel = new JPanel(new BorderLayout());
        TitledSeparator separator = new TitledSeparator(DatabaseBundle.message((String)"separator.scope", (Object[])new Object[0]));
        separator.setBorder((Border)JBUI.Borders.emptyLeft((int)UIUtil.PANEL_REGULAR_INSETS.left));
        centerPanel.add((Component)separator, "North");
        centerPanel.add((Component)this.myScopeEditor.getComponent(), "Center");
        this.myPanel.add((Component)centerPanel, "Center");
        this.myDataSourceId = target.getDataSourceId();
        this.myDdlDataSourceId = target.getDdlDataSourceId();
        this.reset(target);
        this.onUserActivity();
        DdlMappingConfigurable.doNotStretchByText((JComponent)this.myDataSourceLink);
        DdlMappingConfigurable.doNotStretchByText((JComponent)this.myDdlDataSourceLink);
    }

    @NotNull
    public String getHelpTopic() {
        return "data.sources.and.drivers.dialog.ddl.mappings";
    }

    public Icon getIcon() {
        return DdlMappingConfigurable.getIcon(this.myController, this.myDataSourceId, this.myDdlDataSourceId);
    }

    public static Icon getIcon(@NotNull DatabaseConfigEditor controller, @Nullable String dataSourceId, @Nullable String ddlDataSourceId) {
        DbDataSource ds1;
        if (controller == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(3);
        }
        if ((ds1 = DdlMappingConfigurable.findDbDataSource(controller, dataSourceId)) != null) {
            return ds1.getDbms().getIcon();
        }
        DbDataSource ds2 = DdlMappingConfigurable.findDbDataSource(controller, ddlDataSourceId);
        if (ds2 != null) {
            return ds2.getDbms().getIcon();
        }
        return AllIcons.Actions.SwapPanels;
    }

    static void doNotStretchByText(JComponent link) {
        Dimension size = link.getPreferredSize();
        size.width = JBUI.scale((int)150);
        link.setPreferredSize(size);
        link.setMinimumSize(size);
    }

    private void setDdlDataSourceId(String dataSourceId) {
        this.myDdlDataSourceId = dataSourceId;
        this.fireChanged();
    }

    private void setDataSourceId(String dataSourceId) {
        this.myDataSourceId = dataSourceId;
        this.fireChanged();
    }

    public String getDisplayName() {
        return this.myNameComponent.getNameValue();
    }

    public JComponent createComponent() {
        return this.getComponent();
    }

    public boolean isModified() {
        if (this.isNewMapping()) {
            return true;
        }
        return !this.getTempTarget().equalConfiguration((DdlMapping)this.getTarget());
    }

    private boolean isNewMapping() {
        return DdlMappingsManager.getInstance((Project)this.getProject()).findById(((DdlMapping)this.getTarget()).getUniqueId()) == null;
    }

    public void apply() throws ConfigurationException {
        this.saveMapping((DdlMapping)this.myTarget);
        DdlMappingsManager.getInstance((Project)this.getProject()).update((DdlMapping)this.myTarget);
    }

    @NotNull
    public DdlMapping getTempTarget() {
        long curStamp = this.getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveMapping(this.myTempMapping);
        }
        DdlMapping ddlMapping = this.myTempMapping;
        if (ddlMapping == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(4);
        }
        return ddlMapping;
    }

    public boolean isTempTarget(@Nullable Object target) {
        return target == this.myTempMapping;
    }

    protected JComponent getComponent() {
        return this.myPanel;
    }

    private void saveMapping(@NotNull DdlMapping mapping) {
        if (mapping == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(5);
        }
        mapping.setName(this.myNameComponent.getNameValue());
        mapping.setDataSourceId(this.myDataSourceId);
        mapping.setDdlDataSourceId(this.myDdlDataSourceId);
        TreePattern scope2 = this.myScopeEditor.getEditorState();
        mapping.setScope(scope2.isEmpty() ? null : scope2);
    }

    protected void reset(@NotNull DdlMapping target) {
        if (target == null) {
            DdlMappingConfigurable.$$$reportNull$$$0(6);
        }
        this.myNameComponent.setNameValue(target.getName());
        this.setDataSourceId(target.getDataSourceId());
        this.setDdlDataSourceId(target.getDdlDataSourceId());
        this.myScopeEditor.setScopes(target.getScope(), target.getScope());
        this.myScopeEditor.updateDataSource();
    }

    @Nullable
    public JComponent getCommonBar() {
        return null;
    }

    @Nullable
    private LocalDataSource getDataSource(boolean forConnect) {
        LocalDataSource dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)DdlMappingConfigurable.findDataSource(this.myController, this.myDataSourceId), LocalDataSource.class);
        if (dataSource == null) {
            return null;
        }
        DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)this.myController.getConfigurable((Object)dataSource, false, DataSourceConfigurable.class));
        return configurable == null ? dataSource : (forConnect ? configurable.getTempDataSourceForConnection() : configurable.getTempDataSource());
    }

    @Nullable
    private static DbDataSource findDbDataSource(DatabaseConfigEditor controller, String dataSourceId) {
        if (dataSourceId == null) {
            return null;
        }
        return (DbDataSource)ContainerUtil.find((Iterable)controller.getDataSources(), ds -> ds.getUniqueId().equals(dataSourceId));
    }

    @Nullable
    private static DasDataSource findDataSource(DatabaseConfigEditor controller, String dataSourceId) {
        if (dataSourceId == null) {
            return null;
        }
        DbDataSource dbDs = DdlMappingConfigurable.findDbDataSource(controller, dataSourceId);
        return dbDs == null ? null : dbDs.getDelegate();
    }

    public void onUserActivity() {
        this.validateDeps();
    }

    protected void validateDeps() {
        this.updateDsLink(this.myDataSourceLink, this.myDataSourceId);
        this.updateDsLink(this.myDdlDataSourceLink, this.myDdlDataSourceId);
        this.myScopeEditor.updateDataSource();
    }

    private void updateDsLink(AnActionLink link, String dataSourceId) {
        DasDataSource dataSource;
        DbDataSource dbDataSource = DdlMappingConfigurable.findDbDataSource(this.myController, dataSourceId);
        DasDataSource dasDataSource = dataSource = dbDataSource == null ? null : (DasDataSource)this.myController.getTempTargetOrTarget((Object)dbDataSource.getDelegate());
        link.setText(dataSource == null ? (dataSourceId == null ? DatabaseBundle.message((String)"choose.data.source", (Object[])new Object[0]) : DatabaseBundle.message((String)"non.existing.data.source", (Object[])new Object[0])) : dataSource.getName());
        link.setIcon(dataSource == null ? null : dataSource.getIcon(0));
        String problem = dbDataSource == null ? SqlBundle.message((String)"notification.title.incomplete.configuration", (Object[])new Object[0]) : this.myController.getProblem((Object)dbDataSource);
        link.setForeground((Color)(problem != null ? JBColor.red : null));
        link.setToolTipText(problem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DdlMappingConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DdlMappingConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private class ChooseLocalDsGroup
    extends ChooseDsGroup {
        private ChooseLocalDsGroup() {
        }

        @Override
        protected String getCurrentId() {
            return DdlMappingConfigurable.this.myDataSourceId;
        }

        @Override
        protected boolean filter(DbDataSource dataSource) {
            return dataSource.getDelegate() instanceof LocalDataSource;
        }

        @Override
        protected void chosen(DasDataSource dataSource) {
            DdlMappingConfigurable.this.setDataSourceId(dataSource == null ? null : dataSource.getUniqueId());
        }

        @Override
        @NotNull
        protected AnAction getCreateAction() {
            DefaultActionGroup create2 = new DefaultActionGroup(DatabaseBundle.message((String)"action.create.text", (Object[])new Object[0]), DdlMappingConfigurable.this.getController().getAddLocalDataSourceActions(ds -> this.chosen((DasDataSource)ds)));
            create2.setPopup(true);
            DefaultActionGroup defaultActionGroup = create2;
            if (defaultActionGroup == null) {
                ChooseLocalDsGroup.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseLocalDsGroup", "getCreateAction"));
        }
    }

    private class ChooseDdlDsGroup
    extends ChooseDsGroup {
        private ChooseDdlDsGroup() {
        }

        @Override
        protected String getCurrentId() {
            return DdlMappingConfigurable.this.myDdlDataSourceId;
        }

        @Override
        protected boolean filter(DbDataSource dataSource) {
            return dataSource.getDelegate() instanceof SqlDataSource;
        }

        @Override
        protected void chosen(DasDataSource dataSource) {
            DdlMappingConfigurable.this.setDdlDataSourceId(dataSource == null ? null : dataSource.getUniqueId());
        }

        @Override
        @Nullable
        protected AnAction getCreateAction() {
            final DataSourceManager manager = DataSourceManager.byDataSource((Project)DdlMappingConfigurable.this.getProject(), SqlDataSource.class);
            if (manager == null) {
                return null;
            }
            return new AnAction(DatabaseBundle.message((String)"action.create.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SqlDataSource ds = (SqlDataSource)manager.createEmpty();
                    DasDataSource dataSource = DdlMappingConfigurable.findDataSource(DdlMappingConfigurable.this.getController(), DdlMappingConfigurable.this.myDataSourceId);
                    dataSource = dataSource == null ? null : (DasDataSource)DdlMappingConfigurable.this.getController().getTempTargetOrTarget((Object)dataSource);
                    String name = dataSource == null ? DdlMappingConfigurable.this.myNameComponent.getNameValue() : dataSource.getName();
                    ds.setName(name + " (DDL)");
                    if (dataSource instanceof LocalDataSource) {
                        ds.setDefinedDbms(dataSource.getDbms());
                    }
                    DdlMappingConfigurable.this.getController().onCreated((Object)ds);
                    ChooseDdlDsGroup.this.chosen((DasDataSource)ds);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDdlDsGroup$1", "actionPerformed"));
                }
            };
        }
    }

    private class DumpSourceScopeEditor
    extends DataSourceScopeEditor {
        private String myCurrentDs;

        DumpSourceScopeEditor() {
            super(DdlMappingConfigurable.this.getProject());
            this.updateDataSource();
        }

        private void updateDataSource() {
            BasicModel model;
            LocalDataSource dataSource = this.getDataSource(false);
            if (dataSource != null && dataSource.getUniqueId().equals(this.myCurrentDs)) {
                return;
            }
            this.myCurrentDs = dataSource == null ? null : dataSource.getUniqueId();
            this.mySelectedScope = this.getEditorState();
            BasicModel basicModel = model = dataSource == null ? null : (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (dataSource != null && model == null) {
                DasDataSource origDs = DdlMappingConfigurable.findDataSource(DdlMappingConfigurable.this.getController(), DdlMappingConfigurable.this.myDataSourceId);
                model = origDs == null ? null : (BasicModel)ObjectUtils.tryCast((Object)origDs.getModel(), BasicModel.class);
            }
            this.setInitialModel(dataSource, DataSourceSchemasPanel.tryCopy(model));
        }

        @Override
        @NotNull
        public DataSourceSchemaMapping getSchemaMapping() {
            DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
            if (dataSourceSchemaMapping == null) {
                DumpSourceScopeEditor.$$$reportNull$$$0(0);
            }
            return dataSourceSchemaMapping;
        }

        @Override
        protected void handleIntrospectionError(@Nullable String msg) {
        }

        @Override
        @Nullable
        protected LocalDataSource getDataSource(boolean withCredentials) {
            return DdlMappingConfigurable.this.getDataSource(withCredentials);
        }

        @Override
        @NotNull
        protected DatabaseCredentials getCredentials() {
            DatabaseCredentials databaseCredentials = DdlMappingConfigurable.this.getController().getSecretService();
            if (databaseCredentials == null) {
                DumpSourceScopeEditor.$$$reportNull$$$0(1);
            }
            return databaseCredentials;
        }

        @Override
        @NotNull
        protected Dbms getDbms() {
            LocalDataSource dataSource = this.getDataSource(false);
            Dbms dbms = dataSource == null ? Dbms.UNKNOWN : dataSource.getDbms();
            if (dbms == null) {
                DumpSourceScopeEditor.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = new JPanel(new BorderLayout());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DbSourceSchemas", (ActionGroup)this.createTreeActions(), true);
            toolbar.setTargetComponent((JComponent)((Object)this.getTree()));
            northPanel.add((Component)toolbar.getComponent(), "West");
            northPanel.add((Component)this.getFilteringTree().installSearchField(), "East");
            JPanel jPanel = northPanel;
            if (jPanel == null) {
                DumpSourceScopeEditor.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/dataSource/DdlMappingConfigurable$DumpSourceScopeEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaMapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCredentials";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNorthPanel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private abstract class ChooseDsGroup
    extends ActionGroup {
        private ChooseDsGroup() {
        }

        protected abstract String getCurrentId();

        protected abstract boolean filter(DbDataSource var1);

        protected abstract void chosen(DasDataSource var1);

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseDsGroup.$$$reportNull$$$0(0);
            }
            JBPopupFactory factory = JBPopupFactory.getInstance();
            factory.createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, ActionPlaces.getPopupPlace((String)"database")).show(factory.guessBestPopupLocation(e.getDataContext()));
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction create2;
            String currentId = this.getCurrentId();
            DefaultActionGroup group = new DefaultActionGroup();
            List dataSources = ContainerUtil.sorted((Collection)ContainerUtil.filter((Collection)DdlMappingConfigurable.this.getController().getDataSources(), this::filter), Comparator.comparing(ds -> ds.getUniqueId().equals(currentId) ? 1 : 0).thenComparing(DasDataSource::getName, StringUtil::naturalCompare));
            DbDataSource current = (DbDataSource)ContainerUtil.getLastItem((List)dataSources);
            if (current != null && current.getUniqueId().equals(currentId)) {
                dataSources = dataSources.subList(0, dataSources.size() - 1);
            } else {
                current = null;
            }
            if (current != null) {
                final DasDataSource target = (DasDataSource)DdlMappingConfigurable.this.getController().getTempTargetOrTarget((Object)current.getDelegate());
                group.add((AnAction)new DumbAwareAction(target.getName(), null, AllIcons.ToolbarDecorator.Export){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DdlMappingConfigurable.this.getController().navigateTo((Object)target, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDsGroup$1", "actionPerformed"));
                    }
                });
            }
            if ((create2 = this.getCreateAction()) != null) {
                group.add(create2);
            }
            group.add((AnAction)new DumbAwareAction(DatabaseBundle.message((String)"SidePanelItem.reset", (Object[])new Object[0]), null, AllIcons.Vcs.Remove){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ChooseDsGroup.this.chosen(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDsGroup$2", "actionPerformed"));
                }
            });
            group.add((AnAction)Separator.getInstance());
            for (DbDataSource dataSource : dataSources) {
                final DasDataSource target = (DasDataSource)DdlMappingConfigurable.this.getController().getTempTargetOrTarget((Object)dataSource.getDelegate());
                group.add((AnAction)new DumbAwareAction(target.getName(), null, target.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        ChooseDsGroup.this.chosen(target);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDsGroup$3", "actionPerformed"));
                    }
                });
            }
            AnAction[] anActionArray = group.getChildren(e);
            if (anActionArray == null) {
                ChooseDsGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        @Nullable
        protected abstract AnAction getCreateAction();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDsGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DdlMappingConfigurable$ChooseDsGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

