/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.annotations.ColumnName;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0080\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0017\n\u0002\u0010\n\n\u0002\u0010\u0015\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u008e\u0001\u0010\u0000\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\b\u0012\u0004\u0012\u0002H\u0002`\u0007\"\u0004\b\u0000\u0010\u0002*+\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001j\n\u0012\u0004\u0012\u0002H\u0002\u0018\u0001`\u00072+\u0010\b\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\b\u0012\u0004\u0012\u0002H\u0002`\u0007H\u0080\u0004\u001a3\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u0002*\u0002H\u00022\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\f\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001e\u0010\u0011\u001a\u0002H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0012*\u00020\u0010H\u0080\b\u00a2\u0006\u0002\u0010\u0013\u001a-\u0010\u0014\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\u001aH\u0000\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e*\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0000\u001a&\u0010\u001b\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n\u001a\u0018\u0010\u001e\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\nH\u0001\u001a\b\u0010\u001f\u001a\u00020 H\u0001\u001a#\u0010!\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\"*\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0001\u00a2\u0006\u0002\u0010#\u001a!\u0010$\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\"*\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0001\u00a2\u0006\u0002\u0010#\u001a#\u0010%\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00020'H\u0000\u00a2\u0006\u0002\u0010(\u001a*\u0010)\u001a\u00020**\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\n2\u0006\u0010+\u001a\u00020\u00062\n\b\u0002\u0010,\u001a\u0004\u0018\u00010*H\u0000\u001a\u001e\u0010)\u001a\u00020**\n\u0012\u0006\u0012\u0004\u0018\u00010*0\n2\b\b\u0002\u0010-\u001a\u00020\u0006H\u0000\u001a\u0082\u0001\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00/0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a\u0082\u0001\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00;0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a|\u0010<\u001a\b\u0012\u0004\u0012\u00020 0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a$\u0010=\u001a\u00020\u0010\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00>*\n\u0012\u0006\u0012\u0004\u0018\u0001H00?H\u0000\u001a$\u0010@\u001a\u00020\u0010\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00>*\n\u0012\u0006\u0012\u0004\u0018\u0001H00?H\u0000\u001a\u0018\u0010A\u001a\u00020**\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010+\u001a\u00020\u0006H\u0000\u001a\u0014\u0010B\u001a\u00020\u0006*\u00020*2\u0006\u0010C\u001a\u00020*H\u0000\u001a\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020EH\u0001\u001a\u0018\u0010D\u001a\u00020I2\u0006\u0010F\u001a\u00020J2\u0006\u0010H\u001a\u00020IH\u0001\u001a\u0018\u0010D\u001a\u00020K2\u0006\u0010F\u001a\u00020\u00102\u0006\u0010H\u001a\u00020KH\u0001\u001a\u0018\u0010D\u001a\u00020L2\u0006\u0010F\u001a\u00020M2\u0006\u0010H\u001a\u00020LH\u0001\u001a\u0018\u0010D\u001a\u00020N2\u0006\u0010F\u001a\u00020O2\u0006\u0010H\u001a\u00020NH\u0001\u001a\u0018\u0010D\u001a\u00020P2\u0006\u0010F\u001a\u00020Q2\u0006\u0010H\u001a\u00020PH\u0001\u001a\u0018\u0010D\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010H\u001a\u00020\u001aH\u0001\u001a\u0018\u0010D\u001a\u00020R2\u0006\u0010F\u001a\u00020S2\u0006\u0010H\u001a\u00020RH\u0001\u001a4\u0010D\u001a\b\u0012\u0004\u0012\u0002H00T\"\u0006\b\u0000\u00100\u0018\u00012\u0006\u0010F\u001a\u0002H02\u000e\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u0002H00TH\u0081\b\u00a2\u0006\u0002\u0010U\u001a2\u0010V\u001a\b\u0012\u0004\u0012\u0002H00\n\"\u0006\b\u0000\u00100\u0018\u00012\u0006\u0010F\u001a\u0002H02\f\u0010H\u001a\b\u0012\u0004\u0012\u0002H00\nH\u0081\b\u00a2\u0006\u0002\u0010W\u001a2\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0002010?\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u0002012\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00100?H\u0000\u001a2\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000e0?\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00100?H\u0000\u001a\u0019\u0010Z\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0002*\u0002H\u0002H\u0000\u00a2\u0006\u0002\u0010[\u001a&\u0010\\\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010]\u001a\u00020\u0010H\u0000\u001a;\u0010^\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020>*\u0002H\u00022\u0006\u0010_\u001a\u0002H\u00022\u0006\u0010`\u001a\u0002H\u00022\b\b\u0002\u0010a\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010b\u001a\u0012\u0010m\u001a\u00020d*\u00020d2\u0006\u0010n\u001a\u00020f\u001a\f\u0010o\u001a\u00020d*\u00020dH\u0000\u001a\u0012\u0010p\u001a\u00020d*\b\u0012\u0004\u0012\u00020d0\u000eH\u0000\u001a\u0010\u0010q\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030rH\u0000\u001a\u0010\u0010q\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030sH\u0000\u001a\u0010\u0010q\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030tH\u0000\"\u000e\u0010c\u001a\u00020dX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010e\u001a\u00020f\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010h\"\u0011\u0010i\u001a\u00020f\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010h\"\u0014\u0010k\u001a\u00020fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010h\"\"\u0010u\u001a\u00020d*\u0006\u0012\u0002\b\u00030r8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bv\u0010w\u001a\u0004\bx\u0010y\"\"\u0010u\u001a\u00020d*\u0006\u0012\u0002\b\u00030s8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bv\u0010z\u001a\u0004\bx\u0010{\"\"\u0010u\u001a\u00020d*\u0006\u0012\u0002\b\u00030t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bv\u0010|\u001a\u0004\bx\u0010}\u00a8\u0006~"}, d2={"and", "Lkotlin/Function1;", "T", "Lkotlin/ParameterName;", "name", "it", "", "Lorg/jetbrains/kotlinx/dataframe/Predicate;", "other", "toIterable", "", "getNext", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Iterable;", "removeAt", "", "index", "", "cast", "", "(I)Ljava/lang/Object;", "convert", "src", "tartypeOf", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)Ljava/lang/Object;", "getTrueIndices", "", "equalsByElement", "rollingHash", "asList", "anyNull", "emptyPath", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "zeroOrNull", "", "(Lkotlin/reflect/KClass;)Ljava/lang/Number;", "zero", "catchSilent", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "commonType", "Lkotlin/reflect/KType;", "nullable", "upperBound", "useStar", "getColumnsImpl", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "C", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "unresolvedColumnsPolicy", "Lorg/jetbrains/kotlinx/dataframe/columns/UnresolvedColumnsPolicy;", "selector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "getColumnsWithPaths", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "getColumnPaths", "indexOfMin", "", "Lkotlin/sequences/Sequence;", "indexOfMax", "createStarProjectedType", "isSubtypeWithNullabilityOf", "type", "headPlusArray", "", "head", "", "cols", "", "", "", "", "", "", "", "", "", "", "", "", "(Ljava/lang/Object;[Ljava/lang/Object;)[Ljava/lang/Object;", "headPlusIterable", "(Ljava/lang/Object;Ljava/lang/Iterable;)Ljava/lang/Iterable;", "splitByIndices", "startIndices", "asNullable", "(Ljava/lang/Object;)Ljava/lang/Object;", "last", "count", "between", "left", "right", "includeBoundaries", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Z)Z", "DELIMITERS", "", "DELIMITERS_REGEX", "Lkotlin/text/Regex;", "getDELIMITERS_REGEX", "()Lkotlin/text/Regex;", "DELIMITED_STRING_REGEX", "getDELIMITED_STRING_REGEX", "CAMEL_REGEX", "getCAMEL_REGEX", "toCamelCaseByDelimiters", "delimiters", "toSnakeCase", "joinToCamelCaseString", "isGetterLike", "Lkotlin/reflect/KFunction;", "Lkotlin/reflect/KProperty;", "Lkotlin/reflect/KCallable;", "columnName", "getColumnName$annotations", "(Lkotlin/reflect/KFunction;)V", "getColumnName", "(Lkotlin/reflect/KFunction;)Ljava/lang/String;", "(Lkotlin/reflect/KProperty;)V", "(Lkotlin/reflect/KProperty;)Ljava/lang/String;", "(Lkotlin/reflect/KCallable;)V", "(Lkotlin/reflect/KCallable;)Ljava/lang/String;", "core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,410:1\n1755#2,3:411\n1755#2,3:414\n1557#2:417\n1628#2,3:418\n1557#2:421\n1628#2,3:422\n1734#2,3:425\n1557#2:428\n1628#2,3:429\n827#2:432\n855#2,2:433\n1557#2:435\n1628#2,3:436\n1557#2:439\n1628#2,3:440\n295#2,2:447\n295#2,2:450\n295#2,2:453\n1#3:443\n37#4,2:444\n20#5:446\n20#5:449\n20#5:452\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n*L\n119#1:411,3\n163#1:414,3\n171#1:417\n171#1:418,3\n176#1:421\n176#1:422,3\n177#1:425,3\n183#1:428\n183#1:429,3\n184#1:432\n184#1:433,2\n213#1:435\n213#1:436,3\n223#1:439\n223#1:440,3\n387#1:447,2\n396#1:450,2\n408#1:453,2\n309#1:444,2\n387#1:446\n396#1:449\n408#1:452\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final String DELIMITERS = "[_\\s]";
    @NotNull
    private static final Regex DELIMITERS_REGEX = new Regex("[_\\s]");
    @NotNull
    private static final Regex DELIMITED_STRING_REGEX = new Regex(".+[_\\s].+");
    @NotNull
    private static final Regex CAMEL_REGEX = new Regex("(?<=[a-zA-Z])[A-Z]");

    @NotNull
    public static final <T> Function1<T, Boolean> and(@Nullable Function1<? super T, Boolean> $this$and, @NotNull Function1<? super T, Boolean> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Function1<? super T, Boolean> function1 = $this$and;
        return function1 == null ? other : arg_0 -> UtilsKt.and$lambda$0(function1, other, arg_0);
    }

    @NotNull
    public static final <T> Iterable<T> toIterable(T $this$toIterable, @NotNull Function1<? super T, ? extends T> getNext) {
        Intrinsics.checkNotNullParameter(getNext, (String)"getNext");
        return new Iterable<T>(getNext, $this$toIterable){
            final /* synthetic */ Function1 $getNext$inlined;
            final /* synthetic */ Object $this_toIterable$inlined;
            {
                this.$getNext$inlined = function1;
                this.$this_toIterable$inlined = object;
            }

            public Iterator<T> iterator() {
                boolean bl = false;
                return new Iterator<T>(this.$getNext$inlined, this.$this_toIterable$inlined){
                    private T current;
                    private boolean beforeStart;
                    private T next;
                    final /* synthetic */ Function1<T, T> $getNext;
                    final /* synthetic */ T $this_toIterable;
                    {
                        this.$getNext = $getNext;
                        this.$this_toIterable = $receiver;
                        this.beforeStart = true;
                    }

                    public final T getCurrent() {
                        return this.current;
                    }

                    public final void setCurrent(T t) {
                        this.current = t;
                    }

                    public final boolean getBeforeStart() {
                        return this.beforeStart;
                    }

                    public final void setBeforeStart(boolean bl) {
                        this.beforeStart = bl;
                    }

                    public final T getNext() {
                        return this.next;
                    }

                    public final void setNext(T t) {
                        this.next = t;
                    }

                    public boolean hasNext() {
                        if (this.beforeStart) {
                            return true;
                        }
                        if (this.next == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            this.next = this.$getNext.invoke(t);
                        }
                        return this.next != null;
                    }

                    public T next() {
                        if (this.beforeStart) {
                            this.current = this.$this_toIterable;
                            this.beforeStart = false;
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            return t;
                        }
                        Object object = this.next;
                        if (object == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            object = this.$getNext.invoke(t);
                        }
                        this.current = object;
                        this.next = null;
                        T t = this.current;
                        Intrinsics.checkNotNull(t);
                        return t;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final <T> List<T> removeAt(@NotNull List<? extends T> $this$removeAt, int index) {
        Intrinsics.checkNotNullParameter($this$removeAt, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$removeAt.subList(0, index), (Iterable)$this$removeAt.subList(index + 1, $this$removeAt.size()));
    }

    public static final /* synthetic */ <T> T cast(int $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return UtilsKt.convert($this$cast, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> T convert(int src, @NotNull KClass<T> tartypeOf) {
        Object object;
        Intrinsics.checkNotNullParameter(tartypeOf, (String)"tartypeOf");
        KClass<T> kClass = tartypeOf;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = (double)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = (long)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(src);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.valueOf(src);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.convert");
            object = bigDecimal;
        } else {
            throw new NotImplementedError("Casting int to " + tartypeOf + " is not supported");
        }
        return (T)object;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull boolean[] $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res = new ArrayList<Integer>($this$getTrueIndices.length);
        int n = $this$getTrueIndices.length;
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices[i]) continue;
            res.add(i);
        }
        return res;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull List<Boolean> $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter($this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res = new ArrayList<Integer>($this$getTrueIndices.size());
        int n = ((Collection)$this$getTrueIndices).size();
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices.get(i).booleanValue()) continue;
            res.add(i);
        }
        return res;
    }

    public static final <T> boolean equalsByElement(@NotNull Iterable<? extends T> $this$equalsByElement, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$equalsByElement, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterator<T> iterator1 = $this$equalsByElement.iterator();
        Iterator<T> iterator2 = other.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (Intrinsics.areEqual(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static final <T> int rollingHash(@NotNull Iterable<? extends T> $this$rollingHash) {
        Intrinsics.checkNotNullParameter($this$rollingHash, (String)"<this>");
        Iterator<T> i = $this$rollingHash.iterator();
        int hash = 0;
        while (i.hasNext()) {
            T t = i.next();
            hash = 31 * hash + (t != null ? t.hashCode() : 5);
        }
        return hash;
    }

    @NotNull
    public static final <T> List<T> asList(@NotNull Iterable<? extends T> $this$asList) {
        Intrinsics.checkNotNullParameter($this$asList, (String)"<this>");
        return $this$asList instanceof List ? (List)$this$asList : CollectionsKt.toList($this$asList);
    }

    @PublishedApi
    public static final <T> boolean anyNull(@NotNull Iterable<? extends T> $this$anyNull) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$anyNull, (String)"<this>");
            Iterable<T> $this$any$iv = $this$anyNull;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<T> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @PublishedApi
    @NotNull
    public static final ColumnPath emptyPath() {
        return new ColumnPath(CollectionsKt.emptyList());
    }

    @PublishedApi
    @Nullable
    public static final <T extends Number> T zeroOrNull(@NotNull KClass<T> $this$zeroOrNull) {
        Number number;
        Intrinsics.checkNotNullParameter($this$zeroOrNull, (String)"<this>");
        KClass<T> kClass = $this$zeroOrNull;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = 0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = (byte)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = (short)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = 0L;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = 0.0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(0.0f);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zeroOrNull");
            number = bigDecimal;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zeroOrNull");
            number = bigInteger;
        } else {
            Integer n;
            number = Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Number.class)) ? ((n = Integer.valueOf(0)) instanceof Number ? (Number)n : null) : null;
        }
        return (T)number;
    }

    @PublishedApi
    @NotNull
    public static final <T extends Number> T zero(@NotNull KClass<T> $this$zero) {
        Intrinsics.checkNotNullParameter($this$zero, (String)"<this>");
        T t = UtilsKt.zeroOrNull($this$zero);
        if (t == null) {
            throw new NotImplementedError("Zero value for " + $this$zero + " is not supported");
        }
        return t;
    }

    @Nullable
    public static final <T> T catchSilent(@NotNull Function0<? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            object = body.invoke();
        }
        catch (Throwable throwable) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KClass<?>> $this$commonType, boolean nullable, @Nullable KType upperBound) {
        Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
        return TypeUtilsKt.createType((Iterable)TypeUtilsKt.commonParents($this$commonType), nullable, upperBound);
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, KType kType, int n, Object object) {
        if ((n & 2) != 0) {
            kType = null;
        }
        return UtilsKt.commonType(iterable, bl, kType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KType> $this$commonType, boolean useStar) {
        KType kType;
        Object it;
        boolean bl;
        List distinct;
        block17: {
            Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
            distinct = CollectionsKt.distinct($this$commonType);
            Iterable $this$any$iv = distinct;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KType)element$iv;
                    boolean bl2 = false;
                    KType kType2 = it;
                    if (!(kType2 != null ? kType2.isMarkedNullable() : true)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean nullable = bl;
        if (distinct.isEmpty() || distinct.contains(null)) {
            kType = KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
        } else if (distinct.size() == 1) {
            Object object = CollectionsKt.single((List)distinct);
            Intrinsics.checkNotNull((Object)object);
            kType = (KType)object;
        } else {
            boolean bl3;
            List projections;
            KClass<?> kClass;
            Object object;
            block18: {
                KType it2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = distinct;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType3 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl4 = false;
                    void v4 = it2;
                    Intrinsics.checkNotNull((Object)v4);
                    object.add(KTypesJvm.getJvmErasure((KType)v4));
                }
                KClass<?> kClass2 = TypeUtilsKt.commonParent((List)destination$iv$iv);
                if (kClass2 == null) {
                    return KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
                }
                kClass = kClass2;
                $this$map$iv = distinct;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    KType kType4 = it2;
                    Intrinsics.checkNotNull((Object)kType4);
                    object.add(TypeUtilsKt.replaceGenericTypeParametersWithUpperbound(TypeUtilsKt.projectUpTo(kType4, kClass)));
                }
                projections = (List)destination$iv$iv;
                Iterable $this$all$iv = projections;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KType it3 = (KType)element$iv;
                        boolean bl6 = false;
                        if (Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)it3), kClass)) continue;
                        bl3 = false;
                        break block18;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = kClass.getTypeParameters().size();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                KType commonType;
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                KType it4;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void i2;
                int n2;
                int bl6 = n2 = i;
                object = arrayList;
                boolean bl7 = false;
                KTypeParameter typeParameter = (KTypeParameter)kClass.getTypeParameters().get((int)i2);
                Iterable bl5 = projections;
                boolean $i$f$map = false;
                void var16_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType5 = (KType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    collection.add(((KTypeProjection)it4.getArguments().get((int)i2)).getType());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$mapTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it4 = (KType)element$iv$iv;
                    boolean bl9 = false;
                    if (distinct.contains(it4)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List projectionTypes = (List)destination$iv$iv;
                ((ArrayList)object).add(projectionTypes.isEmpty() && typeParameter.getVariance() == KVariance.IN ? (useStar ? KTypeProjection.Companion.getSTAR() : KTypeProjection.Companion.invariant(TypeUtilsKt.nothingType(false))) : (Intrinsics.areEqual((Object)(commonType = UtilsKt.commonType(projectionTypes, useStar)), (Object)Reflection.nullableTypeOf(Object.class)) && useStar ? KTypeProjection.Companion.getSTAR() : new KTypeProjection(typeParameter.getVariance(), commonType)));
            }
            List arguments = arrayList;
            kType = KClassifiers.createType$default((KClassifier)((KClassifier)kClass), (List)arguments, (boolean)nullable, null, (int)4, null);
        }
        return kType;
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.commonType(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<DataColumn<C>> getColumnsImpl(@NotNull DataFrame<? extends T> $this$getColumnsImpl, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnsImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnsImpl, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T, C> List<ColumnWithPath<C>> getColumnsWithPaths(@NotNull DataFrame<? extends T> $this$getColumnsWithPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnsWithPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.resolve(ConstructorsKt.toColumnSet(selector), $this$getColumnsWithPaths, unresolvedColumnsPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<ColumnPath> getColumnPaths(@NotNull DataFrame<? extends T> $this$getColumnPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnPaths, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    public static final <C extends Comparable<? super C>> int indexOfMin(@NotNull Sequence<? extends C> $this$indexOfMin) {
        Intrinsics.checkNotNullParameter($this$indexOfMin, (String)"<this>");
        Iterator iterator2 = $this$indexOfMin.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable min = value;
        int minIndex = index;
        if (!iterator2.hasNext()) {
            return minIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || min.compareTo(v) <= 0) continue;
            min = v;
            minIndex = index;
        } while (iterator2.hasNext());
        return minIndex;
    }

    public static final <C extends Comparable<? super C>> int indexOfMax(@NotNull Sequence<? extends C> $this$indexOfMax) {
        Intrinsics.checkNotNullParameter($this$indexOfMax, (String)"<this>");
        Iterator iterator2 = $this$indexOfMax.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable max = value;
        int maxIndex = index;
        if (!iterator2.hasNext()) {
            return maxIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || max.compareTo(v) >= 0) continue;
            max = v;
            maxIndex = index;
        } while (iterator2.hasNext());
        return maxIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType createStarProjectedType(@NotNull KClass<?> $this$createStarProjectedType, boolean nullable) {
        Object object;
        Intrinsics.checkNotNullParameter($this$createStarProjectedType, (String)"<this>");
        if (Intrinsics.areEqual($this$createStarProjectedType, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            object = TypeUtilsKt.nothingType(nullable);
        } else {
            void var2_2;
            KType it = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)$this$createStarProjectedType));
            boolean bl = false;
            object = nullable ? KTypes.withNullability((KType)it, (boolean)true) : var2_2;
        }
        return object;
    }

    public static final boolean isSubtypeWithNullabilityOf(@NotNull KType $this$isSubtypeWithNullabilityOf, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeWithNullabilityOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KTypes.isSubtypeOf((KType)$this$isSubtypeWithNullabilityOf, (KType)type) && (!$this$isSubtypeWithNullabilityOf.isMarkedNullable() || type.isMarkedNullable());
    }

    @PublishedApi
    @NotNull
    public static final byte[] headPlusArray(byte head, @NotNull byte[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        byte[] byArray = new byte[]{head};
        return ArraysKt.plus((byte[])byArray, (byte[])cols);
    }

    @PublishedApi
    @NotNull
    public static final short[] headPlusArray(short head, @NotNull short[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        short[] sArray = new short[]{head};
        return ArraysKt.plus((short[])sArray, (short[])cols);
    }

    @PublishedApi
    @NotNull
    public static final int[] headPlusArray(int head, @NotNull int[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        int[] nArray = new int[]{head};
        return ArraysKt.plus((int[])nArray, (int[])cols);
    }

    @PublishedApi
    @NotNull
    public static final long[] headPlusArray(long head, @NotNull long[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        long[] lArray = new long[]{head};
        return ArraysKt.plus((long[])lArray, (long[])cols);
    }

    @PublishedApi
    @NotNull
    public static final float[] headPlusArray(float head, @NotNull float[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        float[] fArray = new float[]{head};
        return ArraysKt.plus((float[])fArray, (float[])cols);
    }

    @PublishedApi
    @NotNull
    public static final double[] headPlusArray(double head, @NotNull double[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        double[] dArray = new double[]{head};
        return ArraysKt.plus((double[])dArray, (double[])cols);
    }

    @PublishedApi
    @NotNull
    public static final boolean[] headPlusArray(boolean head, @NotNull boolean[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        boolean[] blArray = new boolean[]{head};
        return ArraysKt.plus((boolean[])blArray, (boolean[])cols);
    }

    @PublishedApi
    @NotNull
    public static final char[] headPlusArray(char head, @NotNull char[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        char[] cArray = new char[]{head};
        return ArraysKt.plus((char[])cArray, (char[])cols);
    }

    @PublishedApi
    public static final /* synthetic */ <C> C[] headPlusArray(C head, C[] cols) {
        Intrinsics.checkNotNullParameter(cols, (String)"cols");
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(head), (Iterable)ArraysKt.toList((Object[])cols));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"C?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    @PublishedApi
    public static final /* synthetic */ <C> Iterable<C> headPlusIterable(C head, Iterable<? extends C> cols) {
        Intrinsics.checkNotNullParameter(cols, (String)"cols");
        boolean $i$f$headPlusIterable = false;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(head), cols);
    }

    @NotNull
    public static final <T> Sequence<DataFrame<T>> splitByIndices(@NotNull DataFrame<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices, (Object)DataFrameKt.getNrow($this$splitByIndices)), (arg_0, arg_1) -> UtilsKt.splitByIndices$lambda$13($this$splitByIndices, arg_0, arg_1));
    }

    @NotNull
    public static final <T> Sequence<List<T>> splitByIndices(@NotNull List<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices, (Object)$this$splitByIndices.size()), (arg_0, arg_1) -> UtilsKt.splitByIndices$lambda$14($this$splitByIndices, arg_0, arg_1));
    }

    @Nullable
    public static final <T> T asNullable(T $this$asNullable) {
        return $this$asNullable;
    }

    @NotNull
    public static final <T> List<T> last(@NotNull List<? extends T> $this$last, int count) {
        Intrinsics.checkNotNullParameter($this$last, (String)"<this>");
        return $this$last.subList($this$last.size() - count, $this$last.size());
    }

    public static final <T extends Comparable<? super T>> boolean between(@NotNull T $this$between, @NotNull T left, @NotNull T right, boolean includeBoundaries) {
        Intrinsics.checkNotNullParameter($this$between, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return includeBoundaries ? (0 <= $this$between.compareTo(left) ? $this$between.compareTo(right) <= 0 : false) : $this$between.compareTo(left) > 0 && $this$between.compareTo(right) < 0;
    }

    public static /* synthetic */ boolean between$default(Comparable comparable, Comparable comparable2, Comparable comparable3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilsKt.between(comparable, comparable2, comparable3, bl);
    }

    @NotNull
    public static final Regex getDELIMITERS_REGEX() {
        return DELIMITERS_REGEX;
    }

    @NotNull
    public static final Regex getDELIMITED_STRING_REGEX() {
        return DELIMITED_STRING_REGEX;
    }

    @NotNull
    public static final Regex getCAMEL_REGEX() {
        return CAMEL_REGEX;
    }

    @NotNull
    public static final String toCamelCaseByDelimiters(@NotNull String $this$toCamelCaseByDelimiters, @NotNull Regex delimiters) {
        Intrinsics.checkNotNullParameter((Object)$this$toCamelCaseByDelimiters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        CharSequence charSequence = $this$toCamelCaseByDelimiters;
        int n = 0;
        return UtilsKt.joinToCamelCaseString(delimiters.split(charSequence, n));
    }

    @NotNull
    public static final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        if (new Regex("[A-Z_]+").matches((CharSequence)$this$toSnakeCase)) {
            string = $this$toSnakeCase;
        } else {
            String string2 = StringsKt.replace$default((String)CAMEL_REGEX.replace((CharSequence)$this$toSnakeCase, UtilsKt::toSnakeCase$lambda$15), (String)" ", (String)"_", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        }
        return string;
    }

    @NotNull
    public static final String joinToCamelCaseString(@NotNull List<String> $this$joinToCamelCaseString) {
        String string;
        Intrinsics.checkNotNullParameter($this$joinToCamelCaseString, (String)"<this>");
        String string2 = CollectionsKt.joinToString$default((Iterable)$this$joinToCamelCaseString, (CharSequence)"", null, null, (int)0, null, UtilsKt::joinToCamelCaseString$lambda$17, (int)30, null);
        if (((CharSequence)string2).length() > 0) {
            char it = string2.charAt(0);
            boolean bl = false;
            char c = Character.toLowerCase(it);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return string;
    }

    public static final boolean isGetterLike(@NotNull KFunction<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        return (StringsKt.startsWith$default((String)$this$isGetterLike.getName(), (String)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isGetterLike.getName(), (String)"is", (boolean)false, (int)2, null)) && KCallables.getValueParameters((KCallable)((KCallable)$this$isGetterLike)).isEmpty() && $this$isGetterLike.getTypeParameters().isEmpty();
    }

    public static final boolean isGetterLike(@NotNull KProperty<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        return true;
    }

    public static final boolean isGetterLike(@NotNull KCallable<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        KCallable<?> kCallable = $this$isGetterLike;
        return kCallable instanceof KProperty ? UtilsKt.isGetterLike((KProperty)$this$isGetterLike) : (kCallable instanceof KFunction ? UtilsKt.isGetterLike((KFunction)$this$isGetterLike) : false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getColumnName(@NotNull KFunction<?> $this$columnName) {
        Object object;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof ColumnName)) continue;
                v0 = element$iv$iv;
                break block4;
            }
            v0 = null;
        }
        if ((object = (ColumnName)((Annotation)v0)) == null || (object = object.name()) == null) {
            String string = StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$columnName.getName(), (CharSequence)"get"), (CharSequence)"is");
            if (((CharSequence)string).length() > 0) {
                void it;
                char $this$firstOrNull$iv$iv = string.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string2 = String.valueOf((char)it);
                Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type java.lang.String");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                String string4 = string;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                object = stringBuilder2.append(string5).toString();
            } else {
                object = string;
            }
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KFunction kFunction) {
    }

    @NotNull
    public static final String getColumnName(@NotNull KProperty<?> $this$columnName) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof ColumnName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (ColumnName)((Annotation)v0)) == null || (object = object.name()) == null) {
            object = $this$columnName.getName();
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KProperty kProperty) {
    }

    @NotNull
    public static final String getColumnName(@NotNull KCallable<?> $this$columnName) {
        Object object;
        Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
        KCallable<?> kCallable = $this$columnName;
        if (kCallable instanceof KFunction) {
            object = UtilsKt.getColumnName((KFunction)$this$columnName);
        } else if (kCallable instanceof KProperty) {
            object = UtilsKt.getColumnName((KProperty)$this$columnName);
        } else {
            Object v1;
            block6: {
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof ColumnName)) continue;
                    v1 = element$iv$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((object = (ColumnName)((Annotation)v1)) == null || (object = object.name()) == null) {
                object = $this$columnName.getName();
            }
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KCallable kCallable) {
    }

    private static final boolean and$lambda$0(Function1 $this_and, Function1 $other, Object it) {
        return (Boolean)$this_and.invoke(it) != false && (Boolean)$other.invoke(it) != false;
    }

    private static final DataFrame splitByIndices$lambda$13(DataFrame $this_splitByIndices, int start, int endExclusive) {
        return start == endExclusive ? CastKt.cast(DataFrame.Companion.empty$default(DataFrame.Companion, 0, 1, null)) : $this_splitByIndices.get(RangesKt.until((int)start, (int)endExclusive));
    }

    private static final List splitByIndices$lambda$14(List $this_splitByIndices, int start, int endExclusive) {
        return $this_splitByIndices.subList(start, endExclusive);
    }

    private static final CharSequence toSnakeCase$lambda$15(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '_' + it.getValue();
    }

    private static final CharSequence joinToCamelCaseString$lambda$17(String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it;
        if (((CharSequence)string2).length() > 0) {
            char it2 = string2.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(it2);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return string;
    }
}

