/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToggleAutoUploadAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(project != null);
        }
        if (project != null) {
            PublishConfig.AutoUploadState state = PublishConfig.getInstance(project).getAutoUploadState();
            Presentation presentation = e.getPresentation();
            presentation.setText(WDBundle.messagePointer(switch (state) {
                default -> throw new MatchException(null, null);
                case PublishConfig.AutoUploadState.ALWAYS -> "toggle.auto.upload.action.always";
                case PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE -> "toggle.auto.upload.action.on.explicit.save";
                case PublishConfig.AutoUploadState.NEVER -> "toggle.auto.upload.action.never";
            }, new Object[0]));
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(2);
        }
        return (project = e.getProject()) != null && PublishConfig.getInstance(project).getAutoUploadState() != PublishConfig.AutoUploadState.NEVER;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project;
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) != null) {
            PublishConfig config = PublishConfig.getInstance(project);
            if (state) {
                WebServerGroupingWrap defaultWrap = config.findDefaultServerOrGroupAsWrap();
                if (defaultWrap == null) {
                    List<WebServerGroupingWrap> wraps = GroupedServersConfigManager.getInstance(project).getGroupedServers();
                    ArrayList<WebServerGroupingWrap> filteredServers = new ArrayList<WebServerGroupingWrap>();
                    block0: for (WebServerGroupingWrap wrap2 : wraps) {
                        if (wrap2 == null) continue;
                        for (WebServerConfig serverConfig2 : wrap2.getServers()) {
                            List<DeploymentPathMapping> mappings;
                            if (!serverConfig2.needsTransfer() || serverConfig2.getFileTransferConfig().validateFast() != null || (mappings = config.getPathMappings(serverConfig2.getId())) == null || mappings.isEmpty()) continue;
                            filteredServers.add(wrap2);
                            continue block0;
                        }
                    }
                    if (filteredServers.isEmpty()) {
                        ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.or.group.is.not.configured.and.no.valid.servers", new Object[0]));
                    } else {
                        PublishActionUtil.chooseServerFromWraps(config, filteredServers, e, WDBundle.message("choose.default.server.or.group", new Object[0]), true).onSuccess(wrap -> {
                            config.setDefaultGroupOrServerName(wrap.getName());
                            ToggleAutoUploadAction.setState(state, project, config);
                        });
                    }
                    return;
                }
                if (!ContainerUtil.exists(defaultWrap.getServers(), serverConfig -> serverConfig.needsTransfer())) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.does.n.t.need.automatic.upload", defaultWrap.getName(), defaultWrap.getPresentableName()));
                    return;
                }
                String validationResult = defaultWrap.validateFileTransferFast();
                if (validationResult != null) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.is.invalid.1", defaultWrap.getName(), validationResult, defaultWrap.getPresentableName()));
                    return;
                }
                if (!config.hasValidMapping(defaultWrap)) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.has.no.valid.mappings", defaultWrap.getName(), defaultWrap.getPresentableName()));
                    return;
                }
            }
            ToggleAutoUploadAction.setState(state, project, config);
        }
    }

    private static void setState(boolean state, Project project, PublishConfig config) {
        if (state) {
            config.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        } else {
            config.setAutoUploadState(PublishConfig.AutoUploadState.NEVER);
        }
        ((DeploymentConfigChangeListener)project.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
    }

    private static void showMessage(Project project, String message) {
        Messages.showWarningDialog((Project)project, (String)WDBundle.message("0.n.automatic.upload.is.not.enabled", message), (String)WDBundle.message("automatic.upload.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/ToggleAutoUploadAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/ToggleAutoUploadAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

