/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.bundle.component;

import com.jetbrains.mlapi.bundle.JvmBundleLoadingException;
import com.jetbrains.mlapi.bundle.component.InMemoryClassLoader;
import com.jetbrains.mlapi.bundle.component.JvmBundleComponentLoader;
import com.jetbrains.mlapi.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.mlapi.feature.preprocessor.FeaturePreprocessorFactory;
import com.jetbrains.mlapi.model.pipeline.VFSNode;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/mlapi/bundle/component/JarPreprocessorLoader;", "Lcom/jetbrains/mlapi/bundle/component/JvmBundleComponentLoader;", "Lcom/jetbrains/mlapi/feature/preprocessor/FeaturePreprocessor;", "()V", "PREPROCESSOR_JAR_FILE", "", "name", "getName", "()Ljava/lang/String;", "doLoad", "Ljava/util/concurrent/CompletableFuture;", "executor", "Ljava/util/concurrent/ExecutorService;", "metadata", "Lkotlinx/serialization/json/JsonObject;", "componentDirectory", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode$Directory;", "mlapi-core"})
public final class JarPreprocessorLoader
extends JvmBundleComponentLoader<FeaturePreprocessor> {
    @NotNull
    public static final JarPreprocessorLoader INSTANCE = new JarPreprocessorLoader();
    @NotNull
    private static final String name = "kotlin_feature_preprocessor";
    @NotNull
    private static final String PREPROCESSOR_JAR_FILE = "preprocessor.jar";

    private JarPreprocessorLoader() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    protected CompletableFuture<? extends FeaturePreprocessor> doLoad(@NotNull ExecutorService executor2, @NotNull JsonObject metadata, @NotNull VFSNode.Directory componentDirectory) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)componentDirectory, (String)"componentDirectory");
        CompletableFuture<FeaturePreprocessor> completableFuture = CompletableFuture.supplyAsync(() -> JarPreprocessorLoader.doLoad$lambda$2(componentDirectory, metadata, this), executor2);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final FeaturePreprocessor doLoad$lambda$2(VFSNode.Directory $componentDirectory, JsonObject $metadata, JarPreprocessorLoader this$0) {
        Object object;
        byte[] preprocessorParametersPayload;
        block5: {
            Object object2;
            String preprocessorQualifiedName;
            block4: {
                Intrinsics.checkNotNullParameter((Object)$componentDirectory, (String)"$componentDirectory");
                Intrinsics.checkNotNullParameter((Object)$metadata, (String)"$metadata");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                preprocessorParametersPayload = $componentDirectory.getFile("preprocessor_parameters").getContent();
                preprocessorQualifiedName = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)$metadata), (Object)"preprocessor_qualified_name"))).getContent();
                object = $componentDirectory.getFileOrNull(PREPROCESSOR_JAR_FILE);
                if (object == null) break block4;
                VFSNode.File preprocessorJar = object;
                boolean bl = false;
                byte[] byArray = preprocessorJar.getContent();
                ClassLoader classLoader = this$0.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                InMemoryClassLoader classLoader2 = new InMemoryClassLoader(byArray, classLoader);
                Class<?> clazz = classLoader2.loadClass(preprocessorQualifiedName);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
                KClass factoryClass = JvmClassMappingKt.getKotlinClass(clazz);
                Object object3 = factoryClass.getObjectInstance();
                if (object3 == null) {
                    object3 = KClasses.createInstance((KClass)factoryClass);
                }
                object = object3;
                if (object3 != null) break block5;
            }
            JarPreprocessorLoader $this$doLoad_u24lambda_u242_u24lambda_u241 = INSTANCE;
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName(preprocessorQualifiedName);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                object2 = KClasses.createInstance((KClass)JvmClassMappingKt.getKotlinClass(clazz));
            }
            catch (ClassNotFoundException e) {
                throw new JvmBundleLoadingException("No JAR was provided, and the specified preprocessor class '" + preprocessorQualifiedName + "' is not available for this class loader either", e);
            }
            object = object2;
        }
        Object preprocessorFactory = object;
        Intrinsics.checkNotNull((Object)preprocessorFactory, (String)"null cannot be cast to non-null type com.jetbrains.mlapi.feature.preprocessor.FeaturePreprocessorFactory");
        FeaturePreprocessorFactory cfr_ignored_0 = (FeaturePreprocessorFactory)preprocessorFactory;
        return ((FeaturePreprocessorFactory)preprocessorFactory).createFeaturePreprocessor(preprocessorParametersPayload);
    }
}

